#ifndef _FNCACHE_H // -*-C++-*-
#define _FNCACHE_H

class Value;
class VMState;

// Cache for pure function results. Currently only handles nullary
// functions (so handy for complicated constant functions, for example).

// HOWEVER: I'm not sure this is actually valid in general... so it remains
// unimplemented for the moment. Consider, for example, the pure function
// which creates a structure, but then that structure gets modified, thus
// invalidating the cache. Curse these mutable structures!
class FnCache {
public:
    FnCache(VMState* vm);

    void addEntry(Value* result);
    void addEntry(Value* arg1, Value* result);

    Value* checkCache(int args);

private:
    VMState* m_vm;
    Value** m_cache;
    Value** m_cacheptr;
    Value** m_cacheend;
};

#endif
