#include <stdlib.h>

#include <qcanvas.h>
#include <qstring.h>
#include <qimage.h>
#include <qtimer.h>
#include <qdict.h>
#include <qlineedit.h>

#include <kstandarddirs.h>
#include <kdebug.h>

#include "misc.h"
#include "pref.h"
#include "main.h"
#include "fishes.h"

/**
 * TODO: Add a speep depend on frame for each fish... =)
 */


fishSprite::fishSprite( QCanvas *canvas, QCanvasPixmapArray *pixarr, QObject *parent, const char *name )
            : QObject( parent, name )
            , QCanvasSprite( pixarr, canvas )
//            , m_fishPixArray( 0 )
{
    
    

    //posx = rand() % kfishPref::prefs() -> getPanelWidth();
    
    fishFramesDir = (frameCount()+1)/2;
    
    fishFrameAdd = 1;
    
    init();
    
    setAnimated(true);
    
    show();
}


fishSprite::~fishSprite()
{
}

void fishSprite::init()
{
    setZ(rand() % 10);
    
    fishFrameDelay = 0;
    
    posy = rand() % kfishPref::prefs()->getPanelHeight();
    
    mid_imagex = image(0)->width()/2;
    mid_imagey = image(0)->height()/2;
    
    posyupdown = 1;

    if (rand() % 10 >5) // RIGHT
    {
        fishDirection = Right;
        fishFrame = fishFramesDir + 1;
        posx = - mid_imagex - (rand() % kfishPref::prefs()->getPanelWidth()*2);
        fishEndPosX = kfishPref::prefs()->getPanelWidth() + mid_imagex + (rand() % kfishPref::prefs()->getPanelWidth()*2);
    }
    else  // LEFT
    {
        fishDirection = Left;
        fishFrame = 1;
        posx = kfishPref::prefs()->getPanelWidth() + mid_imagex + (rand() % kfishPref::prefs()->getPanelWidth()*2);
        fishEndPosX = - mid_imagex - (rand() % kfishPref::prefs()->getPanelWidth()*2);
    }
    
    
    
}

void fishSprite::advance( int phase )
{
    if ( phase == 0)
    {
        // Frame stuff
        fishFrameDelay++;
        if (fishFrameDelay > 8) {
            // change the frame
            fishFrame += fishFrameAdd;
            fishFrameDelay = 0;
            // change the y pos;
        }
        // posy stuff.. vibration (or something like that 
/*        int i = (rand() % 10);
        if (i > 5)
        {
            if (i < 9) {
                if (posyupdown == -1) posyupdown = 1;
                else posyupdown = -1;
            }
            posy += posyupdown;
        }*/
        
        if (fishDirection == Right)
        {
            posx++;
            if (fishFrame >= fishFramesDir*2)
                fishFrameAdd = -1;
            else
                if (fishFrame <= fishFramesDir+1)
                    fishFrameAdd = 1;
            if (posx > fishEndPosX )
                init();
        }
        else
        {
            posx--;
            if (fishFrame <= 1)
                fishFrameAdd = 1;
            else
                if (fishFrame >= fishFramesDir )
                    fishFrameAdd = -1;
            if (posx < fishEndPosX )
                init();
        }
    }
    else
    {
        move ( posx, posy , fishFrame - 1);
    }
}

void fishSprite::slotResized()
{
    setAnimated( false );
    
    init();
    
    setAnimated( true );
}

void fishSprite::slotSettingsChanged()
{
}

kfishManager::kfishManager( QObject *parent, const char *name)
            : QObject( parent, name )
{
    m_fish.setAutoDelete(true);

    loadFishes();
    
    showFishes();
    connect(kfishApp->getCanvas(), SIGNAL( resized() ), SIGNAL( signalResized() ));
    connect(kfishApp, SIGNAL( signalSettingsChanged() ), SLOT( slotSettingsChanged() ));
}

kfishManager::~kfishManager()
{
}

void kfishManager::slotSettingsChanged()
{
    bool change = false;
    if ( oldScale != kfishPref::prefs() ->getFishScale() ) {
        loadFishes();
        change = true;
    }
    if ( kfishPref::prefs() -> getFishSel() )
    {
        change = true;
    }
    else
    {
        if ( (m_fish. count() != kfishPref::prefs() -> getFishNumber()) )
            change = true;
    }
    if (change)
        showFishes();
}

void kfishManager::addFish(QString name)
{
    fishSprite *duh = new fishSprite(kfishApp->getCanvas(), m_listFishesAnim[name], this, name);
    connect(this, SIGNAL( signalResized() ), duh, SLOT( slotResized() ));
    m_fish. insert(name, duh);
}

void kfishManager::loadFishes()
{
    fishInfoStr *duh = kfishPref::prefs()->getFishInfo();
    m_listFishesAnim.clear();
    for(int i=0; duh[i].name != "nomore"; i++)
    {
        m_listFishesAnim. replace(duh[i].name, getFishAnimation(duh[i].file, duh[i].w, duh[i].h, duh[i].numofanim, duh[i].orientation, kfishPref::prefs() ->getFishScale()) );
    }
    oldScale = kfishPref::prefs() ->getFishScale();
}

void kfishManager::showFishes()
/*
    5 10 - 1 hasta 5
    13 10 - 1 hasta diez y despues aumentar 5 mas
*/
{
    m_fish.clear();    
    if (! kfishPref::prefs() -> getFishSel() )
    {
        QDictIterator<QCanvasPixmapArray> it( m_listFishesAnim );
        for(int i = 1; i <= kfishPref::prefs() -> getFishNumber(); i++)
        {
            addFish(it.currentKey());
            ++it;
            if (! it.current() )
                it.toFirst();
        } 
    }
    else
    {
        QDict<QString> fishSel = kfishPref::prefs() -> getFishSelected();
        QDictIterator<QString> it( fishSel );
        bool ok;
        for( ; it.current(); ++it ) {
            for(int i=0; i < it.current()->toInt(&ok, 10); i++)
                addFish(it.currentKey());
        }
    }
}

QCanvasPixmapArray *kfishManager::getFishAnimation(QString fishfile, int w, int h, int num, Qt::Orientation ori, int por)
{
    QCanvasPixmapArray *m_fishPix = new QCanvasPixmapArray();
    QCanvasPixmap *pix;
    QString fileload = locate("data","kaquarium/pics/"+fishfile);
    if (! getAnimationFromFile( *m_fishPix, fileload, w, h, num, ori, (w * por)/100,(h * por)/100) ) {
        delete m_fishPix;
        return NULL;
    }
    makeAnimationMirror( *m_fishPix);
    for (unsigned int i = 0; i < m_fishPix -> count(); i++) {
        pix = m_fishPix -> image(i);
        pix -> setOffset( pix->width()/2, pix->height()/2 );
    }
    return m_fishPix;
}


