/*
    filterlistwidget.cpp - Display a list of filter.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "filterlistwidget.h"

// Qt includes
#include <qlayout.h>
#include <qlabel.h>

// KDE includes
#include <klistbox.h>
#include <klocale.h>

class FilterListWidget::Private
{
public:
	Private()
	{}
	
	QString filterName;
	KListBox *filterList;
};

FilterListWidget::FilterListWidget(const QString &filterName, QWidget *parent, const char *name)
	: QWidget(parent, name), d(new Private)
{
	d->filterName = filterName;

	createGUI();
}

FilterListWidget::~FilterListWidget()
{
	delete d;
}

void FilterListWidget::createGUI()
{
	QVBoxLayout *mainLayout = new QVBoxLayout(this);

	mainLayout->addWidget( new QLabel(QString("<b>%1</b>").arg(d->filterName), this) );
	d->filterList = new KListBox(this, "filterList");
	clear();

	mainLayout->addWidget(d->filterList);

	connect(d->filterList, SIGNAL(highlighted(int)), this, SLOT(privateItemSelected(int)));
}

void FilterListWidget::clear()
{
	d->filterList->clear();
	d->filterList->insertItem( i18n("(All)"), 0);
}

void FilterListWidget::sort()
{
	d->filterList->sort();
	// HACK: Make sure that (All) is always the first.
	QListBoxItem *all = d->filterList->findItem( i18n("(All)") );
	if( all )
	{
		d->filterList->takeItem( all );
		d->filterList->insertItem( i18n("(All)"), 0);
	}
}

void FilterListWidget::insertItem(const QString &item)
{
	d->filterList->insertItem(item);
}

void FilterListWidget::privateItemSelected(int index)
{
	QString selection = d->filterList->text(index);
	if( selection.compare(i18n("(All)")) == 0 )
	{
		selection = QString::null;
	}
	emit selectionChanged(selection);
}

QString FilterListWidget::selection() const
{
	QString current = d->filterList->currentText();
	if( current.compare(i18n("(All)")) == 0 )
	{
		current = QString::null;
	}
	return current;
}

void FilterListWidget::select( const QString &text )
{
	QListBoxItem *item = d->filterList->findItem ( text, Qt::CaseSensitive | Qt::ExactMatch );
	if( item )
	{
		d->filterList->setSelected(item, true);
	}
	else
	{
		d->filterList->setSelected(0, true); // selects '(All)'
	}
}

#include "filterlistwidget.moc"
