/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include <qlistview.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qheader.h>

#include "kadu.h"
#include "userbox.h"
#include "userlist.h"
#include "main_configuration_window.h"
#include "configuration_window_widgets.h"
#include "message_box.h"
#include "icons_manager.h"
#include "modules/notify/notify.h"

#include "weather.h"
#include "show_forecast_dialog.h"
#include "getcitydialog.h"
#include "weather_global.h"
#include "citysearchresult.h"
#include "weather_cfg_ui_handler.h"

WeatherGlobal* weather_global;
Weather* weather_session;

extern "C" int weather_init()
{
	weather_global = new WeatherGlobal;
    weather_session = new Weather;

    return 0;
}

extern "C" void weather_close()
{	
    delete weather_session;
	delete weather_global;
}

/**
	Weather
**/
Weather::Weather()
{
	// Contacts parameters
	userlist->addPerContactNonProtocolConfigEntry( "city", "City" );
	userlist->addPerContactNonProtocolConfigEntry( "weather", "WeatherData" );

	// Config parameters
	//
	config_file.addVariable("Weather", "HintFont", QFont("Helvetica", 11));
	config_file.addVariable("Weather", "HintDay", 0);
	config_file.addVariable("Weather", "DescriptionDay", 0);
	config_file.addVariable("Weather", "HintText", tr("<u>%l</u> - <b>%d:</b><br>Temperature: %t<br>Pressure: %p"));
	config_file.addVariable("Weather", "DescriptionText", tr("Temperature in %l: %t"));
	
	cfgHandler_ = new WeatherCfgUiHandler;
	
	notification_manager->registerEvent("NewForecast",  QT_TRANSLATE_NOOP("@default", "New forecast has been fetched"), CallbackNotRequired);
	
	if(config_file.readBoolEntry("Weather", "ShowLocalForecast", true))
		menuMyWeather_ = kadu->mainMenu()->insertItem(icons_manager->loadIcon("ShowWeather"),
			tr("Local forecast"),this, SLOT(ShowMyWeather()), 0, -1, 0);
	else
		menuMyWeather_ = -1;
	
	if(config_file.readBoolEntry("Weather", "ForecastFor", true))
		menuWeatherFor_ = kadu->mainMenu()->insertItem(icons_manager->loadIcon("ShowWeather"),
			tr("Forecast for..."), this, SLOT(ShowWeatherFor()), 0, -1, 1);
	else
		menuWeatherFor_ = -1;
	
	menuShowContactWeather_ = config_file.readBoolEntry("Weather", "ShowContactWeather", true);
	if(menuShowContactWeather_)
		UserBox::userboxmenu->addItemAtPos(2,"ShowWeather", tr("Show contact weather"), this, SLOT(ShowWeather()));
}

Weather::~Weather()
{
	delete cfgHandler_;
	UserBox::userboxmenu->removeItem(UserBox::userboxmenu->getItem(tr("Show contact weather")));
 	notification_manager->unregisterEvent("NewForecast");
	
	kadu->mainMenu()->removeItem(menuWeatherFor_);
	kadu->mainMenu()->removeItem(menuMyWeather_);
}

void Weather::configurationUpdated()
{
	if(config_file.readBoolEntry("Weather", "ShowLocalForecast", false) && menuMyWeather_ == -1 )
		menuMyWeather_ = kadu->mainMenu()->insertItem(icons_manager->loadIcon("ShowWeather"),
			tr("Local forecast"),this, SLOT(ShowMyWeather()), 0, -1, 0);
	else if(!config_file.readBoolEntry("Weather", "ShowLocalForecast") && menuMyWeather_ != -1)
	{
		kadu->mainMenu()->removeItem(menuMyWeather_);
		menuMyWeather_ = -1;
	}
	
	if(config_file.readBoolEntry("Weather", "ForecastFor") && menuWeatherFor_ == -1)
		menuWeatherFor_ = kadu->mainMenu()->insertItem(icons_manager->loadIcon("ShowWeather"),
			tr("Forecast for..."), this, SLOT(ShowWeatherFor()), 0, -1, 1);
	else if(!config_file.readBoolEntry("Weather", "ForecastFor") && menuWeatherFor_ != -1)
	{
		kadu->mainMenu()->removeItem(menuWeatherFor_);
		menuWeatherFor_ = -1;
	}
	
	if( config_file.readBoolEntry("Weather", "ShowContactWeather") && !menuShowContactWeather_ )
	{
		UserBox::userboxmenu->addItemAtPos(2,"ShowWeather", tr("Show contact weather"), this, SLOT(ShowWeather()));
		menuShowContactWeather_ = true;
	}
	else if( !config_file.readBoolEntry("Weather", "ShowContactWeather") && menuShowContactWeather_ )
	{
		UserBox::userboxmenu->removeItem(UserBox::userboxmenu->getItem(tr("Show contact weather")));
		menuShowContactWeather_ = false;
	}
}

void Weather::ShowWeather()
{
	UserBox* activeUserBox=kadu->userbox()->activeUserBox();
	if( activeUserBox != 0)
	{
		UserListElement user = activeUserBox->selectedUsers().first();
	
		CitySearchResult result;
		if( result.readUserWeatherData( user ) )
		{
			ShowForecastDialog* sfd = new ShowForecastDialog( result, user );
			sfd->show();
		}
		else
		{
			SearchingCityDialog* scd = new SearchingCityDialog( user );
			scd->show();
		}
	}
}

void Weather::ShowMyWeather()
{
	CitySearchResult result;
	if( result.readMyWeatherData() )
	{
		ShowForecastDialog* sfd = new ShowForecastDialog( result, kadu->myself() );
		sfd->show();
	}
	else
	{
		SearchingCityDialog* scd = new SearchingCityDialog( kadu->myself() );
		scd->show();
	}
	
}

void Weather::ShowWeatherFor()
{
	EnterCityDialog* window = new EnterCityDialog;
	window->show();
}
