#ifndef HOT_KEY_H
#define HOT_KEY_H

#include <qkeysequence.h>
#include <qlineedit.h>

class HotKey
{
public:
	/**
	  Pobiera skrt klawiszowy, z pliku konfiguracyjnego
	  z grupy "groupname", o polu "name"
	 **/
	static QKeySequence shortCutFromFile(const QString& groupname, const QString &name);

	/**
	  Sprawdza czy skrt nacinity przy zdarzeniu QKeyEvent zgadza si
	  ze skrtem klawiszowym, z pliku konfiguracyjnego, o polu "name"
	 **/
	static bool shortCut(QKeyEvent *e, const QString& groupname, const QString &name);

	static QString keyEventToString(QKeyEvent *e);
};

class HotKeyEdit : public QLineEdit
{
protected:
	virtual void keyPressEvent(QKeyEvent *e);
	virtual void keyReleaseEvent(QKeyEvent *e);

public:
	HotKeyEdit(QWidget *parent = 0, const char *name = 0)
		: QLineEdit(parent, name) {}
	/**
	  Pobiera skrt klawiszowy
	**/
	QString shortCutString() const { return text(); }

	/**
	  Pobiera skrt klawiszowy
	**/
	QKeySequence shortCut() const { return QKeySequence(text()); }

	/**
	  Ustawia skrt klawiszowy
	**/
	void setShortCut(const QString &shortcut);

	/**
	  Ustawia skrt klawiszowy
	**/
	void setShortCut(const QKeySequence &shortcut) { setText(shortcut); }

};

#endif // HOT_KEY_H
