/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "infos_list_view_item.h"

#include "debug.h"

InfosListViewItem::InfosListViewItem(QListView *parent, QString label1, QString label2, QString label3,
	QString label4, QString label5, QString label6, QString label7)
	: QListViewItem(parent, label1, label2, label3, label4, label5, label6, label7),
	parentList(parent)
{
}

InfosListViewItem::~InfosListViewItem()
{
}


void InfosListViewItem::paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int align)
{
	QColorGroup newCg(cg);
	int itemPos = parentList->itemPos(this);
	int itemHeight = this->totalHeight();
	if((itemPos/itemHeight) % 2)
		newCg.setColor(QColorGroup::Base, QColor(238, 246, 255));
	else
		newCg.setColor(QColorGroup::Base, Qt::white);
	QListViewItem::paintCell(p, newCg, column, width, align);
}

bool InfosListViewItem::alternativeColor = true;
