/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepHandler;
import com.tonicsystems.jarjar.PathClass;
import com.tonicsystems.jarjar.asm.AnnotationVisitor;
import com.tonicsystems.jarjar.asm.FieldVisitor;
import com.tonicsystems.jarjar.asm.Label;
import com.tonicsystems.jarjar.asm.MethodVisitor;
import com.tonicsystems.jarjar.asm.Type;
import com.tonicsystems.jarjar.asm.commons.EmptyVisitor;
import com.tonicsystems.jarjar.asm.signature.SignatureReader;
import com.tonicsystems.jarjar.asm.signature.SignatureVisitor;
import com.tonicsystems.jarjar.ext_util.EmptySignatureVisitor;
import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipFile;

class DepFindVisitor
extends EmptyVisitor {
    private Map classes;
    private String source;
    private String curName;
    private DepHandler handler;
    private PathClass curPathClass;
    private final SignatureVisitor SIG = new EmptySignatureVisitor(){

        public void visitTypeVariable(String name) {
            DepFindVisitor.this.checkName(name);
        }

        public void visitClassType(String name) {
            DepFindVisitor.this.checkName(name);
        }

        public void visitInnerClassType(String name) {
            DepFindVisitor.this.checkName(name);
        }
    };

    public DepFindVisitor(Map classes, Object source, DepHandler handler) throws IOException {
        this.classes = classes;
        this.source = this.getSourceName(source);
        this.handler = handler;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.curName = name;
        this.curPathClass = new PathClass(this.source, this.curName);
        this.checkSignature(signature, false);
        this.checkName(superName);
        this.checkNames(interfaces);
    }

    private void checkSignature(String signature, boolean type) {
        if (signature != null) {
            SignatureReader reader = new SignatureReader(signature);
            if (type) {
                reader.acceptType(this.SIG);
            } else {
                reader.accept(this.SIG);
            }
        }
    }

    private void checkDesc(String desc) {
        int index = desc.indexOf(76);
        if (index >= 0) {
            this.checkName(desc.substring(index + 1, desc.length() - 1));
        }
    }

    private void checkMethodDesc(String methodDesc) {
        this.checkDesc(Type.getReturnType(methodDesc).getDescriptor());
        Type[] args = Type.getArgumentTypes(methodDesc);
        for (int i = 0; i < args.length; ++i) {
            this.checkDesc(args[i].getDescriptor());
        }
    }

    private String getSourceName(Object source) throws IOException {
        if (source instanceof ZipFile) {
            return ((ZipFile)source).getName();
        }
        return ((File)source).getCanonicalPath();
    }

    private void checkName(String name) {
        try {
            String otherSource;
            if (this.classes.containsKey(name) && !this.source.equals(otherSource = this.getSourceName(this.classes.get(name)))) {
                this.handler.handle(this.curPathClass, new PathClass(otherSource, name));
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void checkNames(String[] names) {
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                this.checkName(names[i]);
            }
        }
    }

    private void checkType(Object value) {
        if (value instanceof Type) {
            this.checkDesc(((Type)value).getDescriptor());
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.checkMethodDesc(desc);
        this.checkSignature(signature, false);
        this.checkNames(exceptions);
        return this;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.checkDesc(desc);
        this.checkSignature(signature, true);
        this.checkType(value);
        return this;
    }

    public void visitTypeInsn(int opcode, String desc) {
        if (desc.charAt(0) == '[') {
            this.checkDesc(desc);
        } else {
            this.checkName(desc);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.checkName(owner);
        this.checkDesc(desc);
    }

    public void visitLdcInsn(Object cst) {
        this.checkType(cst);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.checkName(owner);
        this.checkMethodDesc(desc);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.checkDesc(desc);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.checkName(type);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.checkDesc(desc);
        this.checkSignature(signature, true);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkDesc(desc);
        return this;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.checkDesc(desc);
        return this;
    }

    public void visit(String name, Object value) {
        this.checkType(value);
    }

    public void visitClassType(String name) {
        this.checkName(name);
    }

    public void visitInnerClassType(String name) {
        this.checkName(name);
    }

    public void visitTypeVariable(String name) {
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.checkDesc(desc);
        return this;
    }

    public void visitEnum(String name, String desc, String value) {
        this.checkDesc(desc);
    }
}

