#include <Python.h>

#include "pytype_memos.h"
#include "pytype_basics.h"
#include "structmember.h"

/*******************************************************
 * Create and delloc methods for objects 
 ******************************************************/

extern PyObject* PyPiMemo_New(PyTypeObject *type, PyObject *args, PyObject *kwds) {
  int i;
  PyPiMemo* self;

  MemoType.ob_type = &PyType_Type;
  self = (PyPiMemo *)type->tp_alloc(type, 0);
  new_Memo(&(self->a));
  SetBasicRecordObjectAttributeDefaults((PyObject*) self, pack_Memo);

  return (PyObject*)self;
}

extern int PyPiMemo_Init(PyObject *self, PyObject *args, PyObject *kwds) {
  PyPiMemo* frommemo = NULL;
  PyPiMemo* memo = NULL;
  int i;
  
  static char *kwlist[] = {"memo", NULL};
  if (!PyArg_ParseTupleAndKeywords(args, kwds, "|O", kwlist, 
				   &frommemo)) {
    return -1;
  }
  
  memo = (PyPiMemo*)self;
  /* we have to support calling __init__ more than once */
  free_Memo(&(memo->a));
  if (memo->saved_br.size > 0 && memo->saved_br.buf) {	
    free(memo->saved_br.buf);					
  }
  if ((frommemo == NULL) || ((PyObject *)frommemo == Py_None)) {
    /* Initialise attributes custom to this type of object */
    new_Memo(&(memo->a));
    SetBasicRecordObjectAttributeDefaults((PyObject*) memo, pack_Memo);    
  } else {
    if (!PyPiMemo_Check(frommemo)) {
      PyErr_SetString(PyExc_TypeError,"Must provide a Memo object to share");
      return -1;
    }
    
    /* copy all the database agnostic record attributes */
    memo->saved_br.size = frommemo->saved_br.size;
    memo->saved_br.attrib = frommemo->saved_br.attrib;
    memo->saved_br.rt = frommemo->saved_br.rt;
    memo->saved_br.unique_id = frommemo->saved_br.unique_id;
    
    memo->rt = frommemo->rt;
    memo->unique_id = frommemo->unique_id;
    
    memo->saved_br.buf = malloc(frommemo->saved_br.size);
    memcpy(memo->saved_br.buf,
	   frommemo->saved_br.buf,
	   frommemo->saved_br.size);
    
    memo->category = frommemo->category;
    memo->unsaved_changes = frommemo->unsaved_changes;
    memo->deleted = frommemo->deleted;
    memo->modified = frommemo->modified;
    memo->busy = frommemo->busy;
    memo->secret = frommemo->secret;
    
    /* Now do the pointers */
    pyint_strcpy(memo->a.text, frommemo->a.text);
    
  }
  return 0;
}


static PyObject * PyPiMemo_Allocate(PyTypeObject *type, int nitems) {
  PyPiMemo *memo;
  if (type == &MemoType) {
    memo = PyObject_New(PyPiMemo, &MemoType);
    return (PyObject *) memo;
  } else {
    /* Is this for subclasses ? */
    memo = (PyPiMemo *)PyType_GenericAlloc(type, nitems);
    return (PyObject*)memo;
  }
}

extern PyObject* PyPiMemo_Wrap(struct Memo* a, PCRecType rt, 
				 unsigned int unique_id, unsigned char attrib,
				 int size, void* buf) {
  PyPiMemo* memo;
  int i;

  memo = (PyPiMemo*)PyPiMemo_New(&MemoType,NULL,NULL);


  /* set saved_br stuff, and rt and unique_id, and attrib derived details for the current memo */
  SetSavedBrAndRTandUniqueIDandAttribs(rt, unique_id, attrib, size, buf, (PyObject *)memo);

  pyp_strcpy(memo->a.text, a->text);

  return (PyObject*)memo;
}

static void PyPiMemo_Dealloc(PyPiMemo* self) {
  free_Memo(&(self->a));
  if (self->saved_br.size > 0 && self->saved_br.buf) {
    free(self->saved_br.buf);
  }
  self->ob_type->tp_free((PyObject*)self);
}


static int PyPiMemo_Compare(PyPiMemo* self,PyPiMemo *other) {
  int res;

  if ((self->a.text) &&
      (other->a.text)) {
    
    res = strcasecmp(self->a.text,
		 other->a.text);
    if (res > 0) {
      res = 1;
    } else if (res < 0) {
      res = -1;
    } else {
      res = 0;
    }
  } else if (self->a.text) {
    res = -1;
  } else if (other->a.text) {
    res = 1;
  } else {
    res = 0;
  }

  return res;

}

static char *PyPiMemo_key_list[] = {
  "text",
  NULL};

static PyObject* PyPiMemo_keys(PyObject* self) {
  return Py_BuildValue("[s]", PyPiMemo_key_list[0]);
}

PyObject *PyPiMemo_GetItem(PyPiMemo* self,  PyObject* key);

static PyObject* PyPiMemo_values(PyObject* self) {
  PyObject *list;
  PyObject *key;
  PyObject *value;
  key = PyString_FromString(PyPiMemo_key_list[0]);
  value =  PyPiMemo_GetItem((PyPiMemo *)self, key);
  list = Py_BuildValue("[O]", value);
  Py_DECREF(value);
  Py_DECREF(key);
  return list;
}

static PyObject* PyPiMemo_items(PyObject* self) {
  PyObject *list;
  PyObject *key;
  PyObject *value;
  key = PyString_FromString(PyPiMemo_key_list[0]);
  value =  PyPiMemo_GetItem((PyPiMemo *)self, key);
  list = Py_BuildValue("[(OO)]", key, value);
  Py_DECREF(value);
  Py_DECREF(key);
  return list;
}

/*******************************************************
 * 
 ******************************************************/

static PyMethodDef PyPiMemo_Methods[] = {
  { "keys", (PyCFunction)PyPiMemo_keys, METH_NOARGS, "Return a list of available keys"},
  { "items",(PyCFunction)PyPiMemo_items, METH_NOARGS, "Return a list of available items"},
  { "values",(PyCFunction)PyPiMemo_values, METH_NOARGS, "Return a list of available items"},
  {NULL,NULL} /* Sentinel */
};

static PyMemberDef PyPiMemo_Members[] = {
  PYPI_MEMBERS_HEAD,
  {NULL}  /* Sentinel */
};

static PyGetSetDef PyPiMemo_Getseters[] = {
  PYPI_GETSETERS_HEAD,
  {NULL}  /* Sentinel */
};

/**** mapping interface ****/
int PyPiMemo_Len(self) {
  return 1;
}

PyObject *PyPiMemo_GetItem(PyPiMemo* self,  PyObject* key) {
  char *keystring;
  if (!PyString_Check(key)) {
    Py_INCREF(Py_None);
    return Py_None;  
  }

  Py_INCREF(key);
  keystring = PyString_AsString(key);

  GET_STRING_ATTR(keystring,"text", a.text);
  
  PyErr_Format(PyExc_KeyError,"no such key '%s'", keystring);
  Py_DECREF(key);
  return NULL;
}

int PyPiMemo_SetItem(PyPiMemo* self, PyObject* key, PyObject* value) {
  char buf[255];
  char *keystring;

  if (!PyString_Check(key)) {
    PyErr_SetString(PyExc_TypeError,"key must be a String");
    return -1;
  }
 
  Py_INCREF(key);
  keystring = PyString_AsString(key);

  if (value == NULL) {
    PyErr_Format(PyExc_ValueError,"Can't delete value %s", keystring);
    return -1;
  }
  
  SET_STRING_ATTR(keystring,"text",a.text,value, 4096);

  PyErr_SetString(PyExc_KeyError,"no such key");
  Py_DECREF(key);
  return -1;
}

static PyMappingMethods PyPiMemo_Mapping = {
  (inquiry)PyPiMemo_Len,
  (binaryfunc)PyPiMemo_GetItem, 
  (objobjargproc)PyPiMemo_SetItem,
};



/*******************************************************
 * Provide a repr method
 ******************************************************/

static PyObject *PyPiMemo_Repr(PyPiMemo* self) {
  static PyObject *format = NULL;
  PyObject *attrib, *args, *result;
  int len1;

  if (format == NULL) {
    format = PyString_FromString("<%s %r %s>");
    if (format == NULL)
      return NULL;
  }

  if (self->a.text) {
    len1 = strlen(self->a.text) > 25 ? 25 : strlen(self->a.text);
  } else {
    len1 = 0;
  }
  
  args = Py_BuildValue("ss#O", 
		       (self->ob_type)->tp_name,
		       self->a.text,
		       len1,
		       Attribute_Repr((PyObject *)self));

  if (args == NULL)
    return NULL;

  result = PyString_Format(format, args);
  Py_DECREF(args);
  return result;
}


/*******************************************************
 * Declare the type
 ******************************************************/


PyTypeObject MemoType = {
  PyObject_HEAD_INIT(NULL)
  0, /* ob_size */
  "jppy._jpilot.__jpilot.Memo", /*tp_name*/
  sizeof(PyPiMemo),  0, /*tp_basicsize*/ /*tp_itemsize*/
  (destructor)PyPiMemo_Dealloc, /*tp_dealloc*/
  0,          /*tp_print*/
  0,
  0,
  (cmpfunc)PyPiMemo_Compare,          /*tp_compare*/
  (reprfunc)PyPiMemo_Repr,          /*tp_repr*/
  0,          /*tp_as_number*/
  0,          /*tp_as_sequence*/
  &PyPiMemo_Mapping,          /*tp_as_mapping*/
  0,          /*tp_hash */
  0,                         /*tp_call*/
  0,                         /*tp_str*/
  0,                         /*tp_getattro*/
  0,                         /*tp_setattro*/
  0,                         /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /*tp_flags*/
  "Memo objects",           /* tp_doc */
  0,		               /* tp_traverse */
  0,		               /* tp_clear */
  0,		               /* tp_richcompare */
  0,		               /* tp_weaklistoffset */
  0,		               /* tp_iter */
  0,		               /* tp_iternext */
  PyPiMemo_Methods,            /* tp_methods */
  PyPiMemo_Members,            /* tp_members */
  PyPiMemo_Getseters,          /* tp_getset */
  0,                           /* tp_base */
  0,                           /* tp_dict */
  0,                           /* tp_descr_get */
  0,                           /* tp_descr_set */
  0,                           /* tp_dictoffset */
  (initproc)PyPiMemo_Init,            /* tp_init */
  (allocfunc)PyPiMemo_Allocate,                 /* tp_alloc */
  (newfunc)PyPiMemo_New,                 /* tp_new */
  0, /* Low-level free-memory routine */
};

