/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ProxyReader;
import ucar.nc2.SectionReader;
import ucar.nc2.SliceReader;
import ucar.nc2.Structure;
import ucar.nc2.VariableIF;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.iosp.AbstractIOServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variable
implements VariableIF {
    public static final int defaultSizeToCache = 4000;
    protected static boolean debugCaching = false;
    private static Logger log = LoggerFactory.getLogger(Variable.class);
    protected NetcdfFile ncfile;
    protected Group group;
    protected String shortName;
    protected int[] shape;
    protected Section shapeAsSection;
    protected DataType dataType;
    protected int elementSize;
    protected List<Dimension> dimensions = new ArrayList<Dimension>(5);
    protected List<Attribute> attributes = new ArrayList<Attribute>();
    protected boolean isVariableLength = false;
    protected boolean isMetadata = false;
    private boolean immutable = false;
    protected Cache cache = new Cache();
    protected int sizeToCache = 4000;
    protected Structure parent = null;
    protected ProxyReader preReader;
    protected ProxyReader postReader;
    private EnumTypedef enumTypedef;
    private static boolean showSize = false;
    protected int hashCode = 0;
    protected Object spiObject;

    @Override
    public String getName() {
        return NetcdfFile.makeFullName(this.group, this);
    }

    @Override
    public String getNameEscaped() {
        return NetcdfFile.makeFullNameEscaped(this.group, this);
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int[] getShape() {
        int[] result = new int[this.shape.length];
        System.arraycopy(this.shape, 0, result, 0, this.shape.length);
        return result;
    }

    public int getShape(int index) {
        return this.shape[index];
    }

    @Override
    public long getSize() {
        long size = 1L;
        for (int i = 0; i < this.shape.length; ++i) {
            if (this.shape[i] < 0) continue;
            size *= (long)this.shape[i];
        }
        return size;
    }

    @Override
    public int getElementSize() {
        return this.elementSize;
    }

    @Override
    public int getRank() {
        return this.shape.length;
    }

    @Override
    public Group getParentGroup() {
        return this.group;
    }

    @Override
    public boolean isMetadata() {
        return this.isMetadata;
    }

    @Override
    public boolean isScalar() {
        return this.getRank() == 0;
    }

    @Override
    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    @Override
    public boolean isUnsigned() {
        Attribute att = this.findAttributeIgnoreCase("_Unsigned");
        return att != null && att.getStringValue().equalsIgnoreCase("true");
    }

    @Override
    public boolean isUnlimited() {
        for (Dimension d : this.dimensions) {
            if (!d.isUnlimited()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    @Override
    public Dimension getDimension(int i) {
        if (i < 0 || i >= this.getRank()) {
            return null;
        }
        return this.dimensions.get(i);
    }

    public String getDimensionsString() {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension dim = this.dimensions.get(i);
            if (i > 0) {
                buff.append(" ");
            }
            buff.append(dim.getName());
        }
        return buff.toString();
    }

    @Override
    public int findDimensionIndex(String name) {
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = this.dimensions.get(i);
            if (!name.equals(d.getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public Attribute findAttribute(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return a;
        }
        return null;
    }

    @Override
    public String getDescription() {
        String desc = null;
        Attribute att = this.findAttributeIgnoreCase("long_name");
        if (att != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.findAttributeIgnoreCase("description")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.findAttributeIgnoreCase("title")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.findAttributeIgnoreCase("standard_name")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        return desc;
    }

    @Override
    public String getUnitsString() {
        String units = null;
        Attribute att = this.findAttributeIgnoreCase("units");
        if (att != null && att.isString()) {
            units = att.getStringValue().trim();
        }
        return units;
    }

    @Override
    public List<Range> getRanges() {
        return this.getShapeAsSection().getRanges();
    }

    @Override
    public Section getShapeAsSection() {
        if (this.shapeAsSection == null) {
            try {
                ArrayList<Range> list = new ArrayList<Range>();
                for (Dimension d : this.dimensions) {
                    int len = d.getLength();
                    if (len > 0) {
                        list.add(new Range(d.getName(), 0, len - 1));
                        continue;
                    }
                    if (len == 0) {
                        list.add(Range.EMPTY);
                        continue;
                    }
                    list.add(Range.VLEN);
                }
                this.shapeAsSection = new Section(list).makeImmutable();
            }
            catch (InvalidRangeException e) {
                log.error("Bad shape in variable " + this.getName(), e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        return this.shapeAsSection;
    }

    @Override
    public Variable section(List<Range> ranges) throws InvalidRangeException {
        return this.section(new Section(ranges, this.shape).makeImmutable());
    }

    public Variable section(Section subsection) throws InvalidRangeException {
        subsection = Section.fill(subsection, this.shape);
        Variable sectionV = this.copy();
        sectionV.preReader = new SectionReader(this, subsection);
        sectionV.shape = subsection.getShape();
        sectionV.dimensions = new ArrayList<Dimension>();
        for (int i = 0; i < this.getRank(); ++i) {
            Dimension oldD = this.getDimension(i);
            Dimension newD = oldD.getLength() == sectionV.shape[i] ? oldD : new Dimension(oldD.getName(), sectionV.shape[i], false);
            newD.setUnlimited(oldD.isUnlimited());
            sectionV.dimensions.add(newD);
        }
        sectionV.resetShape();
        return sectionV;
    }

    public Variable slice(int dim, int value) throws InvalidRangeException {
        if (dim < 0 || dim >= this.shape.length) {
            throw new InvalidRangeException("Slice dim invalid= " + dim);
        }
        if (value < 0 || value >= this.shape[dim]) {
            throw new InvalidRangeException("Slice value invalid= " + value + " for dimension " + dim);
        }
        Variable sliceV = this.copy();
        Section slice = new Section(this.getShapeAsSection());
        slice.replaceRange(dim, new Range(value, value)).makeImmutable();
        sliceV.preReader = new SliceReader(this, dim, slice);
        sliceV.dimensions.remove(dim);
        sliceV.resetShape();
        return sliceV;
    }

    protected Variable copy() {
        return new Variable(this);
    }

    public String lookupEnumString(int val) {
        if (!this.dataType.isEnum()) {
            throw new UnsupportedOperationException("Can only call Variable.lookupEnumVal() on enum types");
        }
        return this.enumTypedef.lookupEnumString(val);
    }

    public void setEnumTypedef(EnumTypedef enumTypedef) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (!this.dataType.isEnum()) {
            throw new UnsupportedOperationException("Can only call Variable.setEnumTypedef() on enum types");
        }
        this.enumTypedef = enumTypedef;
    }

    @Override
    public Array read(int[] origin, int[] shape) throws IOException, InvalidRangeException {
        if (origin == null && shape == null) {
            return this.read();
        }
        if (origin == null) {
            return this.read(new Section(shape));
        }
        if (shape == null) {
            return this.read(new Section(origin, shape));
        }
        return this.read(new Section(origin, shape));
    }

    @Override
    public Array read(String sectionSpec) throws IOException, InvalidRangeException {
        return this.read(new Section(sectionSpec));
    }

    public Array read(List<Range> ranges) throws IOException, InvalidRangeException {
        if (null == ranges) {
            return this._read();
        }
        return this.read(new Section(ranges));
    }

    @Override
    public Array read(Section section) throws IOException, InvalidRangeException {
        return section == null ? this._read() : this._read(Section.fill(section, this.shape));
    }

    @Override
    public Array read() throws IOException {
        return this._read();
    }

    @Override
    public byte readScalarByte() throws IOException {
        Array data = this.getScalarData();
        return data.getByte(Index.scalarIndex);
    }

    @Override
    public short readScalarShort() throws IOException {
        Array data = this.getScalarData();
        return data.getShort(Index.scalarIndex);
    }

    @Override
    public int readScalarInt() throws IOException {
        Array data = this.getScalarData();
        return data.getInt(Index.scalarIndex);
    }

    @Override
    public long readScalarLong() throws IOException {
        Array data = this.getScalarData();
        return data.getLong(Index.scalarIndex);
    }

    @Override
    public float readScalarFloat() throws IOException {
        Array data = this.getScalarData();
        return data.getFloat(Index.scalarIndex);
    }

    @Override
    public double readScalarDouble() throws IOException {
        Array data = this.getScalarData();
        return data.getDouble(Index.scalarIndex);
    }

    @Override
    public String readScalarString() throws IOException {
        Array data = this.getScalarData();
        if (this.dataType == DataType.STRING) {
            return (String)data.getObject(Index.scalarIndex);
        }
        if (this.dataType == DataType.CHAR) {
            ArrayChar dataC = (ArrayChar)data;
            return dataC.getString();
        }
        throw new IllegalArgumentException("readScalarString not STRING or CHAR " + this.getName());
    }

    protected Array getScalarData() throws IOException {
        Array scalarData = this.cache != null && this.cache.data != null ? this.cache.data : this.read();
        if ((scalarData = scalarData.reduce()).getRank() == 0 || scalarData.getRank() == 1 && this.dataType == DataType.CHAR) {
            return scalarData;
        }
        throw new UnsupportedOperationException("not a scalar variable =" + this);
    }

    protected Array _read() throws IOException {
        Array data;
        if (this.preReader != null) {
            return this.preReader.read(this, null);
        }
        if (this.isMemberOfStructure()) {
            ArrayList<String> memList = new ArrayList<String>();
            memList.add(this.getShortName());
            Structure s = this.parent.select(memList);
            ArrayStructure as = (ArrayStructure)s.read();
            return as.extractMemberArray(as.findMember(this.shortName));
        }
        if (this.cache != null && this.cache.data != null) {
            if (debugCaching) {
                System.out.println("got data from cache " + this.getName());
            }
            return this.cache.data.copy();
        }
        try {
            data = this.ncfile.readData(this, this.getShapeAsSection());
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        if (this.isCaching()) {
            this.cache.data = data;
            if (debugCaching) {
                System.out.println("cache " + this.getName());
            }
            return this.cache.data.copy();
        }
        return data;
    }

    protected Array _read(Section section) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this._read();
        }
        if (this.preReader != null) {
            return this.preReader.read(this, section, null);
        }
        if (this.isMemberOfStructure()) {
            throw new UnsupportedOperationException("Cannot directly read section of Member Variable=" + this.getName());
        }
        if (this.isCaching()) {
            if (this.cache.data == null) {
                this.cache.data = this.ncfile.readData(this, this.getShapeAsSection());
                if (debugCaching) {
                    System.out.println("cache " + this.getName());
                }
            }
            if (debugCaching) {
                System.out.println("got data from cache " + this.getName());
            }
            return this.cache.data.sectionNoReduce(section.getRanges()).copy();
        }
        return this.ncfile.readData(this, section);
    }

    public long readToByteChannel(Section section, WritableByteChannel wbc) throws IOException, InvalidRangeException {
        if (this.ncfile == null || this.hasCachedData()) {
            return AbstractIOServiceProvider.copyToByteChannel(this.read(section), wbc);
        }
        return this.ncfile.readToByteChannel(this, section, wbc);
    }

    public String getNameAndDimensions() {
        StringBuilder buf = new StringBuilder();
        this.getNameAndDimensions(buf);
        return buf.toString();
    }

    public void getNameAndDimensions(StringBuilder buf) {
        this.getNameAndDimensions(buf, true, false);
    }

    public void getNameAndDimensions(StringBuffer buf) {
        Formatter proxy = new Formatter();
        this.getNameAndDimensions(proxy, true, false);
        buf.append(proxy.toString());
    }

    public void getNameAndDimensions(StringBuilder buf, boolean useFullName, boolean strict) {
        Formatter proxy = new Formatter();
        this.getNameAndDimensions(proxy, useFullName, strict);
        buf.append(proxy.toString());
    }

    @Override
    public void getNameAndDimensions(Formatter buf, boolean useFullName, boolean strict) {
        String name;
        useFullName = useFullName && !strict;
        String string = name = useFullName ? this.getName() : this.getShortName();
        if (strict) {
            name = NetcdfFile.escapeName(name);
        }
        buf.format("%s", name);
        if (this.getRank() > 0) {
            buf.format("(", new Object[0]);
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension myd = this.dimensions.get(i);
            String dimName = myd.getName();
            if (dimName != null && strict) {
                dimName = NetcdfFile.escapeName(dimName);
            }
            if (i != 0) {
                buf.format(", ", new Object[0]);
            }
            if (myd.isVariableLength()) {
                buf.format("*", new Object[0]);
                continue;
            }
            if (myd.isShared()) {
                if (!strict) {
                    buf.format("%s=%d", dimName, myd.getLength());
                    continue;
                }
                buf.format(dimName, new Object[0]);
                continue;
            }
            if (dimName != null) {
                buf.format("%s=", dimName);
            }
            buf.format("%d", myd.getLength());
        }
        if (this.getRank() > 0) {
            buf.format(")", new Object[0]);
        }
    }

    public String toString() {
        return this.writeCDL("   ", false, false);
    }

    public String writeCDL(String indent, boolean useFullName, boolean strict) {
        Formatter buf = new Formatter();
        this.writeCDL(buf, indent, useFullName, strict);
        return buf.toString();
    }

    protected void writeCDL(Formatter buf, String indent, boolean useFullName, boolean strict) {
        buf.format(indent, new Object[0]);
        if (this.dataType.isEnum()) {
            if (this.enumTypedef == null) {
                buf.format("enum UNKNOWN", new Object[0]);
            } else {
                buf.format("enum %s", this.enumTypedef.getName());
            }
        } else {
            buf.format(this.dataType.toString(), new Object[0]);
        }
        buf.format(" ", new Object[0]);
        this.getNameAndDimensions(buf, useFullName, strict);
        buf.format(";", new Object[0]);
        if (!strict) {
            buf.format(this.extraInfo(), new Object[0]);
        }
        buf.format("\n", new Object[0]);
        for (Attribute att : this.getAttributes()) {
            buf.format("%s  ", indent);
            if (strict) {
                buf.format(NetcdfFile.escapeName(this.getShortName()), new Object[0]);
            }
            buf.format(":%s;", att.toString(strict));
            if (!strict && att.getDataType() != DataType.STRING) {
                buf.format(" // %s", new Object[]{att.getDataType()});
            }
            buf.format("\n", new Object[0]);
        }
    }

    @Override
    public String toStringDebug() {
        return this.ncfile.toStringDebug(this);
    }

    protected String extraInfo() {
        return showSize ? " // " + this.getElementSize() + " " + this.getSize() : "";
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Variable)) {
            return false;
        }
        Variable o = (Variable)oo;
        if (!this.getShortName().equals(o.getShortName())) {
            return false;
        }
        if (this.isScalar() != o.isScalar()) {
            return false;
        }
        if (this.getDataType() != o.getDataType()) {
            return false;
        }
        if (!this.getParentGroup().equals(o.getParentGroup())) {
            return false;
        }
        if (this.getParentStructure() != null && !this.getParentStructure().equals(o.getParentStructure())) {
            return false;
        }
        if (this.isVariableLength() != o.isVariableLength()) {
            return false;
        }
        if (this.dimensions.size() != o.getDimensions().size()) {
            return false;
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (this.getDimension(i).equals(o.getDimension(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getShortName().hashCode();
            if (this.isScalar()) {
                ++result;
            }
            result = 37 * result + this.getDataType().hashCode();
            result = 37 * result + this.getParentGroup().hashCode();
            if (this.parent != null) {
                result = 37 * result + this.parent.hashCode();
            }
            if (this.isVariableLength) {
                ++result;
            }
            this.hashCode = result = 37 * result + ((Object)this.dimensions).hashCode();
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(VariableSimpleIF o) {
        return this.getName().compareTo(o.getName());
    }

    protected Variable() {
    }

    public Variable(NetcdfFile ncfile, Group group, Structure parent, String shortName) {
        this.ncfile = ncfile;
        this.group = group == null ? ncfile.getRootGroup() : group;
        this.parent = parent;
        this.shortName = shortName;
    }

    public Variable(NetcdfFile ncfile, Group group, Structure parent, String shortName, DataType dtype, String dims) {
        this.ncfile = ncfile;
        this.group = group == null ? ncfile.getRootGroup() : group;
        this.parent = parent;
        this.shortName = shortName;
        this.setDataType(dtype);
        this.setDimensions(dims);
    }

    public Variable(Variable from) {
        this.attributes = new ArrayList<Attribute>(from.attributes);
        this.cache = from.cache;
        this.dataType = from.getDataType();
        this.dimensions = new ArrayList<Dimension>(from.dimensions);
        this.elementSize = from.getElementSize();
        this.enumTypedef = from.enumTypedef;
        this.group = from.group;
        this.isMetadata = from.isMetadata;
        this.isVariableLength = from.isVariableLength;
        this.ncfile = from.ncfile;
        this.parent = from.parent;
        this.preReader = from.preReader;
        this.postReader = from.postReader;
        this.shape = from.getShape();
        this.shortName = from.shortName;
        this.sizeToCache = from.sizeToCache;
        this.spiObject = from.spiObject;
    }

    public void setDataType(DataType dataType) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dataType = dataType;
        this.elementSize = this.getDataType().getSize();
    }

    public void setName(String shortName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.shortName = shortName;
    }

    public void setParentGroup(Group group) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.group = group;
    }

    public void setElementSize(int elementSize) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.elementSize = elementSize;
    }

    public Attribute addAttribute(Attribute att) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute a = this.attributes.get(i);
            if (!att.getName().equals(a.getName())) continue;
            this.attributes.set(i, att);
            return att;
        }
        this.attributes.add(att);
        return att;
    }

    public boolean remove(Attribute a) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return a != null && this.attributes.remove(a);
    }

    public boolean removeAttribute(String attName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        Attribute att = this.findAttribute(attName);
        return att != null && this.attributes.remove(att);
    }

    public boolean removeAttributeIgnoreCase(String attName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        Attribute att = this.findAttributeIgnoreCase(attName);
        return att != null && this.attributes.remove(att);
    }

    public void setDimensions(List<Dimension> dims) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions = dims == null ? new ArrayList<Dimension>() : new ArrayList<Dimension>(dims);
        this.resetShape();
    }

    public void resetShape() {
        this.shape = new int[this.dimensions.size()];
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension dim = this.dimensions.get(i);
            this.shape[i] = dim.getLength();
            if (!dim.isVariableLength()) continue;
            this.isVariableLength = true;
        }
        this.shapeAsSection = null;
    }

    public void setDimensions(String dimString) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        ArrayList<Dimension> newDimensions = new ArrayList<Dimension>();
        if (dimString == null || dimString.length() == 0) {
            this.dimensions = newDimensions;
            this.resetShape();
            return;
        }
        StringTokenizer stoke = new StringTokenizer(dimString);
        while (stoke.hasMoreTokens()) {
            Dimension d;
            String dimName = stoke.nextToken();
            Dimension dimension = d = dimName.equals("*") ? Dimension.VLEN : this.group.findDimension(dimName);
            if (d == null) {
                try {
                    int len = Integer.parseInt(dimName);
                    d = new Dimension("", len, false, false, false);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Variable " + this.getName() + " setDimensions = " + dimString + " FAILED, dim doesnt exist=" + dimName + " file = " + this.ncfile.getLocation());
                }
            }
            newDimensions.add(d);
        }
        this.dimensions = newDimensions;
        this.resetShape();
    }

    public void resetDimensions() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        ArrayList<Dimension> newDimensions = new ArrayList<Dimension>();
        for (Dimension dim : this.dimensions) {
            if (dim.isShared()) {
                Dimension newD = this.group.findDimension(dim.getName());
                if (newD == null) {
                    throw new IllegalArgumentException("Variable " + this.getName() + " resetDimensions  FAILED, dim doesnt exist in parent group=" + dim);
                }
                newDimensions.add(newD);
                continue;
            }
            newDimensions.add(dim);
        }
        this.dimensions = newDimensions;
        this.resetShape();
    }

    public void setDimensionsAnonymous(int[] shape) throws InvalidRangeException {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions = new ArrayList<Dimension>();
        for (int i = 0; i < shape.length; ++i) {
            Dimension anon;
            if (shape[i] < 1 && shape[i] != -1) {
                throw new InvalidRangeException("shape[" + i + "]=" + shape[i] + " must be > 0");
            }
            if (shape[i] == -1) {
                anon = Dimension.VLEN;
                this.isVariableLength = true;
            } else {
                anon = new Dimension(null, shape[i], false, false, false);
            }
            this.dimensions.add(anon);
        }
        this.resetShape();
    }

    public void setIsScalar() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions = new ArrayList<Dimension>();
        this.resetShape();
    }

    public void setDimension(int idx, Dimension dim) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions.set(idx, dim);
        this.resetShape();
    }

    public Variable setImmutable() {
        this.immutable = true;
        this.dimensions = Collections.unmodifiableList(this.dimensions);
        this.attributes = Collections.unmodifiableList(this.attributes);
        return this;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public Object getSPobject() {
        return this.spiObject;
    }

    public void setSPobject(Object spiObject) {
        this.spiObject = spiObject;
    }

    public int getSizeToCache() {
        return this.sizeToCache;
    }

    public void setSizeToCache(int sizeToCache) {
        this.sizeToCache = sizeToCache;
    }

    public void setCaching(boolean caching) {
        this.cache.isCaching = caching;
        this.cache.cachingSet = true;
    }

    public boolean isCaching() {
        if (!this.cache.cachingSet) {
            this.cache.isCaching = !this.isVariableLength && this.getSize() * (long)this.getElementSize() < (long)this.sizeToCache;
            this.cache.cachingSet = true;
        }
        return this.cache.isCaching;
    }

    public void invalidateCache() {
        this.cache.data = null;
    }

    public void setCachedData(Array cacheData, boolean isMetadata) {
        if (cacheData != null && cacheData.getElementType() != this.getDataType().getPrimitiveClassType()) {
            throw new IllegalArgumentException("setCachedData type=" + cacheData.getElementType() + " incompatible with variable type=" + (Object)((Object)this.getDataType()));
        }
        this.cache.data = cacheData;
        this.isMetadata = isMetadata;
        this.cache.cachingSet = true;
        this.cache.isCaching = true;
    }

    public void createNewCache() {
        this.cache = new Cache();
    }

    public boolean hasCachedData() {
        return null != this.cache.data;
    }

    @Override
    public boolean isMemberOfStructure() {
        return this.parent != null;
    }

    @Override
    public Structure getParentStructure() {
        return this.parent;
    }

    public void setParentStructure(Structure parent) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.parent = parent;
    }

    @Override
    public List<Dimension> getDimensionsAll() {
        ArrayList<Dimension> dimsAll = new ArrayList<Dimension>();
        this.addDimensionsAll(dimsAll, this);
        return dimsAll;
    }

    private void addDimensionsAll(List<Dimension> result, Variable v) {
        if (v.isMemberOfStructure()) {
            this.addDimensionsAll(result, v.getParentStructure());
        }
        for (int i = 0; i < v.getRank(); ++i) {
            result.add(v.getDimension(i));
        }
    }

    @Override
    public boolean isCoordinateVariable() {
        Dimension firstd;
        if (this.dataType == DataType.STRUCTURE || this.isMemberOfStructure()) {
            return false;
        }
        int n = this.getRank();
        if (n == 1 && this.dimensions.size() == 1 && this.shortName.equals((firstd = this.dimensions.get(0)).getName())) {
            return true;
        }
        return n == 2 && this.dimensions.size() == 2 && this.shortName.equals((firstd = this.dimensions.get(0)).getName()) && this.getDataType() == DataType.CHAR;
    }

    public boolean isUnknownLength() {
        return this.isVariableLength;
    }

    protected static class Cache {
        public Array data;
        public boolean isCaching = false;
        public boolean cachingSet = false;
    }
}

