/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.RandomAccess;

public class UndefinedData
extends Data {
    long byteSize;
    byte[] data;

    public UndefinedData(Header header) throws FitsException {
        int n = 1;
        int n2 = 0;
        while (n2 < header.getIntValue("NAXIS")) {
            n *= header.getIntValue("NAXIS" + (n2 + 1));
            ++n2;
        }
        n += header.getIntValue("PCOUNT");
        if (header.getIntValue("GCOUNT") > 1) {
            n *= header.getIntValue("GCOUNT");
        }
        this.data = new byte[n *= Math.abs(header.getIntValue("BITPIX") / 8)];
        this.byteSize = n;
    }

    public UndefinedData(Object object) {
        this.byteSize = ArrayFuncs.computeSize(object);
        this.data = new byte[(int)this.byteSize];
    }

    protected void fillHeader(Header header) {
        try {
            header.setXtension("UNKNOWN");
            header.setBitpix(8);
            header.setNaxes(1);
            header.addValue("NAXIS1", this.byteSize, " Number of Bytes ");
            header.addValue("PCOUNT", 0L, (String)null);
            header.addValue("GCOUNT", 1L, (String)null);
            header.addValue("EXTEND", true, "Extensions are permitted");
        }
        catch (HeaderCardException headerCardException) {
            System.err.println("Unable to create unknown header:" + headerCardException);
        }
    }

    public void read(ArrayDataInput arrayDataInput) throws FitsException {
        this.setFileOffset(arrayDataInput);
        if (arrayDataInput instanceof RandomAccess) {
            try {
                arrayDataInput.skipBytes((int)this.byteSize);
            }
            catch (IOException iOException) {
                throw new FitsException("Unable to skip over data:" + iOException);
            }
        }
        try {
            arrayDataInput.readFully(this.data);
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to read unknown data:" + iOException);
        }
        int n = FitsUtil.padding(this.getTrueSize());
        try {
            if (arrayDataInput.skipBytes(n) != n) {
                throw new FitsException("Error skipping padding");
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Error reading unknown padding:" + iOException);
        }
    }

    public void write(ArrayDataOutput arrayDataOutput) throws FitsException {
        if (this.data == null) {
            this.getData();
        }
        if (this.data == null) {
            throw new FitsException("Null unknown data");
        }
        try {
            arrayDataOutput.write(this.data);
        }
        catch (IOException iOException) {
            throw new FitsException("IO Error on unknown data write" + iOException);
        }
        byte[] byArray = new byte[FitsUtil.padding(this.getTrueSize())];
        try {
            arrayDataOutput.write(byArray);
        }
        catch (IOException iOException) {
            throw new FitsException("Error writing padding: " + iOException);
        }
    }

    protected int getTrueSize() {
        return (int)this.byteSize;
    }

    public Object getData() {
        if (this.data == null) {
            try {
                FitsUtil.reposition(this.input, this.fileOffset);
                this.input.read(this.data);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.data;
    }
}

