/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.RandomAccess;

public abstract class Data
implements FitsElement {
    protected long fileOffset = -1L;
    protected int dataSize;
    protected RandomAccess input;

    public long getFileOffset() {
        return this.fileOffset;
    }

    protected void setFileOffset(Object object) {
        if (object instanceof RandomAccess) {
            this.fileOffset = FitsUtil.findOffset(object);
            this.dataSize = this.getTrueSize();
            this.input = (RandomAccess)object;
        }
    }

    public abstract void write(ArrayDataOutput var1) throws FitsException;

    public abstract void read(ArrayDataInput var1) throws FitsException;

    public void rewrite() throws FitsException {
        if (!this.rewriteable()) {
            throw new FitsException("Illegal attempt to rewrite data");
        }
        FitsUtil.reposition(this.input, this.fileOffset);
        this.write((ArrayDataOutput)((Object)this.input));
        try {
            ((ArrayDataOutput)((Object)this.input)).flush();
        }
        catch (IOException iOException) {
            throw new FitsException("Error in rewrite flush: " + iOException);
        }
    }

    public boolean rewriteable() {
        return this.input != null && this.fileOffset >= 0L && (this.getTrueSize() + 2879) / 2880 == (this.dataSize + 2879) / 2880;
    }

    abstract int getTrueSize();

    public long getSize() {
        return FitsUtil.addPadding(this.getTrueSize());
    }

    public abstract Object getData() throws FitsException;

    public Object getKernel() throws FitsException {
        return this.getData();
    }

    abstract void fillHeader(Header var1) throws FitsException;
}

