/*
    Copyright 2005 Peter Bennett

    This file is part of Jampal.

    Jampal is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Jampal is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Jampal.  If not, see <http://www.gnu.org/licenses/>.
*/
package pgbennett.jampal;
import java.awt.Font;

/**
 *
 * @author  Peter Bennett
 */
public class SearchDialog extends javax.swing.JDialog {
    
    MainFrame mainFrame;
    
    /** Creates new form SearchDialog */
    public SearchDialog(MainFrame mainFrame, boolean modal) {
        super(mainFrame.frame, modal);
        this.mainFrame=mainFrame;
        initComponents();
        textExplanation.setBackground(null);
        getRootPane().setDefaultButton(buttonFind);
        setText();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        typeGroup = new javax.swing.ButtonGroup();
        labelFind = new javax.swing.JLabel();
        textFind = new javax.swing.JTextField();
        buttonFind = new javax.swing.JButton();
        radioAllCols = new javax.swing.JRadioButton();
        radioSelectedCol = new javax.swing.JRadioButton();
        buttonClose = new javax.swing.JButton();
        textExplanation = new javax.swing.JTextArea();
        checkboxRegex = new javax.swing.JCheckBox();
        checkboxFindAll = new javax.swing.JCheckBox();
        checkboxCaseIns = new javax.swing.JCheckBox();

        setTitle("Find");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowActivated(java.awt.event.WindowEvent evt) {
                formWindowActivated(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        labelFind.setText("Find What");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        getContentPane().add(labelFind, gridBagConstraints);

        textFind.setFont(mainFrame.getSelectedFont());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 0);
        getContentPane().add(textFind, gridBagConstraints);

        buttonFind.setText("Find");
        buttonFind.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonFindActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 0, 8);
        getContentPane().add(buttonFind, gridBagConstraints);

        typeGroup.add(radioAllCols);
        radioAllCols.setSelected(true);
        radioAllCols.setText("All Columns");
        radioAllCols.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SearchDialog.this.stateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 0);
        getContentPane().add(radioAllCols, gridBagConstraints);

        typeGroup.add(radioSelectedCol);
        radioSelectedCol.setText("Selected Column Only");
        radioSelectedCol.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SearchDialog.this.stateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 0);
        getContentPane().add(radioSelectedCol, gridBagConstraints);

        buttonClose.setText("Close");
        buttonClose.setDefaultCapable(false);
        buttonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 8);
        getContentPane().add(buttonClose, gridBagConstraints);

        textExplanation.setEditable(false);
        textExplanation.setFont(mainFrame.getSelectedFont());
        textExplanation.setLineWrap(true);
        textExplanation.setWrapStyleWord(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 8, 8);
        getContentPane().add(textExplanation, gridBagConstraints);

        checkboxRegex.setText("Regular Expression");
        checkboxRegex.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SearchDialog.this.stateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 0);
        getContentPane().add(checkboxRegex, gridBagConstraints);

        checkboxFindAll.setText("Find All");
        checkboxFindAll.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SearchDialog.this.stateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 0);
        getContentPane().add(checkboxFindAll, gridBagConstraints);

        checkboxCaseIns.setSelected(true);
        checkboxCaseIns.setText("Case Insensitive");
        checkboxCaseIns.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SearchDialog.this.stateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 0);
        getContentPane().add(checkboxCaseIns, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void stateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_stateChanged
        setText();
    }//GEN-LAST:event_stateChanged

    private void setText() {
        String text=null;
        if (radioSelectedCol.isSelected())
            text = "Search on the selected column only (column of selected cell).";
        else
            text = "Search on all columns.";
        if (checkboxRegex.isSelected()) {
            text=text+"\nSearch String uses special characters to define a search pattern.";
        }
        if (checkboxCaseIns.isSelected()) {
            text=text+"\nTreats UPPER and lower case as the same.";
            if (checkboxRegex.isSelected())
                text=text+" Only finds results with diacritics if you include them in the search string " + 
                    "or use a wild card (e.g. period).";
            else {
                text=text+" Ignores diacritics.";
                if (radioSelectedCol.isSelected())
                    text=text+" Also ignores "+
                        "leading 'a', leading 'the', leading punctuation and parenthesized text in " +
                        "titles and albums.";
            }
        }
        else {
            text=text+"\nOnly finds values which match upper or lower case keyed in. "+
                    "Only finds results with diacritics if you include them in the search string";
            if (checkboxRegex.isSelected())
                text=text+" or use a wild card (e.g. period).";
            else
                text=text+".";
        }
            
        if (checkboxFindAll.isSelected()) 
            text=text+"\nFinds all matching songs and selects them. To see them all together drag them to " +
                    "another library or to the playlist.";
        textExplanation.setText(text);
        
        pack();
    }
    
    
    
    private void formWindowActivated(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowActivated
//        int selectedColCount = mainFrame.mainTable.getSelectedColumnCount();
//        int selectedColCount = mainFrame.focusCol;
        
        if (mainFrame.focusCol == -1) {
            radioAllCols.setSelected(true);
            radioSelectedCol.setEnabled(false);
        }
        else {
            if (!radioSelectedCol.isEnabled()) {
                radioSelectedCol.setEnabled(true);
            }
        }
    }//GEN-LAST:event_formWindowActivated

    private void buttonFindActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonFindActionPerformed
        mainFrame.model.find(textFind.getText(),radioSelectedCol.isSelected(),checkboxRegex.isSelected(),
                checkboxFindAll.isSelected(),checkboxCaseIns.isSelected());
    }//GEN-LAST:event_buttonFindActionPerformed

    private void buttonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonCloseActionPerformed
        setVisible(false);
    }//GEN-LAST:event_buttonCloseActionPerformed
    
    /**
     * @param args the command line arguments
     */
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton buttonClose;
    private javax.swing.JButton buttonFind;
    private javax.swing.JCheckBox checkboxCaseIns;
    private javax.swing.JCheckBox checkboxFindAll;
    private javax.swing.JCheckBox checkboxRegex;
    private javax.swing.JLabel labelFind;
    private javax.swing.JRadioButton radioAllCols;
    private javax.swing.JRadioButton radioSelectedCol;
    private javax.swing.JTextArea textExplanation;
    private javax.swing.JTextField textFind;
    private javax.swing.ButtonGroup typeGroup;
    // End of variables declaration//GEN-END:variables
    
}
