
/****************************************************************************
*
* Copyright (C) 2004 Ikke - http://www.eikke.com.  All rights reserved.
*
* This file is part of IVMan (ivm).
*
* This file may be distributed under the terms of the Q Public License
* as defined by Troll Tech AS of Norway and appearing in the file
* LICENSE.QPL included in the packaging of this file.
* 
* See http://www.troll.no/qpl for QPL licensing information.
*
* $Id: hal_interface.h,v 1.9 2007/01/29 11:52:31 makoenig Exp $
*****************************************************************************/

#ifndef _HAL_INTERFACE_H
#define _HAL_INTERFACE_H

void hal_device_added(LibHalContext * ctx
                      __attribute__ ((__unused__)), const char *udi);
void hal_device_removed(LibHalContext * ctx
                        __attribute__ ((__unused__)), const char *udi);
void hal_device_new_capability(LibHalContext * ctx
                               __attribute__ ((__unused__)),
                               const char *udi
                               __attribute__ ((__unused__)),
                               const char *capability
                               __attribute__ ((__unused__)));
void hal_device_lost_capability(LibHalContext * ctx
                                __attribute__ ((__unused__)),
                                const char *udi
                                __attribute__ ((__unused__)),
                                const char *capability
                                __attribute__ ((__unused__)));
void hal_device_property_modified(LibHalContext * ctx
                                  __attribute__ ((__unused__)),
                                  const char *udi, const char *key,
                                  dbus_bool_t is_removed
                                  __attribute__ ((__unused__)),
                                  dbus_bool_t is_added
                                  __attribute__ ((__unused__)));
#ifdef HAL_0_4
void hal_device_condition(LibHalContext * ctx
                          __attribute__ ((__unused__)),
                          const char *udi,
                          const char *condition_name,
                          DBusMessage * message
                          __attribute__ ((__unused__)));
#else
void hal_device_condition(LibHalContext * ctx
                          __attribute__ ((__unused__)),
                          const char *udi,
                          const char *condition_name,
                          const char *condition_detail);

#endif
#ifdef HAL_0_4
void hal_mainloop_integration(LibHalContext * ctx
                              __attribute__ ((__unused__)),
                              DBusConnection * dbus_connection);
#else
dbus_bool_t hal_mainloop_integration(LibHalContext * ctx,
                                     DBusError * error);
#endif                          // HAL_0_4


void
ivm_check_dbus_error(DBusError * error);
#endif

void hal_init(void);
void hal_deinit(void);
