#!/bin/sh
set -e
# wrapper that sets environment variables for itrans(1)
# by Jaldhar H. Vyas <jaldhar@debian.org> Sep 30 2004
# donated to public domain

#------------------------------------------------------------
# ITRANSPATH is used by itrans, to look for the files it needs
# (such as dvng.ifm, dvng10.tfm, devnac.afm, etc)
ITRANSPATH=/usr/share/itrans/lib:/usr/share/texmf-texlive/fonts/afm/public/itrans:/usr/share/texmf-texlive/fonts/tfm/public/itrans:/usr/share/texmf-texlive/fonts/truetype/public/itrans:/usr/share/texmf-texlive/fonts/type1/public/itrans
export ITRANSPATH

#------------------------------------------------------------
# TEXFONTS is used by tex, latex, etc,
# In some systems, even system wide paths have to be mentioned again here..
TEXFONTS=:/usr/share/texmf-texlive:
export TEXFONTS

#------------------------------------------------------------
# looks like dvips does not look for the pk files in TEXFONTS (it
# does look for TFM files there), anyway, define TEXPKS for dvips
# to be same as the TEXFONTS definition
TEXPKS=$TEXFONTS
export TEXPKS

#------------------------------------------------------------
# TEXCONFIG is used by dvips, and it understands the empty path
# to mean search in the system wide area, so just need to
# provide our path here.., system wide paths are taken care of
# automatically.
TEXCONFIG=:$ITRANSPATH
export TEXCONFIG

#------------------------------------------------------------
# TeX and MF input files (\input TeX command, and MetaFont *.mf files)
TEXINPUTS=$TEXFONTS
export TEXINPUTS
MFINPUTS=$TEXFONTS
export MFINPUTS

#------------------------------------------------------------
# location of dvips(1) startup file
DVIPSRC=/usr/share/itrans/lib/DVIPSRC
export DVIPSRC

exec /usr/bin/itrans.real $@
