;;;; tests from RFC 2104

(in-package :crypto-tests)

;;; Test vectors from the RFC use MD5.
(defvar *digest-algorithm* :md5)

(defun hmac-test (key data expected-digest)
  (let ((hmac (ironclad:make-hmac key *digest-algorithm*)))
    (ironclad:update-hmac hmac data)
    (not (mismatch expected-digest (ironclad:hmac-digest hmac)))))

(rt:deftest hmac.0
  (hmac-test (make-array 16 :element-type '(unsigned-byte 8)
                         :initial-element #x0b)
             (ironclad:ascii-string-to-byte-array "Hi There")
             #(#x92 #x94 #x72 #x7A #x36 #x38 #xBB #x1C #x13 #xF4 #x8E #xF8 #x15 #x8B #xFC #x9D))
  t)

(rt:deftest hmac.1
  (hmac-test (ironclad:ascii-string-to-byte-array "Jefe")
             (ironclad:ascii-string-to-byte-array "what do ya want for nothing?")
             #(#x75 #x0c #x78 #x3e #x6a #xb0 #xb5 #x03 #xea #xa8 #x6e #x31 #x0a #x5d #xb7 #x38))
  t)

(rt:deftest hmac.2
  (hmac-test (make-array 16 :element-type '(unsigned-byte 8)
                         :initial-element #xaa)
             (make-array 50 :element-type '(unsigned-byte 8)
                         :initial-element #xdd)
             #(#x56 #xbe #x34 #x52 #x1d #x14 #x4c #x88 #xdb #xb8 #xc7 #x33 #xf0 #xe8 #xb3 #xf6))
  t)
