/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/common/irmp3tools.h,v $ -- some useful functions
 * $Id: irmp3tools.h,v 1.6 2004/02/08 10:30:31 boucman Exp $
 *
 * Copyright (C) by Andreas Neuhaus <andy@fasta.fh-dortmund.de>
 *
 * Please contact the current maintainer, Jeremy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */

#ifndef TOOLS_H
#define TOOLS_H

#include <stdio.h>

/*************************************************************************
 * GLOBAL VARIABLES
 */
// signals to reading function that they shouldn't wait for input and return.
extern int terminate;

/*************************************************************************
 * MACRO FUNCTIONS
 */
#define MAX(a,b) (((a)>(b))?(a):(b))
#define MIN(a,b) (((a)<(b))?(a):(b))


/*************************************************************************
 * FUNCTIONS
 */
int freadtrimedline(FILE *fh, char *buf, int count);
int readline (int fd, char *buf, int count);
int sendtext (int fd, char *text, ...);
char *trimleft (char *str);
char *trimright (char *str);
char *trim (char *str);



#endif /* TOOLS_H */

/*************************************************************************
 * EOF
 */
