// --------------------------------------------------------------------
// Width information for the 14 standard postscript fonts
// Taken from Xpdf 2.01, Copyright 2001-2002 Glyph & Cog, LLC
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2012  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ipebase.h"

using namespace ipe;

// --------------------------------------------------------------------

struct StdFontWidth {
  const char *iName;
  ushort iWidth;
};

struct StdFontData {
  const char *iName;
  const StdFontWidth *iWidths;
  int iNumWidths;
  short iAscent;
  short iDescent;
  short iBBox[4];
};

// --------------------------------------------------------------------

// All courier fonts are monospaced with a width of 600

static const StdFontWidth helveticaWidthsTab[] = {
  { "Ntilde",                            722 },
  { "comma",                             278 },
  { "cedilla",                           333 },
  { "plusminus",                         584 },
  { "circumflex",                        333 },
  { "dotaccent",                         333 },
  { "asciitilde",                        584 },
  { "colon",                             278 },
  { "onehalf",                           834 },
  { "dollar",                            556 },
  { "ntilde",                            556 },
  { "minus",                             584 },
  { "yen",                               556 },
  { "space",                             278 },
  { "questiondown",                      611 },
  { "emdash",                           1000 },
  { "Agrave",                            667 },
  { "three",                             556 },
  { "numbersign",                        556 },
  { "A",                                 667 },
  { "B",                                 667 },
  { "C",                                 722 },
  { "D",                                 722 },
  { "E",                                 667 },
  { "onequarter",                        834 },
  { "F",                                 611 },
  { "G",                                 778 },
  { "H",                                 722 },
  { "I",                                 278 },
  { "J",                                 500 },
  { "K",                                 667 },
  { "backslash",                         278 },
  { "L",                                 556 },
  { "periodcentered",                    278 },
  { "M",                                 833 },
  { "N",                                 722 },
  { "O",                                 778 },
  { "P",                                 667 },
  { "Q",                                 778 },
  { "R",                                 722 },
  { "Aacute",                            667 },
  { "caron",                             333 },
  { "S",                                 667 },
  { "T",                                 611 },
  { "U",                                 722 },
  { "agrave",                            556 },
  { "V",                                 667 },
  { "W",                                 944 },
  { "X",                                 667 },
  { "question",                          556 },
  { "equal",                             584 },
  { "Y",                                 667 },
  { "Z",                                 611 },
  { "four",                              556 },
  { "a",                                 556 },
  { "b",                                 556 },
  { "c",                                 500 },
  { "d",                                 556 },
  { "e",                                 556 },
  { "f",                                 278 },
  { "g",                                 556 },
  { "bullet",                            350 },
  { "h",                                 556 },
  { "i",                                 222 },
  { "Oslash",                            778 },
  { "dagger",                            556 },
  { "j",                                 222 },
  { "k",                                 500 },
  { "l",                                 222 },
  { "m",                                 833 },
  { "n",                                 556 },
  { "o",                                 556 },
  { "ordfeminine",                       370 },
  { "ring",                              333 },
  { "p",                                 556 },
  { "q",                                 556 },
  { "r",                                 333 },
  { "twosuperior",                       333 },
  { "aacute",                            556 },
  { "s",                                 500 },
  { "OE",                               1000 },
  { "t",                                 278 },
  { "divide",                            584 },
  { "u",                                 556 },
  { "v",                                 500 },
  { "w",                                 722 },
  { "x",                                 500 },
  { "y",                                 500 },
  { "z",                                 500 },
  { "hungarumlaut",                      333 },
  { "quotedbl",                          355 },
  { "mu",                                556 },
  { "Scaron",                            667 },
  { "Lslash",                            556 },
  { "semicolon",                         278 },
  { "oslash",                            611 },
  { "parenright",                        333 },
  { "Ecircumflex",                       667 },
  { "trademark",                        1000 },
  { "daggerdbl",                         556 },
  { "macron",                            333 },
  { "Otilde",                            778 },
  { "ellipsis",                         1000 },
  { "scaron",                            500 },
  { "AE",                               1000 },
  { "Ucircumflex",                       722 },
  { "lslash",                            222 },
  { "quotedblleft",                      333 },
  { "guilsinglright",                    333 },
  { "hyphen",                            333 },
  { "quotesingle",                       191 },
  { "eight",                             556 },
  { "exclamdown",                        333 },
  { "endash",                            556 },
  { "oe",                                944 },
  { "ecircumflex",                       556 },
  { "copyright",                         737 },
  { "Adieresis",                         667 },
  { "Egrave",                            667 },
  { "slash",                             278 },
  { "Edieresis",                         667 },
  { "otilde",                            556 },
  { "Idieresis",                         278 },
  { "parenleft",                         333 },
  { "one",                               556 },
  { "ucircumflex",                       556 },
  { "Odieresis",                         778 },
  { "bracketleft",                       278 },
  { "Ugrave",                            722 },
  { "quoteright",                        222 },
  { "Udieresis",                         722 },
  { "perthousand",                      1000 },
  { "Ydieresis",                         667 },
  { "Eacute",                            667 },
  { "adieresis",                         556 },
  { "egrave",                            556 },
  { "edieresis",                         556 },
  { "idieresis",                         278 },
  { "Eth",                               722 },
  { "ae",                                889 },
  { "asterisk",                          389 },
  { "odieresis",                         556 },
  { "Uacute",                            722 },
  { "ugrave",                            556 },
  { "nine",                              556 },
  { "five",                              556 },
  { "udieresis",                         556 },
  { "Zcaron",                            611 },
  { "threequarters",                     834 },
  { "guillemotright",                    556 },
  { "ydieresis",                         500 },
  { "Ccedilla",                          722 },
  { "tilde",                             333 },
  { "at",                               1015 },
  { "eacute",                            556 },
  { "underscore",                        556 },
  { "multiply",                          584 },
  { "zero",                              556 },
  { "eth",                               556 },
  { "Ograve",                            778 },
  { "uacute",                            556 },
  { "braceleft",                         334 },
  { "Thorn",                             667 },
  { "zcaron",                            500 },
  { "ccedilla",                          500 },
  { "Ocircumflex",                       778 },
  { "Oacute",                            778 },
  { "ogonek",                            333 },
  { "ograve",                            556 },
  { "thorn",                             556 },
  { "degree",                            400 },
  { "registered",                        737 },
  { "Aring",                             667 },
  { "percent",                           889 },
  { "six",                               556 },
  { "paragraph",                         537 },
  { "two",                               556 },
  { "Igrave",                            278 },
  { "ocircumflex",                       556 },
  { "oacute",                            556 },
  { "asciicircum",                       469 },
  { "aring",                             556 },
  { "grave",                             333 },
  { "bracketright",                      278 },
  { "Iacute",                            278 },
  { "ampersand",                         667 },
  { "igrave",                            278 },
  { "plus",                              584 },
  { "quotesinglbase",                    222 },
  { "Yacute",                            667 },
  { "threesuperior",                     333 },
  { "acute",                             333 },
  { "section",                           556 },
  { "dieresis",                          333 },
  { "iacute",                            278 },
  { "quotedblbase",                      333 },
  { "florin",                            556 },
  { "yacute",                            500 },
  { "fi",                                500 },
  { "fl",                                500 },
  { "Acircumflex",                       667 },
  { "Icircumflex",                       278 },
  { "guillemotleft",                     556 },
  { "germandbls",                        611 },
  { "seven",                             556 },
  { "ordmasculine",                      365 },
  { "dotlessi",                          278 },
  { "sterling",                          556 },
  { "acircumflex",                       556 },
  { "icircumflex",                       278 },
  { "braceright",                        334 },
  { "quotedblright",                     333 },
  { "cent",                              556 },
  { "currency",                          556 },
  { "logicalnot",                        584 },
  { "Atilde",                            667 },
  { "breve",                             333 },
  { "bar",                               260 },
  { "fraction",                          167 },
  { "less",                              584 },
  { "guilsinglleft",                     333 },
  { "exclam",                            278 },
  { "period",                            278 },
  { "greater",                           584 },
  { "atilde",                            556 },
  { "brokenbar",                         260 },
  { "quoteleft",                         222 },
  { "onesuperior",                       333 }
};

static const StdFontWidth helveticaBoldWidthsTab[] = {
  { "Ntilde",                            722 },
  { "comma",                             278 },
  { "cedilla",                           333 },
  { "plusminus",                         584 },
  { "circumflex",                        333 },
  { "dotaccent",                         333 },
  { "asciitilde",                        584 },
  { "colon",                             333 },
  { "onehalf",                           834 },
  { "dollar",                            556 },
  { "ntilde",                            611 },
  { "minus",                             584 },
  { "yen",                               556 },
  { "space",                             278 },
  { "questiondown",                      611 },
  { "emdash",                           1000 },
  { "Agrave",                            722 },
  { "three",                             556 },
  { "numbersign",                        556 },
  { "A",                                 722 },
  { "B",                                 722 },
  { "C",                                 722 },
  { "D",                                 722 },
  { "E",                                 667 },
  { "onequarter",                        834 },
  { "F",                                 611 },
  { "G",                                 778 },
  { "H",                                 722 },
  { "I",                                 278 },
  { "J",                                 556 },
  { "K",                                 722 },
  { "backslash",                         278 },
  { "L",                                 611 },
  { "periodcentered",                    278 },
  { "M",                                 833 },
  { "N",                                 722 },
  { "O",                                 778 },
  { "P",                                 667 },
  { "Q",                                 778 },
  { "R",                                 722 },
  { "Aacute",                            722 },
  { "caron",                             333 },
  { "S",                                 667 },
  { "T",                                 611 },
  { "U",                                 722 },
  { "agrave",                            556 },
  { "V",                                 667 },
  { "W",                                 944 },
  { "X",                                 667 },
  { "question",                          611 },
  { "equal",                             584 },
  { "Y",                                 667 },
  { "Z",                                 611 },
  { "four",                              556 },
  { "a",                                 556 },
  { "b",                                 611 },
  { "c",                                 556 },
  { "d",                                 611 },
  { "e",                                 556 },
  { "f",                                 333 },
  { "g",                                 611 },
  { "bullet",                            350 },
  { "h",                                 611 },
  { "i",                                 278 },
  { "Oslash",                            778 },
  { "dagger",                            556 },
  { "j",                                 278 },
  { "k",                                 556 },
  { "l",                                 278 },
  { "m",                                 889 },
  { "n",                                 611 },
  { "o",                                 611 },
  { "ordfeminine",                       370 },
  { "ring",                              333 },
  { "p",                                 611 },
  { "q",                                 611 },
  { "r",                                 389 },
  { "twosuperior",                       333 },
  { "aacute",                            556 },
  { "s",                                 556 },
  { "OE",                               1000 },
  { "t",                                 333 },
  { "divide",                            584 },
  { "u",                                 611 },
  { "v",                                 556 },
  { "w",                                 778 },
  { "x",                                 556 },
  { "y",                                 556 },
  { "z",                                 500 },
  { "hungarumlaut",                      333 },
  { "quotedbl",                          474 },
  { "mu",                                611 },
  { "Scaron",                            667 },
  { "Lslash",                            611 },
  { "semicolon",                         333 },
  { "oslash",                            611 },
  { "parenright",                        333 },
  { "Ecircumflex",                       667 },
  { "trademark",                        1000 },
  { "daggerdbl",                         556 },
  { "macron",                            333 },
  { "Otilde",                            778 },
  { "ellipsis",                         1000 },
  { "scaron",                            556 },
  { "AE",                               1000 },
  { "Ucircumflex",                       722 },
  { "lslash",                            278 },
  { "quotedblleft",                      500 },
  { "guilsinglright",                    333 },
  { "hyphen",                            333 },
  { "quotesingle",                       238 },
  { "eight",                             556 },
  { "exclamdown",                        333 },
  { "endash",                            556 },
  { "oe",                                944 },
  { "ecircumflex",                       556 },
  { "copyright",                         737 },
  { "Adieresis",                         722 },
  { "Egrave",                            667 },
  { "slash",                             278 },
  { "Edieresis",                         667 },
  { "otilde",                            611 },
  { "Idieresis",                         278 },
  { "parenleft",                         333 },
  { "one",                               556 },
  { "ucircumflex",                       611 },
  { "Odieresis",                         778 },
  { "bracketleft",                       333 },
  { "Ugrave",                            722 },
  { "quoteright",                        278 },
  { "Udieresis",                         722 },
  { "perthousand",                      1000 },
  { "Ydieresis",                         667 },
  { "Eacute",                            667 },
  { "adieresis",                         556 },
  { "egrave",                            556 },
  { "edieresis",                         556 },
  { "idieresis",                         278 },
  { "Eth",                               722 },
  { "ae",                                889 },
  { "asterisk",                          389 },
  { "odieresis",                         611 },
  { "Uacute",                            722 },
  { "ugrave",                            611 },
  { "nine",                              556 },
  { "five",                              556 },
  { "udieresis",                         611 },
  { "Zcaron",                            611 },
  { "threequarters",                     834 },
  { "guillemotright",                    556 },
  { "ydieresis",                         556 },
  { "Ccedilla",                          722 },
  { "tilde",                             333 },
  { "dbldaggerumlaut",                   556 },
  { "at",                                975 },
  { "eacute",                            556 },
  { "underscore",                        556 },
  { "multiply",                          584 },
  { "zero",                              556 },
  { "eth",                               611 },
  { "Ograve",                            778 },
  { "uacute",                            611 },
  { "braceleft",                         389 },
  { "Thorn",                             667 },
  { "zcaron",                            500 },
  { "ccedilla",                          556 },
  { "Ocircumflex",                       778 },
  { "Oacute",                            778 },
  { "ogonek",                            333 },
  { "ograve",                            611 },
  { "thorn",                             611 },
  { "degree",                            400 },
  { "registered",                        737 },
  { "Aring",                             722 },
  { "percent",                           889 },
  { "six",                               556 },
  { "paragraph",                         556 },
  { "two",                               556 },
  { "Igrave",                            278 },
  { "ocircumflex",                       611 },
  { "oacute",                            611 },
  { "asciicircum",                       584 },
  { "aring",                             556 },
  { "grave",                             333 },
  { "bracketright",                      333 },
  { "Iacute",                            278 },
  { "ampersand",                         722 },
  { "igrave",                            278 },
  { "plus",                              584 },
  { "quotesinglbase",                    278 },
  { "Yacute",                            667 },
  { "threesuperior",                     333 },
  { "acute",                             333 },
  { "section",                           556 },
  { "dieresis",                          333 },
  { "iacute",                            278 },
  { "quotedblbase",                      500 },
  { "florin",                            556 },
  { "yacute",                            556 },
  { "fi",                                611 },
  { "fl",                                611 },
  { "Acircumflex",                       722 },
  { "Icircumflex",                       278 },
  { "guillemotleft",                     556 },
  { "germandbls",                        611 },
  { "seven",                             556 },
  { "ordmasculine",                      365 },
  { "dotlessi",                          278 },
  { "sterling",                          556 },
  { "acircumflex",                       556 },
  { "icircumflex",                       278 },
  { "braceright",                        389 },
  { "quotedblright",                     500 },
  { "cent",                              556 },
  { "currency",                          556 },
  { "logicalnot",                        584 },
  { "Atilde",                            722 },
  { "breve",                             333 },
  { "bar",                               280 },
  { "fraction",                          167 },
  { "less",                              584 },
  { "guilsinglleft",                     333 },
  { "exclam",                            333 },
  { "period",                            278 },
  { "greater",                           584 },
  { "atilde",                            556 },
  { "brokenbar",                         280 },
  { "quoteleft",                         278 },
  { "onesuperior",                       333 }
};

static const StdFontWidth helveticaBoldObliqueWidthsTab[] = {
  { "Ntilde",                            722 },
  { "comma",                             278 },
  { "cedilla",                           333 },
  { "plusminus",                         584 },
  { "circumflex",                        333 },
  { "dotaccent",                         333 },
  { "asciitilde",                        584 },
  { "colon",                             333 },
  { "onehalf",                           834 },
  { "dollar",                            556 },
  { "ntilde",                            611 },
  { "minus",                             584 },
  { "yen",                               556 },
  { "space",                             278 },
  { "questiondown",                      611 },
  { "emdash",                           1000 },
  { "Agrave",                            722 },
  { "three",                             556 },
  { "numbersign",                        556 },
  { "A",                                 722 },
  { "B",                                 722 },
  { "C",                                 722 },
  { "D",                                 722 },
  { "E",                                 667 },
  { "onequarter",                        834 },
  { "F",                                 611 },
  { "G",                                 778 },
  { "H",                                 722 },
  { "I",                                 278 },
  { "J",                                 556 },
  { "K",                                 722 },
  { "backslash",                         278 },
  { "L",                                 611 },
  { "periodcentered",                    278 },
  { "M",                                 833 },
  { "N",                                 722 },
  { "O",                                 778 },
  { "P",                                 667 },
  { "Q",                                 778 },
  { "R",                                 722 },
  { "Aacute",                            722 },
  { "caron",                             333 },
  { "S",                                 667 },
  { "T",                                 611 },
  { "U",                                 722 },
  { "agrave",                            556 },
  { "V",                                 667 },
  { "W",                                 944 },
  { "X",                                 667 },
  { "question",                          611 },
  { "equal",                             584 },
  { "Y",                                 667 },
  { "Z",                                 611 },
  { "four",                              556 },
  { "a",                                 556 },
  { "b",                                 611 },
  { "c",                                 556 },
  { "d",                                 611 },
  { "e",                                 556 },
  { "f",                                 333 },
  { "g",                                 611 },
  { "bullet",                            350 },
  { "h",                                 611 },
  { "i",                                 278 },
  { "Oslash",                            778 },
  { "dagger",                            556 },
  { "j",                                 278 },
  { "k",                                 556 },
  { "l",                                 278 },
  { "m",                                 889 },
  { "n",                                 611 },
  { "o",                                 611 },
  { "ordfeminine",                       370 },
  { "ring",                              333 },
  { "p",                                 611 },
  { "q",                                 611 },
  { "r",                                 389 },
  { "twosuperior",                       333 },
  { "aacute",                            556 },
  { "s",                                 556 },
  { "OE",                               1000 },
  { "t",                                 333 },
  { "divide",                            584 },
  { "u",                                 611 },
  { "v",                                 556 },
  { "w",                                 778 },
  { "x",                                 556 },
  { "y",                                 556 },
  { "z",                                 500 },
  { "hungarumlaut",                      333 },
  { "quotedbl",                          474 },
  { "mu",                                611 },
  { "Scaron",                            667 },
  { "Lslash",                            611 },
  { "semicolon",                         333 },
  { "oslash",                            611 },
  { "parenright",                        333 },
  { "Ecircumflex",                       667 },
  { "trademark",                        1000 },
  { "daggerdbl",                         556 },
  { "macron",                            333 },
  { "Otilde",                            778 },
  { "ellipsis",                         1000 },
  { "scaron",                            556 },
  { "AE",                               1000 },
  { "Ucircumflex",                       722 },
  { "lslash",                            278 },
  { "quotedblleft",                      500 },
  { "guilsinglright",                    333 },
  { "hyphen",                            333 },
  { "quotesingle",                       238 },
  { "eight",                             556 },
  { "exclamdown",                        333 },
  { "endash",                            556 },
  { "oe",                                944 },
  { "ecircumflex",                       556 },
  { "copyright",                         737 },
  { "Adieresis",                         722 },
  { "Egrave",                            667 },
  { "slash",                             278 },
  { "Edieresis",                         667 },
  { "otilde",                            611 },
  { "Idieresis",                         278 },
  { "parenleft",                         333 },
  { "one",                               556 },
  { "ucircumflex",                       611 },
  { "Odieresis",                         778 },
  { "bracketleft",                       333 },
  { "Ugrave",                            722 },
  { "quoteright",                        278 },
  { "Udieresis",                         722 },
  { "perthousand",                      1000 },
  { "Ydieresis",                         667 },
  { "Eacute",                            667 },
  { "adieresis",                         556 },
  { "egrave",                            556 },
  { "edieresis",                         556 },
  { "idieresis",                         278 },
  { "Eth",                               722 },
  { "ae",                                889 },
  { "asterisk",                          389 },
  { "odieresis",                         611 },
  { "Uacute",                            722 },
  { "ugrave",                            611 },
  { "nine",                              556 },
  { "five",                              556 },
  { "udieresis",                         611 },
  { "Zcaron",                            611 },
  { "threequarters",                     834 },
  { "guillemotright",                    556 },
  { "ydieresis",                         556 },
  { "Ccedilla",                          722 },
  { "tilde",                             333 },
  { "at",                                975 },
  { "eacute",                            556 },
  { "underscore",                        556 },
  { "multiply",                          584 },
  { "zero",                              556 },
  { "eth",                               611 },
  { "Ograve",                            778 },
  { "uacute",                            611 },
  { "braceleft",                         389 },
  { "Thorn",                             667 },
  { "zcaron",                            500 },
  { "ccedilla",                          556 },
  { "Ocircumflex",                       778 },
  { "Oacute",                            778 },
  { "ogonek",                            333 },
  { "ograve",                            611 },
  { "thorn",                             611 },
  { "degree",                            400 },
  { "registered",                        737 },
  { "Aring",                             722 },
  { "percent",                           889 },
  { "six",                               556 },
  { "paragraph",                         556 },
  { "two",                               556 },
  { "Igrave",                            278 },
  { "ocircumflex",                       611 },
  { "oacute",                            611 },
  { "asciicircum",                       584 },
  { "aring",                             556 },
  { "grave",                             333 },
  { "bracketright",                      333 },
  { "Iacute",                            278 },
  { "ampersand",                         722 },
  { "igrave",                            278 },
  { "plus",                              584 },
  { "quotesinglbase",                    278 },
  { "Yacute",                            667 },
  { "threesuperior",                     333 },
  { "acute",                             333 },
  { "section",                           556 },
  { "dieresis",                          333 },
  { "iacute",                            278 },
  { "quotedblbase",                      500 },
  { "florin",                            556 },
  { "yacute",                            556 },
  { "fi",                                611 },
  { "fl",                                611 },
  { "Acircumflex",                       722 },
  { "Icircumflex",                       278 },
  { "guillemotleft",                     556 },
  { "germandbls",                        611 },
  { "seven",                             556 },
  { "ordmasculine",                      365 },
  { "dotlessi",                          278 },
  { "sterling",                          556 },
  { "acircumflex",                       556 },
  { "icircumflex",                       278 },
  { "braceright",                        389 },
  { "quotedblright",                     500 },
  { "cent",                              556 },
  { "currency",                          556 },
  { "logicalnot",                        584 },
  { "Atilde",                            722 },
  { "breve",                             333 },
  { "bar",                               280 },
  { "fraction",                          167 },
  { "less",                              584 },
  { "guilsinglleft",                     333 },
  { "exclam",                            333 },
  { "period",                            278 },
  { "greater",                           584 },
  { "atilde",                            556 },
  { "brokenbar",                         280 },
  { "quoteleft",                         278 },
  { "onesuperior",                       333 }
};

static const StdFontWidth helveticaObliqueWidthsTab[] = {
  { "Ntilde",                            722 },
  { "comma",                             278 },
  { "cedilla",                           333 },
  { "plusminus",                         584 },
  { "circumflex",                        333 },
  { "dotaccent",                         333 },
  { "asciitilde",                        584 },
  { "colon",                             278 },
  { "onehalf",                           834 },
  { "dollar",                            556 },
  { "ntilde",                            556 },
  { "minus",                             584 },
  { "yen",                               556 },
  { "space",                             278 },
  { "questiondown",                      611 },
  { "emdash",                           1000 },
  { "Agrave",                            667 },
  { "three",                             556 },
  { "numbersign",                        556 },
  { "A",                                 667 },
  { "B",                                 667 },
  { "C",                                 722 },
  { "D",                                 722 },
  { "E",                                 667 },
  { "onequarter",                        834 },
  { "F",                                 611 },
  { "G",                                 778 },
  { "H",                                 722 },
  { "I",                                 278 },
  { "J",                                 500 },
  { "K",                                 667 },
  { "backslash",                         278 },
  { "L",                                 556 },
  { "periodcentered",                    278 },
  { "M",                                 833 },
  { "N",                                 722 },
  { "O",                                 778 },
  { "P",                                 667 },
  { "Q",                                 778 },
  { "R",                                 722 },
  { "Aacute",                            667 },
  { "caron",                             333 },
  { "S",                                 667 },
  { "T",                                 611 },
  { "U",                                 722 },
  { "agrave",                            556 },
  { "V",                                 667 },
  { "W",                                 944 },
  { "X",                                 667 },
  { "question",                          556 },
  { "equal",                             584 },
  { "Y",                                 667 },
  { "Z",                                 611 },
  { "four",                              556 },
  { "a",                                 556 },
  { "b",                                 556 },
  { "c",                                 500 },
  { "d",                                 556 },
  { "e",                                 556 },
  { "f",                                 278 },
  { "g",                                 556 },
  { "bullet",                            350 },
  { "h",                                 556 },
  { "i",                                 222 },
  { "Oslash",                            778 },
  { "dagger",                            556 },
  { "j",                                 222 },
  { "k",                                 500 },
  { "l",                                 222 },
  { "m",                                 833 },
  { "n",                                 556 },
  { "o",                                 556 },
  { "ordfeminine",                       370 },
  { "ring",                              333 },
  { "p",                                 556 },
  { "q",                                 556 },
  { "r",                                 333 },
  { "twosuperior",                       333 },
  { "aacute",                            556 },
  { "s",                                 500 },
  { "OE",                               1000 },
  { "t",                                 278 },
  { "divide",                            584 },
  { "u",                                 556 },
  { "v",                                 500 },
  { "w",                                 722 },
  { "x",                                 500 },
  { "y",                                 500 },
  { "z",                                 500 },
  { "hungarumlaut",                      333 },
  { "quotedbl",                          355 },
  { "mu",                                556 },
  { "Scaron",                            667 },
  { "Lslash",                            556 },
  { "semicolon",                         278 },
  { "oslash",                            611 },
  { "parenright",                        333 },
  { "Ecircumflex",                       667 },
  { "trademark",                        1000 },
  { "daggerdbl",                         556 },
  { "macron",                            333 },
  { "Otilde",                            778 },
  { "ellipsis",                         1000 },
  { "scaron",                            500 },
  { "AE",                               1000 },
  { "Ucircumflex",                       722 },
  { "lslash",                            222 },
  { "quotedblleft",                      333 },
  { "guilsinglright",                    333 },
  { "hyphen",                            333 },
  { "quotesingle",                       191 },
  { "eight",                             556 },
  { "exclamdown",                        333 },
  { "endash",                            556 },
  { "oe",                                944 },
  { "ecircumflex",                       556 },
  { "copyright",                         737 },
  { "Adieresis",                         667 },
  { "Egrave",                            667 },
  { "slash",                             278 },
  { "Edieresis",                         667 },
  { "otilde",                            556 },
  { "Idieresis",                         278 },
  { "parenleft",                         333 },
  { "one",                               556 },
  { "ucircumflex",                       556 },
  { "Odieresis",                         778 },
  { "bracketleft",                       278 },
  { "Ugrave",                            722 },
  { "quoteright",                        222 },
  { "Udieresis",                         722 },
  { "perthousand",                      1000 },
  { "Ydieresis",                         667 },
  { "Eacute",                            667 },
  { "adieresis",                         556 },
  { "egrave",                            556 },
  { "edieresis",                         556 },
  { "idieresis",                         278 },
  { "Eth",                               722 },
  { "ae",                                889 },
  { "asterisk",                          389 },
  { "odieresis",                         556 },
  { "Uacute",                            722 },
  { "ugrave",                            556 },
  { "nine",                              556 },
  { "five",                              556 },
  { "udieresis",                         556 },
  { "Zcaron",                            611 },
  { "threequarters",                     834 },
  { "guillemotright",                    556 },
  { "ydieresis",                         500 },
  { "Ccedilla",                          722 },
  { "tilde",                             333 },
  { "at",                               1015 },
  { "eacute",                            556 },
  { "underscore",                        556 },
  { "multiply",                          584 },
  { "zero",                              556 },
  { "eth",                               556 },
  { "Ograve",                            778 },
  { "uacute",                            556 },
  { "braceleft",                         334 },
  { "Thorn",                             667 },
  { "zcaron",                            500 },
  { "ccedilla",                          500 },
  { "Ocircumflex",                       778 },
  { "Oacute",                            778 },
  { "ogonek",                            333 },
  { "ograve",                            556 },
  { "thorn",                             556 },
  { "degree",                            400 },
  { "registered",                        737 },
  { "Aring",                             667 },
  { "percent",                           889 },
  { "six",                               556 },
  { "paragraph",                         537 },
  { "two",                               556 },
  { "Igrave",                            278 },
  { "ocircumflex",                       556 },
  { "oacute",                            556 },
  { "asciicircum",                       469 },
  { "aring",                             556 },
  { "grave",                             333 },
  { "bracketright",                      278 },
  { "Iacute",                            278 },
  { "ampersand",                         667 },
  { "igrave",                            278 },
  { "plus",                              584 },
  { "quotesinglbase",                    222 },
  { "Yacute",                            667 },
  { "threesuperior",                     333 },
  { "acute",                             333 },
  { "section",                           556 },
  { "dieresis",                          333 },
  { "iacute",                            278 },
  { "quotedblbase",                      333 },
  { "florin",                            556 },
  { "yacute",                            500 },
  { "fi",                                500 },
  { "fl",                                500 },
  { "Acircumflex",                       667 },
  { "Icircumflex",                       278 },
  { "guillemotleft",                     556 },
  { "germandbls",                        611 },
  { "seven",                             556 },
  { "ordmasculine",                      365 },
  { "dotlessi",                          278 },
  { "sterling",                          556 },
  { "acircumflex",                       556 },
  { "icircumflex",                       278 },
  { "braceright",                        334 },
  { "quotedblright",                     333 },
  { "cent",                              556 },
  { "currency",                          556 },
  { "logicalnot",                        584 },
  { "Atilde",                            667 },
  { "breve",                             333 },
  { "bar",                               260 },
  { "fraction",                          167 },
  { "less",                              584 },
  { "guilsinglleft",                     333 },
  { "exclam",                            278 },
  { "period",                            278 },
  { "greater",                           584 },
  { "atilde",                            556 },
  { "brokenbar",                         260 },
  { "quoteleft",                         222 },
  { "onesuperior",                       333 }
};

static const StdFontWidth symbolWidthsTab[] = {
  { "bracketleftex",                     384 },
  { "alpha",                             631 },
  { "union",                             768 },
  { "infinity",                          713 },
  { "comma",                             250 },
  { "copyrightsans",                     790 },
  { "plusminus",                         549 },
  { "arrowup",                           603 },
  { "apple",                             790 },
  { "parenleftbt",                       384 },
  { "notelement",                        713 },
  { "colon",                             278 },
  { "beta",                              549 },
  { "braceleftbt",                       494 },
  { "Lambda",                            686 },
  { "Phi",                               763 },
  { "minus",                             549 },
  { "space",                             250 },
  { "Sigma",                             592 },
  { "approxequal",                       549 },
  { "minute",                            247 },
  { "circleplus",                        768 },
  { "Omicron",                           722 },
  { "three",                             500 },
  { "numbersign",                        500 },
  { "lambda",                            549 },
  { "phi",                               521 },
  { "aleph",                             823 },
  { "Tau",                               611 },
  { "spade",                             753 },
  { "logicaland",                        603 },
  { "sigma",                             603 },
  { "propersuperset",                    713 },
  { "omicron",                           549 },
  { "question",                          444 },
  { "equal",                             549 },
  { "Epsilon",                           611 },
  { "emptyset",                          823 },
  { "diamond",                           753 },
  { "four",                              500 },
  { "Mu",                                889 },
  { "parenlefttp",                       384 },
  { "club",                              753 },
  { "bullet",                            460 },
  { "Omega",                             768 },
  { "tau",                               439 },
  { "Upsilon",                           690 },
  { "bracelefttp",                       494 },
  { "heart",                             753 },
  { "divide",                            549 },
  { "epsilon",                           439 },
  { "logicalor",                         603 },
  { "parenleftex",                       384 },
  { "greaterequal",                      549 },
  { "mu",                                576 },
  { "Nu",                                722 },
  { "therefore",                         863 },
  { "notsubset",                         713 },
  { "omega",                             686 },
  { "semicolon",                         278 },
  { "element",                           713 },
  { "upsilon",                           576 },
  { "existential",                       549 },
  { "integralbt",                        686 },
  { "lessequal",                         549 },
  { "phi1",                              603 },
  { "lozenge",                           494 },
  { "trademarkserif",                    890 },
  { "parenright",                        333 },
  { "reflexsuperset",                    713 },
  { "sigma1",                            439 },
  { "nu",                                521 },
  { "Gamma",                             603 },
  { "angleright",                        329 },
  { "ellipsis",                         1000 },
  { "Rho",                               556 },
  { "parenrightbt",                      384 },
  { "radicalex",                         500 },
  { "eight",                             500 },
  { "angleleft",                         329 },
  { "arrowdbldown",                      603 },
  { "congruent",                         549 },
  { "Theta",                             741 },
  { "intersection",                      768 },
  { "Pi",                                768 },
  { "slash",                             278 },
  { "registerserif",                     790 },
  { "parenleft",                         333 },
  { "one",                               500 },
  { "gamma",                             411 },
  { "bracketleft",                       333 },
  { "rho",                               549 },
  { "circlemultiply",                    768 },
  { "Chi",                               722 },
  { "theta",                             521 },
  { "pi",                                549 },
  { "integraltp",                        686 },
  { "Eta",                               722 },
  { "product",                           823 },
  { "nine",                              500 },
  { "five",                              500 },
  { "propersubset",                      713 },
  { "bracketrightbt",                    384 },
  { "trademarksans",                     786 },
  { "dotmath",                           250 },
  { "integralex",                        686 },
  { "chi",                               549 },
  { "parenrighttp",                      384 },
  { "eta",                               603 },
  { "underscore",                        500 },
  { "multiply",                          549 },
  { "zero",                              500 },
  { "partialdiff",                       494 },
  { "angle",                             768 },
  { "arrowdblleft",                      987 },
  { "braceleft",                         480 },
  { "parenrightex",                      384 },
  { "Rfraktur",                          795 },
  { "Zeta",                              611 },
  { "braceex",                           494 },
  { "arrowdblup",                        603 },
  { "arrowdown",                         603 },
  { "Ifraktur",                          686 },
  { "degree",                            400 },
  { "Iota",                              333 },
  { "perpendicular",                     658 },
  { "radical",                           549 },
  { "asteriskmath",                      500 },
  { "percent",                           833 },
  { "zeta",                              494 },
  { "six",                               500 },
  { "two",                               500 },
  { "weierstrass",                       987 },
  { "summation",                         713 },
  { "bracketrighttp",                    384 },
  { "carriagereturn",                    658 },
  { "suchthat",                          439 },
  { "arrowvertex",                       603 },
  { "Delta",                             612 },
  { "iota",                              329 },
  { "arrowhorizex",                     1000 },
  { "bracketrightex",                    384 },
  { "bracketright",                      333 },
  { "ampersand",                         778 },
  { "plus",                              549 },
  { "proportional",                      713 },
  { "delta",                             494 },
  { "copyrightserif",                    790 },
  { "bracerightmid",                     494 },
  { "arrowleft",                         987 },
  { "second",                            411 },
  { "arrowdblboth",                     1042 },
  { "florin",                            500 },
  { "Psi",                               795 },
  { "bracerightbt",                      494 },
  { "bracketleftbt",                     384 },
  { "seven",                             500 },
  { "braceleftmid",                      494 },
  { "notequal",                          549 },
  { "psi",                               686 },
  { "equivalence",                       549 },
  { "universal",                         713 },
  { "arrowdblright",                     987 },
  { "braceright",                        480 },
  { "reflexsubset",                      713 },
  { "Xi",                                645 },
  { "theta1",                            631 },
  { "logicalnot",                        713 },
  { "Kappa",                             722 },
  { "similar",                           549 },
  { "bar",                               200 },
  { "fraction",                          167 },
  { "less",                              549 },
  { "registersans",                      790 },
  { "omega1",                            713 },
  { "exclam",                            333 },
  { "Upsilon1",                          620 },
  { "bracerighttp",                      494 },
  { "xi",                                493 },
  { "period",                            250 },
  { "Alpha",                             722 },
  { "arrowright",                        987 },
  { "greater",                           549 },
  { "bracketlefttp",                     384 },
  { "kappa",                             549 },
  { "gradient",                          713 },
  { "integral",                          274 },
  { "arrowboth",                        1042 },
  { "Beta",                              667 }
};

static const StdFontWidth timesBoldWidthsTab[] = {
  { "Ntilde",                            722 },
  { "comma",                             250 },
  { "cedilla",                           333 },
  { "plusminus",                         570 },
  { "circumflex",                        333 },
  { "dotaccent",                         333 },
  { "asciitilde",                        520 },
  { "colon",                             333 },
  { "onehalf",                           750 },
  { "dollar",                            500 },
  { "ntilde",                            556 },
  { "minus",                             570 },
  { "yen",                               500 },
  { "space",                             250 },
  { "questiondown",                      500 },
  { "emdash",                           1000 },
  { "Agrave",                            722 },
  { "three",                             500 },
  { "numbersign",                        500 },
  { "A",                                 722 },
  { "B",                                 667 },
  { "C",                                 722 },
  { "D",                                 722 },
  { "E",                                 667 },
  { "onequarter",                        750 },
  { "F",                                 611 },
  { "G",                                 778 },
  { "H",                                 778 },
  { "I",                                 389 },
  { "J",                                 500 },
  { "K",                                 778 },
  { "backslash",                         278 },
  { "L",                                 667 },
  { "periodcentered",                    250 },
  { "M",                                 944 },
  { "N",                                 722 },
  { "O",                                 778 },
  { "P",                                 611 },
  { "Q",                                 778 },
  { "R",                                 722 },
  { "Aacute",                            722 },
  { "caron",                             333 },
  { "S",                                 556 },
  { "T",                                 667 },
  { "U",                                 722 },
  { "agrave",                            500 },
  { "V",                                 722 },
  { "W",                                1000 },
  { "X",                                 722 },
  { "question",                          500 },
  { "equal",                             570 },
  { "Y",                                 722 },
  { "Z",                                 667 },
  { "four",                              500 },
  { "a",                                 500 },
  { "b",                                 556 },
  { "c",                                 444 },
  { "d",                                 556 },
  { "e",                                 444 },
  { "f",                                 333 },
  { "g",                                 500 },
  { "bullet",                            350 },
  { "h",                                 556 },
  { "i",                                 278 },
  { "Oslash",                            778 },
  { "dagger",                            500 },
  { "j",                                 333 },
  { "k",                                 556 },
  { "l",                                 278 },
  { "m",                                 833 },
  { "n",                                 556 },
  { "o",                                 500 },
  { "ordfeminine",                       300 },
  { "ring",                              333 },
  { "p",                                 556 },
  { "q",                                 556 },
  { "r",                                 444 },
  { "twosuperior",                       300 },
  { "aacute",                            500 },
  { "s",                                 389 },
  { "OE",                               1000 },
  { "t",                                 333 },
  { "divide",                            570 },
  { "u",                                 556 },
  { "v",                                 500 },
  { "w",                                 722 },
  { "x",                                 500 },
  { "y",                                 500 },
  { "z",                                 444 },
  { "hungarumlaut",                      333 },
  { "quotedbl",                          555 },
  { "mu",                                556 },
  { "Scaron",                            556 },
  { "Lslash",                            667 },
  { "semicolon",                         333 },
  { "oslash",                            500 },
  { "parenright",                        333 },
  { "Ecircumflex",                       667 },
  { "trademark",                        1000 },
  { "daggerdbl",                         500 },
  { "macron",                            333 },
  { "Otilde",                            778 },
  { "ellipsis",                         1000 },
  { "scaron",                            389 },
  { "AE",                               1000 },
  { "Ucircumflex",                       722 },
  { "lslash",                            278 },
  { "quotedblleft",                      500 },
  { "guilsinglright",                    333 },
  { "hyphen",                            333 },
  { "quotesingle",                       278 },
  { "eight",                             500 },
  { "exclamdown",                        333 },
  { "endash",                            500 },
  { "oe",                                722 },
  { "ecircumflex",                       444 },
  { "copyright",                         747 },
  { "Adieresis",                         722 },
  { "Egrave",                            667 },
  { "slash",                             278 },
  { "Edieresis",                         667 },
  { "otilde",                            500 },
  { "Idieresis",                         389 },
  { "parenleft",                         333 },
  { "one",                               500 },
  { "ucircumflex",                       556 },
  { "Odieresis",                         778 },
  { "bracketleft",                       333 },
  { "Ugrave",                            722 },
  { "quoteright",                        333 },
  { "Udieresis",                         722 },
  { "perthousand",                      1000 },
  { "Ydieresis",                         722 },
  { "Eacute",                            667 },
  { "adieresis",                         500 },
  { "egrave",                            444 },
  { "edieresis",                         444 },
  { "idieresis",                         278 },
  { "Eth",                               722 },
  { "ae",                                722 },
  { "asterisk",                          500 },
  { "odieresis",                         500 },
  { "Uacute",                            722 },
  { "ugrave",                            556 },
  { "nine",                              500 },
  { "five",                              500 },
  { "udieresis",                         556 },
  { "Zcaron",                            667 },
  { "threequarters",                     750 },
  { "guillemotright",                    500 },
  { "ydieresis",                         500 },
  { "Ccedilla",                          722 },
  { "tilde",                             333 },
  { "at",                                930 },
  { "eacute",                            444 },
  { "underscore",                        500 },
  { "multiply",                          570 },
  { "zero",                              500 },
  { "eth",                               500 },
  { "Ograve",                            778 },
  { "uacute",                            556 },
  { "braceleft",                         394 },
  { "Thorn",                             611 },
  { "zcaron",                            444 },
  { "ccedilla",                          444 },
  { "Ocircumflex",                       778 },
  { "Oacute",                            778 },
  { "ogonek",                            333 },
  { "ograve",                            500 },
  { "thorn",                             556 },
  { "degree",                            400 },
  { "registered",                        747 },
  { "Aring",                             722 },
  { "percent",                          1000 },
  { "six",                               500 },
  { "paragraph",                         540 },
  { "two",                               500 },
  { "Igrave",                            389 },
  { "ocircumflex",                       500 },
  { "oacute",                            500 },
  { "asciicircum",                       581 },
  { "aring",                             500 },
  { "grave",                             333 },
  { "bracketright",                      333 },
  { "Iacute",                            389 },
  { "ampersand",                         833 },
  { "igrave",                            278 },
  { "plus",                              570 },
  { "quotesinglbase",                    333 },
  { "Yacute",                            722 },
  { "threesuperior",                     300 },
  { "acute",                             333 },
  { "section",                           500 },
  { "dieresis",                          333 },
  { "iacute",                            278 },
  { "quotedblbase",                      500 },
  { "florin",                            500 },
  { "yacute",                            500 },
  { "fi",                                556 },
  { "fl",                                556 },
  { "Acircumflex",                       722 },
  { "Icircumflex",                       389 },
  { "guillemotleft",                     500 },
  { "germandbls",                        556 },
  { "seven",                             500 },
  { "ordmasculine",                      330 },
  { "dotlessi",                          278 },
  { "sterling",                          500 },
  { "acircumflex",                       500 },
  { "icircumflex",                       278 },
  { "braceright",                        394 },
  { "quotedblright",                     500 },
  { "cent",                              500 },
  { "currency",                          500 },
  { "logicalnot",                        570 },
  { "Atilde",                            722 },
  { "breve",                             333 },
  { "bar",                               220 },
  { "fraction",                          167 },
  { "less",                              570 },
  { "guilsinglleft",                     333 },
  { "exclam",                            333 },
  { "period",                            250 },
  { "greater",                           570 },
  { "atilde",                            500 },
  { "brokenbar",                         220 },
  { "quoteleft",                         333 },
  { "onesuperior",                       300 }
};

static const StdFontWidth timesBoldItalicWidthsTab[] = {
  { "Ntilde",                            722 },
  { "comma",                             250 },
  { "cedilla",                           333 },
  { "plusminus",                         570 },
  { "circumflex",                        333 },
  { "dotaccent",                         333 },
  { "asciitilde",                        570 },
  { "colon",                             333 },
  { "onehalf",                           750 },
  { "dollar",                            500 },
  { "ntilde",                            556 },
  { "minus",                             606 },
  { "yen",                               500 },
  { "space",                             250 },
  { "questiondown",                      500 },
  { "emdash",                           1000 },
  { "Agrave",                            667 },
  { "three",                             500 },
  { "numbersign",                        500 },
  { "A",                                 667 },
  { "B",                                 667 },
  { "C",                                 667 },
  { "D",                                 722 },
  { "E",                                 667 },
  { "onequarter",                        750 },
  { "F",                                 667 },
  { "G",                                 722 },
  { "H",                                 778 },
  { "I",                                 389 },
  { "J",                                 500 },
  { "K",                                 667 },
  { "backslash",                         278 },
  { "L",                                 611 },
  { "periodcentered",                    250 },
  { "M",                                 889 },
  { "N",                                 722 },
  { "O",                                 722 },
  { "P",                                 611 },
  { "Q",                                 722 },
  { "R",                                 667 },
  { "Aacute",                            667 },
  { "caron",                             333 },
  { "S",                                 556 },
  { "T",                                 611 },
  { "U",                                 722 },
  { "agrave",                            500 },
  { "V",                                 667 },
  { "W",                                 889 },
  { "X",                                 667 },
  { "question",                          500 },
  { "equal",                             570 },
  { "Y",                                 611 },
  { "Z",                                 611 },
  { "four",                              500 },
  { "a",                                 500 },
  { "b",                                 500 },
  { "c",                                 444 },
  { "d",                                 500 },
  { "e",                                 444 },
  { "f",                                 333 },
  { "g",                                 500 },
  { "bullet",                            350 },
  { "h",                                 556 },
  { "i",                                 278 },
  { "Oslash",                            722 },
  { "dagger",                            500 },
  { "j",                                 278 },
  { "k",                                 500 },
  { "l",                                 278 },
  { "m",                                 778 },
  { "n",                                 556 },
  { "o",                                 500 },
  { "ordfeminine",                       266 },
  { "ring",                              333 },
  { "p",                                 500 },
  { "q",                                 500 },
  { "r",                                 389 },
  { "twosuperior",                       300 },
  { "aacute",                            500 },
  { "s",                                 389 },
  { "OE",                                944 },
  { "t",                                 278 },
  { "divide",                            570 },
  { "u",                                 556 },
  { "v",                                 444 },
  { "w",                                 667 },
  { "x",                                 500 },
  { "y",                                 444 },
  { "z",                                 389 },
  { "hungarumlaut",                      333 },
  { "quotedbl",                          555 },
  { "mu",                                576 },
  { "Scaron",                            556 },
  { "Lslash",                            611 },
  { "semicolon",                         333 },
  { "oslash",                            500 },
  { "parenright",                        333 },
  { "Ecircumflex",                       667 },
  { "trademark",                        1000 },
  { "daggerdbl",                         500 },
  { "macron",                            333 },
  { "Otilde",                            722 },
  { "ellipsis",                         1000 },
  { "scaron",                            389 },
  { "AE",                                944 },
  { "Ucircumflex",                       722 },
  { "lslash",                            278 },
  { "quotedblleft",                      500 },
  { "guilsinglright",                    333 },
  { "hyphen",                            333 },
  { "quotesingle",                       278 },
  { "eight",                             500 },
  { "exclamdown",                        389 },
  { "endash",                            500 },
  { "oe",                                722 },
  { "ecircumflex",                       444 },
  { "copyright",                         747 },
  { "Adieresis",                         667 },
  { "Egrave",                            667 },
  { "slash",                             278 },
  { "Edieresis",                         667 },
  { "otilde",                            500 },
  { "Idieresis",                         389 },
  { "parenleft",                         333 },
  { "one",                               500 },
  { "ucircumflex",                       556 },
  { "Odieresis",                         722 },
  { "bracketleft",                       333 },
  { "Ugrave",                            722 },
  { "quoteright",                        333 },
  { "Udieresis",                         722 },
  { "perthousand",                      1000 },
  { "Ydieresis",                         611 },
  { "Eacute",                            667 },
  { "adieresis",                         500 },
  { "egrave",                            444 },
  { "edieresis",                         444 },
  { "idieresis",                         278 },
  { "Eth",                               722 },
  { "ae",                                722 },
  { "asterisk",                          500 },
  { "odieresis",                         500 },
  { "Uacute",                            722 },
  { "ugrave",                            556 },
  { "nine",                              500 },
  { "five",                              500 },
  { "udieresis",                         556 },
  { "Zcaron",                            611 },
  { "threequarters",                     750 },
  { "guillemotright",                    500 },
  { "ydieresis",                         444 },
  { "Ccedilla",                          667 },
  { "tilde",                             333 },
  { "at",                                832 },
  { "eacute",                            444 },
  { "underscore",                        500 },
  { "multiply",                          570 },
  { "zero",                              500 },
  { "eth",                               500 },
  { "Ograve",                            722 },
  { "uacute",                            556 },
  { "braceleft",                         348 },
  { "Thorn",                             611 },
  { "zcaron",                            389 },
  { "ccedilla",                          444 },
  { "Ocircumflex",                       722 },
  { "Oacute",                            722 },
  { "ogonek",                            333 },
  { "ograve",                            500 },
  { "thorn",                             500 },
  { "degree",                            400 },
  { "registered",                        747 },
  { "Aring",                             667 },
  { "percent",                           833 },
  { "six",                               500 },
  { "paragraph",                         500 },
  { "two",                               500 },
  { "Igrave",                            389 },
  { "ocircumflex",                       500 },
  { "oacute",                            500 },
  { "asciicircum",                       570 },
  { "aring",                             500 },
  { "grave",                             333 },
  { "bracketright",                      333 },
  { "Iacute",                            389 },
  { "ampersand",                         778 },
  { "igrave",                            278 },
  { "plus",                              570 },
  { "quotesinglbase",                    333 },
  { "Yacute",                            611 },
  { "threesuperior",                     300 },
  { "acute",                             333 },
  { "section",                           500 },
  { "dieresis",                          333 },
  { "iacute",                            278 },
  { "quotedblbase",                      500 },
  { "florin",                            500 },
  { "yacute",                            444 },
  { "fi",                                556 },
  { "fl",                                556 },
  { "Acircumflex",                       667 },
  { "Icircumflex",                       389 },
  { "guillemotleft",                     500 },
  { "germandbls",                        500 },
  { "seven",                             500 },
  { "ordmasculine",                      300 },
  { "dotlessi",                          278 },
  { "sterling",                          500 },
  { "acircumflex",                       500 },
  { "icircumflex",                       278 },
  { "braceright",                        348 },
  { "quotedblright",                     500 },
  { "cent",                              500 },
  { "currency",                          500 },
  { "logicalnot",                        606 },
  { "Atilde",                            667 },
  { "breve",                             333 },
  { "bar",                               220 },
  { "fraction",                          167 },
  { "less",                              570 },
  { "guilsinglleft",                     333 },
  { "exclam",                            389 },
  { "period",                            250 },
  { "greater",                           570 },
  { "atilde",                            500 },
  { "brokenbar",                         220 },
  { "quoteleft",                         333 },
  { "onesuperior",                       300 }
};

static const StdFontWidth timesItalicWidthsTab[] = {
  { "Ntilde",                            667 },
  { "comma",                             250 },
  { "cedilla",                           333 },
  { "plusminus",                         675 },
  { "circumflex",                        333 },
  { "dotaccent",                         333 },
  { "asciitilde",                        541 },
  { "colon",                             333 },
  { "onehalf",                           750 },
  { "dollar",                            500 },
  { "ntilde",                            500 },
  { "minus",                             675 },
  { "yen",                               500 },
  { "space",                             250 },
  { "questiondown",                      500 },
  { "emdash",                            889 },
  { "Agrave",                            611 },
  { "three",                             500 },
  { "numbersign",                        500 },
  { "A",                                 611 },
  { "B",                                 611 },
  { "C",                                 667 },
  { "D",                                 722 },
  { "E",                                 611 },
  { "onequarter",                        750 },
  { "F",                                 611 },
  { "G",                                 722 },
  { "H",                                 722 },
  { "I",                                 333 },
  { "J",                                 444 },
  { "K",                                 667 },
  { "backslash",                         278 },
  { "L",                                 556 },
  { "periodcentered",                    250 },
  { "M",                                 833 },
  { "N",                                 667 },
  { "O",                                 722 },
  { "P",                                 611 },
  { "Q",                                 722 },
  { "R",                                 611 },
  { "Aacute",                            611 },
  { "caron",                             333 },
  { "S",                                 500 },
  { "T",                                 556 },
  { "U",                                 722 },
  { "agrave",                            500 },
  { "V",                                 611 },
  { "W",                                 833 },
  { "X",                                 611 },
  { "question",                          500 },
  { "equal",                             675 },
  { "Y",                                 556 },
  { "Z",                                 556 },
  { "four",                              500 },
  { "a",                                 500 },
  { "b",                                 500 },
  { "c",                                 444 },
  { "d",                                 500 },
  { "e",                                 444 },
  { "f",                                 278 },
  { "g",                                 500 },
  { "bullet",                            350 },
  { "h",                                 500 },
  { "i",                                 278 },
  { "Oslash",                            722 },
  { "dagger",                            500 },
  { "j",                                 278 },
  { "k",                                 444 },
  { "l",                                 278 },
  { "m",                                 722 },
  { "n",                                 500 },
  { "o",                                 500 },
  { "ordfeminine",                       276 },
  { "ring",                              333 },
  { "p",                                 500 },
  { "q",                                 500 },
  { "r",                                 389 },
  { "twosuperior",                       300 },
  { "aacute",                            500 },
  { "s",                                 389 },
  { "OE",                                944 },
  { "t",                                 278 },
  { "divide",                            675 },
  { "u",                                 500 },
  { "v",                                 444 },
  { "w",                                 667 },
  { "x",                                 444 },
  { "y",                                 444 },
  { "z",                                 389 },
  { "hungarumlaut",                      333 },
  { "quotedbl",                          420 },
  { "mu",                                500 },
  { "Scaron",                            500 },
  { "Lslash",                            556 },
  { "semicolon",                         333 },
  { "oslash",                            500 },
  { "parenright",                        333 },
  { "Ecircumflex",                       611 },
  { "trademark",                         980 },
  { "daggerdbl",                         500 },
  { "macron",                            333 },
  { "Otilde",                            722 },
  { "ellipsis",                          889 },
  { "scaron",                            389 },
  { "AE",                                889 },
  { "Ucircumflex",                       722 },
  { "lslash",                            278 },
  { "quotedblleft",                      556 },
  { "guilsinglright",                    333 },
  { "hyphen",                            333 },
  { "quotesingle",                       214 },
  { "eight",                             500 },
  { "exclamdown",                        389 },
  { "endash",                            500 },
  { "oe",                                667 },
  { "ecircumflex",                       444 },
  { "copyright",                         760 },
  { "Adieresis",                         611 },
  { "Egrave",                            611 },
  { "slash",                             278 },
  { "Edieresis",                         611 },
  { "otilde",                            500 },
  { "Idieresis",                         333 },
  { "parenleft",                         333 },
  { "one",                               500 },
  { "ucircumflex",                       500 },
  { "Odieresis",                         722 },
  { "bracketleft",                       389 },
  { "Ugrave",                            722 },
  { "quoteright",                        333 },
  { "Udieresis",                         722 },
  { "perthousand",                      1000 },
  { "Ydieresis",                         556 },
  { "Eacute",                            611 },
  { "adieresis",                         500 },
  { "egrave",                            444 },
  { "edieresis",                         444 },
  { "idieresis",                         278 },
  { "Eth",                               722 },
  { "ae",                                667 },
  { "asterisk",                          500 },
  { "odieresis",                         500 },
  { "Uacute",                            722 },
  { "ugrave",                            500 },
  { "nine",                              500 },
  { "five",                              500 },
  { "udieresis",                         500 },
  { "Zcaron",                            556 },
  { "threequarters",                     750 },
  { "guillemotright",                    500 },
  { "ydieresis",                         444 },
  { "Ccedilla",                          667 },
  { "tilde",                             333 },
  { "at",                                920 },
  { "eacute",                            444 },
  { "underscore",                        500 },
  { "multiply",                          675 },
  { "zero",                              500 },
  { "eth",                               500 },
  { "Ograve",                            722 },
  { "uacute",                            500 },
  { "braceleft",                         400 },
  { "Thorn",                             611 },
  { "zcaron",                            389 },
  { "ccedilla",                          444 },
  { "Ocircumflex",                       722 },
  { "Oacute",                            722 },
  { "ogonek",                            333 },
  { "ograve",                            500 },
  { "thorn",                             500 },
  { "degree",                            400 },
  { "registered",                        760 },
  { "Aring",                             611 },
  { "percent",                           833 },
  { "six",                               500 },
  { "paragraph",                         523 },
  { "two",                               500 },
  { "Igrave",                            333 },
  { "ocircumflex",                       500 },
  { "oacute",                            500 },
  { "asciicircum",                       422 },
  { "aring",                             500 },
  { "grave",                             333 },
  { "bracketright",                      389 },
  { "Iacute",                            333 },
  { "ampersand",                         778 },
  { "igrave",                            278 },
  { "plus",                              675 },
  { "quotesinglbase",                    333 },
  { "Yacute",                            556 },
  { "threesuperior",                     300 },
  { "acute",                             333 },
  { "section",                           500 },
  { "dieresis",                          333 },
  { "iacute",                            278 },
  { "quotedblbase",                      556 },
  { "florin",                            500 },
  { "yacute",                            444 },
  { "fi",                                500 },
  { "fl",                                500 },
  { "Acircumflex",                       611 },
  { "Icircumflex",                       333 },
  { "guillemotleft",                     500 },
  { "germandbls",                        500 },
  { "seven",                             500 },
  { "ordmasculine",                      310 },
  { "dotlessi",                          278 },
  { "sterling",                          500 },
  { "acircumflex",                       500 },
  { "icircumflex",                       278 },
  { "braceright",                        400 },
  { "quotedblright",                     556 },
  { "cent",                              500 },
  { "currency",                          500 },
  { "logicalnot",                        675 },
  { "Atilde",                            611 },
  { "breve",                             333 },
  { "bar",                               275 },
  { "fraction",                          167 },
  { "less",                              675 },
  { "guilsinglleft",                     333 },
  { "exclam",                            333 },
  { "period",                            250 },
  { "greater",                           675 },
  { "atilde",                            500 },
  { "brokenbar",                         275 },
  { "quoteleft",                         333 },
  { "onesuperior",                       300 }
};

static const StdFontWidth timesRomanWidthsTab[] = {
  { "Ntilde",                            722 },
  { "comma",                             250 },
  { "cedilla",                           333 },
  { "plusminus",                         564 },
  { "circumflex",                        333 },
  { "dotaccent",                         333 },
  { "asciitilde",                        541 },
  { "colon",                             278 },
  { "onehalf",                           750 },
  { "dollar",                            500 },
  { "ntilde",                            500 },
  { "minus",                             564 },
  { "yen",                               500 },
  { "space",                             250 },
  { "questiondown",                      444 },
  { "emdash",                           1000 },
  { "Agrave",                            722 },
  { "three",                             500 },
  { "numbersign",                        500 },
  { "A",                                 722 },
  { "B",                                 667 },
  { "C",                                 667 },
  { "D",                                 722 },
  { "E",                                 611 },
  { "onequarter",                        750 },
  { "F",                                 556 },
  { "G",                                 722 },
  { "H",                                 722 },
  { "I",                                 333 },
  { "J",                                 389 },
  { "K",                                 722 },
  { "backslash",                         278 },
  { "L",                                 611 },
  { "periodcentered",                    250 },
  { "M",                                 889 },
  { "N",                                 722 },
  { "O",                                 722 },
  { "P",                                 556 },
  { "Q",                                 722 },
  { "R",                                 667 },
  { "Aacute",                            722 },
  { "caron",                             333 },
  { "S",                                 556 },
  { "T",                                 611 },
  { "U",                                 722 },
  { "agrave",                            444 },
  { "V",                                 722 },
  { "W",                                 944 },
  { "X",                                 722 },
  { "question",                          444 },
  { "equal",                             564 },
  { "Y",                                 722 },
  { "Z",                                 611 },
  { "four",                              500 },
  { "a",                                 444 },
  { "b",                                 500 },
  { "c",                                 444 },
  { "d",                                 500 },
  { "e",                                 444 },
  { "f",                                 333 },
  { "g",                                 500 },
  { "bullet",                            350 },
  { "h",                                 500 },
  { "i",                                 278 },
  { "Oslash",                            722 },
  { "dagger",                            500 },
  { "j",                                 278 },
  { "k",                                 500 },
  { "l",                                 278 },
  { "m",                                 778 },
  { "n",                                 500 },
  { "o",                                 500 },
  { "ordfeminine",                       276 },
  { "ring",                              333 },
  { "p",                                 500 },
  { "q",                                 500 },
  { "r",                                 333 },
  { "twosuperior",                       300 },
  { "aacute",                            444 },
  { "s",                                 389 },
  { "OE",                                889 },
  { "t",                                 278 },
  { "divide",                            564 },
  { "u",                                 500 },
  { "v",                                 500 },
  { "w",                                 722 },
  { "x",                                 500 },
  { "y",                                 500 },
  { "z",                                 444 },
  { "hungarumlaut",                      333 },
  { "quotedbl",                          408 },
  { "mu",                                500 },
  { "Scaron",                            556 },
  { "Lslash",                            611 },
  { "semicolon",                         278 },
  { "oslash",                            500 },
  { "parenright",                        333 },
  { "Ecircumflex",                       611 },
  { "trademark",                         980 },
  { "daggerdbl",                         500 },
  { "macron",                            333 },
  { "Otilde",                            722 },
  { "ellipsis",                         1000 },
  { "scaron",                            389 },
  { "AE",                                889 },
  { "Ucircumflex",                       722 },
  { "lslash",                            278 },
  { "quotedblleft",                      444 },
  { "guilsinglright",                    333 },
  { "hyphen",                            333 },
  { "quotesingle",                       180 },
  { "eight",                             500 },
  { "exclamdown",                        333 },
  { "endash",                            500 },
  { "oe",                                722 },
  { "ecircumflex",                       444 },
  { "copyright",                         760 },
  { "Adieresis",                         722 },
  { "Egrave",                            611 },
  { "slash",                             278 },
  { "Edieresis",                         611 },
  { "otilde",                            500 },
  { "Idieresis",                         333 },
  { "parenleft",                         333 },
  { "one",                               500 },
  { "ucircumflex",                       500 },
  { "Odieresis",                         722 },
  { "bracketleft",                       333 },
  { "Ugrave",                            722 },
  { "quoteright",                        333 },
  { "Udieresis",                         722 },
  { "perthousand",                      1000 },
  { "Ydieresis",                         722 },
  { "Eacute",                            611 },
  { "adieresis",                         444 },
  { "egrave",                            444 },
  { "edieresis",                         444 },
  { "idieresis",                         278 },
  { "Eth",                               722 },
  { "ae",                                667 },
  { "asterisk",                          500 },
  { "odieresis",                         500 },
  { "Uacute",                            722 },
  { "ugrave",                            500 },
  { "nine",                              500 },
  { "five",                              500 },
  { "udieresis",                         500 },
  { "Zcaron",                            611 },
  { "threequarters",                     750 },
  { "guillemotright",                    500 },
  { "ydieresis",                         500 },
  { "Ccedilla",                          667 },
  { "tilde",                             333 },
  { "at",                                921 },
  { "eacute",                            444 },
  { "underscore",                        500 },
  { "multiply",                          564 },
  { "zero",                              500 },
  { "eth",                               500 },
  { "Ograve",                            722 },
  { "uacute",                            500 },
  { "braceleft",                         480 },
  { "Thorn",                             556 },
  { "zcaron",                            444 },
  { "ccedilla",                          444 },
  { "Ocircumflex",                       722 },
  { "Oacute",                            722 },
  { "ogonek",                            333 },
  { "ograve",                            500 },
  { "thorn",                             500 },
  { "degree",                            400 },
  { "registered",                        760 },
  { "Aring",                             722 },
  { "percent",                           833 },
  { "six",                               500 },
  { "paragraph",                         453 },
  { "two",                               500 },
  { "Igrave",                            333 },
  { "ocircumflex",                       500 },
  { "oacute",                            500 },
  { "asciicircum",                       469 },
  { "aring",                             444 },
  { "grave",                             333 },
  { "bracketright",                      333 },
  { "Iacute",                            333 },
  { "ampersand",                         778 },
  { "igrave",                            278 },
  { "plus",                              564 },
  { "quotesinglbase",                    333 },
  { "Yacute",                            722 },
  { "threesuperior",                     300 },
  { "acute",                             333 },
  { "section",                           500 },
  { "dieresis",                          333 },
  { "iacute",                            278 },
  { "quotedblbase",                      444 },
  { "florin",                            500 },
  { "yacute",                            500 },
  { "fi",                                556 },
  { "fl",                                556 },
  { "Acircumflex",                       722 },
  { "Icircumflex",                       333 },
  { "guillemotleft",                     500 },
  { "germandbls",                        500 },
  { "seven",                             500 },
  { "ordmasculine",                      310 },
  { "dotlessi",                          278 },
  { "sterling",                          500 },
  { "acircumflex",                       444 },
  { "icircumflex",                       278 },
  { "braceright",                        480 },
  { "quotedblright",                     444 },
  { "cent",                              500 },
  { "currency",                          500 },
  { "logicalnot",                        564 },
  { "Atilde",                            722 },
  { "breve",                             333 },
  { "bar",                               200 },
  { "fraction",                          167 },
  { "less",                              564 },
  { "guilsinglleft",                     333 },
  { "exclam",                            333 },
  { "period",                            250 },
  { "greater",                           564 },
  { "atilde",                            444 },
  { "brokenbar",                         200 },
  { "quoteleft",                         333 },
  { "onesuperior",                       300 }
};

static const StdFontWidth zapfDingbatsWidthsTab[] = {
  { "a81",                               438 },
  { "a82",                               138 },
  { "a83",                               277 },
  { "a84",                               415 },
  { "a85",                               509 },
  { "a86",                               410 },
  { "a87",                               234 },
  { "a88",                               234 },
  { "a89",                               390 },
  { "a140",                              788 },
  { "a141",                              788 },
  { "a142",                              788 },
  { "a143",                              788 },
  { "a144",                              788 },
  { "a145",                              788 },
  { "a146",                              788 },
  { "a147",                              788 },
  { "a148",                              788 },
  { "a149",                              788 },
  { "a90",                               390 },
  { "a91",                               276 },
  { "a92",                               276 },
  { "space",                             278 },
  { "a93",                               317 },
  { "a94",                               317 },
  { "a95",                               334 },
  { "a96",                               334 },
  { "a97",                               392 },
  { "a98",                               392 },
  { "a99",                               668 },
  { "a150",                              788 },
  { "a151",                              788 },
  { "a152",                              788 },
  { "a153",                              788 },
  { "a154",                              788 },
  { "a155",                              788 },
  { "a156",                              788 },
  { "a157",                              788 },
  { "a158",                              788 },
  { "a159",                              788 },
  { "a160",                              894 },
  { "a161",                              838 },
  { "a162",                              924 },
  { "a163",                             1016 },
  { "a164",                              458 },
  { "a165",                              924 },
  { "a166",                              918 },
  { "a167",                              927 },
  { "a168",                              928 },
  { "a169",                              928 },
  { "a170",                              834 },
  { "a171",                              873 },
  { "a172",                              828 },
  { "a173",                              924 },
  { "a174",                              917 },
  { "a175",                              930 },
  { "a176",                              931 },
  { "a177",                              463 },
  { "a178",                              883 },
  { "a179",                              836 },
  { "a180",                              867 },
  { "a181",                              696 },
  { "a182",                              874 },
  { "a183",                              760 },
  { "a184",                              946 },
  { "a185",                              865 },
  { "a186",                              967 },
  { "a187",                              831 },
  { "a188",                              873 },
  { "a189",                              927 },
  { "a1",                                974 },
  { "a2",                                961 },
  { "a3",                                980 },
  { "a4",                                719 },
  { "a5",                                789 },
  { "a6",                                494 },
  { "a7",                                552 },
  { "a8",                                537 },
  { "a9",                                577 },
  { "a190",                              970 },
  { "a191",                              918 },
  { "a192",                              748 },
  { "a193",                              836 },
  { "a194",                              771 },
  { "a195",                              888 },
  { "a196",                              748 },
  { "a197",                              771 },
  { "a198",                              888 },
  { "a199",                              867 },
  { "a10",                               692 },
  { "a11",                               960 },
  { "a12",                               939 },
  { "a13",                               549 },
  { "a14",                               855 },
  { "a15",                               911 },
  { "a16",                               933 },
  { "a17",                               945 },
  { "a18",                               974 },
  { "a19",                               755 },
  { "a20",                               846 },
  { "a21",                               762 },
  { "a22",                               761 },
  { "a23",                               571 },
  { "a24",                               677 },
  { "a25",                               763 },
  { "a26",                               760 },
  { "a27",                               759 },
  { "a28",                               754 },
  { "a29",                               786 },
  { "a30",                               788 },
  { "a31",                               788 },
  { "a32",                               790 },
  { "a33",                               793 },
  { "a34",                               794 },
  { "a35",                               816 },
  { "a36",                               823 },
  { "a37",                               789 },
  { "a38",                               841 },
  { "a39",                               823 },
  { "a40",                               833 },
  { "a41",                               816 },
  { "a42",                               831 },
  { "a43",                               923 },
  { "a44",                               744 },
  { "a45",                               723 },
  { "a46",                               749 },
  { "a47",                               790 },
  { "a48",                               792 },
  { "a49",                               695 },
  { "a100",                              668 },
  { "a101",                              732 },
  { "a102",                              544 },
  { "a103",                              544 },
  { "a104",                              910 },
  { "a105",                              911 },
  { "a106",                              667 },
  { "a107",                              760 },
  { "a108",                              760 },
  { "a109",                              626 },
  { "a50",                               776 },
  { "a51",                               768 },
  { "a52",                               792 },
  { "a53",                               759 },
  { "a54",                               707 },
  { "a55",                               708 },
  { "a56",                               682 },
  { "a57",                               701 },
  { "a58",                               826 },
  { "a59",                               815 },
  { "a110",                              694 },
  { "a111",                              595 },
  { "a112",                              776 },
  { "a117",                              690 },
  { "a118",                              791 },
  { "a119",                              790 },
  { "a60",                               789 },
  { "a61",                               789 },
  { "a62",                               707 },
  { "a63",                               687 },
  { "a64",                               696 },
  { "a65",                               689 },
  { "a66",                               786 },
  { "a67",                               787 },
  { "a68",                               713 },
  { "a69",                               791 },
  { "a200",                              696 },
  { "a201",                              874 },
  { "a120",                              788 },
  { "a121",                              788 },
  { "a202",                              974 },
  { "a122",                              788 },
  { "a203",                              762 },
  { "a123",                              788 },
  { "a204",                              759 },
  { "a205",                              509 },
  { "a124",                              788 },
  { "a206",                              410 },
  { "a125",                              788 },
  { "a126",                              788 },
  { "a127",                              788 },
  { "a128",                              788 },
  { "a129",                              788 },
  { "a70",                               785 },
  { "a71",                               791 },
  { "a72",                               873 },
  { "a73",                               761 },
  { "a74",                               762 },
  { "a75",                               759 },
  { "a76",                               892 },
  { "a77",                               892 },
  { "a78",                               788 },
  { "a79",                               784 },
  { "a130",                              788 },
  { "a131",                              788 },
  { "a132",                              788 },
  { "a133",                              788 },
  { "a134",                              788 },
  { "a135",                              788 },
  { "a136",                              788 },
  { "a137",                              788 },
  { "a138",                              788 },
  { "a139",                              788 }
};

// --------------------------------------------------------------------

static const StdFontData stdFonts[] = {
  { "Courier",               0,            0,
    624, -207, { -40, -290,  640,  795} },
  { "Courier-Bold",          0,            0,
    674, -257, {-100, -350,  700,  855} },
  { "Courier-BoldOblique",   0,            0,
    674, -257, {-145, -350,  817,  855} },
  { "Courier-Oblique",       0,            0,
    624, -207, { -85, -290,  759,  795} },
  { "Helvetica",             helveticaWidthsTab, 228,
    729, -219, {-174, -220, 1001,  944} },
  { "Helvetica-Bold",        helveticaBoldWidthsTab, 229,
    729, -219, {-173, -221, 1003,  936} },
  { "Helvetica-BoldOblique", helveticaBoldObliqueWidthsTab, 228,
    729, -219, {-177, -221, 1107,  936} },
  { "Helvetica-Oblique",     helveticaObliqueWidthsTab, 228,
    729, -219, {-178, -220, 1108,  944} },
  { "Symbol",                symbolWidthsTab, 189,
    1010, -293, {-180, -293, 1090, 1010} },
  { "Times-Bold",            timesBoldWidthsTab, 228,
    670, -210, {-172, -256, 1008,  965} },
  { "Times-BoldItalic",      timesBoldItalicWidthsTab, 228,
    682, -203, {-168, -232, 1014,  894} },
  { "Times-Italic",          timesItalicWidthsTab, 228,
    684, -206, {-176, -252,  990,  930} },
  { "Times-Roman",           timesRomanWidthsTab, 228,
    682, -217, {-170, -223, 1024,  896} },
  { "ZapfDingbats",          zapfDingbatsWidthsTab, 202,
    820, -143, {  -1, -143,  981,  820} }
};

// --------------------------------------------------------------------

bool getStdFontWidths(String fontName, const String encoding[0x100],
		      int width[0x100])
{
  for (int i = 0; i < 14; ++i) {
    if (fontName == stdFonts[i].iName) {
      const StdFontWidth *wid = stdFonts[i].iWidths;
      int num = stdFonts[i].iNumWidths;
      // ipeDebug("Found %s at %d, %d glyphs", fontName.z(), i, num);
      if (num == 0) {
	// Courier fonts are monospaced
	for (int j = 0; j < 0x100; ++j)
	  width[j] = 600;
	return true;
      }
      for (int j = 0; j < 0x100; ++j) {
	String glyphName = encoding[j];
	if (glyphName == ".notdef") {
	  width[j] = 0;
	} else {
	  int k = 0;
	  while (k < num && glyphName != wid[k].iName) {
	    ++k;
	  }
	  if (k == num) {
	    ipeDebug("Cannot find width for glyph '%s' in '%s'",
		     glyphName.z(), fontName.z());
	    width[j] = 0;
	  } else
	    width[j] = wid[k].iWidth;
	}
      }
      return true;
    }
  }
  return false;
}

// --------------------------------------------------------------------
