#!/usr/bin/python

"""
Module Nikto Web Server Scanner for Inguma
Copyright (c) 2007 Joxean Koret <joxeankoret@yahoo.es>

Sullo, a member of the Nikto project gives us permission to use Nikto's
database in Inguma. To obtain updated databases of Nikto navigate to
http://www.cirt.net and/or to get more information.

Thanks you Sullo!

License is GPL
"""
import sys
import socket
import urllib2

from lib import libnikto
from lib.libexploit import CIngumaModule

name = "nikto"
brief_description = "Nikto web server scanner module for Inguma"
type = "gather"

class CNikto(CIngumaModule):
    target = ""  # Main target
    port = 80
    waitTime = 0
    timeout = 1
    exploitType = 1
    services = {}
    results = {}
    dict = None
    interactive = False
    _urls = []
    ssl = False

    def help(self):
        print "target = <target host or network>"
        print "port = <target port>"
        print "timeout = <timeout>"
        print "ssl = True|False"

    def doAssessment(self):

        socket.setdefaulttimeout(self.timeout)

        if self.port == 0 or self.port == None:
            self.port = 80
            print "Using port 80"
        else:
            print "[+] Using port %d" % int(self.port)

        if self.ssl:
            baseurl = "https://"
        else:
            baseurl = "http://"
        baseurl += self.target + ":" + str(self.port) + "/"

        # Read signatures and/or download databases
        print "[+] Reading signatures ... "
        print "[i] To upgrade signatures run python lib/libnikto.py"
        res = libnikto.getDatabases()

        if not res:
            return False

        print "Checking url list..."
        print

        self._urls = []

        for rule in libnikto.SIGNATURES:
            niktoRule = libnikto.CNiktoRule(rule)
            page = niktoRule.uri

            try:
                x = urllib2.urlopen(baseurl + page)
                if x.read().find(niktoRule.match1) > -1:
                    del x
                    self.addToDict("nikto_vulnerable_urls", page)

                    print "Adding vulnerable URL '%s'..." % page
                    print "-"*40
                    print "OSVDB: %s" % niktoRule.osvdbId
                    print "URI: %s" % niktoRule.uri
                    print "Match: '%s'" % niktoRule.match1
                    print "Summary: %s" % niktoRule.summary
                    print "-"*40
                    print
                    self._urls.append(page)
            except urllib2.HTTPError:
                pass # Just ignore
            except urllib2.URLError:
                pass # Just ignore
            except KeyboardInterrupt:
                print "Aborted."
                return
            except:
                print "Exception:", sys.exc_info()[0], sys.exc_info()[1]

        print "Done."

    def run(self):
        if self.port is None or self.port == 0:
            self.port = 80

        if self.target == "" or self.target is None:
            self.target = "localhost"
        
        self.doAssessment()

        return True

    def printSummary(self):
        print "The following vulnerable URL(s) were found:"
        print

        for url in self._urls:
            print "\t\t%s" % url
        print
        print
