<?php

require_once 'Horde/IMAP/Search.php';

/**
 * The IMP_IMAP_Search:: class extends the IMAP_Search class in order to
 * provide necessary bug fixes to ensure backwards compatibility with Horde
 * 3.0.
 *
 * $Horde: imp/lib/IMAP/Search.php,v 1.5.2.4 2008/01/02 11:31:29 jan Exp $
 *
 * Copyright 2006-2008 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Michael Slusarz <slusarz@horde.org>
 * @since   IMP 4.1
 * @package Horde_IMAP
 */
class IMP_IMAP_Search extends IMAP_Search {

    /**
     * Returns a reference to the global IMP_IMAP_Search object, only creating
     * it if it doesn't already exist.
     *
     * @see IMAP_Search::singleton()
     */
    function &singleton($params = array())
    {
        static $object;

        if (!isset($object)) {
            $object = new IMP_IMAP_Search($params);
        }

        return $object;
    }

    /**
     * Searches messages by ALL headers (rather than the limited set provided
     * by imap_search()).
     *
     * @see IMAP_Search::searchMailbox(). $imap does not needed to be passed
     *      in.
     */
    function searchMailbox($query, $imap, $mbox)
    {
        /* Clear the search flag. */
        $this->_searchflag = 0;

        $imp_imap = &IMP_IMAP::singleton();
        if (!$imp_imap->changeMbox($mbox, IMP_IMAP_AUTO)) {
            return array();
        }
        $stream = $imp_imap->stream();

        return $this->_searchMailbox($query, $stream, $mbox);
    }

    /**
     * Searches a mailbox and sorts the results.
     *
     * @see IMAP_Search::searchSortMailbox(). $imap does not needed to be
     *      passed in.
     */
    function searchSortMailbox($query, $imap, $mbox, $sortby, $sortdir = 0)
    {
        $imp_imap = &IMP_IMAP::singleton();
        $stream = $imp_imap->stream();
        return parent::searchSortMailbox($query, $stream, $mbox, $sortby, $sortdir);
    }

}

/**
 * The IMP_IMAP_Search_Query:: class extends the IMAP_Search_Query class in
 * order to provide necessary bug fixes to ensure backwards compatibility with
 * Horde 3.0.
 *
 * @author  Michael Slusarz <slusarz@horde.org>
 * @since   IMP 4.1
 * @package Horde_IMAP
 */
class IMP_IMAP_Search_Query extends IMAP_Search_Query {

    /**
     * Builds the IMAP search query.
     */
    function build()
    {
        $search = parent::build();
        if (empty($search)) {
            if (!empty($this->_or)) {
                return $search;
            }
            $search = new stdClass;
            $search->flags = null;
            $search->not = false;
            $search->fullquery = $search->query = 'ALL';
        }
        return $search;
    }
}
