""" simple image transforms

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: Transforms.py,v 1.10 2004/04/18 20:11:57 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.10 $"

from string import *
import Error

try:
    # PIL imports
    import ImageFont
    import ImageEnhance
    import ImageDraw
    import ImageChops
    import Image
    import ImageFilter
except:
    Error.PrintTB("import - Transforms")
    print "Some Python Imaging Lib modules are missing. Please install PIL correctly if you want the related features. (Transform tools)"

try:
    from qt import *
except:
    Error.qtImportError()

class Transforms:
    """Implements all transforms

    for each new transform:
    list it and it's parameters on getTransforms
    create its function:
    b is an unused parameter right now. (just make it 0). a0..n are parameters passed by GUI
    real is a string where it should save changes to. If real is None, then save changes to  .temp thumbnail

    For more complex transforms (use caption as an example), you may want to get gui data from self.wnd instead and simply ignore parameters
    """
    def __init__(self, wnd):
        self.wnd = wnd
        self.tPixmap = QPixmap()               # temp pixmap holding transformed images
        self.callback = None              # will hold a funtion that should be called whenever a slider changes. arguments to a callback function are (parm index,value)
        self.curdb = self.wnd.curdb

    def getTransforms(self):
        """call to get existing transforms

        @return: list of transforms: [name,callback,[parameter1 type, parameter 1 caption]]
        @rtype: list
        """
        ### Please keep this list alphabetically sorted, or else I'll have to write code to sort it.
        return [
            ["Blur",self.blur,[]],
            ["Caption",self.caption,[["Text","Caption"],["Combo","Position",["Top Left","Top Right","Bottom Left","Bottom Right"]],["Combo","Color",["Black","White","Red","Green","Blue"]]]],
            ["Color",self.color,[["Int","Factor",0,100]]],
            ["Contrast",self.contrast,[["Int","Factor",0,100]]],
            ["Contour",self.CONTOUR,[]],
            ["Darken",self.bright,[["Int","Factor",0,100]]],
            ["Detail",self.DETAIL,[]],
            ["Edge enhance",self.EDGE_ENHANCE,[]],
            ["Edge enhance more",self.EDGE_ENHANCE_MORE,[]],
            ["Emboss",self.EMBOSS,[]],
            ["Find edges",self.FIND_EDGES,[]],
            ["Invert",self.invert,[]],
            ["Rotate",self.rotate,[["Int","Degree",0,360]]],
            ["Sharpen",self.SHARPEN,[]],
            ["Sharpness",self.sharp,[["Int","Factor",0,100]]],
            ["Smooth",self.SMOOTH,[]],
            ["Smooth more",self.SMOOTH_MORE,[]]
            ]

    def caption(self,a0 = 0,b=0,caption=None,position=0,real=0):
        dcolor = [(0,0,0),                # black
                (255,255,255),          # white
                (255,0,0),              # red
                (0,255,0),              # gree
                (0,0,255),              # blue
                ]
        if not real:                    # on filters that do not offer a preview, just do a return here
                                        # on other filters, you should apply the transform on a thumbnail and show it on self.wnd.thumbLabel

            #TODO4: warn user that the preview is not broken. (that is, caption transform is not supposed to show a thumbnailed preview)

            #How do I remove the current pixmap of a label and then set it's caption ????
            #self.wnd.thumbLabel.setPixmap(QPixmap())
            #self.wnd.thumbLabel.clear()
            #self.wnd.thumbLabel.setCaption("No preview")
            return
        # extract parameters
        caption = str(self.wnd.controls[self.wnd.textControls[0]][1].text())
        if not caption: caption = "Sample caption"
        ifo = ImageFont.load(self.wnd.parent().imglibdir+"courB12.pil")
        #TODO5: font is hardcoded, make it configurable later (since .pil font files must be used, make at least the size an option)
        image = Image.open(self.wnd.curfidname)
        draw = ImageDraw.Draw(image)
        position = int(self.wnd.controls[self.wnd.comboControls[0]][1].currentItem())
        scolor = dcolor[int(self.wnd.controls[self.wnd.comboControls[1]][1].currentItem())]
        tsz = draw.textsize(caption, font=ifo)
        imsz = image.size
        if position==0:                 # top keft
            draw.text((0,0),caption,fill = scolor,font=ifo)
        elif position==1:                 # top right
            draw.text((imsz[0]-4-tsz[0],0),caption,fill = scolor,font=ifo)
        elif position==2:               # bottom left
            draw.text((0,imsz[1]-4-tsz[1]),caption,fill = scolor,font=ifo)
        elif position==3:               # bottom riht
            draw.text((imsz[0]-4-tsz[0],imsz[1]-4-tsz[1]),caption,fill = scolor,font=ifo)
        image.save(real)
        del image
        del draw

    def color(self,b = 0,a0=10,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
        else:
            image = Image.open(self.wnd.curfidname)
        enhancer = ImageEnhance.Color(image)
        if not real:
            enhancer.enhance(a0/100.0).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            enhancer.enhance(a0/100.0).save(real)
        del image
        del enhancer

    def bright(self,b = 0,a0=10,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
        else:
            image = Image.open(self.wnd.curfidname)
        enhancer = ImageEnhance.Brightness(image)
        if not real:
            enhancer.enhance((a0)/100.0).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            enhancer.enhance(a0/100.0).save(real)
        del image
        del enhancer

    def rotate(self,b = 0,a0=10,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            image = image.rotate(int(a0)%360)
            image.save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            import commands             # for running external apps
            accomp = 0                  # if has accomplished rotation
            if self.wnd.env.hasJpegtran and int(a0)%360 in [90,180,270]: # if jpegtran should be used
		# jpegtran has a different coordinate system, use 360-a0
                commands.getstatusoutput("cp %s %s.tmp" % (self.wnd.curfidname, self.wnd.curfidname))
                jstat,joutp = commands.getstatusoutput("jpegtran -rotate %d -copy all -outfile %s %s.tmp" % (int(360-a0)%360,real,self.wnd.curfidname))
                commands.getstatusoutput("rm %s.tmp" % (self.wnd.curfidname))
                accomp = 1
                if jstat:               # returned error
                    accomp = 0
                    print "jpegtran failed:"
                    print joutp
            if not accomp:              # try harder using PIL this time
                image = Image.open(self.wnd.curfidname)
                image = image.rotate(int(a0)%360)
                image.save(real)

    def contrast(self,b = 0,a0=10,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
        else:
            image = Image.open(self.wnd.curfidname)
        enhancer = ImageEnhance.Contrast(image)
        if not real:
            enhancer.enhance(a0/100.0).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            enhancer.enhance(a0/100.0).save(real)
        del image
        del enhancer

    def sharp(self,b = 0,a0=10,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
        else:
            image = Image.open(self.wnd.curfidname)
        enhancer = ImageEnhance.Sharpness(image)
        if not real:
            enhancer.enhance(a0/100.0).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            enhancer.enhance(a0/100.0).save(real)
        del image
        del enhancer

    def blur(self,b = 0,a0=50,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            image.filter(ImageFilter.BLUR).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            image = Image.open(self.wnd.curfidname)
            image.filter(ImageFilter.BLUR).save(real)
        del image

    def CONTOUR(self,b = 0,a0=50,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            image.filter(ImageFilter.CONTOUR).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            image = Image.open(self.wnd.curfidname)
            image.filter(ImageFilter.CONTOUR).save(real)
        del image

    def DETAIL(self,b = 0,a0=50,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            image.filter(ImageFilter.DETAIL).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            image = Image.open(self.wnd.curfidname)
            image.filter(ImageFilter.DETAIL).save(real)
        del image

    def EDGE_ENHANCE(self,b = 0,a0=50,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            image.filter(ImageFilter.EDGE_ENHANCE).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            image = Image.open(self.wnd.curfidname)
            image.filter(ImageFilter.EDGE_ENHANCE).save(real)
        del image

    def EDGE_ENHANCE_MORE(self,b = 0,a0=50,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            image.filter(ImageFilter.EDGE_ENHANCE_MORE).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            image = Image.open(self.wnd.curfidname)
            image.filter(ImageFilter.EDGE_ENHANCE_MORE).save(real)
        del image

    def EMBOSS(self,b = 0,a0=50,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            image.filter(ImageFilter.EMBOSS).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            image = Image.open(self.wnd.curfidname)
            image.filter(ImageFilter.EMBOSS).save(real)
        del image

    def FIND_EDGES(self,b = 0,a0=50,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            image.filter(ImageFilter.FIND_EDGES).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            image = Image.open(self.wnd.curfidname)
            image.filter(ImageFilter.FIND_EDGES).save(real)
        del image

    def invert(self,b = 0,a0=50,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            ImageChops.invert(image).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            image = Image.open(self.wnd.curfidname)
            ImageChops.invert(image).save(real)
        del image

    def SMOOTH(self,b = 0,a0=50,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            image.filter(ImageFilter.SMOOTH).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            image = Image.open(self.wnd.curfidname)
            image.filter(ImageFilter.SMOOTH).save(real)
        del image

    def SMOOTH_MORE(self,b = 0,a0=50,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            image.filter(ImageFilter.SMOOTH_MORE).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            image = Image.open(self.wnd.curfidname)
            image.filter(ImageFilter.SMOOTH_MORE).save(real)
        del image

    def SHARPEN(self,b = 0,a0=50,real=0):
        if not real:
            image = Image.open(self.wnd.curdb.getThumbName(self.wnd.curfidname))
            image.filter(ImageFilter.SHARPEN).save(".temp", "PPM")
            self.tPixmap.load(".temp")
            self.wnd.thumbLabel.setPixmap(self.tPixmap)
        else:
            image = Image.open(self.wnd.curfidname)
            image.filter(ImageFilter.SHARPEN).save(real)
        del image
