/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iparticlegrouppipeline.h"


#include "ierror.h"
#include "iparticledataconverter.h"
#include "iparticlegroup.h"
#include "ireplicatedpolydata.h"

//
//  Templates
//
#include "iarraytemplate.h"
#include "igenericfiltertemplate.h"
#include "iviewsubjectpipelinetemplate.h"


//
// iParticleGroupPipeline class
//
iParticleGroupPipeline::iParticleGroupPipeline(iParticleGroup *s) : iViewSubjectPipeline(s,1)
{
	mParent = s;

	//
	//  Do VTK stuff
	//	
	mDataConverter = this->CreateFilter<iParticleDataConverter>();
	mDataReplicated = this->CreateFilter<iReplicatedPolyData>();

	mDataReplicated->SetInput(mDataConverter->GetOutput());

	this->UpdateContents(_All);
}


iParticleGroupPipeline::~iParticleGroupPipeline()
{
}


void iParticleGroupPipeline::ProduceOutput()
{
	vtkPolyData *output = this->GetOutput();
	vtkPolyData *input = vtkPolyData::SafeDownCast(this->GetInput());
	if(input == 0)
	{
		IERROR_FATAL("iParticleGroupPipeline is configured incorrectly.");
		return;
	}

	if(mDataConverter->GetInput() != input)
	{
		mDataConverter->SetInput(input);
	}
	
	//
	//  Update the pipeline
	//
	mDataReplicated->Update();
	output->ShallowCopy(mDataReplicated->GetOutput());
}


float iParticleGroupPipeline::GetContentsMemorySize() const
{
	float s = 0.0;
	s += mDataConverter->GetMemorySize();
	s += mDataReplicated->GetMemorySize();
	return s;
}


void iParticleGroupPipeline::UpdateContents(int n, int)
{
	if(n==_All || n==_AttToSize) this->UpdateAttToSize();
	if(n==_All || n==_FixedSize) this->UpdateFixedSize();
	if(n==_All || n==_Replicas) this->UpdateReplicas();
	if(n==_All || n==_SizeFunction) this->UpdateSizeFunction();
	if(n==_All || n==_Type) this->UpdateType();
}


void iParticleGroupPipeline::UpdateAttToSize()
{ 
	mDataConverter->Modified();
	this->Modified();
}


void iParticleGroupPipeline::UpdateType()
{ 
	mDataConverter->SetType(mParent->GetType());
	this->Modified();
}


void iParticleGroupPipeline::UpdateFixedSize()
{ 
	mDataConverter->SetSize(mParent->GetFixedSize());
	this->Modified();
}


void iParticleGroupPipeline::UpdateReplicas()
{
	mDataReplicated->Modified();
	this->Modified();
}


void iParticleGroupPipeline::UpdateSizeFunction()
{
	mDataConverter->Modified();
	this->Modified();
}
