/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggdialogloadfile.h"


#include "icontrolmodule.h"
#include "idata.h"
#include "idatareader.h"
#include "ierror.h"
#include "ishell.h"
#include "isystem.h"
#include "iviewmodule.h"

#include "iggframe.h"
#include "iggmainwindow.h"
#include "iggwidgetarea.h"
#include "iggwidgetprogressbar.h"


using namespace iParameter;


const bool iggDialogLoadFile::mIsMultiThread = false;


namespace iggDialogLoadFile_Private
{
	class ProgressBar : public iggWidgetProgressBar
	{

	public:

		ProgressBar(iggFrame *parent) : iggWidgetProgressBar(parent)
		{
		}

	protected:

		virtual void OnSetProgress()
		{
			this->GetMainWindow()->ProcessEvents();
		}
	};
};


using namespace iggDialogLoadFile_Private;


//
//  Main class
//
iggDialogLoadFile::iggDialogLoadFile(iggMainWindow *parent) : iggDialog(parent,mIsMultiThread?0U:DialogFlag::Blocking,0,"Loading file...",0,2,"Abort")
{
	mProgressBar = new ProgressBar(mFrame);
	mLabel = new iggWidgetTextArea("",mFrame);

	mFrame->AddLine(new iggWidgetTextArea("%bLoading file:",mFrame));
	mFrame->AddLine(mLabel,2);
	mFrame->AddLine(mProgressBar,2);
	if(mIsMultiThread)
	{
		mFrame->AddLine(new iggWidgetTextArea("You can work with other windows while file is being loaded.",mFrame),2);
	}
	else
	{
		mFrame->AddLine(new iggWidgetTextArea("Please wait while file is being loaded.",mFrame),2);
	}

	mFrame->SetColStretch(1,10);

	this->ResizeContents(300,200);
}


iggDialogLoadFile::~iggDialogLoadFile()
{
}


void iggDialogLoadFile::LoadData(const iDataInfo &info, const iString &filename, int mod)
{
	int i;

	if(this->GetShell()->GetControlModule()->GetViewModule(mod)->IsClone()) return;

	mLabel->SetText(filename);
	iggDialog::Show(true);

	this->GetMainWindow()->Block(true);

	for(i=0; i<info.Count(); i++)
	{
		this->GetShell()->GetControlModule()->GetViewModule(mod)->GetReader()->LoadFile(info.Type(i),filename);
		if(mod==-1 || mod==this->GetShell()->GetControlModule()->GetCurrentViewModuleIndex()) this->GetMainWindow()->AfterLoadData(info.Type(i),filename);
	}

	this->GetMainWindow()->Block(false);
	iggDialog::Show(false);
}


void iggDialogLoadFile::ReloadData(const iDataInfo &info)
{
	int i;

	iggDialog::Show(true);
	this->GetMainWindow()->Block(true);

	for(i=0; i<info.Count(); i++)
	{
		mLabel->SetText(this->GetShell()->GetControlModule()->GetViewModule()->GetReader()->GetLastFileName(info.Type(i)));
		this->GetShell()->GetControlModule()->GetViewModule()->GetReader()->ReloadData(info.Type(i));
		this->GetMainWindow()->AfterReloadData(info.Type(i));
	}
	
	this->GetMainWindow()->Block(false);
	iggDialog::Show(false);
}


bool iggDialogLoadFile::CanBeClosed()
{
	mProgressBar->Abort();
	return true;
}


void iggDialogLoadFile::Show(bool)
{
	//
	//  This dialog is showed/hidden automatically
	//
}

#endif
