/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILEVIEWER_H
#define FILEVIEWER_H

#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtimer.h>
#include <qdir.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtoolbar.h>

#include "iointerface.h"

class QWidget;
class QDragEnterEvent;
class QDragMoveEvent;
class QDragLeaveEvent;
class QDropEvent;


extern QPixmap *folderLocked;
extern QPixmap *folderClosed;
extern QPixmap *folderOpen;
extern QPixmap *fileNormal;

class FileViewToolBar: public QWidget
   {
   Q_OBJECT

public:
   FileViewToolBar(QWidget *parent = 0, const char *name = 0);
   ~FileViewToolBar();

public slots:
   void sUpOneLevelClicked(void);
   void sRefreshClicked(void);
   void sCreateDirectoryClicked(void);
   void sPropertiesClicked(void);
   void sRenameClicked(void);
   void sDeleteClicked(void);

signals:
   void UpOneLevelClicked(void);
   void RefreshClicked(void);
   void CreateDirectoryClicked(void);
   void PropertiesClicked(void);
   void RenameClicked(void);
   void DeleteClicked(void);

private:
   QBoxLayout   *top_layout;
   QLabel       *panelName;
   QLabel       *lblSpace1;
   QLabel       *lblSpace2;
   QLabel       *lblSpace3;

   QPushButton  *UpOneLevel;
   QPushButton  *Refresh;
   QPushButton  *CreateDirectory;
   QPushButton  *Properties;
   QPushButton  *Rename;
   QPushButton  *Delete;
   };

class FileItem : public QListViewItem
   {
public:
   FileItem(QListViewItem *parent, const QString &filename, const QString filetype, const QString fsize)
         : QListViewItem(parent, filename, filetype, fsize), pix(0)
         {
         setPixmap(fileNormal);
         setRenameEnabled(0, TRUE);
         }

   const QPixmap *pixmap(int idx) const;
#if !defined(Q_NO_USING_KEYWORD)
   using QListViewItem::setPixmap;
#endif
   void setPixmap(QPixmap *p);

private:
   QPixmap *pix;
   };

class Directory : public QListViewItem
   {
public:
   Directory(QListView *parent, const QString& filename, IOInterface *Intf);
   Directory(Directory *parent, const QString& filename, IOInterface *Intf);

   QString fullName();

   void setOpen(bool);
   void setup();
   void setDirName(const QString&);

   const QPixmap *pixmap(int idx) const;
#if !defined(Q_NO_USING_KEYWORD)
   using QListViewItem::setPixmap;
#endif
   void setPixmap(QPixmap *qpix);

private:
   QFile file;
   Directory *parent_dir;
   bool readable;
   bool showDirsOnly;
   QPixmap *pix;
   IOInterface *ioIntf;
   };

class DirectoryView : public QListView
   {
   Q_OBJECT

public:
   DirectoryView(QWidget *parent = 0, const char *name = 0, bool sdo = FALSE);
   bool showDirsOnly() {return dirsOnly;}
   QString fullPath(QListViewItem* item);
   QString baseDirectory(QListViewItem* item);
   void clearItem(QListViewItem* item);
   QString currentDirectory(void);

   int msgflag, delmsgflag;
   IOInterface *ioIntf;

public slots:
   void setDir(const QString &);
   void fvUpOneLevel(void);
   void fvCreateDirectory(void);
   void fvRenameFile(void);
   void fvDeleteFile(void);
   void fvProperties(void);
   void fvRefreshFileItem(void);
   void fvTransferSelectedFiles(QString& destDir);

protected slots:
   void openFolder();
   void keyPressEvent(QKeyEvent *);
   void fvItemRenamed(QListViewItem * item, int col, const QString & text);

protected:
   void contentsDragEnterEvent(QDragEnterEvent *e);
   void contentsDragMoveEvent(QDragMoveEvent *e);
   void contentsDragLeaveEvent(QDragLeaveEvent *e);
   void contentsDropEvent(QDropEvent *e);
   void contentsMouseMoveEvent(QMouseEvent *e);
   void contentsMousePressEvent(QMouseEvent *e);
   void contentsMouseReleaseEvent(QMouseEvent *e);

private:
   void contextMenuEvent(QContextMenuEvent *);
   void unselectAllChildren(QListViewItem *parentItem);
   int getListOfSelectedItems(QPtrList<FileInfos> *file_info_list);
   bool dirsOnly;
   QListViewItem *oldCurrent;
   QListViewItem *dropItem;
   QTimer* autoopen_timer;
   QPoint presspos;
   bool mousePressed;
   bool yesAll;
   QString OldRenamePath;
   };

class fileManagerView : public QWidget
{
    Q_OBJECT
public:
   fileManagerView(QWidget *parent, const char *title = 0, bool sort = FALSE, int ioIntfType = 0);
   ~fileManagerView();

   QString currentDirectory(void);
   bool isProcessing();

public slots:
   void setDir(const QString &);
   void fmCreateDirectory(void);
   void fmRenameFile(void);
   void fmDeleteFile(void);
   void fmRefreshFileItem(void);
   void fmTransferSelectedFiles(QString& destDir);
   int  fmUploadFileList(QString& destination, QPtrList<FileInfos> *file_info_list);

protected slots:
   void sUpOneLevelClicked(void);
   void sRefreshClicked(void);
   void sCreateDirectoryClicked(void);
   void sPropertiesClicked(void);
   void sRenameClicked(void);
   void sDeleteClicked(void);


private:
   QBoxLayout  *top_layout;
   DirectoryView *internal_fileview;
   FileViewToolBar *filetoolbar;
};

#endif
