dnl Used by aclocal to generate configure

dnl -----------------------------------------------------------
AC_DEFUN([CLASSPATH_FIND_JAVAC],
[
  user_specified_javac=

  CLASSPATH_WITH_JAVAC

  if test "x${user_specified_javac}" = x; then
    AM_CONDITIONAL(FOUND_JAVAC, test "x${JAVAC}" != x)
  else
    AM_CONDITIONAL(FOUND_JAVAC, test "x${user_specified_javac}" = xjavac && test "x${JAVAC}" != x)
  fi

  if test "x${JAVAC}" = x && test "x${user_specified_javac}" != xjavac; then
      AC_MSG_ERROR([cannot find javac, try --with-javac])
  fi
])

dnl -----------------------------------------------------------
AC_DEFUN([CLASSPATH_WITH_JAVAC],
[
  AC_ARG_WITH([javac],
	      [AS_HELP_STRING(--with-javac,bytecode compilation with javac)],
  [
    if test "x${withval}" != x && test "x${withval}" != xyes && test "x${withval}" != xno; then
      CLASSPATH_CHECK_JAVAC(${withval})
    else
      if test "x${withval}" != xno; then
        CLASSPATH_CHECK_JAVAC
      fi
    fi
    user_specified_javac=javac
  ],
  [ 
    CLASSPATH_CHECK_JAVAC
  ])
  AC_SUBST(JAVAC)
  AC_SUBST(JAVAC_OPTS)
])

dnl -----------------------------------------------------------
AC_DEFUN([CLASSPATH_CHECK_JAVAC],
[
  if test "x$1" != x; then
    JAVAC="$1"
  else
    AC_PATH_PROG(JAVAC, "javac")
  fi
  dnl Test the given javac
  AC_MSG_CHECKING([if javac is 1.5-capable])
  cat > conftest.java << EOF
public class conftest {
public static void main(String[] args) {
java.util.List<String> l = new java.util.ArrayList<String>(); 
System.out.println(l);
}}
EOF
  $JAVAC -sourcepath '' conftest.java 
  javac_result=$?
  if test "x$javac_result" = "x0"; then
    AC_MSG_RESULT([yes])
  else
    AC_MSG_WARN([1.5 capable javac required])
  fi
  AC_MSG_CHECKING([whether javac supports -J])
  $JAVAC -J-Xmx512M -sourcepath '' conftest.java
  javac_result=$?
  if test "x$javac_result" = "x0"; then
    AC_MSG_RESULT([yes])
    JAVAC_OPTS="-J-Xmx512M"
  else
    AC_MSG_RESULT([javac doesn't support -J])
  fi
])

dnl Allow langtools directory to be specified
AC_DEFUN([WITH_LANGTOOLS_SRC_DIR],
[
  AC_MSG_CHECKING(langtools sources)
  AC_ARG_WITH([langtools-src-dir],
              [AS_HELP_STRING(--with-langtools-src-dir,specify the location of the openjdk langtools sources)],
  [
    LANGTOOLS_SRC_DIR=${withval}
    AC_MSG_RESULT(${withval})
    conditional_with_langtools_sources=true
  ],
  [ 
    conditional_with_langtools_sources=false
    LANGTOOLS_SRC_DIR=`pwd`/langtools
    AC_MSG_RESULT(${OPENJDK_SRC_DIR})
  ])
  AC_SUBST(LANGTOOLS_SRC_DIR)
  AM_CONDITIONAL(GNU_CLASSLIB_FOUND, test "x${conditional_with_langtools_sources}" = xtrue)
])

dnl -----------------------------------------------------------
dnl CLASSPATH_WITH_CLASSLIB - checks for user specified classpath additions
dnl -----------------------------------------------------------
AC_DEFUN([CLASSPATH_WITH_CLASSLIB],
[
  AC_ARG_WITH([classpath],
	      [AS_HELP_STRING(--with-classpath,specify path to a classes.zip like file)],
  [
    if test "x${withval}" = xyes; then
      # set user classpath to CLASSPATH from env
      AC_MSG_CHECKING(for classlib)
      USER_CLASSLIB=${CLASSPATH}
      AC_SUBST(USER_CLASSLIB)
      AC_MSG_RESULT(${USER_CLASSLIB})
      conditional_with_classlib=true      
    elif test "x${withval}" != x && test "x${withval}" != xno; then
      # set user classpath to specified value
      AC_MSG_CHECKING(for classlib)
      USER_CLASSLIB=${withval}
      AC_SUBST(USER_CLASSLIB)
      AC_MSG_RESULT(${withval})
      conditional_with_classlib=true
    fi
  ],
  [ conditional_with_classlib=false ])
  AM_CONDITIONAL(USER_SPECIFIED_CLASSLIB, test "x${conditional_with_classlib}" = xtrue)

])
