# vim:set et sts=4 sw=4:
#
# ibus-xkbc - The Input Bus Keyboard Layout emulaton engine.
#
# Copyright (c) 2009, 2010 Oracle and/or its affiliates. All rights reserved.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

compose_dict = {
    "\x22" : { 
        "A" : "\xc3\x84",
        "a" : "\xc3\xa4",
        "e" : "\xc3\xab",
        " " : "\xcb\x9d",
        "I" : "\xc3\x8f",
        "O" : "\xc3\x96",
        "i" : "\xc3\xaf",
        "\x22" : "\xc2\xa8",
        "o" : "\xc3\xb6",
        "y" : "\xc3\xbf",
        "E" : "\xc3\x8b",
        "U" : "\xc3\x9c",
        "u" : "\xc3\xbc",
        "Y" : "\xc5\xb8",
    },
    "\xcb\x9b" : { 
        "A" : "\xc4\x84",
        "a" : "\xc4\x85",
        "E" : "\xc4\x98",
        "e" : "\xc4\x99",
    },
    "\xcb\x9d" : { 
        "u" : "\xc5\xb1",
        "U" : "\xc5\xb0",
        "o" : "\xc5\x91",
        "O" : "\xc5\x90",
    },
    "\xcb\x87" : { 
        "C" : "\xc4\x8c",
        "z" : "\xc5\xbe",
        "E" : "\xc4\x9a",
        "D" : "\xc4\x8e",
        "u" : "\xc5\xaf",
        "c" : "\xc4\x8d",
        "r" : "\xc5\x99",
        "L" : "\xc4\xbd",
        "N" : "\xc5\x87",
        "s" : "\xc5\xa1",
        "S" : "\xc5\xa0",
        "R" : "\xc5\x98",
        "U" : "\xc5\xae",
        "T" : "\xc5\xa4",
        "n" : "\xc5\x88",
        "t" : "\xc5\xa5",
        "e" : "\xc4\x9b",
        "Z" : "\xc5\xbd",
        "l" : "\xc4\xbe",
        "d" : "\xc4\x8f",
    },
    "\xc2\xb4" : { 
        "A" : "\xc3\x81",
        "C" : "\xc4\x86",
        "E" : "\xc3\x89",
        "I" : "\xc3\x8d",
        "L" : "\xc4\xb9",
        "O" : "\xc3\x93",
        "N" : "\xc5\x83",
        "S" : "\xc5\x9a",
        "R" : "\xc5\x94",
        "U" : "\xc3\x9a",
        "Y" : "\xc3\x9d",
        "Z" : "\xc4\xbe",
        "a" : "\xc3\xa1",
        "c" : "\xc4\x87",
        "e" : "\xc3\xa9",
        "i" : "\xc3\xad",
        "l" : "\xc4\xba",
        "o" : "\xc3\xb3",
        "n" : "\xc5\x84",
        "s" : "\xc5\x9b",
        "r" : "\xc5\x95",
        "u" : "\xc3\xba",
        "y" : "\xc3\xbd",
        "z" : "\xc5\xba",
    },
    "!" : { 
        "!" : "\xc2\xa1",
        "P" : "\xc2\xb6",
        "s" : "\xc2\xa7",
        "p" : "\xc2\xb6",
        "S" : "\xc2\xa7",
        "^" : "\xc2\xa6",
    },
    " " : { 
        "`" : "\x60",
        "'" : "\x27'",
        " " : "\xc2\xa0",
        "\xcb\x9d" : "\xcb\x9d",
        "\xcb\x9b" : "\xcb\x9b",
        "-" : "\x7e",
        "\xcb\x98" : "\xcb\x98",
        "^" : "\x5e",
        "v" : "\xcb\x87",
        "\xc2\xb0" : "\xc2\xb0",
        ">" : "\x5e",
        "\xcb\x87" : "\xcb\x87",
        "~" : "\x7e",
    },
    "'" : { 
        "A" : "\xc3\x81",
        " " : "\x27",
        "E" : "\xc3\x89",
        "y" : "\xc3\xbd",
        "'" : "\xc2\xb4",
        "o" : "\xc3\xb3",
        "I" : "\xc3\x8d",
        "O" : "\xc3\x93",
        "i" : "\xc3\xad",
        "U" : "\xc3\x9a",
        "a" : "\xc3\xa1",
        "Y" : "\xc3\x9d",
        "e" : "\xc3\xa9",
        "u" : "\xc3\xba",
    },
    ")" : { 
        ")" : "\x5d",
        "-" : "\x7d",
    },
    "(" : { 
        "(" : "\x5b",
        "-" : "\x7b",
    },
    "+" : { 
        "+" : "\x23",
        "-" : "\xc2\xb1",
    },
    "*" : { 
        "A" : "\xc3\x85",
        "0" : "\xc2\xb0",
        "a" : "\xc3\xa5",
    },
    "-" : { 
        "a" : "\xc2\xaa",
        " " : "\x7e",
        ")" : "\x7d",
        "(" : "\x7b",
        "+" : "\xc2\xb1",
        "-" : "\xc2\xad",
        "l" : "\xc2\xa3",
        "o" : "\xc2\xba",
        "L" : "\xc2\xa3",
        "Y" : "\xc2\xa5",
        "N" : "\xc3\x91",
        "n" : "\xc3\xb1",
        "A" : "\xc2\xaa",
        "O" : "\xc2\xba",
        "y" : "\xc2\xa5",
        ":" : "\xc3\xb7",
        "," : "\xc2\xac",
        "^" : "\xc2\xaf",
    },
    "," : { 
        "c" : "\xc3\xa7",
        "l" : "\xc4\xbc",
        "g" : "\xc4\xa3",
        "G" : "\xc4\xa2",
        "N" : "\xc5\x85",
        "s" : "\xc5\x9f",
        "K" : "\xc4\xb6",
        "-" : "\xc2\xac",
        "C" : "\xc3\x87",
        "," : "\xc2\xb8",
        "S" : "\xc5\x9e",
        "R" : "\xc5\x96",
        "T" : "\xc5\xa2",
        "n" : "\xc5\x86",
        "r" : "\xc5\x97",
        "k" : "\xc4\xb7",
        "L" : "\xc4\xbb",
        "t" : "\xc5\xa3",
    },
    "/" : { 
        "o" : "\xc3\xb8",
        "C" : "\xc2\xa2",
        "D" : "\xc4\x90",
        "c" : "\xc2\xa2",
        "/" : "\x5c",
        "d" : "\xc4\x91",
        "u" : "\xc2\xb5",
        "O" : "\xc3\x98",
        "U" : "\xc2\xb5",
        "<" : "\x5c",
        "^" : "\x7c",
    },
    "." : { 
        "C" : "\xc4\x8a",
        "Z" : "\xc5\xbb",
        "g" : "\xc4\xa1",
        "G" : "\xc4\xa0",
        "I" : "\xc4\xb0",
        "c" : "\xc4\x8b",
        "." : "\xc2\xb7",
        "i" : "\xc4\xb1",
        "U" : "\xc5\xae",
        "u" : "\xc5\xaf",
        "z" : "\xc5\xbc",
        "^" : "\xc2\xb7",
    },
    "1" : { 
        "2" : "\xc2\xbd",
        "S" : "\xc2\xb9",
        "4" : "\xc2\xbc",
        "s" : "\xc2\xb9",
        "^" : "\xc2\xb9",
    },
    "0" : { 
        "C" : "\xc2\xa9",
        "s" : "\xc2\xa7",
        "*" : "\xc2\xb0",
        "c" : "\xc2\xa9",
        "O" : "\xc2\xb0",
        "S" : "\xc2\xa7",
        "X" : "\xc2\xa4",
        "x" : "\xc2\xa4",
        "^" : "\xc2\xb0",
    },
    "3" : { 
        "S" : "\xc2\xb3",
        "4" : "\xc2\xbe",
        "s" : "\xc2\xb3",
        "^" : "\xc2\xb3",
    },
    "2" : { 
        "S" : "\xc2\xb2",
        "s" : "\xc2\xb2",
        "^" : "\xc2\xb2",
    },
    ":" : { 
        "-" : "\xc3\xb7",
    },
    "=" : { 
        "c" : "\xe2\x82\xac",
        "E" : "\xe2\x82\xac",
        "C" : "\xe2\x82\xac",
        "L" : "\xc2\xa3",
        "Y" : "\xc2\xa5",
        "y" : "\xc2\xa5",
        "e" : "\xe2\x82\xac",
        "l" : "\xc2\xa3",
    },
    "<" : { 
        "<" : "\xc2\xab",
        "/" : "\x5c",
    },
    "?" : { 
        "?" : "\xc2\xbf",
    },
    ">" : { 
        " " : "\x5e",
        ">" : "\xc2\xbb",
        "A" : "\xc3\x82",
        "C" : "\xc4\x88",
        "E" : "\xc3\x8a",
        "G" : "\xc4\x9c",
        "I" : "\xc3\x8e",
        "H" : "\xc4\xa4",
        "J" : "\xc4\xb4",
        "O" : "\xc3\x94",
        "S" : "\xc5\x9c",
        "U" : "\xc3\x9b",
        "a" : "\xc3\xa2",
        "c" : "\xc4\x89",
        "e" : "\xc3\xaa",
        "g" : "\xc4\x9d",
        "i" : "\xc3\xae",
        "h" : "\xc4\xa5",
        "j" : "\xc4\xb5",
        "o" : "\xc3\xb4",
        "s" : "\xc5\x9d",
        "u" : "\xc3\xbb",
    },
    "A" : { 
        "A" : "\x40",
        "a" : "\xc4\x84",
        "E" : "\xc3\x86",
        "'" : "\xc3\x81",
        "`" : "\xc3\x80",
        "\xc2\xa8" : "\xc3\x84",
        "\xcb\x9b" : "\xc4\x84",
        "*" : "\xc3\x85",
        "-" : "\xc2\xaa",
        "\xcb\x98" : "\xc4\x82",
        "~" : "\xc3\x83",
        "\x22" : "\xc3\x84",
        "u" : "\xc4\x82",
        ">" : "\xc3\x82",
        "\xc2\xb4" : "\xc3\x81",
        "_" : "\xc4\x80",
        "^" : "\xc3\x82",
    },
    "C" : { 
        "'" : "\xc4\x86",
        "." : "\xc4\x8a",
        "\xcb\x87" : "\xc4\x8c",
        "," : "\xc3\x87",
        "O" : "\xc2\xa9",
        "|" : "\xc2\xa2",
        "0" : "\xc2\xa9",
        "o" : "\xc2\xa9",
        "v" : "\xc4\x8c",
        "^" : "\xc4\x88",
        "=" : "\xe2\x82\xac",
        "\xc2\xb4" : "\xc4\x86",
        ">" : "\xc4\x88",
        "/" : "\xc2\xa2",
    },
    "B" : { 
        "V" : "\xc2\xa6",
    },
    "E" : { 
        "a" : "\xc4\x98",
        "`" : "\xc3\x88",
        "'" : "\xc3\x89",
        "\xc2\xa8" : "\xc3\x8b",
        "\xcb\x87" : "\xc4\x9a",
        "\xcb\x9b" : "\xc4\x98",
        "." : "\xc4\x96",
        "\x22" : "\xc3\x8b",
        "v" : "\xc4\x9a",
        "^" : "\xc3\x8a",
        "=" : "\xe2\x82\xac",
        "\xc2\xb4" : "\xc3\x89",
        "_" : "\xc4\x92",
        ">" : "\xc3\x8a",
    },
    "D" : { 
        "\xcb\x87" : "\xc4\x8e",
        "-" : "\xc3\x90",
        "v" : "\xc4\x8e",
    },
    "G" : { 
        "." : "\xc4\xa0",
        ">" : "\xc4\x9c",
        "u" : "\xc4\x9e",
        "," : "\xc4\xa2",
        "^" : "\xc4\x9c",
    },
    "I" : { 
        "a" : "\xc4\xae",
        "`" : "\xc3\x8c",
        "'" : "\xc3\x8d",
        "." : "\xc4\xb0",
        "~" : "\xc4\xa8",
        "\x22" : "\xc3\x8f",
        "^" : "\xc3\x8e",
        "\xc2\xb4" : "\xc3\x8d",
        "_" : "\xc4\xaa",
        ">" : "\xc3\x8e",
    },
    "H" : { 
        ">" : "\xc4\xa4",
        "^" : "\xc4\xa4",
    },
    "K" : { 
        "," : "\xc4\xb6",
    },
    "J" : { 
        ">" : "\xc4\xb4",
        "^" : "\xc4\xb4",
    },
    "L" : { 
        "'" : "\xc4\xb9",
        "\xcb\x87" : "\xc4\xbd",
        "-" : "\xc2\xa3",
        "," : "\xc4\xbb",
        "/" : "\xc5\x81",
        "V" : "\x7c",
        "=" : "\xc2\xa3",
        "\xc2\xb4" : "\xc4\xb9",
        ">" : "\xc4\xbd",
    },
    "O" : { 
        "`" : "\xc3\x92",
        "c" : "\xc2\xa9",
        "E" : "\xc5\x92",
        "'" : "\xc3\x93",
        "\xc2\xa8" : "\xc3\x96",
        "\xcb\x9d" : "\xc5\x90",
        "-" : "\xc2\xba",
        "C" : "\xc2\xa9",
        "/" : "\xc3\x98",
        "S" : "\xc2\xa7",
        "R" : "\xc2\xae",
        "\x22" : "\xc3\x96",
        "x" : "\xc2\xa4",
        "~" : "\xc3\x95",
        "X" : "\xc2\xa4",
        ">" : "\xc3\x94",
        "\xc2\xb4" : "\xc3\x93",
        "_" : "\xc5\x8c",
        "^" : "\xc3\x94",
    },
    "N" : { 
        "'" : "\xc5\x83",
        "-" : "\xc3\x91",
        "," : "\xc5\x85",
        "N" : "\xc5\x8a",
        "v" : "\xc5\x87",
        "\xcb\x87" : "\xc5\x87",
        "\xc2\xb4" : "\xc5\x83",
        "~" : "\xc3\x91",
    },
    "\xcb\x98" : { 
        "A" : "\xc4\x82",
        "a" : "\xc4\x83",
        "U" : "\xc5\xac",
        "u" : "\xc5\xad",
    },
    "P" : { 
        "!" : "\xc2\xb6",
    },
    "S" : { 
        "!" : "\xc2\xa7",
        "'" : "\xc5\x9a",
        "V" : "\xc5\xa0",
        "," : "\xc5\x9e",
        "O" : "\xc2\xa7",
        "1" : "\xc2\xb9",
        "0" : "\xc2\xa7",
        "3" : "\xc2\xb3",
        "2" : "\xc2\xb2",
        "v" : "\xc5\xa0",
        ">" : "\xc5\x9c",
        "\xcb\x87" : "\xc5\xa0",
        "\xc2\xb4" : "\xc5\x9a",
        "^" : "\xc5\x9c",
    },
    "R" : { 
        "'" : "\xc5\x94",
        "," : "\xc5\x96",
        "O" : "\xc2\xae",
        "v" : "\xc5\x98",
        "\xcb\x87" : "\xc5\x98",
        "\xc2\xb4" : "\xc5\x94",
    },
    "U" : { 
        "a" : "\xc5\xb2",
        "`" : "\xc3\x99",
        "'" : "\xc3\x9a",
        "\xc2\xa8" : "\xc3\x9c",
        "*" : "\xc5\xae",
        "\xcb\x9d" : "\xc5\xb0",
        "/" : "\xc2\xb5",
        "." : "\xc5\xae",
        "\xcb\x98" : "\xc5\xac",
        "~" : "\xc5\xa8",
        "\x22" : "\xc3\x9c",
        "v" : "\xc5\xae",
        "u" : "\xc5\xac",
        "^" : "\xc3\x9b",
        "\xcb\x87" : "\xc5\xae",
        "\xc2\xb4" : "\xc3\x9a",
        "_" : "\xc5\xaa",
        ">" : "\xc3\x9b",
    },
    "T" : { 
        "H" : "\xc3\x9e",
        "|" : "\xc5\xa6",
        "\xcb\x87" : "\xc5\xa4",
        "," : "\xc5\xa2",
        "v" : "\xc5\xa4",
    },
    "V" : { 
        "s" : "\xc5\xa1",
        "S" : "\xc5\xa0",
        "B" : "\xc2\xa6",
        "L" : "\x7c",
    },
    "Y" : { 
        "=" : "\xc2\xa5",
        "-" : "\xc2\xa5",
        "\xc2\xb4" : "\xc3\x9d",
        "'" : "\xc3\x9d",
        "\x22" : "\xc5\xb8",
    },
    "X" : { 
        "0" : "\xc2\xa4",
        "o" : "\xc2\xa4",
        "O" : "\xc2\xa4",
    },
    "Z" : { 
        "." : "\xc5\xbb",
        "\xcb\x87" : "\xc5\xbd",
        "\xc2\xb4" : "\xc4\xbe",
        "'" : "\xc5\xb9",
        "v" : "\xc5\xbd",
    },
    "_" : { 
        "A" : "\xc4\x80",
        "a" : "\xc4\x81",
        "e" : "\xc4\x93",
        "d" : "\xc4\x91",
        "I" : "\xc4\xaa",
        "O" : "\xc5\x8c",
        "i" : "\xc4\xab",
        "U" : "\xc5\xaa",
        "o" : "\xc5\x8d",
        "E" : "\xc4\x92",
        "u" : "\xc5\xab",
        "_" : "\xc2\xaf",
        "^" : "\xc2\xaf",
    },
    "^" : { 
        "!" : "\xc2\xa6",
        " " : "\x5e",
        "-" : "\xc2\xaf",
        "/" : "\x7c",
        "." : "\xc2\xb7",
        "1" : "\xc2\xb9",
        "0" : "\xc2\xb0",
        "3" : "\xc2\xb3",
        "2" : "\xc2\xb2",
        "A" : "\xc3\x82",
        "C" : "\xc4\x88",
        "E" : "\xc3\x8a",
        "G" : "\xc4\x9c",
        "I" : "\xc3\x8e",
        "H" : "\xc4\xa4",
        "J" : "\xc4\xb4",
        "O" : "\xc3\x94",
        "S" : "\xc5\x9c",
        "U" : "\xc3\x9b",
        "_" : "\xc2\xaf",
        "a" : "\xc3\xa2",
        "c" : "\xc4\x89",
        "e" : "\xc3\xaa",
        "g" : "\xc4\x9d",
        "i" : "\xc3\xae",
        "h" : "\xc4\xa5",
        "j" : "\xc4\xb5",
        "o" : "\xc3\xb4",
        "s" : "\xc5\x9d",
        "u" : "\xc3\xbb",
    },
    "a" : { 
        "A" : "\xc4\x84",
        "a" : "\xc4\x85",
        "e" : "\xc3\xa6",
        " " : "\xcb\x9b",
        "'" : "\xc3\xa1",
        "`" : "\xc3\xa0",
        "\xc2\xa8" : "\xc3\xa4",
        "i" : "\xc4\xaf",
        "\xcb\x9b" : "\xc4\x85",
        "*" : "\xc3\xa5",
        "-" : "\xc2\xaa",
        "\xcb\x98" : "\xc4\x83",
        "I" : "\xc4\xae",
        "~" : "\xc3\xa3",
        "\x22" : "\xc3\xa4",
        "u" : "\xc4\x83",
        ">" : "\xc3\xa2",
        "\xc2\xb4" : "\xc3\xa1",
        "_" : "\xc4\x81",
        "^" : "\xc3\xa2",
    },
    "`" : { 
        "A" : "\xc3\x80",
        " " : "\x60",
        "E" : "\xc3\x88",
        "o" : "\xc3\xb2",
        "I" : "\xc3\x8c",
        "O" : "\xc3\x92",
        "i" : "\xc3\xac",
        "U" : "\xc3\x99",
        "a" : "\xc3\xa0",
        "e" : "\xc3\xa8",
        "u" : "\xc3\xb9",
    },
    "c" : { 
        "'" : "\xc4\x87",
        "." : "\xc4\x8b",
        "\xcb\x87" : "\xc4\x8d",
        "," : "\xc3\xa7",
        "O" : "\xc2\xa9",
        "|" : "\xc2\xa2",
        "0" : "\xc2\xa9",
        "o" : "\xc2\xa9",
        "v" : "\xc4\x8d",
        "^" : "\xc4\x89",
        "=" : "\xe2\x82\xac",
        "\xc2\xb4" : "\xc4\x87",
        ">" : "\xc4\x89",
        "/" : "\xc2\xa2",
    },
    "b" : { 
        "v" : "\xc2\xa6",
    },
    "e" : { 
        "a" : "\xc4\x99",
        "`" : "\xc3\xa8",
        "'" : "\xc3\xa9",
        "\xc2\xa8" : "\xc3\xab",
        "\xcb\x87" : "\xc4\x9b",
        "\xcb\x9b" : "\xc4\x99",
        "." : "\xc4\x97",
        "\x22" : "\xc3\xab",
        "v" : "\xc4\x9b",
        "^" : "\xc3\xaa",
        "=" : "\xe2\x82\xac",
        "\xc2\xb4" : "\xc3\xa9",
        "_" : "\xc4\x93",
        ">" : "\xc3\xaa",
    },
    "d" : { 
        "\xcb\x87" : "\xc4\x8f",
        "-" : "\xc3\xb0",
        "_" : "\xc4\x91",
        "v" : "\xc4\x8f",
    },
    "g" : { 
        "." : "\xc4\xa1",
        ">" : "\xc4\x9d",
        "u" : "\xc4\x9f",
        "," : "\xc4\xa3",
        "^" : "\xc4\x9d",
    },
    "i" : { 
        "a" : "\xc4\xaf",
        "`" : "\xc3\xac",
        "'" : "\xc3\xad",
        "." : "\xc4\xb1",
        "~" : "\xc4\xa9",
        "\x22" : "\xc3\xaf",
        "^" : "\xc3\xae",
        "\xc2\xb4" : "\xc3\xad",
        "_" : "\xc4\xab",
        ">" : "\xc3\xae",
    },
    "h" : { 
        ">" : "\xc4\xa5",
        "^" : "\xc4\xa5",
    },
    "k" : { 
        "k" : "\xc4\xb8",
        "," : "\xc4\xb7",
    },
    "j" : { 
        ">" : "\xc4\xb5",
        "^" : "\xc4\xb5",
    },
    "l" : { 
        "'" : "\xc4\xba",
        "\xcb\x87" : "\xc4\xbe",
        "-" : "\xc2\xa3",
        "," : "\xc4\xbc",
        "/" : "\xc5\x82",
        "v" : "\x7c",
        "=" : "\xc2\xa3",
        "\xc2\xb4" : "\xc4\xba",
        ">" : "\xc4\xbe",
    },
    "o" : { 
        "`" : "\xc3\xb2",
        "C" : "\xc2\xa9",
        "e" : "\xc5\x93",
        "'" : "\xc3\xb3",
        "\xc2\xa8" : "\xc3\xb6",
        "\xcb\x9d" : "\xc5\x91",
        "-" : "\xc2\xba",
        "c" : "\xc2\xa9",
        "/" : "\xc3\xb8",
        "s" : "\xc2\xa7",
        "~" : "\xc3\xb5",
        "\x22" : "\xc3\xb6",
        "o" : "\xc2\xb0",
        "X" : "\xc2\xa4",
        "x" : "\xc2\xa4",
        ">" : "\xc3\xb4",
        "\xc2\xb4" : "\xc3\xb3",
        "_" : "\xc5\x8d",
        "^" : "\xc3\xb4",
    },
    "n" : { 
        "'" : "\xc5\x84",
        "-" : "\xc3\xb1",
        "," : "\xc5\x86",
        "n" : "\xc5\x8b",
        "v" : "\xc5\x88",
        "\xcb\x87" : "\xc5\x88",
        "\xc2\xb4" : "\xc5\x84",
        "~" : "\xc3\xb1",
    },
    "p" : { 
        "!" : "\xc2\xb6",
    },
    "s" : { 
        "!" : "\xc2\xa7",
        "'" : "\xc5\x9b",
        "V" : "\xc5\xa1",
        "s" : "\xc3\x9f",
        "o" : "\xc2\xa7",
        "," : "\xc5\x9f",
        "1" : "\xc2\xb9",
        "0" : "\xc2\xa7",
        "3" : "\xc2\xb3",
        "2" : "\xc2\xb2",
        "v" : "\xc5\xa1",
        ">" : "\xc5\x9d",
        "\xcb\x87" : "\xc5\xa1",
        "\xc2\xb4" : "\xc5\x9b",
        "^" : "\xc5\x9d",
    },
    "r" : { 
        "," : "\xc5\x97",
        "\xcb\x87" : "\xc5\x99",
        "\xc2\xb4" : "\xc5\x95",
        "'" : "\xc5\x95",
        "v" : "\xc5\x99",
    },
    "u" : { 
        "\xcb\x9d" : "\xc5\xb1",
        "\xcb\x87" : "\xc5\xaf",
        "\xc2\xb4" : "\xc3\xba",
        " " : "\xcb\x98",
        "'" : "\xc3\xba",
        "*" : "\xc5\xaf",
        "/" : "\xc2\xb5",
        "." : "\xc5\xaf",
        ">" : "\xc3\xbb",
        "G" : "\xc4\x9e",
        "\xcb\x98" : "\xc5\xad",
        "\x22" : "\xc3\xbc",
        "_" : "\xc5\xab",
        "^" : "\xc3\xbb",
        "a" : "\xc5\xb3",
        "`" : "\xc3\xb9",
        "g" : "\xc4\x9f",
        "\xc2\xa8" : "\xc3\xbc",
        "u" : "\xc5\xad",
        "v" : "\xc5\xaf",
        "U" : "\xc5\xac",
        "~" : "\xc5\xa9",
    },
    "t" : { 
        "h" : "\xc3\xbe",
        "|" : "\xc5\xa7",
        "\xcb\x87" : "\xc5\xa5",
        "," : "\xc5\xa3",
        "v" : "\xc5\xa5",
    },
    "v" : { 
        " " : "\xcb\x87",
        "C" : "\xc4\x8c",
        "b" : "\xc2\xa6",
        "E" : "\xc4\x9a",
        "D" : "\xc4\x8e",
        "c" : "\xc4\x8d",
        "z" : "\xc5\xbe",
        "r" : "\xc5\x99",
        "l" : "\x7c",
        "N" : "\xc5\x87",
        "s" : "\xc5\xa1",
        "S" : "\xc5\xa0",
        "R" : "\xc5\x98",
        "U" : "\xc5\xae",
        "T" : "\xc5\xa4",
        "n" : "\xc5\x88",
        "t" : "\xc5\xa5",
        "e" : "\xc4\x9b",
        "Z" : "\xc5\xbd",
        "u" : "\xc5\xaf",
        "d" : "\xc4\x8f",
    },
    "y" : { 
        "=" : "\xc2\xa5",
        "-" : "\xc2\xa5",
        "\xc2\xb4" : "\xc3\xbd",
        "'" : "\xc3\xbd",
        "\x22" : "\xc3\xbf",
    },
    "x" : { 
        "0" : "\xc2\xa4",
        "O" : "\xc2\xa4",
        "o" : "\xc2\xa4",
        "x" : "\xc3\x97",
    },
    "z" : { 
        "." : "\xc5\xbc",
        "\xcb\x87" : "\xc5\xbe",
        "\xc2\xb4" : "\xc5\xba",
        "'" : "\xc5\xba",
        "v" : "\xc5\xbe",
    },
    "\xc2\xa8" : { 
        "A" : "\xc3\x84",
        "a" : "\xc3\xa4",
        "E" : "\xc3\x8b",
        "O" : "\xc3\x96",
        "U" : "\xc3\x9c",
        "o" : "\xc3\xb6",
        "e" : "\xc3\xab",
        "u" : "\xc3\xbc",
    },
    "|" : { 
        "C" : "\xc2\xa2",
        "t" : "\xc5\xa7",
        "c" : "\xc2\xa2",
        "T" : "\xc5\xa6",
        "|" : "\xc2\xa6",
    },
    "~" : { 
        "A" : "\xc3\x83",
        " " : "\x7e",
        "o" : "\xc3\xb5",
        "I" : "\xc4\xa8",
        "O" : "\xc3\x95",
        "n" : "\xc3\xb1",
        "i" : "\xc4\xa9",
        "U" : "\xc5\xa8",
        "a" : "\xc3\xa3",
        "u" : "\xc5\xa9",
        "N" : "\xc3\x91",
    },
}
