/* plist.c generated by valac 0.14.0, the Vala compiler
 * generated from plist.vala, do not modify */

/* 
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PLIST (plist_get_type ())
#define PLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLIST, PList))
#define PLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLIST, PListClass))
#define IS_PLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLIST))
#define IS_PLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLIST))
#define PLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLIST, PListClass))

typedef struct _PList PList;
typedef struct _PListClass PListClass;
typedef struct _PListPrivate PListPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

typedef enum  {
	PLIST_PARSE_ERROR_FAILED
} PListParseError;
#define PLIST_PARSE_ERROR plist_parse_error_quark ()
struct _PList {
	GObject parent_instance;
	PListPrivate * priv;
};

struct _PListClass {
	GObjectClass parent_class;
};

struct _PListPrivate {
	GeeMap* map;
};


static gpointer plist_parent_class = NULL;

GQuark plist_parse_error_quark (void);
GType plist_get_type (void) G_GNUC_CONST;
#define PLIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PLIST, PListPrivate))
enum  {
	PLIST_DUMMY_PROPERTY
};
gchar* plist_get (PList* self, const gchar* key);
PList* plist_new (const gchar* str, GError** error);
PList* plist_construct (GType object_type, const gchar* str, GError** error);
gchar* plist_escape (const gchar* str);
gchar* plist_to_string (PList* self);
static void plist_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark plist_parse_error_quark (void) {
	return g_quark_from_static_string ("plist_parse_error-quark");
}


gchar* plist_get (PList* self, const gchar* key) {
	gchar* result = NULL;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = key;
	_tmp2_ = gee_map_get (_tmp0_, _tmp1_);
	result = (gchar*) _tmp2_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


PList* plist_construct (GType object_type, const gchar* str, GError** error) {
	PList * self = NULL;
	GString* _tmp0_;
	GString* builder;
	gchar* key;
	gchar* value;
	gint index = 0;
	gint _tmp38_;
	const gchar* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	self = (PList*) g_object_new (object_type, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	key = NULL;
	value = NULL;
	{
		gboolean _tmp1_;
		index = 0;
		_tmp1_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_;
			gint _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			const gchar* _tmp8_;
			gint _tmp9_;
			gchar _tmp10_ = '\0';
			_tmp2_ = _tmp1_;
			if (!_tmp2_) {
				gint _tmp3_;
				_tmp3_ = index;
				index = _tmp3_ + 1;
			}
			_tmp1_ = FALSE;
			_tmp4_ = index;
			_tmp5_ = str;
			_tmp6_ = strlen (_tmp5_);
			_tmp7_ = _tmp6_;
			if (!(_tmp4_ < _tmp7_)) {
				break;
			}
			_tmp8_ = str;
			_tmp9_ = index;
			_tmp10_ = string_get (_tmp8_, (glong) _tmp9_);
			switch (_tmp10_) {
				case '\\':
				{
					gint _tmp11_;
					gint _tmp12_;
					const gchar* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					GString* _tmp17_;
					const gchar* _tmp18_;
					gint _tmp19_;
					gchar _tmp20_ = '\0';
					_tmp11_ = index;
					index = _tmp11_ + 1;
					_tmp12_ = index;
					_tmp13_ = str;
					_tmp14_ = strlen (_tmp13_);
					_tmp15_ = _tmp14_;
					if (_tmp12_ == _tmp15_) {
						GError* _tmp16_;
						_tmp16_ = g_error_new_literal (PLIST_PARSE_ERROR, PLIST_PARSE_ERROR_FAILED, "");
						_inner_error_ = _tmp16_;
						if (_inner_error_->domain == PLIST_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (value);
							_g_free0 (key);
							_g_string_free0 (builder);
							_g_object_unref0 (self);
							return NULL;
						} else {
							_g_free0 (value);
							_g_free0 (key);
							_g_string_free0 (builder);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp17_ = builder;
					_tmp18_ = str;
					_tmp19_ = index;
					_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
					g_string_append_c (_tmp17_, _tmp20_);
					break;
				}
				case ',':
				{
					const gchar* _tmp21_;
					GString* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					GString* _tmp26_;
					GeeMap* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					_tmp21_ = key;
					if (_tmp21_ == NULL) {
						GError* _tmp22_;
						_tmp22_ = g_error_new_literal (PLIST_PARSE_ERROR, PLIST_PARSE_ERROR_FAILED, "");
						_inner_error_ = _tmp22_;
						if (_inner_error_->domain == PLIST_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (value);
							_g_free0 (key);
							_g_string_free0 (builder);
							_g_object_unref0 (self);
							return NULL;
						} else {
							_g_free0 (value);
							_g_free0 (key);
							_g_string_free0 (builder);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp23_ = builder;
					_tmp24_ = _tmp23_->str;
					_tmp25_ = g_strdup (_tmp24_);
					_g_free0 (value);
					value = _tmp25_;
					_tmp26_ = builder;
					g_string_erase (_tmp26_, (gssize) 0, (gssize) (-1));
					_tmp27_ = self->priv->map;
					_tmp28_ = key;
					_tmp29_ = value;
					gee_map_set (_tmp27_, _tmp28_, _tmp29_);
					_g_free0 (key);
					key = NULL;
					break;
				}
				case '=':
				{
					GString* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					GString* _tmp33_;
					_tmp30_ = builder;
					_tmp31_ = _tmp30_->str;
					_tmp32_ = g_strdup (_tmp31_);
					_g_free0 (key);
					key = _tmp32_;
					_tmp33_ = builder;
					g_string_erase (_tmp33_, (gssize) 0, (gssize) (-1));
					_g_free0 (value);
					value = NULL;
					break;
				}
				default:
				{
					GString* _tmp34_;
					const gchar* _tmp35_;
					gint _tmp36_;
					gchar _tmp37_ = '\0';
					_tmp34_ = builder;
					_tmp35_ = str;
					_tmp36_ = index;
					_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
					g_string_append_c (_tmp34_, _tmp37_);
					break;
				}
			}
		}
	}
	_tmp38_ = index;
	_tmp39_ = str;
	_tmp40_ = strlen (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp38_ == _tmp41_) {
		const gchar* _tmp42_;
		GString* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		GeeMap* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		_tmp42_ = key;
		if (_tmp42_ == NULL) {
			GError* _tmp43_;
			_tmp43_ = g_error_new_literal (PLIST_PARSE_ERROR, PLIST_PARSE_ERROR_FAILED, "");
			_inner_error_ = _tmp43_;
			if (_inner_error_->domain == PLIST_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (value);
				_g_free0 (key);
				_g_string_free0 (builder);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (value);
				_g_free0 (key);
				_g_string_free0 (builder);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp44_ = builder;
		_tmp45_ = _tmp44_->str;
		_tmp46_ = g_strdup (_tmp45_);
		_g_free0 (value);
		value = _tmp46_;
		_tmp47_ = self->priv->map;
		_tmp48_ = key;
		_tmp49_ = value;
		gee_map_set (_tmp47_, _tmp48_, _tmp49_);
	}
	_g_free0 (value);
	_g_free0 (key);
	_g_string_free0 (builder);
	return self;
}


PList* plist_new (const gchar* str, GError** error) {
	return plist_construct (TYPE_PLIST, str, error);
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


gchar* plist_escape (const gchar* str) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* builder;
	gint index;
	gunichar uc = 0U;
	GString* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	index = 0;
	while (TRUE) {
		const gchar* _tmp1_;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gunichar _tmp6_;
		gboolean _tmp8_;
		gboolean _tmp10_;
		GString* _tmp12_;
		gunichar _tmp13_;
		_tmp1_ = str;
		_tmp3_ = string_get_next_char (_tmp1_, &index, &_tmp2_);
		uc = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp6_ = uc;
		if (_tmp6_ == ((gunichar) ',')) {
			_tmp5_ = TRUE;
		} else {
			gunichar _tmp7_;
			_tmp7_ = uc;
			_tmp5_ = _tmp7_ == ((gunichar) '\\');
		}
		_tmp8_ = _tmp5_;
		if (_tmp8_) {
			_tmp4_ = TRUE;
		} else {
			gunichar _tmp9_;
			_tmp9_ = uc;
			_tmp4_ = _tmp9_ == ((gunichar) '=');
		}
		_tmp10_ = _tmp4_;
		if (_tmp10_) {
			GString* _tmp11_;
			_tmp11_ = builder;
			g_string_append (_tmp11_, "\\");
		}
		_tmp12_ = builder;
		_tmp13_ = uc;
		g_string_append_unichar (_tmp12_, _tmp13_);
	}
	_tmp14_ = builder;
	_tmp15_ = _tmp14_->str;
	_tmp16_ = g_strdup (_tmp15_);
	result = _tmp16_;
	_g_string_free0 (builder);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* plist_to_string (PList* self) {
	gchar* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* props;
	GeeArrayList* _tmp1_;
	GeeArrayList* keys;
	GeeArrayList* _tmp2_;
	GeeMap* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp31_;
	GeeArrayList* _tmp32_;
	gint _tmp33_ = 0;
	gpointer* _tmp34_ = NULL;
	gchar** _tmp35_;
	gint _tmp35__length1;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	props = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	keys = _tmp1_;
	_tmp2_ = keys;
	_tmp3_ = self->priv->map;
	_tmp4_ = gee_map_get_keys (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp2_, (GeeCollection*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = keys;
	gee_list_sort ((GeeList*) _tmp7_, NULL);
	{
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		GeeArrayList* _key_list;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _key_size;
		gint _key_index;
		_tmp8_ = keys;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_key_list = _tmp9_;
		_tmp10_ = _key_list;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_key_size = _tmp12_;
		_key_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			GeeArrayList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_ = NULL;
			gchar* key;
			GeeMap* _tmp19_;
			const gchar* _tmp20_;
			gpointer _tmp21_ = NULL;
			gchar* value;
			GeeArrayList* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			_tmp13_ = _key_index;
			_key_index = _tmp13_ + 1;
			_tmp14_ = _key_index;
			_tmp15_ = _key_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _key_list;
			_tmp17_ = _key_index;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
			key = (gchar*) _tmp18_;
			_tmp19_ = self->priv->map;
			_tmp20_ = key;
			_tmp21_ = gee_map_get (_tmp19_, _tmp20_);
			value = (gchar*) _tmp21_;
			_tmp22_ = props;
			_tmp23_ = key;
			_tmp24_ = plist_escape (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = value;
			_tmp27_ = plist_escape (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strdup_printf ("%s=%s", _tmp25_, _tmp28_);
			_tmp30_ = _tmp29_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp30_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp25_);
			_g_free0 (value);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_list);
	}
	_tmp31_ = props;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, NULL);
	_tmp32_ = props;
	_tmp34_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp32_, &_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp35__length1 = _tmp33_;
	_tmp36_ = g_strjoinv (",", _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp37_;
	_g_object_unref0 (keys);
	_g_object_unref0 (props);
	return result;
}


static void plist_class_init (PListClass * klass) {
	plist_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PListPrivate));
	G_OBJECT_CLASS (klass)->finalize = plist_finalize;
}


static void plist_instance_init (PList * self) {
	GeeHashMap* _tmp0_;
	self->priv = PLIST_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	self->priv->map = (GeeMap*) _tmp0_;
}


static void plist_finalize (GObject* obj) {
	PList * self;
	self = PLIST (obj);
	_g_object_unref0 (self->priv->map);
	G_OBJECT_CLASS (plist_parent_class)->finalize (obj);
}


GType plist_get_type (void) {
	static volatile gsize plist_type_id__volatile = 0;
	if (g_once_init_enter (&plist_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PList), 0, (GInstanceInitFunc) plist_instance_init, NULL };
		GType plist_type_id;
		plist_type_id = g_type_register_static (G_TYPE_OBJECT, "PList", &g_define_type_info, 0);
		g_once_init_leave (&plist_type_id__volatile, plist_type_id);
	}
	return plist_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



