#define PULSESHAPER_GAIN        32767.000000f
#define PULSESHAPER_COEFF_SETS  192
static const complexi16_t pulseshaper[PULSESHAPER_COEFF_SETS][27] =
{
    {
        {       0,        0},     /* Filter 0 */
        {      11,      -36},
        {    -108,      -17},
        {       0,     -122},
        {     -79,       12},
        {     -50,     -156},
        {    -127,       65},
        {    -238,     -328},
        {    -102,      102},
        {   -1044,     -758},
        {     588,    -1155},
        {   -1452,     -472},
        {    1024,    -6467},
        {   10585,        0},
        {    1655,    10455},
        {   -6227,     2023},
        {    -693,    -1360},
        {   -1049,      762},
        {    -912,     -912},
        {      85,     -117},
        {    -361,     -184},
        {      44,     -136},
        {    -162,      -25},
        {       0,      -80},
        {    -121,       19},
        {     -34,     -104},
        {     -33,       17}
    },
    {
        {       0,        0},     /* Filter 1 */
        {      11,      -35},
        {    -109,      -17},
        {       0,     -122},
        {     -80,       12},
        {     -50,     -155},
        {    -129,       66},
        {    -238,     -328},
        {    -106,      106},
        {   -1048,     -761},
        {     585,    -1149},
        {   -1473,     -478},
        {    1028,    -6493},
        {   10597,        0},
        {    1654,    10443},
        {   -6201,     2015},
        {    -683,    -1341},
        {   -1054,      766},
        {    -909,     -909},
        {      82,     -113},
        {    -362,     -184},
        {      43,     -134},
        {    -162,      -25},
        {       0,      -79},
        {    -121,       19},
        {     -33,     -104},
        {     -34,       17}
    },
    {
        {       0,        0},     /* Filter 2 */
        {      11,      -34},
        {    -110,      -17},
        {       0,     -121},
        {     -82,       13},
        {     -50,     -154},
        {    -131,       67},
        {    -238,     -328},
        {    -110,      110},
        {   -1051,     -764},
        {     582,    -1143},
        {   -1495,     -485},
        {    1032,    -6520},
        {   10609,        0},
        {    1652,    10431},
        {   -6176,     2006},
        {    -673,    -1321},
        {   -1059,      770},
        {    -905,     -905},
        {      79,     -108},
        {    -362,     -184},
        {      43,     -132},
        {    -163,      -25},
        {       0,      -78},
        {    -122,       19},
        {     -33,     -103},
        {     -34,       17}
    },
    {
        {       0,        0},     /* Filter 3 */
        {      11,      -34},
        {    -110,      -17},
        {       0,     -120},
        {     -83,       13},
        {     -50,     -154},
        {    -133,       68},
        {    -238,     -327},
        {    -114,      114},
        {   -1055,     -767},
        {     579,    -1137},
        {   -1516,     -492},
        {    1036,    -6546},
        {   10621,        0},
        {    1650,    10418},
        {   -6150,     1998},
        {    -663,    -1301},
        {   -1065,      773},
        {    -901,     -901},
        {      76,     -104},
        {    -362,     -184},
        {      42,     -130},
        {    -163,      -25},
        {       0,      -77},
        {    -122,       19},
        {     -33,     -102},
        {     -35,       18}
    },
    {
        {       0,        0},     /* Filter 4 */
        {      10,      -33},
        {    -111,      -17},
        {       0,     -120},
        {     -84,       13},
        {     -49,     -153},
        {    -135,       69},
        {    -238,     -327},
        {    -118,      118},
        {   -1059,     -769},
        {     576,    -1131},
        {   -1538,     -499},
        {    1041,    -6573},
        {   10633,        0},
        {    1648,    10406},
        {   -6124,     1990},
        {    -653,    -1281},
        {   -1070,      777},
        {    -898,     -898},
        {      72,     -100},
        {    -362,     -184},
        {      41,     -128},
        {    -164,      -26},
        {       0,      -76},
        {    -123,       19},
        {     -33,     -102},
        {     -36,       18}
    },
    {
        {       0,        0},     /* Filter 5 */
        {      10,      -33},
        {    -111,      -17},
        {       0,     -119},
        {     -85,       13},
        {     -49,     -153},
        {    -137,       70},
        {    -237,     -327},
        {    -121,      121},
        {   -1063,     -772},
        {     573,    -1125},
        {   -1559,     -506},
        {    1045,    -6599},
        {   10645,        0},
        {    1646,    10393},
        {   -6099,     1981},
        {    -643,    -1262},
        {   -1075,      781},
        {    -894,     -894},
        {      69,      -96},
        {    -362,     -184},
        {      40,     -126},
        {    -164,      -26},
        {       0,      -75},
        {    -124,       19},
        {     -33,     -101},
        {     -36,       18}
    },
    {
        {       0,        0},     /* Filter 6 */
        {      10,      -32},
        {    -112,      -17},
        {       0,     -118},
        {     -86,       13},
        {     -49,     -152},
        {    -139,       71},
        {    -237,     -326},
        {    -125,      125},
        {   -1067,     -775},
        {     570,    -1119},
        {   -1581,     -513},
        {    1049,    -6626},
        {   10656,        0},
        {    1644,    10381},
        {   -6073,     1973},
        {    -633,    -1242},
        {   -1080,      784},
        {    -891,     -891},
        {      66,      -91},
        {    -363,     -184},
        {      40,     -124},
        {    -165,      -26},
        {       0,      -73},
        {    -124,       19},
        {     -32,     -100},
        {     -37,       18}
    },
    {
        {       0,        0},     /* Filter 7 */
        {      10,      -31},
        {    -113,      -17},
        {       0,     -118},
        {     -87,       13},
        {     -49,     -151},
        {    -141,       72},
        {    -237,     -326},
        {    -129,      129},
        {   -1071,     -778},
        {     567,    -1113},
        {   -1602,     -520},
        {    1053,    -6652},
        {   10668,        0},
        {    1642,    10368},
        {   -6047,     1964},
        {    -623,    -1223},
        {   -1084,      788},
        {    -887,     -887},
        {      63,      -87},
        {    -363,     -185},
        {      39,     -121},
        {    -165,      -26},
        {       0,      -72},
        {    -125,       19},
        {     -32,     -100},
        {     -37,       19}
    },
    {
        {       0,        0},     /* Filter 8 */
        {      10,      -31},
        {    -113,      -18},
        {       0,     -117},
        {     -88,       14},
        {     -49,     -151},
        {    -143,       73},
        {    -237,     -326},
        {    -133,      133},
        {   -1075,     -781},
        {     563,    -1106},
        {   -1624,     -527},
        {    1057,    -6679},
        {   10679,        0},
        {    1640,    10355},
        {   -6021,     1956},
        {    -613,    -1203},
        {   -1089,      791},
        {    -884,     -884},
        {      60,      -83},
        {    -363,     -185},
        {      38,     -119},
        {    -166,      -26},
        {       0,      -71},
        {    -125,       19},
        {     -32,      -99},
        {     -38,       19}
    },
    {
        {       0,        0},     /* Filter 9 */
        {       9,      -30},
        {    -114,      -18},
        {       0,     -116},
        {     -89,       14},
        {     -48,     -150},
        {    -145,       74},
        {    -236,     -325},
        {    -137,      137},
        {   -1078,     -783},
        {     560,    -1100},
        {   -1646,     -534},
        {    1062,    -6705},
        {   10690,        0},
        {    1638,    10342},
        {   -5995,     1948},
        {    -603,    -1184},
        {   -1094,      795},
        {    -880,     -880},
        {      57,      -79},
        {    -363,     -185},
        {      38,     -117},
        {    -166,      -26},
        {       0,      -70},
        {    -126,       20},
        {     -32,      -99},
        {     -38,       19}
    },
    {
        {       0,        0},     /* Filter 10 */
        {       9,      -29},
        {    -115,      -18},
        {       0,     -116},
        {     -91,       14},
        {     -48,     -149},
        {    -147,       75},
        {    -236,     -325},
        {    -141,      141},
        {   -1082,     -786},
        {     557,    -1093},
        {   -1668,     -542},
        {    1066,    -6731},
        {   10701,        0},
        {    1636,    10329},
        {   -5970,     1939},
        {    -593,    -1164},
        {   -1099,      798},
        {    -876,     -876},
        {      54,      -75},
        {    -363,     -185},
        {      37,     -115},
        {    -167,      -26},
        {       0,      -69},
        {    -126,       20},
        {     -31,      -98},
        {     -39,       20}
    },
    {
        {       0,        0},     /* Filter 11 */
        {       9,      -29},
        {    -115,      -18},
        {       0,     -115},
        {     -92,       14},
        {     -48,     -149},
        {    -149,       76},
        {    -236,     -324},
        {    -145,      145},
        {   -1086,     -789},
        {     553,    -1086},
        {   -1690,     -549},
        {    1070,    -6758},
        {   10712,        0},
        {    1633,    10316},
        {   -5944,     1931},
        {    -583,    -1145},
        {   -1103,      801},
        {    -872,     -872},
        {      51,      -71},
        {    -363,     -185},
        {      36,     -113},
        {    -167,      -26},
        {       0,      -67},
        {    -127,       20},
        {     -31,      -97},
        {     -39,       20}
    },
    {
        {       0,        0},     /* Filter 12 */
        {       9,      -28},
        {    -116,      -18},
        {       0,     -114},
        {     -93,       14},
        {     -48,     -148},
        {    -151,       77},
        {    -235,     -324},
        {    -149,      149},
        {   -1089,     -791},
        {     550,    -1080},
        {   -1712,     -556},
        {    1074,    -6784},
        {   10723,        0},
        {    1631,    10302},
        {   -5918,     1923},
        {    -573,    -1126},
        {   -1108,      805},
        {    -869,     -869},
        {      48,      -66},
        {    -363,     -185},
        {      36,     -111},
        {    -168,      -26},
        {       0,      -66},
        {    -128,       20},
        {     -31,      -97},
        {     -40,       20}
    },
    {
        {       0,        0},     /* Filter 13 */
        {       9,      -28},
        {    -116,      -18},
        {       0,     -113},
        {     -94,       14},
        {     -48,     -147},
        {    -153,       78},
        {    -235,     -324},
        {    -153,      153},
        {   -1093,     -794},
        {     546,    -1073},
        {   -1734,     -563},
        {    1078,    -6810},
        {   10733,        0},
        {    1629,    10289},
        {   -5892,     1914},
        {    -564,    -1107},
        {   -1112,      808},
        {    -865,     -865},
        {      45,      -62},
        {    -363,     -185},
        {      35,     -109},
        {    -168,      -26},
        {       0,      -65},
        {    -128,       20},
        {     -31,      -96},
        {     -40,       20}
    },
    {
        {       0,        0},     /* Filter 14 */
        {       8,      -27},
        {    -117,      -18},
        {       0,     -113},
        {     -95,       15},
        {     -47,     -147},
        {    -155,       79},
        {    -235,     -323},
        {    -157,      157},
        {   -1097,     -797},
        {     543,    -1066},
        {   -1756,     -570},
        {    1082,    -6836},
        {   10744,        0},
        {    1627,    10275},
        {   -5866,     1906},
        {    -554,    -1088},
        {   -1117,      811},
        {    -861,     -861},
        {      42,      -58},
        {    -363,     -185},
        {      34,     -107},
        {    -169,      -26},
        {       0,      -64},
        {    -129,       20},
        {     -31,      -95},
        {     -41,       21}
    },
    {
        {       0,        0},     /* Filter 15 */
        {       8,      -26},
        {    -117,      -18},
        {       0,     -112},
        {     -96,       15},
        {     -47,     -146},
        {    -157,       80},
        {    -234,     -323},
        {    -161,      161},
        {   -1100,     -799},
        {     539,    -1059},
        {   -1778,     -577},
        {    1086,    -6862},
        {   10755,        0},
        {    1625,    10262},
        {   -5840,     1897},
        {    -544,    -1069},
        {   -1121,      814},
        {    -858,     -858},
        {      39,      -54},
        {    -363,     -185},
        {      34,     -105},
        {    -169,      -26},
        {       0,      -63},
        {    -129,       20},
        {     -30,      -95},
        {     -41,       21}
    },
    {
        {       0,        0},     /* Filter 16 */
        {       8,      -26},
        {    -118,      -18},
        {       0,     -111},
        {     -97,       15},
        {     -47,     -145},
        {    -159,       81},
        {    -234,     -322},
        {    -165,      165},
        {   -1104,     -802},
        {     536,    -1052},
        {   -1800,     -585},
        {    1091,    -6889},
        {   10765,        0},
        {    1623,    10248},
        {   -5814,     1889},
        {    -535,    -1050},
        {   -1125,      818},
        {    -854,     -854},
        {      36,      -50},
        {    -363,     -184},
        {      33,     -103},
        {    -170,      -26},
        {       0,      -62},
        {    -130,       20},
        {     -30,      -94},
        {     -42,       21}
    },
    {
        {       0,        0},     /* Filter 17 */
        {       8,      -25},
        {    -119,      -18},
        {       0,     -111},
        {     -98,       15},
        {     -47,     -144},
        {    -161,       82},
        {    -233,     -321},
        {    -169,      169},
        {   -1107,     -804},
        {     532,    -1045},
        {   -1822,     -592},
        {    1095,    -6915},
        {   10775,        0},
        {    1620,    10234},
        {   -5788,     1880},
        {    -525,    -1031},
        {   -1130,      821},
        {    -850,     -850},
        {      33,      -46},
        {    -362,     -184},
        {      32,     -101},
        {    -170,      -26},
        {       0,      -60},
        {    -130,       20},
        {     -30,      -93},
        {     -42,       21}
    },
    {
        {       0,        0},     /* Filter 18 */
        {       8,      -24},
        {    -119,      -18},
        {       0,     -110},
        {     -99,       15},
        {     -46,     -143},
        {    -163,       83},
        {    -233,     -321},
        {    -173,      173},
        {   -1111,     -807},
        {     529,    -1038},
        {   -1845,     -599},
        {    1099,    -6941},
        {   10785,        0},
        {    1618,    10220},
        {   -5762,     1872},
        {    -515,    -1012},
        {   -1134,      824},
        {    -846,     -846},
        {      30,      -42},
        {    -362,     -184},
        {      32,      -99},
        {    -170,      -27},
        {       0,      -59},
        {    -131,       20},
        {     -30,      -93},
        {     -43,       22}
    },
    {
        {       0,        0},     /* Filter 19 */
        {       7,      -24},
        {    -120,      -19},
        {       0,     -109},
        {    -100,       15},
        {     -46,     -143},
        {    -165,       84},
        {    -233,     -320},
        {    -177,      177},
        {   -1114,     -810},
        {     525,    -1031},
        {   -1867,     -606},
        {    1103,    -6967},
        {   10795,        0},
        {    1616,    10206},
        {   -5736,     1864},
        {    -506,     -993},
        {   -1138,      827},
        {    -842,     -842},
        {      27,      -38},
        {    -362,     -184},
        {      31,      -96},
        {    -171,      -27},
        {       0,      -58},
        {    -131,       20},
        {     -30,      -92},
        {     -43,       22}
    },
    {
        {       0,        0},     /* Filter 20 */
        {       7,      -23},
        {    -120,      -19},
        {       0,     -108},
        {    -101,       16},
        {     -46,     -142},
        {    -166,       85},
        {    -232,     -320},
        {    -181,      181},
        {   -1118,     -812},
        {     521,    -1023},
        {   -1889,     -614},
        {    1107,    -6993},
        {   10805,        0},
        {    1614,    10192},
        {   -5710,     1855},
        {    -496,     -975},
        {   -1142,      830},
        {    -838,     -838},
        {      25,      -34},
        {    -362,     -184},
        {      30,      -94},
        {    -171,      -27},
        {       0,      -57},
        {    -132,       20},
        {     -29,      -91},
        {     -44,       22}
    },
    {
        {       0,        0},     /* Filter 21 */
        {       7,      -22},
        {    -121,      -19},
        {       0,     -108},
        {    -102,       16},
        {     -46,     -141},
        {    -168,       86},
        {    -232,     -319},
        {    -185,      185},
        {   -1121,     -815},
        {     517,    -1016},
        {   -1912,     -621},
        {    1111,    -7019},
        {   10815,        0},
        {    1611,    10177},
        {   -5684,     1847},
        {    -487,     -956},
        {   -1146,      832},
        {    -835,     -835},
        {      22,      -30},
        {    -362,     -184},
        {      30,      -92},
        {    -171,      -27},
        {       0,      -55},
        {    -132,       20},
        {     -29,      -90},
        {     -44,       22}
    },
    {
        {       0,        0},     /* Filter 22 */
        {       7,      -22},
        {    -121,      -19},
        {       0,     -107},
        {    -104,       16},
        {     -45,     -140},
        {    -170,       87},
        {    -231,     -318},
        {    -189,      189},
        {   -1125,     -817},
        {     514,    -1009},
        {   -1934,     -628},
        {    1115,    -7044},
        {   10824,        0},
        {    1609,    10163},
        {   -5658,     1838},
        {    -477,     -937},
        {   -1150,      835},
        {    -831,     -831},
        {      19,      -26},
        {    -362,     -184},
        {      29,      -90},
        {    -172,      -27},
        {       0,      -54},
        {    -132,       21},
        {     -29,      -90},
        {     -45,       23}
    },
    {
        {       0,        0},     /* Filter 23 */
        {       6,      -21},
        {    -122,      -19},
        {       0,     -106},
        {    -105,       16},
        {     -45,     -139},
        {    -172,       88},
        {    -231,     -318},
        {    -193,      193},
        {   -1128,     -819},
        {     510,    -1001},
        {   -1957,     -635},
        {    1119,    -7070},
        {   10834,        0},
        {    1607,    10148},
        {   -5632,     1830},
        {    -468,     -919},
        {   -1154,      838},
        {    -827,     -827},
        {      16,      -22},
        {    -361,     -184},
        {      28,      -88},
        {    -172,      -27},
        {       0,      -53},
        {    -133,       21},
        {     -29,      -89},
        {     -45,       23}
    },
    {
        {       0,        0},     /* Filter 24 */
        {       6,      -20},
        {    -122,      -19},
        {       0,     -105},
        {    -106,       16},
        {     -45,     -139},
        {    -174,       88},
        {    -230,     -317},
        {    -197,      197},
        {   -1131,     -822},
        {     506,     -993},
        {   -1980,     -643},
        {    1123,    -7096},
        {   10843,        0},
        {    1605,    10133},
        {   -5606,     1821},
        {    -459,     -900},
        {   -1157,      841},
        {    -823,     -823},
        {      13,      -18},
        {    -361,     -184},
        {      28,      -86},
        {    -172,      -27},
        {       0,      -52},
        {    -133,       21},
        {     -28,      -88},
        {     -46,       23}
    },
    {
        {       0,        0},     /* Filter 25 */
        {       6,      -20},
        {    -123,      -19},
        {       0,     -104},
        {    -107,       16},
        {     -44,     -138},
        {    -176,       89},
        {    -230,     -316},
        {    -201,      201},
        {   -1135,     -824},
        {     502,     -986},
        {   -2002,     -650},
        {    1128,    -7122},
        {   10852,        0},
        {    1602,    10119},
        {   -5580,     1813},
        {    -449,     -882},
        {   -1161,      843},
        {    -819,     -819},
        {      10,      -14},
        {    -361,     -184},
        {      27,      -84},
        {    -173,      -27},
        {       0,      -51},
        {    -134,       21},
        {     -28,      -88},
        {     -46,       23}
    },
    {
        {       0,        0},     /* Filter 26 */
        {       6,      -19},
        {    -124,      -19},
        {       0,     -104},
        {    -108,       17},
        {     -44,     -137},
        {    -178,       90},
        {    -229,     -315},
        {    -205,      205},
        {   -1138,     -827},
        {     498,     -978},
        {   -2025,     -658},
        {    1132,    -7148},
        {   10861,        0},
        {    1600,    10104},
        {   -5554,     1804},
        {    -440,     -864},
        {   -1165,      846},
        {    -815,     -815},
        {       7,      -10},
        {    -361,     -183},
        {      26,      -82},
        {    -173,      -27},
        {       0,      -49},
        {    -134,       21},
        {     -28,      -87},
        {     -47,       24}
    },
    {
        {       0,        0},     /* Filter 27 */
        {       6,      -18},
        {    -124,      -19},
        {       0,     -103},
        {    -109,       17},
        {     -44,     -136},
        {    -180,       91},
        {    -229,     -315},
        {    -209,      209},
        {   -1141,     -829},
        {     494,     -970},
        {   -2048,     -665},
        {    1136,    -7173},
        {   10870,        0},
        {    1597,    10089},
        {   -5528,     1796},
        {    -431,     -846},
        {   -1168,      849},
        {    -811,     -811},
        {       5,       -7},
        {    -360,     -183},
        {      26,      -80},
        {    -173,      -27},
        {       0,      -48},
        {    -135,       21},
        {     -28,      -86},
        {     -47,       24}
    },
    {
        {       0,        0},     /* Filter 28 */
        {       5,      -17},
        {    -125,      -19},
        {       0,     -102},
        {    -110,       17},
        {     -44,     -135},
        {    -182,       92},
        {    -228,     -314},
        {    -213,      213},
        {   -1144,     -831},
        {     490,     -962},
        {   -2071,     -672},
        {    1140,    -7199},
        {   10879,        0},
        {    1595,    10074},
        {   -5502,     1787},
        {    -421,     -827},
        {   -1172,      851},
        {    -807,     -807},
        {       2,       -3},
        {    -360,     -183},
        {      25,      -78},
        {    -173,      -27},
        {       0,      -47},
        {    -135,       21},
        {     -27,      -86},
        {     -48,       24}
    },
    {
        {       0,        0},     /* Filter 29 */
        {       5,      -17},
        {    -125,      -19},
        {       0,     -101},
        {    -111,       17},
        {     -43,     -134},
        {    -184,       93},
        {    -227,     -313},
        {    -218,      218},
        {   -1148,     -834},
        {     486,     -954},
        {   -2094,     -680},
        {    1144,    -7225},
        {   10888,        0},
        {    1593,    10059},
        {   -5476,     1779},
        {    -412,     -809},
        {   -1175,      854},
        {    -803,     -803},
        {       0,        0},
        {    -360,     -183},
        {      24,      -76},
        {    -174,      -27},
        {       0,      -46},
        {    -135,       21},
        {     -27,      -85},
        {     -48,       24}
    },
    {
        {       0,        0},     /* Filter 30 */
        {       5,      -16},
        {    -126,      -19},
        {       0,     -100},
        {    -112,       17},
        {     -43,     -133},
        {    -186,       94},
        {    -227,     -312},
        {    -222,      222},
        {   -1151,     -836},
        {     482,     -946},
        {   -2117,     -687},
        {    1148,    -7250},
        {   10896,        0},
        {    1590,    10043},
        {   -5450,     1770},
        {    -403,     -791},
        {   -1179,      856},
        {    -799,     -799},
        {      -3,        4},
        {    -359,     -183},
        {      24,      -74},
        {    -174,      -27},
        {       0,      -45},
        {    -136,       21},
        {     -27,      -84},
        {     -49,       25}
    },
    {
        {       0,        0},     /* Filter 31 */
        {       5,      -15},
        {    -126,      -20},
        {       0,     -100},
        {    -113,       17},
        {     -43,     -132},
        {    -188,       95},
        {    -226,     -311},
        {    -226,      226},
        {   -1154,     -838},
        {     478,     -938},
        {   -2140,     -695},
        {    1152,    -7276},
        {   10905,        0},
        {    1588,    10028},
        {   -5423,     1762},
        {    -394,     -773},
        {   -1182,      859},
        {    -795,     -795},
        {      -5,        8},
        {    -359,     -183},
        {      23,      -72},
        {    -174,      -27},
        {       0,      -43},
        {    -136,       21},
        {     -27,      -83},
        {     -49,       25}
    },
    {
        {       0,        0},     /* Filter 32 */
        {       4,      -15},
        {    -127,      -20},
        {       0,      -99},
        {    -114,       18},
        {     -42,     -131},
        {    -189,       96},
        {    -225,     -311},
        {    -230,      230},
        {   -1157,     -840},
        {     473,     -930},
        {   -2163,     -702},
        {    1156,    -7301},
        {   10913,        0},
        {    1585,    10012},
        {   -5397,     1753},
        {    -385,     -755},
        {   -1185,      861},
        {    -791,     -791},
        {      -8,       11},
        {    -358,     -182},
        {      22,      -70},
        {    -174,      -27},
        {       0,      -42},
        {    -137,       21},
        {     -27,      -83},
        {     -50,       25}
    },
    {
        {       0,        0},     /* Filter 33 */
        {       4,      -14},
        {    -127,      -20},
        {       0,      -98},
        {    -115,       18},
        {     -42,     -130},
        {    -191,       97},
        {    -225,     -310},
        {    -234,      234},
        {   -1160,     -843},
        {     469,     -921},
        {   -2186,     -710},
        {    1160,    -7327},
        {   10922,        0},
        {    1583,     9997},
        {   -5371,     1745},
        {    -376,     -737},
        {   -1188,      863},
        {    -787,     -787},
        {     -11,       15},
        {    -358,     -182},
        {      22,      -68},
        {    -174,      -27},
        {       0,      -41},
        {    -137,       21},
        {     -26,      -82},
        {     -50,       25}
    },
    {
        {       0,        0},     /* Filter 34 */
        {       4,      -13},
        {    -128,      -20},
        {       0,      -97},
        {    -116,       18},
        {     -42,     -129},
        {    -193,       98},
        {    -224,     -309},
        {    -238,      238},
        {   -1163,     -845},
        {     465,     -913},
        {   -2209,     -717},
        {    1164,    -7352},
        {   10930,        0},
        {    1580,     9981},
        {   -5345,     1736},
        {    -366,     -720},
        {   -1192,      866},
        {    -783,     -783},
        {     -14,       19},
        {    -358,     -182},
        {      21,      -66},
        {    -175,      -27},
        {       0,      -40},
        {    -137,       21},
        {     -26,      -81},
        {     -51,       25}
    },
    {
        {       0,        0},     /* Filter 35 */
        {       4,      -13},
        {    -128,      -20},
        {       0,      -96},
        {    -117,       18},
        {     -41,     -128},
        {    -195,       99},
        {    -223,     -308},
        {    -243,      243},
        {   -1166,     -847},
        {     461,     -905},
        {   -2232,     -725},
        {    1168,    -7377},
        {   10938,        0},
        {    1578,     9965},
        {   -5319,     1728},
        {    -357,     -702},
        {   -1195,      868},
        {    -779,     -779},
        {     -16,       22},
        {    -357,     -182},
        {      20,      -64},
        {    -175,      -27},
        {       0,      -38},
        {    -138,       21},
        {     -26,      -80},
        {     -51,       26}
    },
    {
        {       0,        0},     /* Filter 36 */
        {       4,      -12},
        {    -129,      -20},
        {       0,      -95},
        {    -118,       18},
        {     -41,     -127},
        {    -197,      100},
        {    -223,     -307},
        {    -247,      247},
        {   -1169,     -849},
        {     456,     -896},
        {   -2255,     -732},
        {    1172,    -7403},
        {   10945,        0},
        {    1575,     9949},
        {   -5293,     1719},
        {    -348,     -684},
        {   -1198,      870},
        {    -774,     -774},
        {     -19,       26},
        {    -357,     -181},
        {      20,      -62},
        {    -175,      -27},
        {       0,      -37},
        {    -138,       21},
        {     -26,      -80},
        {     -51,       26}
    },
    {
        {       0,        0},     /* Filter 37 */
        {       3,      -11},
        {    -129,      -20},
        {       0,      -94},
        {    -119,       18},
        {     -41,     -126},
        {    -199,      101},
        {    -222,     -306},
        {    -251,      251},
        {   -1172,     -851},
        {     452,     -887},
        {   -2279,     -740},
        {    1176,    -7428},
        {   10953,        0},
        {    1573,     9933},
        {   -5266,     1711},
        {    -339,     -667},
        {   -1201,      872},
        {    -770,     -770},
        {     -22,       30},
        {    -356,     -181},
        {      19,      -60},
        {    -175,      -27},
        {       0,      -36},
        {    -138,       22},
        {     -25,      -79},
        {     -52,       26}
    },
    {
        {       0,        0},     /* Filter 38 */
        {       3,      -10},
        {    -129,      -20},
        {       0,      -94},
        {    -120,       19},
        {     -40,     -125},
        {    -201,      102},
        {    -221,     -305},
        {    -255,      255},
        {   -1175,     -853},
        {     447,     -879},
        {   -2302,     -748},
        {    1180,    -7453},
        {   10961,        0},
        {    1570,     9917},
        {   -5240,     1702},
        {    -331,     -649},
        {   -1204,      874},
        {    -766,     -766},
        {     -24,       33},
        {    -356,     -181},
        {      18,      -58},
        {    -175,      -27},
        {       0,      -35},
        {    -139,       22},
        {     -25,      -78},
        {     -52,       26}
    },
    {
        {       0,        0},     /* Filter 39 */
        {       3,      -10},
        {    -130,      -20},
        {       0,      -93},
        {    -121,       19},
        {     -40,     -124},
        {    -203,      103},
        {    -221,     -304},
        {    -260,      260},
        {   -1177,     -855},
        {     443,     -870},
        {   -2326,     -755},
        {    1184,    -7478},
        {   10968,        0},
        {    1568,     9901},
        {   -5214,     1694},
        {    -322,     -632},
        {   -1206,      876},
        {    -762,     -762},
        {     -27,       37},
        {    -355,     -181},
        {      18,      -56},
        {    -175,      -27},
        {       0,      -34},
        {    -139,       22},
        {     -25,      -78},
        {     -53,       27}
    },
    {
        {       0,        0},     /* Filter 40 */
        {       3,       -9},
        {    -130,      -20},
        {       0,      -92},
        {    -122,       19},
        {     -40,     -123},
        {    -205,      104},
        {    -220,     -303},
        {    -264,      264},
        {   -1180,     -857},
        {     439,     -861},
        {   -2349,     -763},
        {    1188,    -7503},
        {   10976,        0},
        {    1565,     9884},
        {   -5188,     1685},
        {    -313,     -614},
        {   -1209,      878},
        {    -758,     -758},
        {     -29,       41},
        {    -355,     -180},
        {      17,      -54},
        {    -175,      -27},
        {       0,      -32},
        {    -139,       22},
        {     -25,      -77},
        {     -53,       27}
    },
    {
        {       0,        0},     /* Filter 41 */
        {       2,       -8},
        {    -131,      -20},
        {       0,      -91},
        {    -123,       19},
        {     -39,     -122},
        {    -206,      105},
        {    -219,     -302},
        {    -268,      268},
        {   -1183,     -859},
        {     434,     -852},
        {   -2373,     -771},
        {    1192,    -7528},
        {   10983,        0},
        {    1562,     9868},
        {   -5162,     1677},
        {    -304,     -597},
        {   -1212,      880},
        {    -754,     -754},
        {     -32,       44},
        {    -354,     -180},
        {      16,      -52},
        {    -175,      -27},
        {       0,      -31},
        {    -140,       22},
        {     -24,      -76},
        {     -54,       27}
    },
    {
        {       0,        0},     /* Filter 42 */
        {       2,       -8},
        {    -131,      -20},
        {       0,      -90},
        {    -123,       19},
        {     -39,     -121},
        {    -208,      106},
        {    -218,     -301},
        {    -272,      272},
        {   -1186,     -861},
        {     429,     -843},
        {   -2396,     -778},
        {    1196,    -7553},
        {   10990,        0},
        {    1560,     9851},
        {   -5136,     1668},
        {    -295,     -580},
        {   -1215,      882},
        {    -750,     -750},
        {     -35,       48},
        {    -353,     -180},
        {      16,      -50},
        {    -176,      -27},
        {       0,      -30},
        {    -140,       22},
        {     -24,      -75},
        {     -54,       27}
    },
    {
        {       0,        0},     /* Filter 43 */
        {       2,       -7},
        {    -132,      -20},
        {       0,      -89},
        {    -124,       19},
        {     -39,     -120},
        {    -210,      107},
        {    -217,     -299},
        {    -277,      277},
        {   -1188,     -863},
        {     425,     -834},
        {   -2420,     -786},
        {    1200,    -7578},
        {   10997,        0},
        {    1557,     9835},
        {   -5109,     1660},
        {    -287,     -563},
        {   -1217,      884},
        {    -745,     -745},
        {     -37,       51},
        {    -353,     -180},
        {      15,      -48},
        {    -176,      -27},
        {       0,      -29},
        {    -140,       22},
        {     -24,      -75},
        {     -54,       27}
    },
    {
        {       0,        0},     /* Filter 44 */
        {       2,       -6},
        {    -132,      -21},
        {       0,      -88},
        {    -125,       19},
        {     -38,     -119},
        {    -212,      108},
        {    -217,     -298},
        {    -281,      281},
        {   -1191,     -865},
        {     420,     -825},
        {   -2443,     -794},
        {    1204,    -7603},
        {   11004,        0},
        {    1555,     9818},
        {   -5083,     1651},
        {    -278,     -546},
        {   -1220,      886},
        {    -741,     -741},
        {     -40,       55},
        {    -352,     -179},
        {      14,      -46},
        {    -176,      -27},
        {       0,      -27},
        {    -141,       22},
        {     -24,      -74},
        {     -55,       28}
    },
    {
        {       0,        0},     /* Filter 45 */
        {       1,       -5},
        {    -133,      -21},
        {       0,      -87},
        {    -126,       20},
        {     -38,     -118},
        {    -214,      109},
        {    -216,     -297},
        {    -285,      285},
        {   -1194,     -867},
        {     415,     -816},
        {   -2467,     -801},
        {    1208,    -7628},
        {   11010,        0},
        {    1552,     9801},
        {   -5057,     1643},
        {    -269,     -529},
        {   -1222,      888},
        {    -737,     -737},
        {     -42,       58},
        {    -352,     -179},
        {      14,      -44},
        {    -176,      -27},
        {       0,      -26},
        {    -141,       22},
        {     -23,      -73},
        {     -55,       28}
    },
    {
        {       0,        0},     /* Filter 46 */
        {       1,       -5},
        {    -133,      -21},
        {       0,      -86},
        {    -127,       20},
        {     -38,     -117},
        {    -216,      110},
        {    -215,     -296},
        {    -289,      289},
        {   -1196,     -869},
        {     411,     -806},
        {   -2491,     -809},
        {    1212,    -7653},
        {   11017,        0},
        {    1549,     9784},
        {   -5031,     1634},
        {    -261,     -512},
        {   -1225,      890},
        {    -733,     -733},
        {     -45,       62},
        {    -351,     -179},
        {      13,      -42},
        {    -176,      -27},
        {       0,      -25},
        {    -141,       22},
        {     -23,      -72},
        {     -56,       28}
    },
    {
        {       0,        0},     /* Filter 47 */
        {       1,       -4},
        {    -133,      -21},
        {       0,      -85},
        {    -128,       20},
        {     -37,     -116},
        {    -217,      111},
        {    -214,     -295},
        {    -294,      294},
        {   -1199,     -871},
        {     406,     -797},
        {   -2515,     -817},
        {    1216,    -7678},
        {   11023,        0},
        {    1546,     9767},
        {   -5004,     1626},
        {    -252,     -495},
        {   -1227,      891},
        {    -729,     -729},
        {     -47,       65},
        {    -350,     -178},
        {      13,      -40},
        {    -176,      -27},
        {       0,      -24},
        {    -142,       22},
        {     -23,      -72},
        {     -56,       28}
    },
    {
        {       0,        0},     /* Filter 48 */
        {       1,       -3},
        {    -134,      -21},
        {       0,      -85},
        {    -129,       20},
        {     -37,     -115},
        {    -219,      111},
        {    -213,     -293},
        {    -298,      298},
        {   -1201,     -873},
        {     401,     -788},
        {   -2539,     -825},
        {    1220,    -7702},
        {   11030,        0},
        {    1544,     9750},
        {   -4978,     1617},
        {    -243,     -478},
        {   -1229,      893},
        {    -724,     -724},
        {     -50,       69},
        {    -349,     -178},
        {      12,      -38},
        {    -176,      -27},
        {       0,      -22},
        {    -142,       22},
        {     -23,      -71},
        {     -56,       28}
    },
    {
        {       0,        0},     /* Filter 49 */
        {       0,       -2},
        {    -134,      -21},
        {       0,      -84},
        {    -130,       20},
        {     -37,     -114},
        {    -221,      112},
        {    -212,     -292},
        {    -302,      302},
        {   -1204,     -874},
        {     396,     -778},
        {   -2563,     -832},
        {    1223,    -7727},
        {   11036,        0},
        {    1541,     9732},
        {   -4952,     1609},
        {    -235,     -461},
        {   -1231,      895},
        {    -720,     -720},
        {     -52,       72},
        {    -349,     -177},
        {      11,      -36},
        {    -176,      -27},
        {       0,      -21},
        {    -142,       22},
        {     -22,      -70},
        {     -57,       29}
    },
    {
        {       0,        0},     /* Filter 50 */
        {       0,       -2},
        {    -135,      -21},
        {       0,      -83},
        {    -131,       20},
        {     -36,     -112},
        {    -223,      113},
        {    -211,     -291},
        {    -307,      307},
        {   -1206,     -876},
        {     391,     -768},
        {   -2586,     -840},
        {    1227,    -7752},
        {   11042,        0},
        {    1538,     9715},
        {   -4926,     1600},
        {    -226,     -445},
        {   -1234,      896},
        {    -716,     -716},
        {     -55,       75},
        {    -348,     -177},
        {      11,      -34},
        {    -176,      -27},
        {       0,      -20},
        {    -142,       22},
        {     -22,      -69},
        {     -57,       29}
    },
    {
        {       0,        0},     /* Filter 51 */
        {       0,       -1},
        {    -135,      -21},
        {       0,      -82},
        {    -132,       20},
        {     -36,     -111},
        {    -225,      114},
        {    -210,     -290},
        {    -311,      311},
        {   -1208,     -878},
        {     386,     -759},
        {   -2610,     -848},
        {    1231,    -7776},
        {   11048,        0},
        {    1536,     9698},
        {   -4900,     1592},
        {    -218,     -428},
        {   -1236,      898},
        {    -711,     -711},
        {     -57,       79},
        {    -347,     -177},
        {      10,      -32},
        {    -176,      -27},
        {       0,      -19},
        {    -143,       22},
        {     -22,      -69},
        {     -57,       29}
    },
    {
        {       0,        0},     /* Filter 52 */
        {       0,        0},
        {    -135,      -21},
        {       0,      -81},
        {    -133,       21},
        {     -35,     -110},
        {    -226,      115},
        {    -209,     -288},
        {    -315,      315},
        {   -1211,     -880},
        {     381,     -749},
        {   -2635,     -856},
        {    1235,    -7801},
        {   11054,        0},
        {    1533,     9680},
        {   -4873,     1583},
        {    -209,     -412},
        {   -1238,      899},
        {    -707,     -707},
        {     -60,       82},
        {    -347,     -176},
        {       9,      -30},
        {    -176,      -27},
        {       0,      -18},
        {    -143,       22},
        {     -22,      -68},
        {     -58,       29}
    },
    {
        {       0,        0},     /* Filter 53 */
        {       0,        0},
        {    -136,      -21},
        {       0,      -80},
        {    -133,       21},
        {     -35,     -109},
        {    -228,      116},
        {    -208,     -287},
        {    -320,      320},
        {   -1213,     -881},
        {     376,     -739},
        {   -2659,     -863},
        {    1239,    -7825},
        {   11059,        0},
        {    1530,     9662},
        {   -4847,     1575},
        {    -201,     -395},
        {   -1240,      901},
        {    -703,     -703},
        {     -62,       85},
        {    -346,     -176},
        {       9,      -28},
        {    -176,      -27},
        {       0,      -16},
        {    -143,       22},
        {     -21,      -67},
        {     -58,       29}
    },
    {
        {       0,        0},     /* Filter 54 */
        {       0,        0},
        {    -136,      -21},
        {       0,      -79},
        {    -134,       21},
        {     -35,     -108},
        {    -230,      117},
        {    -207,     -286},
        {    -324,      324},
        {   -1215,     -883},
        {     371,     -729},
        {   -2683,     -871},
        {    1243,    -7850},
        {   11065,        0},
        {    1527,     9644},
        {   -4821,     1566},
        {    -193,     -379},
        {   -1242,      902},
        {    -699,     -699},
        {     -64,       89},
        {    -345,     -176},
        {       8,      -26},
        {    -176,      -27},
        {       0,      -15},
        {    -143,       22},
        {     -21,      -66},
        {     -59,       30}
    },
    {
        {       0,        0},     /* Filter 55 */
        {       0,        1},
        {    -136,      -21},
        {       0,      -78},
        {    -135,       21},
        {     -34,     -107},
        {    -232,      118},
        {    -206,     -284},
        {    -329,      329},
        {   -1218,     -885},
        {     366,     -719},
        {   -2707,     -879},
        {    1247,    -7874},
        {   11070,        0},
        {    1524,     9627},
        {   -4795,     1558},
        {    -184,     -362},
        {   -1243,      903},
        {    -694,     -694},
        {     -67,       92},
        {    -344,     -175},
        {       7,      -24},
        {    -176,      -27},
        {       0,      -14},
        {    -143,       22},
        {     -21,      -65},
        {     -59,       30}
    },
    {
        {       0,        0},     /* Filter 56 */
        {       0,        2},
        {    -137,      -21},
        {       0,      -77},
        {    -136,       21},
        {     -34,     -105},
        {    -234,      119},
        {    -205,     -283},
        {    -333,      333},
        {   -1220,     -886},
        {     361,     -709},
        {   -2731,     -887},
        {    1251,    -7898},
        {   11076,        0},
        {    1521,     9609},
        {   -4769,     1549},
        {    -176,     -346},
        {   -1245,      905},
        {    -690,     -690},
        {     -69,       95},
        {    -343,     -175},
        {       7,      -22},
        {    -175,      -27},
        {       0,      -13},
        {    -144,       22},
        {     -21,      -65},
        {     -59,       30}
    },
    {
        {       0,        0},     /* Filter 57 */
        {      -1,        3},
        {    -137,      -21},
        {       0,      -76},
        {    -137,       21},
        {     -33,     -104},
        {    -235,      120},
        {    -204,     -281},
        {    -337,      337},
        {   -1222,     -888},
        {     356,     -699},
        {   -2755,     -895},
        {    1254,    -7922},
        {   11081,        0},
        {    1519,     9591},
        {   -4742,     1541},
        {    -168,     -330},
        {   -1247,      906},
        {    -686,     -686},
        {     -71,       99},
        {    -342,     -174},
        {       6,      -20},
        {    -175,      -27},
        {       0,      -11},
        {    -144,       22},
        {     -20,      -64},
        {     -60,       30}
    },
    {
        {       0,        0},     /* Filter 58 */
        {      -1,        3},
        {    -138,      -21},
        {       0,      -75},
        {    -138,       21},
        {     -33,     -103},
        {    -237,      121},
        {    -203,     -280},
        {    -342,      342},
        {   -1224,     -889},
        {     351,     -689},
        {   -2780,     -903},
        {    1258,    -7946},
        {   11086,        0},
        {    1516,     9572},
        {   -4716,     1532},
        {    -160,     -314},
        {   -1249,      907},
        {    -681,     -681},
        {     -74,      102},
        {    -342,     -174},
        {       6,      -18},
        {    -175,      -27},
        {       0,      -10},
        {    -144,       22},
        {     -20,      -63},
        {     -60,       30}
    },
    {
        {       0,        0},     /* Filter 59 */
        {      -1,        4},
        {    -138,      -21},
        {       0,      -74},
        {    -138,       22},
        {     -33,     -102},
        {    -239,      121},
        {    -202,     -278},
        {    -346,      346},
        {   -1226,     -891},
        {     345,     -678},
        {   -2804,     -911},
        {    1262,    -7971},
        {   11091,        0},
        {    1513,     9554},
        {   -4690,     1524},
        {    -152,     -298},
        {   -1250,      908},
        {    -677,     -677},
        {     -76,      105},
        {    -341,     -173},
        {       5,      -16},
        {    -175,      -27},
        {       0,       -9},
        {    -144,       22},
        {     -20,      -62},
        {     -60,       30}
    },
    {
        {       0,        0},     /* Filter 60 */
        {      -1,        5},
        {    -138,      -21},
        {       0,      -73},
        {    -139,       22},
        {     -32,     -100},
        {    -241,      122},
        {    -201,     -277},
        {    -351,      351},
        {   -1228,     -892},
        {     340,     -668},
        {   -2828,     -919},
        {    1266,    -7995},
        {   11096,        0},
        {    1510,     9536},
        {   -4664,     1515},
        {    -143,     -282},
        {   -1252,      909},
        {    -673,     -673},
        {     -78,      108},
        {    -340,     -173},
        {       4,      -15},
        {    -175,      -27},
        {       0,       -8},
        {    -144,       22},
        {     -20,      -62},
        {     -61,       31}
    },
    {
        {       0,        0},     /* Filter 61 */
        {      -1,        6},
        {    -139,      -22},
        {       0,      -72},
        {    -140,       22},
        {     -32,      -99},
        {    -242,      123},
        {    -200,     -275},
        {    -355,      355},
        {   -1230,     -894},
        {     335,     -658},
        {   -2853,     -927},
        {    1270,    -8019},
        {   11100,        0},
        {    1507,     9517},
        {   -4638,     1507},
        {    -135,     -266},
        {   -1253,      911},
        {    -668,     -668},
        {     -81,      111},
        {    -339,     -172},
        {       4,      -13},
        {    -175,      -27},
        {       0,       -7},
        {    -145,       22},
        {     -19,      -61},
        {     -61,       31}
    },
    {
        {       0,        0},     /* Filter 62 */
        {      -2,        6},
        {    -139,      -22},
        {       0,      -71},
        {    -141,       22},
        {     -31,      -98},
        {    -244,      124},
        {    -199,     -274},
        {    -359,      359},
        {   -1232,     -895},
        {     329,     -647},
        {   -2877,     -935},
        {    1273,    -8042},
        {   11105,        0},
        {    1504,     9499},
        {   -4612,     1498},
        {    -127,     -250},
        {   -1255,      912},
        {    -664,     -664},
        {     -83,      114},
        {    -338,     -172},
        {       3,      -11},
        {    -175,      -27},
        {       0,       -5},
        {    -145,       23},
        {     -19,      -60},
        {     -61,       31}
    },
    {
        {       0,        0},     /* Filter 63 */
        {      -2,        7},
        {    -139,      -22},
        {       0,      -70},
        {    -142,       22},
        {     -31,      -96},
        {    -246,      125},
        {    -198,     -272},
        {    -364,      364},
        {   -1234,     -896},
        {     324,     -636},
        {   -2902,     -943},
        {    1277,    -8066},
        {   11109,        0},
        {    1501,     9480},
        {   -4585,     1490},
        {    -119,     -234},
        {   -1256,      913},
        {    -659,     -659},
        {     -85,      117},
        {    -337,     -171},
        {       3,       -9},
        {    -175,      -27},
        {       0,       -4},
        {    -145,       23},
        {     -19,      -59},
        {     -62,       31}
    },
    {
        {       0,        0},     /* Filter 64 */
        {      -2,        8},
        {    -139,      -22},
        {       0,      -69},
        {    -143,       22},
        {     -31,      -95},
        {    -248,      126},
        {    -196,     -271},
        {    -368,      368},
        {   -1236,     -898},
        {     319,     -626},
        {   -2926,     -950},
        {    1281,    -8090},
        {   11113,        0},
        {    1498,     9462},
        {   -4559,     1481},
        {    -111,     -219},
        {   -1258,      914},
        {    -655,     -655},
        {     -87,      121},
        {    -336,     -171},
        {       2,       -7},
        {    -174,      -27},
        {       0,       -3},
        {    -145,       23},
        {     -19,      -58},
        {     -62,       31}
    },
    {
        {       0,        0},     /* Filter 65 */
        {      -2,        9},
        {    -140,      -22},
        {       0,      -68},
        {    -143,       22},
        {     -30,      -94},
        {    -249,      127},
        {    -195,     -269},
        {    -373,      373},
        {   -1238,     -899},
        {     313,     -615},
        {   -2951,     -958},
        {    1285,    -8114},
        {   11117,        0},
        {    1495,     9443},
        {   -4533,     1473},
        {    -103,     -203},
        {   -1259,      915},
        {    -651,     -651},
        {     -90,      124},
        {    -335,     -170},
        {       1,       -5},
        {    -174,      -27},
        {       0,       -2},
        {    -145,       23},
        {     -18,      -58},
        {     -62,       31}
    },
    {
        {       0,        0},     /* Filter 66 */
        {      -3,        9},
        {    -140,      -22},
        {       0,      -67},
        {    -144,       22},
        {     -30,      -93},
        {    -251,      128},
        {    -194,     -267},
        {    -377,      377},
        {   -1239,     -900},
        {     307,     -604},
        {   -2976,     -966},
        {    1288,    -8138},
        {   11121,        0},
        {    1492,     9424},
        {   -4507,     1464},
        {     -95,     -188},
        {   -1260,      915},
        {    -646,     -646},
        {     -92,      127},
        {    -334,     -170},
        {       1,       -3},
        {    -174,      -27},
        {       0,        0},
        {    -145,       23},
        {     -18,      -57},
        {     -63,       32}
    },
    {
        {       0,        0},     /* Filter 67 */
        {      -3,       10},
        {    -140,      -22},
        {       0,      -66},
        {    -145,       23},
        {     -29,      -91},
        {    -253,      129},
        {    -193,     -266},
        {    -382,      382},
        {   -1241,     -902},
        {     302,     -593},
        {   -3000,     -975},
        {    1292,    -8161},
        {   11125,        0},
        {    1489,     9405},
        {   -4481,     1456},
        {     -88,     -172},
        {   -1261,      916},
        {    -642,     -642},
        {     -94,      130},
        {    -333,     -169},
        {       0,       -1},
        {    -174,      -27},
        {       0,        0},
        {    -145,       23},
        {     -18,      -56},
        {     -63,       32}
    },
    {
        {       0,        0},     /* Filter 68 */
        {      -3,       11},
        {    -141,      -22},
        {       0,      -65},
        {    -146,       23},
        {     -29,      -90},
        {    -254,      129},
        {    -192,     -264},
        {    -386,      386},
        {   -1243,     -903},
        {     296,     -582},
        {   -3025,     -983},
        {    1296,    -8185},
        {   11129,        0},
        {    1486,     9386},
        {   -4455,     1447},
        {     -80,     -157},
        {   -1263,      917},
        {    -637,     -637},
        {     -96,      133},
        {    -332,     -169},
        {       0,        0},
        {    -174,      -27},
        {       0,        1},
        {    -146,       23},
        {     -18,      -55},
        {     -63,       32}
    },
    {
        {       0,        0},     /* Filter 69 */
        {      -3,       12},
        {    -141,      -22},
        {       0,      -64},
        {    -146,       23},
        {     -28,      -89},
        {    -256,      130},
        {    -190,     -262},
        {    -391,      391},
        {   -1245,     -904},
        {     291,     -571},
        {   -3050,     -991},
        {    1300,    -8208},
        {   11133,        0},
        {    1483,     9367},
        {   -4429,     1439},
        {     -72,     -142},
        {   -1264,      918},
        {    -633,     -633},
        {     -98,      136},
        {    -331,     -168},
        {       0,        1},
        {    -173,      -27},
        {       0,        2},
        {    -146,       23},
        {     -17,      -55},
        {     -63,       32}
    },
    {
        {       0,        0},     /* Filter 70 */
        {      -4,       13},
        {    -141,      -22},
        {       0,      -63},
        {    -147,       23},
        {     -28,      -87},
        {    -258,      131},
        {    -189,     -261},
        {    -395,      395},
        {   -1246,     -905},
        {     285,     -560},
        {   -3074,     -999},
        {    1303,    -8232},
        {   11136,        0},
        {    1480,     9347},
        {   -4403,     1430},
        {     -64,     -126},
        {   -1265,      919},
        {    -629,     -629},
        {    -101,      139},
        {    -330,     -168},
        {      -1,        3},
        {    -173,      -27},
        {       0,        3},
        {    -146,       23},
        {     -17,      -54},
        {     -64,       32}
    },
    {
        {       0,        0},     /* Filter 71 */
        {      -4,       13},
        {    -141,      -22},
        {       0,      -62},
        {    -148,       23},
        {     -28,      -86},
        {    -259,      132},
        {    -188,     -259},
        {    -399,      399},
        {   -1248,     -906},
        {     279,     -548},
        {   -3099,    -1007},
        {    1307,    -8255},
        {   11140,        0},
        {    1477,     9328},
        {   -4377,     1422},
        {     -56,     -111},
        {   -1266,      919},
        {    -624,     -624},
        {    -103,      142},
        {    -329,     -167},
        {      -1,        5},
        {    -173,      -27},
        {       0,        5},
        {    -146,       23},
        {     -17,      -53},
        {     -64,       32}
    },
    {
        {       0,        0},     /* Filter 72 */
        {      -4,       14},
        {    -142,      -22},
        {       0,      -61},
        {    -149,       23},
        {     -27,      -84},
        {    -261,      133},
        {    -187,     -257},
        {    -404,      404},
        {   -1249,     -908},
        {     273,     -537},
        {   -3124,    -1015},
        {    1311,    -8278},
        {   11143,        0},
        {    1474,     9308},
        {   -4351,     1413},
        {     -49,      -96},
        {   -1267,      920},
        {    -620,     -620},
        {    -105,      144},
        {    -328,     -167},
        {      -2,        7},
        {    -173,      -27},
        {       0,        6},
        {    -146,       23},
        {     -17,      -52},
        {     -64,       32}
    },
    {
        {       0,        0},     /* Filter 73 */
        {      -5,       15},
        {    -142,      -22},
        {       0,      -60},
        {    -149,       23},
        {     -27,      -83},
        {    -263,      134},
        {    -185,     -255},
        {    -408,      408},
        {   -1251,     -909},
        {     268,     -526},
        {   -3149,    -1023},
        {    1314,    -8301},
        {   11146,        0},
        {    1471,     9289},
        {   -4325,     1405},
        {     -41,      -81},
        {   -1267,      921},
        {    -615,     -615},
        {    -107,      147},
        {    -327,     -166},
        {      -2,        9},
        {    -172,      -27},
        {       0,        7},
        {    -146,       23},
        {     -16,      -51},
        {     -65,       33}
    },
    {
        {       0,        0},     /* Filter 74 */
        {      -5,       16},
        {    -142,      -22},
        {       0,      -59},
        {    -150,       23},
        {     -26,      -82},
        {    -264,      134},
        {    -184,     -253},
        {    -413,      413},
        {   -1252,     -910},
        {     262,     -514},
        {   -3174,    -1031},
        {    1318,    -8324},
        {   11149,        0},
        {    1468,     9269},
        {   -4299,     1396},
        {     -34,      -66},
        {   -1268,      921},
        {    -611,     -611},
        {    -109,      150},
        {    -326,     -166},
        {      -3,       10},
        {    -172,      -27},
        {       0,        8},
        {    -146,       23},
        {     -16,      -51},
        {     -65,       33}
    },
    {
        {       0,        0},     /* Filter 75 */
        {      -5,       16},
        {    -142,      -22},
        {       0,      -57},
        {    -151,       23},
        {     -26,      -80},
        {    -266,      135},
        {    -183,     -252},
        {    -417,      417},
        {   -1254,     -911},
        {     256,     -503},
        {   -3199,    -1039},
        {    1322,    -8348},
        {   11152,        0},
        {    1465,     9250},
        {   -4273,     1388},
        {     -26,      -51},
        {   -1269,      922},
        {    -606,     -606},
        {    -111,      153},
        {    -325,     -165},
        {      -4,       12},
        {    -172,      -27},
        {       0,        9},
        {    -146,       23},
        {     -16,      -50},
        {     -65,       33}
    },
    {
        {       0,        0},     /* Filter 76 */
        {      -5,       17},
        {    -143,      -22},
        {       0,      -56},
        {    -151,       24},
        {     -25,      -79},
        {    -268,      136},
        {    -181,     -250},
        {    -422,      422},
        {   -1255,     -912},
        {     250,     -491},
        {   -3224,    -1047},
        {    1325,    -8371},
        {   11154,        0},
        {    1461,     9230},
        {   -4246,     1379},
        {     -18,      -37},
        {   -1270,      922},
        {    -602,     -602},
        {    -113,      156},
        {    -323,     -165},
        {      -4,       14},
        {    -172,      -27},
        {       0,       11},
        {    -146,       23},
        {     -16,      -49},
        {     -65,       33}
    },
    {
        {       0,        0},     /* Filter 77 */
        {      -6,       18},
        {    -143,      -22},
        {       0,      -55},
        {    -152,       24},
        {     -25,      -77},
        {    -269,      137},
        {    -180,     -248},
        {    -426,      426},
        {   -1256,     -913},
        {     244,     -479},
        {   -3249,    -1055},
        {    1329,    -8394},
        {   11157,        0},
        {    1458,     9210},
        {   -4221,     1371},
        {     -11,      -22},
        {   -1270,      923},
        {    -597,     -597},
        {    -115,      159},
        {    -322,     -164},
        {      -5,       16},
        {    -171,      -27},
        {       0,       12},
        {    -146,       23},
        {     -15,      -48},
        {     -66,       33}
    },
    {
        {       0,        0},     /* Filter 78 */
        {      -6,       19},
        {    -143,      -22},
        {       0,      -54},
        {    -153,       24},
        {     -24,      -76},
        {    -271,      138},
        {    -178,     -246},
        {    -431,      431},
        {   -1258,     -914},
        {     238,     -468},
        {   -3274,    -1063},
        {    1333,    -8416},
        {   11159,        0},
        {    1455,     9190},
        {   -4195,     1363},
        {      -3,       -7},
        {   -1271,      923},
        {    -593,     -593},
        {    -117,      161},
        {    -321,     -163},
        {      -5,       18},
        {    -171,      -27},
        {       0,       13},
        {    -146,       23},
        {     -15,      -47},
        {     -66,       33}
    },
    {
        {       0,        0},     /* Filter 79 */
        {      -6,       20},
        {    -143,      -22},
        {       0,      -53},
        {    -153,       24},
        {     -24,      -74},
        {    -272,      139},
        {    -177,     -244},
        {    -435,      435},
        {   -1259,     -914},
        {     232,     -456},
        {   -3299,    -1072},
        {    1336,    -8439},
        {   11162,        0},
        {    1452,     9170},
        {   -4169,     1354},
        {       3,        6},
        {   -1271,      924},
        {    -588,     -588},
        {    -119,      164},
        {    -320,     -163},
        {      -6,       19},
        {    -171,      -27},
        {       0,       14},
        {    -146,       23},
        {     -15,      -47},
        {     -66,       33}
    },
    {
        {       0,        0},     /* Filter 80 */
        {      -6,       20},
        {    -144,      -22},
        {       0,      -52},
        {    -154,       24},
        {     -23,      -73},
        {    -274,      139},
        {    -176,     -242},
        {    -440,      440},
        {   -1260,     -915},
        {     226,     -444},
        {   -3324,    -1080},
        {    1340,    -8462},
        {   11164,        0},
        {    1449,     9150},
        {   -4143,     1346},
        {      10,       21},
        {   -1272,      924},
        {    -584,     -584},
        {    -121,      167},
        {    -319,     -162},
        {      -7,       21},
        {    -170,      -27},
        {       0,       15},
        {    -146,       23},
        {     -15,      -46},
        {     -66,       34}
    },
    {
        {       0,        0},     /* Filter 81 */
        {      -7,       21},
        {    -144,      -22},
        {       0,      -51},
        {    -155,       24},
        {     -23,      -71},
        {    -276,      140},
        {    -174,     -240},
        {    -444,      444},
        {   -1261,     -916},
        {     220,     -432},
        {   -3349,    -1088},
        {    1343,    -8485},
        {   11166,        0},
        {    1446,     9129},
        {   -4117,     1337},
        {      18,       35},
        {   -1272,      924},
        {    -579,     -579},
        {    -123,      170},
        {    -317,     -162},
        {      -7,       23},
        {    -170,      -26},
        {       0,       17},
        {    -146,       23},
        {     -14,      -45},
        {     -67,       34}
    },
    {
        {       0,        0},     /* Filter 82 */
        {      -7,       22},
        {    -144,      -22},
        {       0,      -50},
        {    -155,       24},
        {     -22,      -70},
        {    -277,      141},
        {    -173,     -238},
        {    -449,      449},
        {   -1262,     -917},
        {     214,     -420},
        {   -3375,    -1096},
        {    1347,    -8507},
        {   11168,        0},
        {    1442,     9109},
        {   -4091,     1329},
        {      25,       49},
        {   -1273,      924},
        {    -575,     -575},
        {    -125,      172},
        {    -316,     -161},
        {      -8,       25},
        {    -170,      -26},
        {       0,       18},
        {    -146,       23},
        {     -14,      -44},
        {     -67,       34}
    },
    {
        {       0,        0},     /* Filter 83 */
        {      -7,       23},
        {    -144,      -22},
        {       0,      -49},
        {    -156,       24},
        {     -22,      -68},
        {    -279,      142},
        {    -171,     -236},
        {    -453,      453},
        {   -1263,     -918},
        {     207,     -407},
        {   -3400,    -1104},
        {    1351,    -8530},
        {   11169,        0},
        {    1439,     9089},
        {   -4065,     1320},
        {      32,       64},
        {   -1273,      925},
        {    -571,     -571},
        {    -127,      175},
        {    -315,     -160},
        {      -8,       26},
        {    -169,      -26},
        {       0,       19},
        {    -146,       23},
        {     -14,      -43},
        {     -67,       34}
    },
    {
        {       0,        0},     /* Filter 84 */
        {      -7,       24},
        {    -144,      -22},
        {       0,      -48},
        {    -157,       24},
        {     -21,      -67},
        {    -280,      143},
        {    -170,     -234},
        {    -458,      458},
        {   -1264,     -918},
        {     201,     -395},
        {   -3425,    -1113},
        {    1354,    -8552},
        {   11171,        0},
        {    1436,     9068},
        {   -4039,     1312},
        {      39,       78},
        {   -1273,      925},
        {    -566,     -566},
        {    -129,      178},
        {    -314,     -160},
        {      -9,       28},
        {    -169,      -26},
        {       0,       20},
        {    -146,       23},
        {     -14,      -43},
        {     -67,       34}
    },
    {
        {       0,        0},     /* Filter 85 */
        {      -8,       24},
        {    -144,      -22},
        {       0,      -47},
        {    -157,       24},
        {     -21,      -65},
        {    -282,      143},
        {    -168,     -232},
        {    -462,      462},
        {   -1265,     -919},
        {     195,     -383},
        {   -3450,    -1121},
        {    1358,    -8575},
        {   11173,        0},
        {    1433,     9048},
        {   -4013,     1304},
        {      47,       92},
        {   -1273,      925},
        {    -562,     -562},
        {    -131,      180},
        {    -313,     -159},
        {      -9,       30},
        {    -168,      -26},
        {       0,       21},
        {    -146,       23},
        {     -13,      -42},
        {     -68,       34}
    },
    {
        {       0,        0},     /* Filter 86 */
        {      -8,       25},
        {    -145,      -22},
        {       0,      -45},
        {    -158,       25},
        {     -20,      -64},
        {    -283,      144},
        {    -167,     -230},
        {    -467,      467},
        {   -1266,     -920},
        {     188,     -370},
        {   -3476,    -1129},
        {    1361,    -8597},
        {   11174,        0},
        {    1429,     9027},
        {   -3987,     1295},
        {      54,      106},
        {   -1273,      925},
        {    -557,     -557},
        {    -133,      183},
        {    -311,     -158},
        {     -10,       31},
        {    -168,      -26},
        {       0,       23},
        {    -146,       23},
        {     -13,      -41},
        {     -68,       34}
    },
    {
        {       0,        0},     /* Filter 87 */
        {      -8,       26},
        {    -145,      -23},
        {       0,      -44},
        {    -158,       25},
        {     -20,      -62},
        {    -285,      145},
        {    -165,     -228},
        {    -471,      471},
        {   -1267,     -920},
        {     182,     -358},
        {   -3501,    -1137},
        {    1365,    -8619},
        {   11175,        0},
        {    1426,     9006},
        {   -3962,     1287},
        {      61,      120},
        {   -1274,      925},
        {    -553,     -553},
        {    -134,      185},
        {    -310,     -158},
        {     -10,       33},
        {    -168,      -26},
        {       0,       24},
        {    -146,       23},
        {     -13,      -40},
        {     -68,       34}
    },
    {
        {       0,        0},     /* Filter 88 */
        {      -8,       27},
        {    -145,      -23},
        {       0,      -43},
        {    -159,       25},
        {     -19,      -61},
        {    -286,      146},
        {    -164,     -225},
        {    -476,      476},
        {   -1268,     -921},
        {     176,     -345},
        {   -3526,    -1145},
        {    1368,    -8641},
        {   11176,        0},
        {    1423,     8985},
        {   -3936,     1278},
        {      68,      134},
        {   -1274,      925},
        {    -548,     -548},
        {    -136,      188},
        {    -309,     -157},
        {     -11,       35},
        {    -167,      -26},
        {       0,       25},
        {    -146,       23},
        {     -12,      -39},
        {     -68,       35}
    },
    {
        {       0,        0},     /* Filter 89 */
        {      -9,       28},
        {    -145,      -23},
        {       0,      -42},
        {    -160,       25},
        {     -19,      -59},
        {    -288,      146},
        {    -162,     -223},
        {    -480,      480},
        {   -1268,     -921},
        {     169,     -333},
        {   -3552,    -1154},
        {    1372,    -8663},
        {   11177,        0},
        {    1419,     8964},
        {   -3910,     1270},
        {      75,      148},
        {   -1274,      925},
        {    -544,     -544},
        {    -138,      190},
        {    -307,     -156},
        {     -12,       37},
        {    -167,      -26},
        {       0,       26},
        {    -146,       23},
        {     -12,      -39},
        {     -68,       35}
    },
    {
        {       0,        0},     /* Filter 90 */
        {      -9,       28},
        {    -145,      -23},
        {       0,      -41},
        {    -160,       25},
        {     -18,      -58},
        {    -289,      147},
        {    -160,     -221},
        {    -485,      485},
        {   -1269,     -922},
        {     163,     -320},
        {   -3577,    -1162},
        {    1375,    -8685},
        {   11178,        0},
        {    1416,     8943},
        {   -3884,     1262},
        {      82,      161},
        {   -1274,      925},
        {    -539,     -539},
        {    -140,      193},
        {    -306,     -156},
        {     -12,       38},
        {    -166,      -26},
        {       0,       27},
        {    -146,       23},
        {     -12,      -38},
        {     -69,       35}
    },
    {
        {       0,        0},     /* Filter 91 */
        {      -9,       29},
        {    -145,      -23},
        {       0,      -40},
        {    -161,       25},
        {     -18,      -56},
        {    -291,      148},
        {    -159,     -219},
        {    -489,      489},
        {   -1270,     -922},
        {     156,     -307},
        {   -3603,    -1170},
        {    1379,    -8707},
        {   11179,        0},
        {    1413,     8922},
        {   -3859,     1253},
        {      89,      175},
        {   -1273,      925},
        {    -535,     -535},
        {    -142,      195},
        {    -305,     -155},
        {     -13,       40},
        {    -166,      -26},
        {       0,       28},
        {    -146,       23},
        {     -12,      -37},
        {     -69,       35}
    },
    {
        {       0,        0},     /* Filter 92 */
        {      -9,       30},
        {    -145,      -23},
        {       0,      -39},
        {    -161,       25},
        {     -17,      -55},
        {    -292,      149},
        {    -157,     -217},
        {    -494,      494},
        {   -1270,     -923},
        {     150,     -294},
        {   -3628,    -1178},
        {    1382,    -8729},
        {   11180,        0},
        {    1409,     8901},
        {   -3833,     1245},
        {      96,      189},
        {   -1273,      925},
        {    -530,     -530},
        {    -144,      198},
        {    -303,     -154},
        {     -13,       42},
        {    -165,      -26},
        {       0,       30},
        {    -146,       23},
        {     -11,      -36},
        {     -69,       35}
    },
    {
        {       0,        0},     /* Filter 93 */
        {     -10,       31},
        {    -146,      -23},
        {       0,      -38},
        {    -162,       25},
        {     -17,      -53},
        {    -294,      149},
        {    -156,     -214},
        {    -498,      498},
        {   -1271,     -923},
        {     143,     -281},
        {   -3654,    -1187},
        {    1386,    -8751},
        {   11180,        0},
        {    1406,     8880},
        {   -3807,     1237},
        {     103,      202},
        {   -1273,      925},
        {    -525,     -525},
        {    -145,      200},
        {    -302,     -154},
        {     -14,       43},
        {    -165,      -26},
        {       0,       31},
        {    -146,       23},
        {     -11,      -35},
        {     -69,       35}
    },
    {
        {       0,        0},     /* Filter 94 */
        {     -10,       31},
        {    -146,      -23},
        {       0,      -36},
        {    -162,       25},
        {     -16,      -51},
        {    -295,      150},
        {    -154,     -212},
        {    -503,      503},
        {   -1271,     -924},
        {     136,     -268},
        {   -3679,    -1195},
        {    1389,    -8773},
        {   11180,        0},
        {    1403,     8859},
        {   -3782,     1228},
        {     110,      215},
        {   -1273,      925},
        {    -521,     -521},
        {    -147,      203},
        {    -301,     -153},
        {     -14,       45},
        {    -164,      -26},
        {       0,       32},
        {    -146,       23},
        {     -11,      -35},
        {     -69,       35}
    },
    {
        {       0,        0},     /* Filter 95 */
        {     -10,       32},
        {    -146,      -23},
        {       0,      -35},
        {    -163,       25},
        {     -16,      -50},
        {    -296,      151},
        {    -152,     -210},
        {    -507,      507},
        {   -1272,     -924},
        {     130,     -255},
        {   -3705,    -1203},
        {    1392,    -8794},
        {   11181,        0},
        {    1399,     8837},
        {   -3756,     1220},
        {     116,      229},
        {   -1273,      924},
        {    -516,     -516},
        {    -149,      205},
        {    -299,     -152},
        {     -15,       47},
        {    -164,      -26},
        {       0,       33},
        {    -146,       23},
        {     -11,      -34},
        {     -70,       35}
    },
    {
        {       0,        0},     /* Filter 96 */
        {     -10,       33},
        {    -146,      -23},
        {       0,      -34},
        {    -163,       25},
        {     -15,      -48},
        {    -298,      151},
        {    -151,     -207},
        {    -512,      512},
        {   -1272,     -924},
        {     123,     -242},
        {   -3730,    -1212},
        {    1396,    -8816},
        {   11181,        0},
        {    1396,     8816},
        {   -3730,     1212},
        {     123,      242},
        {   -1272,      924},
        {    -512,     -512},
        {    -151,      207},
        {    -298,     -151},
        {     -15,       48},
        {    -163,      -25},
        {       0,       34},
        {    -146,       23},
        {     -10,      -33},
        {     -70,       35}
    },
    {
        {       0,        0},     /* Filter 97 */
        {     -11,       34},
        {    -146,      -23},
        {       0,      -33},
        {    -164,       26},
        {     -15,      -47},
        {    -299,      152},
        {    -149,     -205},
        {    -516,      516},
        {   -1273,     -924},
        {     116,     -229},
        {   -3756,    -1220},
        {    1399,    -8837},
        {   11181,        0},
        {    1392,     8794},
        {   -3705,     1203},
        {     130,      255},
        {   -1272,      924},
        {    -507,     -507},
        {    -152,      210},
        {    -296,     -151},
        {     -16,       50},
        {    -163,      -25},
        {       0,       35},
        {    -146,       23},
        {     -10,      -32},
        {     -70,       35}
    },
    {
        {       0,        0},     /* Filter 98 */
        {     -11,       35},
        {    -146,      -23},
        {       0,      -32},
        {    -164,       26},
        {     -14,      -45},
        {    -301,      153},
        {    -147,     -203},
        {    -521,      521},
        {   -1273,     -925},
        {     110,     -215},
        {   -3782,    -1228},
        {    1403,    -8859},
        {   11180,        0},
        {    1389,     8773},
        {   -3679,     1195},
        {     136,      268},
        {   -1271,      924},
        {    -503,     -503},
        {    -154,      212},
        {    -295,     -150},
        {     -16,       51},
        {    -162,      -25},
        {       0,       36},
        {    -146,       23},
        {     -10,      -31},
        {     -70,       35}
    },
    {
        {       0,        0},     /* Filter 99 */
        {     -11,       35},
        {    -146,      -23},
        {       0,      -31},
        {    -165,       26},
        {     -14,      -43},
        {    -302,      154},
        {    -145,     -200},
        {    -525,      525},
        {   -1273,     -925},
        {     103,     -202},
        {   -3807,    -1237},
        {    1406,    -8880},
        {   11180,        0},
        {    1386,     8751},
        {   -3654,     1187},
        {     143,      281},
        {   -1271,      923},
        {    -498,     -498},
        {    -156,      214},
        {    -294,     -149},
        {     -17,       53},
        {    -162,      -25},
        {       0,       38},
        {    -146,       23},
        {     -10,      -31},
        {     -70,       36}
    },
    {
        {       0,        0},     /* Filter 100 */
        {     -11,       36},
        {    -146,      -23},
        {       0,      -30},
        {    -165,       26},
        {     -13,      -42},
        {    -303,      154},
        {    -144,     -198},
        {    -530,      530},
        {   -1273,     -925},
        {      96,     -189},
        {   -3833,    -1245},
        {    1409,    -8901},
        {   11180,        0},
        {    1382,     8729},
        {   -3628,     1178},
        {     150,      294},
        {   -1270,      923},
        {    -494,     -494},
        {    -157,      217},
        {    -292,     -149},
        {     -17,       55},
        {    -161,      -25},
        {       0,       39},
        {    -145,       23},
        {      -9,      -30},
        {     -70,       36}
    },
    {
        {       0,        0},     /* Filter 101 */
        {     -12,       37},
        {    -146,      -23},
        {       0,      -28},
        {    -166,       26},
        {     -13,      -40},
        {    -305,      155},
        {    -142,     -195},
        {    -535,      535},
        {   -1273,     -925},
        {      89,     -175},
        {   -3859,    -1253},
        {    1413,    -8922},
        {   11179,        0},
        {    1379,     8707},
        {   -3603,     1170},
        {     156,      307},
        {   -1270,      922},
        {    -489,     -489},
        {    -159,      219},
        {    -291,     -148},
        {     -18,       56},
        {    -161,      -25},
        {       0,       40},
        {    -145,       23},
        {      -9,      -29},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 102 */
        {     -12,       38},
        {    -146,      -23},
        {       0,      -27},
        {    -166,       26},
        {     -12,      -38},
        {    -306,      156},
        {    -140,     -193},
        {    -539,      539},
        {   -1274,     -925},
        {      82,     -161},
        {   -3884,    -1262},
        {    1416,    -8943},
        {   11178,        0},
        {    1375,     8685},
        {   -3577,     1162},
        {     163,      320},
        {   -1269,      922},
        {    -485,     -485},
        {    -160,      221},
        {    -289,     -147},
        {     -18,       58},
        {    -160,      -25},
        {       0,       41},
        {    -145,       23},
        {      -9,      -28},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 103 */
        {     -12,       39},
        {    -146,      -23},
        {       0,      -26},
        {    -167,       26},
        {     -12,      -37},
        {    -307,      156},
        {    -138,     -190},
        {    -544,      544},
        {   -1274,     -925},
        {      75,     -148},
        {   -3910,    -1270},
        {    1419,    -8964},
        {   11177,        0},
        {    1372,     8663},
        {   -3552,     1154},
        {     169,      333},
        {   -1268,      921},
        {    -480,     -480},
        {    -162,      223},
        {    -288,     -146},
        {     -19,       59},
        {    -160,      -25},
        {       0,       42},
        {    -145,       23},
        {      -9,      -28},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 104 */
        {     -12,       39},
        {    -146,      -23},
        {       0,      -25},
        {    -167,       26},
        {     -11,      -35},
        {    -309,      157},
        {    -136,     -188},
        {    -548,      548},
        {   -1274,     -925},
        {      68,     -134},
        {   -3936,    -1278},
        {    1423,    -8985},
        {   11176,        0},
        {    1368,     8641},
        {   -3526,     1145},
        {     176,      345},
        {   -1268,      921},
        {    -476,     -476},
        {    -164,      225},
        {    -286,     -146},
        {     -19,       61},
        {    -159,      -25},
        {       0,       43},
        {    -145,       23},
        {      -8,      -27},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 105 */
        {     -13,       40},
        {    -146,      -23},
        {       0,      -24},
        {    -168,       26},
        {     -10,      -33},
        {    -310,      158},
        {    -134,     -185},
        {    -553,      553},
        {   -1274,     -925},
        {      61,     -120},
        {   -3962,    -1287},
        {    1426,    -9006},
        {   11175,        0},
        {    1365,     8619},
        {   -3501,     1137},
        {     182,      358},
        {   -1267,      920},
        {    -471,     -471},
        {    -165,      228},
        {    -285,     -145},
        {     -20,       62},
        {    -158,      -25},
        {       0,       44},
        {    -145,       23},
        {      -8,      -26},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 106 */
        {     -13,       41},
        {    -146,      -23},
        {       0,      -23},
        {    -168,       26},
        {     -10,      -31},
        {    -311,      158},
        {    -133,     -183},
        {    -557,      557},
        {   -1273,     -925},
        {      54,     -106},
        {   -3987,    -1295},
        {    1429,    -9027},
        {   11174,        0},
        {    1361,     8597},
        {   -3476,     1129},
        {     188,      370},
        {   -1266,      920},
        {    -467,     -467},
        {    -167,      230},
        {    -283,     -144},
        {     -20,       64},
        {    -158,      -25},
        {       0,       45},
        {    -145,       22},
        {      -8,      -25},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 107 */
        {     -13,       42},
        {    -146,      -23},
        {       0,      -21},
        {    -168,       26},
        {      -9,      -30},
        {    -313,      159},
        {    -131,     -180},
        {    -562,      562},
        {   -1273,     -925},
        {      47,      -92},
        {   -4013,    -1304},
        {    1433,    -9048},
        {   11173,        0},
        {    1358,     8575},
        {   -3450,     1121},
        {     195,      383},
        {   -1265,      919},
        {    -462,     -462},
        {    -168,      232},
        {    -282,     -143},
        {     -21,       65},
        {    -157,      -24},
        {       0,       47},
        {    -144,       22},
        {      -8,      -24},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 108 */
        {     -14,       43},
        {    -146,      -23},
        {       0,      -20},
        {    -169,       26},
        {      -9,      -28},
        {    -314,      160},
        {    -129,     -178},
        {    -566,      566},
        {   -1273,     -925},
        {      39,      -78},
        {   -4039,    -1312},
        {    1436,    -9068},
        {   11171,        0},
        {    1354,     8552},
        {   -3425,     1113},
        {     201,      395},
        {   -1264,      918},
        {    -458,     -458},
        {    -170,      234},
        {    -280,     -143},
        {     -21,       67},
        {    -157,      -24},
        {       0,       48},
        {    -144,       22},
        {      -7,      -24},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 109 */
        {     -14,       43},
        {    -146,      -23},
        {       0,      -19},
        {    -169,       26},
        {      -8,      -26},
        {    -315,      160},
        {    -127,     -175},
        {    -571,      571},
        {   -1273,     -925},
        {      32,      -64},
        {   -4065,    -1320},
        {    1439,    -9089},
        {   11169,        0},
        {    1351,     8530},
        {   -3400,     1104},
        {     207,      407},
        {   -1263,      918},
        {    -453,     -453},
        {    -171,      236},
        {    -279,     -142},
        {     -22,       68},
        {    -156,      -24},
        {       0,       49},
        {    -144,       22},
        {      -7,      -23},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 110 */
        {     -14,       44},
        {    -146,      -23},
        {       0,      -18},
        {    -170,       26},
        {      -8,      -25},
        {    -316,      161},
        {    -125,     -172},
        {    -575,      575},
        {   -1273,     -924},
        {      25,      -49},
        {   -4091,    -1329},
        {    1442,    -9109},
        {   11168,        0},
        {    1347,     8507},
        {   -3375,     1096},
        {     214,      420},
        {   -1262,      917},
        {    -449,     -449},
        {    -173,      238},
        {    -277,     -141},
        {     -22,       70},
        {    -155,      -24},
        {       0,       50},
        {    -144,       22},
        {      -7,      -22},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 111 */
        {     -14,       45},
        {    -146,      -23},
        {       0,      -17},
        {    -170,       26},
        {      -7,      -23},
        {    -317,      162},
        {    -123,     -170},
        {    -579,      579},
        {   -1272,     -924},
        {      18,      -35},
        {   -4117,    -1337},
        {    1446,    -9129},
        {   11166,        0},
        {    1343,     8485},
        {   -3349,     1088},
        {     220,      432},
        {   -1261,      916},
        {    -444,     -444},
        {    -174,      240},
        {    -276,     -140},
        {     -23,       71},
        {    -155,      -24},
        {       0,       51},
        {    -144,       22},
        {      -7,      -21},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 112 */
        {     -15,       46},
        {    -146,      -23},
        {       0,      -15},
        {    -170,       27},
        {      -7,      -21},
        {    -319,      162},
        {    -121,     -167},
        {    -584,      584},
        {   -1272,     -924},
        {      10,      -21},
        {   -4143,    -1346},
        {    1449,    -9150},
        {   11164,        0},
        {    1340,     8462},
        {   -3324,     1080},
        {     226,      444},
        {   -1260,      915},
        {    -440,     -440},
        {    -176,      242},
        {    -274,     -139},
        {     -23,       73},
        {    -154,      -24},
        {       0,       52},
        {    -144,       22},
        {      -6,      -20},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 113 */
        {     -15,       47},
        {    -146,      -23},
        {       0,      -14},
        {    -171,       27},
        {      -6,      -19},
        {    -320,      163},
        {    -119,     -164},
        {    -588,      588},
        {   -1271,     -924},
        {       3,       -6},
        {   -4169,    -1354},
        {    1452,    -9170},
        {   11162,        0},
        {    1336,     8439},
        {   -3299,     1072},
        {     232,      456},
        {   -1259,      914},
        {    -435,     -435},
        {    -177,      244},
        {    -272,     -139},
        {     -24,       74},
        {    -153,      -24},
        {       0,       53},
        {    -143,       22},
        {      -6,      -20},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 114 */
        {     -15,       47},
        {    -146,      -23},
        {       0,      -13},
        {    -171,       27},
        {      -5,      -18},
        {    -321,      163},
        {    -117,     -161},
        {    -593,      593},
        {   -1271,     -923},
        {      -3,        7},
        {   -4195,    -1363},
        {    1455,    -9190},
        {   11159,        0},
        {    1333,     8416},
        {   -3274,     1063},
        {     238,      468},
        {   -1258,      914},
        {    -431,     -431},
        {    -178,      246},
        {    -271,     -138},
        {     -24,       76},
        {    -153,      -24},
        {       0,       54},
        {    -143,       22},
        {      -6,      -19},
        {     -72,       37}
    },
    {
        {       0,        0},     /* Filter 115 */
        {     -15,       48},
        {    -146,      -23},
        {       0,      -12},
        {    -171,       27},
        {      -5,      -16},
        {    -322,      164},
        {    -115,     -159},
        {    -597,      597},
        {   -1270,     -923},
        {     -11,       22},
        {   -4221,    -1371},
        {    1458,    -9210},
        {   11157,        0},
        {    1329,     8394},
        {   -3249,     1055},
        {     244,      479},
        {   -1256,      913},
        {    -426,     -426},
        {    -180,      248},
        {    -269,     -137},
        {     -25,       77},
        {    -152,      -24},
        {       0,       55},
        {    -143,       22},
        {      -6,      -18},
        {     -72,       37}
    },
    {
        {       0,        0},     /* Filter 116 */
        {     -16,       49},
        {    -146,      -23},
        {       0,      -11},
        {    -172,       27},
        {      -4,      -14},
        {    -323,      165},
        {    -113,     -156},
        {    -602,      602},
        {   -1270,     -922},
        {     -18,       37},
        {   -4246,    -1379},
        {    1461,    -9230},
        {   11154,        0},
        {    1325,     8371},
        {   -3224,     1047},
        {     250,      491},
        {   -1255,      912},
        {    -422,     -422},
        {    -181,      250},
        {    -268,     -136},
        {     -25,       79},
        {    -151,      -24},
        {       0,       56},
        {    -143,       22},
        {      -5,      -17},
        {     -72,       37}
    },
    {
        {       0,        0},     /* Filter 117 */
        {     -16,       50},
        {    -146,      -23},
        {       0,       -9},
        {    -172,       27},
        {      -4,      -12},
        {    -325,      165},
        {    -111,     -153},
        {    -606,      606},
        {   -1269,     -922},
        {     -26,       51},
        {   -4273,    -1388},
        {    1465,    -9250},
        {   11152,        0},
        {    1322,     8348},
        {   -3199,     1039},
        {     256,      503},
        {   -1254,      911},
        {    -417,     -417},
        {    -183,      252},
        {    -266,     -135},
        {     -26,       80},
        {    -151,      -23},
        {       0,       57},
        {    -142,       22},
        {      -5,      -16},
        {     -72,       37}
    },
    {
        {       0,        0},     /* Filter 118 */
        {     -16,       51},
        {    -146,      -23},
        {       0,       -8},
        {    -172,       27},
        {      -3,      -10},
        {    -326,      166},
        {    -109,     -150},
        {    -611,      611},
        {   -1268,     -921},
        {     -34,       66},
        {   -4299,    -1396},
        {    1468,    -9269},
        {   11149,        0},
        {    1318,     8324},
        {   -3174,     1031},
        {     262,      514},
        {   -1252,      910},
        {    -413,     -413},
        {    -184,      253},
        {    -264,     -134},
        {     -26,       82},
        {    -150,      -23},
        {       0,       59},
        {    -142,       22},
        {      -5,      -16},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 119 */
        {     -16,       51},
        {    -146,      -23},
        {       0,       -7},
        {    -172,       27},
        {      -2,       -9},
        {    -327,      166},
        {    -107,     -147},
        {    -615,      615},
        {   -1267,     -921},
        {     -41,       81},
        {   -4325,    -1405},
        {    1471,    -9289},
        {   11146,        0},
        {    1314,     8301},
        {   -3149,     1023},
        {     268,      526},
        {   -1251,      909},
        {    -408,     -408},
        {    -185,      255},
        {    -263,     -134},
        {     -27,       83},
        {    -149,      -23},
        {       0,       60},
        {    -142,       22},
        {      -5,      -15},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 120 */
        {     -17,       52},
        {    -146,      -23},
        {       0,       -6},
        {    -173,       27},
        {      -2,       -7},
        {    -328,      167},
        {    -105,     -144},
        {    -620,      620},
        {   -1267,     -920},
        {     -49,       96},
        {   -4351,    -1413},
        {    1474,    -9308},
        {   11143,        0},
        {    1311,     8278},
        {   -3124,     1015},
        {     273,      537},
        {   -1249,      908},
        {    -404,     -404},
        {    -187,      257},
        {    -261,     -133},
        {     -27,       84},
        {    -149,      -23},
        {       0,       61},
        {    -142,       22},
        {      -4,      -14},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 121 */
        {     -17,       53},
        {    -146,      -23},
        {       0,       -5},
        {    -173,       27},
        {      -1,       -5},
        {    -329,      167},
        {    -103,     -142},
        {    -624,      624},
        {   -1266,     -919},
        {     -56,      111},
        {   -4377,    -1422},
        {    1477,    -9328},
        {   11140,        0},
        {    1307,     8255},
        {   -3099,     1007},
        {     279,      548},
        {   -1248,      906},
        {    -399,     -399},
        {    -188,      259},
        {    -259,     -132},
        {     -28,       86},
        {    -148,      -23},
        {       0,       62},
        {    -141,       22},
        {      -4,      -13},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 122 */
        {     -17,       54},
        {    -146,      -23},
        {       0,       -3},
        {    -173,       27},
        {      -1,       -3},
        {    -330,      168},
        {    -101,     -139},
        {    -629,      629},
        {   -1265,     -919},
        {     -64,      126},
        {   -4403,    -1430},
        {    1480,    -9347},
        {   11136,        0},
        {    1303,     8232},
        {   -3074,      999},
        {     285,      560},
        {   -1246,      905},
        {    -395,     -395},
        {    -189,      261},
        {    -258,     -131},
        {     -28,       87},
        {    -147,      -23},
        {       0,       63},
        {    -141,       22},
        {      -4,      -13},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 123 */
        {     -17,       55},
        {    -146,      -23},
        {       0,       -2},
        {    -173,       27},
        {       0,       -1},
        {    -331,      168},
        {     -98,     -136},
        {    -633,      633},
        {   -1264,     -918},
        {     -72,      142},
        {   -4429,    -1439},
        {    1483,    -9367},
        {   11133,        0},
        {    1300,     8208},
        {   -3050,      991},
        {     291,      571},
        {   -1245,      904},
        {    -391,     -391},
        {    -190,      262},
        {    -256,     -130},
        {     -28,       89},
        {    -146,      -23},
        {       0,       64},
        {    -141,       22},
        {      -3,      -12},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 124 */
        {     -18,       55},
        {    -146,      -23},
        {       0,       -1},
        {    -174,       27},
        {       0,        0},
        {    -332,      169},
        {     -96,     -133},
        {    -637,      637},
        {   -1263,     -917},
        {     -80,      157},
        {   -4455,    -1447},
        {    1486,    -9386},
        {   11129,        0},
        {    1296,     8185},
        {   -3025,      983},
        {     296,      582},
        {   -1243,      903},
        {    -386,     -386},
        {    -192,      264},
        {    -254,     -129},
        {     -29,       90},
        {    -146,      -23},
        {       0,       65},
        {    -141,       22},
        {      -3,      -11},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 125 */
        {     -18,       56},
        {    -145,      -23},
        {       0,        0},
        {    -174,       27},
        {       0,        1},
        {    -333,      169},
        {     -94,     -130},
        {    -642,      642},
        {   -1261,     -916},
        {     -88,      172},
        {   -4481,    -1456},
        {    1489,    -9405},
        {   11125,        0},
        {    1292,     8161},
        {   -3000,      975},
        {     302,      593},
        {   -1241,      902},
        {    -382,     -382},
        {    -193,      266},
        {    -253,     -129},
        {     -29,       91},
        {    -145,      -23},
        {       0,       66},
        {    -140,       22},
        {      -3,      -10},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 126 */
        {     -18,       57},
        {    -145,      -23},
        {       0,        0},
        {    -174,       27},
        {       1,        3},
        {    -334,      170},
        {     -92,     -127},
        {    -646,      646},
        {   -1260,     -915},
        {     -95,      188},
        {   -4507,    -1464},
        {    1492,    -9424},
        {   11121,        0},
        {    1288,     8138},
        {   -2976,      966},
        {     307,      604},
        {   -1239,      900},
        {    -377,     -377},
        {    -194,      267},
        {    -251,     -128},
        {     -30,       93},
        {    -144,      -22},
        {       0,       67},
        {    -140,       22},
        {      -3,       -9},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 127 */
        {     -18,       58},
        {    -145,      -23},
        {       0,        2},
        {    -174,       27},
        {       1,        5},
        {    -335,      170},
        {     -90,     -124},
        {    -651,      651},
        {   -1259,     -915},
        {    -103,      203},
        {   -4533,    -1473},
        {    1495,    -9443},
        {   11117,        0},
        {    1285,     8114},
        {   -2951,      958},
        {     313,      615},
        {   -1238,      899},
        {    -373,     -373},
        {    -195,      269},
        {    -249,     -127},
        {     -30,       94},
        {    -143,      -22},
        {       0,       68},
        {    -140,       22},
        {      -2,       -9},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 128 */
        {     -19,       58},
        {    -145,      -23},
        {       0,        3},
        {    -174,       27},
        {       2,        7},
        {    -336,      171},
        {     -87,     -121},
        {    -655,      655},
        {   -1258,     -914},
        {    -111,      219},
        {   -4559,    -1481},
        {    1498,    -9462},
        {   11113,        0},
        {    1281,     8090},
        {   -2926,      950},
        {     319,      626},
        {   -1236,      898},
        {    -368,     -368},
        {    -196,      271},
        {    -248,     -126},
        {     -31,       95},
        {    -143,      -22},
        {       0,       69},
        {    -139,       22},
        {      -2,       -8},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 129 */
        {     -19,       59},
        {    -145,      -23},
        {       0,        4},
        {    -175,       27},
        {       3,        9},
        {    -337,      171},
        {     -85,     -117},
        {    -659,      659},
        {   -1256,     -913},
        {    -119,      234},
        {   -4585,    -1490},
        {    1501,    -9480},
        {   11109,        0},
        {    1277,     8066},
        {   -2902,      943},
        {     324,      636},
        {   -1234,      896},
        {    -364,     -364},
        {    -198,      272},
        {    -246,     -125},
        {     -31,       96},
        {    -142,      -22},
        {       0,       70},
        {    -139,       22},
        {      -2,       -7},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 130 */
        {     -19,       60},
        {    -145,      -23},
        {       0,        5},
        {    -175,       27},
        {       3,       11},
        {    -338,      172},
        {     -83,     -114},
        {    -664,      664},
        {   -1255,     -912},
        {    -127,      250},
        {   -4612,    -1498},
        {    1504,    -9499},
        {   11105,        0},
        {    1273,     8042},
        {   -2877,      935},
        {     329,      647},
        {   -1232,      895},
        {    -359,     -359},
        {    -199,      274},
        {    -244,     -124},
        {     -31,       98},
        {    -141,      -22},
        {       0,       71},
        {    -139,       22},
        {      -2,       -6},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 131 */
        {     -19,       61},
        {    -145,      -22},
        {       0,        7},
        {    -175,       27},
        {       4,       13},
        {    -339,      172},
        {     -81,     -111},
        {    -668,      668},
        {   -1253,     -911},
        {    -135,      266},
        {   -4638,    -1507},
        {    1507,    -9517},
        {   11100,        0},
        {    1270,     8019},
        {   -2853,      927},
        {     335,      658},
        {   -1230,      894},
        {    -355,     -355},
        {    -200,      275},
        {    -242,     -123},
        {     -32,       99},
        {    -140,      -22},
        {       0,       72},
        {    -139,       22},
        {      -1,       -6},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 132 */
        {     -20,       62},
        {    -144,      -22},
        {       0,        8},
        {    -175,       27},
        {       4,       15},
        {    -340,      173},
        {     -78,     -108},
        {    -673,      673},
        {   -1252,     -909},
        {    -143,      282},
        {   -4664,    -1515},
        {    1510,    -9536},
        {   11096,        0},
        {    1266,     7995},
        {   -2828,      919},
        {     340,      668},
        {   -1228,      892},
        {    -351,     -351},
        {    -201,      277},
        {    -241,     -122},
        {     -32,      100},
        {    -139,      -22},
        {       0,       73},
        {    -138,       21},
        {      -1,       -5},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 133 */
        {     -20,       62},
        {    -144,      -22},
        {       0,        9},
        {    -175,       27},
        {       5,       16},
        {    -341,      173},
        {     -76,     -105},
        {    -677,      677},
        {   -1250,     -908},
        {    -152,      298},
        {   -4690,    -1524},
        {    1513,    -9554},
        {   11091,        0},
        {    1262,     7971},
        {   -2804,      911},
        {     345,      678},
        {   -1226,      891},
        {    -346,     -346},
        {    -202,      278},
        {    -239,     -121},
        {     -33,      102},
        {    -138,      -22},
        {       0,       74},
        {    -138,       21},
        {      -1,       -4},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 134 */
        {     -20,       63},
        {    -144,      -22},
        {       0,       10},
        {    -175,       27},
        {       6,       18},
        {    -342,      174},
        {     -74,     -102},
        {    -681,      681},
        {   -1249,     -907},
        {    -160,      314},
        {   -4716,    -1532},
        {    1516,    -9572},
        {   11086,        0},
        {    1258,     7946},
        {   -2780,      903},
        {     351,      689},
        {   -1224,      889},
        {    -342,     -342},
        {    -203,      280},
        {    -237,     -121},
        {     -33,      103},
        {    -138,      -21},
        {       0,       75},
        {    -138,       21},
        {      -1,       -3},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 135 */
        {     -20,       64},
        {    -144,      -22},
        {       0,       11},
        {    -175,       27},
        {       6,       20},
        {    -342,      174},
        {     -71,      -99},
        {    -686,      686},
        {   -1247,     -906},
        {    -168,      330},
        {   -4742,    -1541},
        {    1519,    -9591},
        {   11081,        0},
        {    1254,     7922},
        {   -2755,      895},
        {     356,      699},
        {   -1222,      888},
        {    -337,     -337},
        {    -204,      281},
        {    -235,     -120},
        {     -33,      104},
        {    -137,      -21},
        {       0,       76},
        {    -137,       21},
        {      -1,       -3},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 136 */
        {     -21,       65},
        {    -144,      -22},
        {       0,       13},
        {    -175,       27},
        {       7,       22},
        {    -343,      175},
        {     -69,      -95},
        {    -690,      690},
        {   -1245,     -905},
        {    -176,      346},
        {   -4769,    -1549},
        {    1521,    -9609},
        {   11076,        0},
        {    1251,     7898},
        {   -2731,      887},
        {     361,      709},
        {   -1220,      886},
        {    -333,     -333},
        {    -205,      283},
        {    -234,     -119},
        {     -34,      105},
        {    -136,      -21},
        {       0,       77},
        {    -137,       21},
        {       0,       -2},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 137 */
        {     -21,       65},
        {    -143,      -22},
        {       0,       14},
        {    -176,       27},
        {       7,       24},
        {    -344,      175},
        {     -67,      -92},
        {    -694,      694},
        {   -1243,     -903},
        {    -184,      362},
        {   -4795,    -1558},
        {    1524,    -9627},
        {   11070,        0},
        {    1247,     7874},
        {   -2707,      879},
        {     366,      719},
        {   -1218,      885},
        {    -329,     -329},
        {    -206,      284},
        {    -232,     -118},
        {     -34,      107},
        {    -135,      -21},
        {       0,       78},
        {    -136,       21},
        {       0,       -1},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 138 */
        {     -21,       66},
        {    -143,      -22},
        {       0,       15},
        {    -176,       27},
        {       8,       26},
        {    -345,      176},
        {     -64,      -89},
        {    -699,      699},
        {   -1242,     -902},
        {    -193,      379},
        {   -4821,    -1566},
        {    1527,    -9644},
        {   11065,        0},
        {    1243,     7850},
        {   -2683,      871},
        {     371,      729},
        {   -1215,      883},
        {    -324,     -324},
        {    -207,      286},
        {    -230,     -117},
        {     -35,      108},
        {    -134,      -21},
        {       0,       79},
        {    -136,       21},
        {       0,        0},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 139 */
        {     -21,       67},
        {    -143,      -22},
        {       0,       16},
        {    -176,       27},
        {       9,       28},
        {    -346,      176},
        {     -62,      -85},
        {    -703,      703},
        {   -1240,     -901},
        {    -201,      395},
        {   -4847,    -1575},
        {    1530,    -9662},
        {   11059,        0},
        {    1239,     7825},
        {   -2659,      863},
        {     376,      739},
        {   -1213,      881},
        {    -320,     -320},
        {    -208,      287},
        {    -228,     -116},
        {     -35,      109},
        {    -133,      -21},
        {       0,       80},
        {    -136,       21},
        {       0,        0},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 140 */
        {     -22,       68},
        {    -143,      -22},
        {       0,       18},
        {    -176,       27},
        {       9,       30},
        {    -347,      176},
        {     -60,      -82},
        {    -707,      707},
        {   -1238,     -899},
        {    -209,      412},
        {   -4873,    -1583},
        {    1533,    -9680},
        {   11054,        0},
        {    1235,     7801},
        {   -2635,      856},
        {     381,      749},
        {   -1211,      880},
        {    -315,     -315},
        {    -209,      288},
        {    -226,     -115},
        {     -35,      110},
        {    -133,      -21},
        {       0,       81},
        {    -135,       21},
        {       0,        0},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 141 */
        {     -22,       69},
        {    -143,      -22},
        {       0,       19},
        {    -176,       27},
        {      10,       32},
        {    -347,      177},
        {     -57,      -79},
        {    -711,      711},
        {   -1236,     -898},
        {    -218,      428},
        {   -4900,    -1592},
        {    1536,    -9698},
        {   11048,        0},
        {    1231,     7776},
        {   -2610,      848},
        {     386,      759},
        {   -1208,      878},
        {    -311,     -311},
        {    -210,      290},
        {    -225,     -114},
        {     -36,      111},
        {    -132,      -20},
        {       0,       82},
        {    -135,       21},
        {       0,        1},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 142 */
        {     -22,       69},
        {    -142,      -22},
        {       0,       20},
        {    -176,       27},
        {      11,       34},
        {    -348,      177},
        {     -55,      -75},
        {    -716,      716},
        {   -1234,     -896},
        {    -226,      445},
        {   -4926,    -1600},
        {    1538,    -9715},
        {   11042,        0},
        {    1227,     7752},
        {   -2586,      840},
        {     391,      768},
        {   -1206,      876},
        {    -307,     -307},
        {    -211,      291},
        {    -223,     -113},
        {     -36,      112},
        {    -131,      -20},
        {       0,       83},
        {    -135,       21},
        {       0,        2},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 143 */
        {     -22,       70},
        {    -142,      -22},
        {       0,       21},
        {    -176,       27},
        {      11,       36},
        {    -349,      177},
        {     -52,      -72},
        {    -720,      720},
        {   -1231,     -895},
        {    -235,      461},
        {   -4952,    -1609},
        {    1541,    -9732},
        {   11036,        0},
        {    1223,     7727},
        {   -2563,      832},
        {     396,      778},
        {   -1204,      874},
        {    -302,     -302},
        {    -212,      292},
        {    -221,     -112},
        {     -37,      114},
        {    -130,      -20},
        {       0,       84},
        {    -134,       21},
        {       0,        2},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 144 */
        {     -23,       71},
        {    -142,      -22},
        {       0,       22},
        {    -176,       27},
        {      12,       38},
        {    -349,      178},
        {     -50,      -69},
        {    -724,      724},
        {   -1229,     -893},
        {    -243,      478},
        {   -4978,    -1617},
        {    1544,    -9750},
        {   11030,        0},
        {    1220,     7702},
        {   -2539,      825},
        {     401,      788},
        {   -1201,      873},
        {    -298,     -298},
        {    -213,      293},
        {    -219,     -111},
        {     -37,      115},
        {    -129,      -20},
        {       0,       85},
        {    -134,       21},
        {       1,        3},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 145 */
        {     -23,       72},
        {    -142,      -22},
        {       0,       24},
        {    -176,       27},
        {      13,       40},
        {    -350,      178},
        {     -47,      -65},
        {    -729,      729},
        {   -1227,     -891},
        {    -252,      495},
        {   -5004,    -1626},
        {    1546,    -9767},
        {   11023,        0},
        {    1216,     7678},
        {   -2515,      817},
        {     406,      797},
        {   -1199,      871},
        {    -294,     -294},
        {    -214,      295},
        {    -217,     -111},
        {     -37,      116},
        {    -128,      -20},
        {       0,       85},
        {    -133,       21},
        {       1,        4},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 146 */
        {     -23,       72},
        {    -141,      -22},
        {       0,       25},
        {    -176,       27},
        {      13,       42},
        {    -351,      179},
        {     -45,      -62},
        {    -733,      733},
        {   -1225,     -890},
        {    -261,      512},
        {   -5031,    -1634},
        {    1549,    -9784},
        {   11017,        0},
        {    1212,     7653},
        {   -2491,      809},
        {     411,      806},
        {   -1196,      869},
        {    -289,     -289},
        {    -215,      296},
        {    -216,     -110},
        {     -38,      117},
        {    -127,      -20},
        {       0,       86},
        {    -133,       21},
        {       1,        5},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 147 */
        {     -23,       73},
        {    -141,      -22},
        {       0,       26},
        {    -176,       27},
        {      14,       44},
        {    -352,      179},
        {     -42,      -58},
        {    -737,      737},
        {   -1222,     -888},
        {    -269,      529},
        {   -5057,    -1643},
        {    1552,    -9801},
        {   11010,        0},
        {    1208,     7628},
        {   -2467,      801},
        {     415,      816},
        {   -1194,      867},
        {    -285,     -285},
        {    -216,      297},
        {    -214,     -109},
        {     -38,      118},
        {    -126,      -20},
        {       0,       87},
        {    -133,       21},
        {       1,        5},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 148 */
        {     -24,       74},
        {    -141,      -22},
        {       0,       27},
        {    -176,       27},
        {      14,       46},
        {    -352,      179},
        {     -40,      -55},
        {    -741,      741},
        {   -1220,     -886},
        {    -278,      546},
        {   -5083,    -1651},
        {    1555,    -9818},
        {   11004,        0},
        {    1204,     7603},
        {   -2443,      794},
        {     420,      825},
        {   -1191,      865},
        {    -281,     -281},
        {    -217,      298},
        {    -212,     -108},
        {     -38,      119},
        {    -125,      -19},
        {       0,       88},
        {    -132,       21},
        {       2,        6},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 149 */
        {     -24,       75},
        {    -140,      -22},
        {       0,       29},
        {    -176,       27},
        {      15,       48},
        {    -353,      180},
        {     -37,      -51},
        {    -745,      745},
        {   -1217,     -884},
        {    -287,      563},
        {   -5109,    -1660},
        {    1557,    -9835},
        {   10997,        0},
        {    1200,     7578},
        {   -2420,      786},
        {     425,      834},
        {   -1188,      863},
        {    -277,     -277},
        {    -217,      299},
        {    -210,     -107},
        {     -39,      120},
        {    -124,      -19},
        {       0,       89},
        {    -132,       20},
        {       2,        7},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 150 */
        {     -24,       75},
        {    -140,      -22},
        {       0,       30},
        {    -176,       27},
        {      16,       50},
        {    -353,      180},
        {     -35,      -48},
        {    -750,      750},
        {   -1215,     -882},
        {    -295,      580},
        {   -5136,    -1668},
        {    1560,    -9851},
        {   10990,        0},
        {    1196,     7553},
        {   -2396,      778},
        {     429,      843},
        {   -1186,      861},
        {    -272,     -272},
        {    -218,      301},
        {    -208,     -106},
        {     -39,      121},
        {    -123,      -19},
        {       0,       90},
        {    -131,       20},
        {       2,        8},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 151 */
        {     -24,       76},
        {    -140,      -22},
        {       0,       31},
        {    -175,       27},
        {      16,       52},
        {    -354,      180},
        {     -32,      -44},
        {    -754,      754},
        {   -1212,     -880},
        {    -304,      597},
        {   -5162,    -1677},
        {    1562,    -9868},
        {   10983,        0},
        {    1192,     7528},
        {   -2373,      771},
        {     434,      852},
        {   -1183,      859},
        {    -268,     -268},
        {    -219,      302},
        {    -206,     -105},
        {     -39,      122},
        {    -123,      -19},
        {       0,       91},
        {    -131,       20},
        {       2,        8},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 152 */
        {     -25,       77},
        {    -139,      -22},
        {       0,       32},
        {    -175,       27},
        {      17,       54},
        {    -355,      180},
        {     -29,      -41},
        {    -758,      758},
        {   -1209,     -878},
        {    -313,      614},
        {   -5188,    -1685},
        {    1565,    -9884},
        {   10976,        0},
        {    1188,     7503},
        {   -2349,      763},
        {     439,      861},
        {   -1180,      857},
        {    -264,     -264},
        {    -220,      303},
        {    -205,     -104},
        {     -40,      123},
        {    -122,      -19},
        {       0,       92},
        {    -130,       20},
        {       3,        9},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 153 */
        {     -25,       78},
        {    -139,      -22},
        {       0,       34},
        {    -175,       27},
        {      18,       56},
        {    -355,      181},
        {     -27,      -37},
        {    -762,      762},
        {   -1206,     -876},
        {    -322,      632},
        {   -5214,    -1694},
        {    1568,    -9901},
        {   10968,        0},
        {    1184,     7478},
        {   -2326,      755},
        {     443,      870},
        {   -1177,      855},
        {    -260,     -260},
        {    -221,      304},
        {    -203,     -103},
        {     -40,      124},
        {    -121,      -19},
        {       0,       93},
        {    -130,       20},
        {       3,       10},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 154 */
        {     -25,       78},
        {    -139,      -22},
        {       0,       35},
        {    -175,       27},
        {      18,       58},
        {    -356,      181},
        {     -24,      -33},
        {    -766,      766},
        {   -1204,     -874},
        {    -331,      649},
        {   -5240,    -1702},
        {    1570,    -9917},
        {   10961,        0},
        {    1180,     7453},
        {   -2302,      748},
        {     447,      879},
        {   -1175,      853},
        {    -255,     -255},
        {    -221,      305},
        {    -201,     -102},
        {     -40,      125},
        {    -120,      -19},
        {       0,       94},
        {    -129,       20},
        {       3,       10},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 155 */
        {     -25,       79},
        {    -138,      -22},
        {       0,       36},
        {    -175,       27},
        {      19,       60},
        {    -356,      181},
        {     -22,      -30},
        {    -770,      770},
        {   -1201,     -872},
        {    -339,      667},
        {   -5266,    -1711},
        {    1573,    -9933},
        {   10953,        0},
        {    1176,     7428},
        {   -2279,      740},
        {     452,      887},
        {   -1172,      851},
        {    -251,     -251},
        {    -222,      306},
        {    -199,     -101},
        {     -41,      126},
        {    -119,      -18},
        {       0,       94},
        {    -129,       20},
        {       3,       11},
        {     -73,       37}
    },
    {
        {       0,        0},     /* Filter 156 */
        {     -26,       80},
        {    -138,      -21},
        {       0,       37},
        {    -175,       27},
        {      20,       62},
        {    -357,      181},
        {     -19,      -26},
        {    -774,      774},
        {   -1198,     -870},
        {    -348,      684},
        {   -5293,    -1719},
        {    1575,    -9949},
        {   10945,        0},
        {    1172,     7403},
        {   -2255,      732},
        {     456,      896},
        {   -1169,      849},
        {    -247,     -247},
        {    -223,      307},
        {    -197,     -100},
        {     -41,      127},
        {    -118,      -18},
        {       0,       95},
        {    -129,       20},
        {       4,       12},
        {     -72,       37}
    },
    {
        {       0,        0},     /* Filter 157 */
        {     -26,       80},
        {    -138,      -21},
        {       0,       38},
        {    -175,       27},
        {      20,       64},
        {    -357,      182},
        {     -16,      -22},
        {    -779,      779},
        {   -1195,     -868},
        {    -357,      702},
        {   -5319,    -1728},
        {    1578,    -9965},
        {   10938,        0},
        {    1168,     7377},
        {   -2232,      725},
        {     461,      905},
        {   -1166,      847},
        {    -243,     -243},
        {    -223,      308},
        {    -195,      -99},
        {     -41,      128},
        {    -117,      -18},
        {       0,       96},
        {    -128,       20},
        {       4,       13},
        {     -72,       37}
    },
    {
        {       0,        0},     /* Filter 158 */
        {     -26,       81},
        {    -137,      -21},
        {       0,       40},
        {    -175,       27},
        {      21,       66},
        {    -358,      182},
        {     -14,      -19},
        {    -783,      783},
        {   -1192,     -866},
        {    -366,      720},
        {   -5345,    -1736},
        {    1580,    -9981},
        {   10930,        0},
        {    1164,     7352},
        {   -2209,      717},
        {     465,      913},
        {   -1163,      845},
        {    -238,     -238},
        {    -224,      309},
        {    -193,      -98},
        {     -42,      129},
        {    -116,      -18},
        {       0,       97},
        {    -128,       20},
        {       4,       13},
        {     -72,       37}
    },
    {
        {       0,        0},     /* Filter 159 */
        {     -26,       82},
        {    -137,      -21},
        {       0,       41},
        {    -174,       27},
        {      22,       68},
        {    -358,      182},
        {     -11,      -15},
        {    -787,      787},
        {   -1188,     -863},
        {    -376,      737},
        {   -5371,    -1745},
        {    1583,    -9997},
        {   10922,        0},
        {    1160,     7327},
        {   -2186,      710},
        {     469,      921},
        {   -1160,      843},
        {    -234,     -234},
        {    -225,      310},
        {    -191,      -97},
        {     -42,      130},
        {    -115,      -18},
        {       0,       98},
        {    -127,       20},
        {       4,       14},
        {     -72,       37}
    },
    {
        {       0,        0},     /* Filter 160 */
        {     -27,       83},
        {    -137,      -21},
        {       0,       42},
        {    -174,       27},
        {      22,       70},
        {    -358,      182},
        {      -8,      -11},
        {    -791,      791},
        {   -1185,     -861},
        {    -385,      755},
        {   -5397,    -1753},
        {    1585,   -10012},
        {   10913,        0},
        {    1156,     7301},
        {   -2163,      702},
        {     473,      930},
        {   -1157,      840},
        {    -230,     -230},
        {    -225,      311},
        {    -189,      -96},
        {     -42,      131},
        {    -114,      -18},
        {       0,       99},
        {    -127,       20},
        {       4,       15},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 161 */
        {     -27,       83},
        {    -136,      -21},
        {       0,       43},
        {    -174,       27},
        {      23,       72},
        {    -359,      183},
        {      -5,       -8},
        {    -795,      795},
        {   -1182,     -859},
        {    -394,      773},
        {   -5423,    -1762},
        {    1588,   -10028},
        {   10905,        0},
        {    1152,     7276},
        {   -2140,      695},
        {     478,      938},
        {   -1154,      838},
        {    -226,     -226},
        {    -226,      311},
        {    -188,      -95},
        {     -43,      132},
        {    -113,      -17},
        {       0,      100},
        {    -126,       20},
        {       5,       15},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 162 */
        {     -27,       84},
        {    -136,      -21},
        {       0,       45},
        {    -174,       27},
        {      24,       74},
        {    -359,      183},
        {      -3,       -4},
        {    -799,      799},
        {   -1179,     -856},
        {    -403,      791},
        {   -5450,    -1770},
        {    1590,   -10043},
        {   10896,        0},
        {    1148,     7250},
        {   -2117,      687},
        {     482,      946},
        {   -1151,      836},
        {    -222,     -222},
        {    -227,      312},
        {    -186,      -94},
        {     -43,      133},
        {    -112,      -17},
        {       0,      100},
        {    -126,       19},
        {       5,       16},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 163 */
        {     -27,       85},
        {    -135,      -21},
        {       0,       46},
        {    -174,       27},
        {      24,       76},
        {    -360,      183},
        {       0,        0},
        {    -803,      803},
        {   -1175,     -854},
        {    -412,      809},
        {   -5476,    -1779},
        {    1593,   -10059},
        {   10888,        0},
        {    1144,     7225},
        {   -2094,      680},
        {     486,      954},
        {   -1148,      834},
        {    -218,     -218},
        {    -227,      313},
        {    -184,      -93},
        {     -43,      134},
        {    -111,      -17},
        {       0,      101},
        {    -125,       19},
        {       5,       17},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 164 */
        {     -27,       86},
        {    -135,      -21},
        {       0,       47},
        {    -173,       27},
        {      25,       78},
        {    -360,      183},
        {       2,        3},
        {    -807,      807},
        {   -1172,     -851},
        {    -421,      827},
        {   -5502,    -1787},
        {    1595,   -10074},
        {   10879,        0},
        {    1140,     7199},
        {   -2071,      672},
        {     490,      962},
        {   -1144,      831},
        {    -213,     -213},
        {    -228,      314},
        {    -182,      -92},
        {     -44,      135},
        {    -110,      -17},
        {       0,      102},
        {    -125,       19},
        {       5,       17},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 165 */
        {     -28,       86},
        {    -135,      -21},
        {       0,       48},
        {    -173,       27},
        {      26,       80},
        {    -360,      183},
        {       5,        7},
        {    -811,      811},
        {   -1168,     -849},
        {    -431,      846},
        {   -5528,    -1796},
        {    1597,   -10089},
        {   10870,        0},
        {    1136,     7173},
        {   -2048,      665},
        {     494,      970},
        {   -1141,      829},
        {    -209,     -209},
        {    -229,      315},
        {    -180,      -91},
        {     -44,      136},
        {    -109,      -17},
        {       0,      103},
        {    -124,       19},
        {       6,       18},
        {     -72,       36}
    },
    {
        {       0,        0},     /* Filter 166 */
        {     -28,       87},
        {    -134,      -21},
        {       0,       49},
        {    -173,       27},
        {      26,       82},
        {    -361,      183},
        {       7,       10},
        {    -815,      815},
        {   -1165,     -846},
        {    -440,      864},
        {   -5554,    -1804},
        {    1600,   -10104},
        {   10861,        0},
        {    1132,     7148},
        {   -2025,      658},
        {     498,      978},
        {   -1138,      827},
        {    -205,     -205},
        {    -229,      315},
        {    -178,      -90},
        {     -44,      137},
        {    -108,      -17},
        {       0,      104},
        {    -124,       19},
        {       6,       19},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 167 */
        {     -28,       88},
        {    -134,      -21},
        {       0,       51},
        {    -173,       27},
        {      27,       84},
        {    -361,      184},
        {      10,       14},
        {    -819,      819},
        {   -1161,     -843},
        {    -449,      882},
        {   -5580,    -1813},
        {    1602,   -10119},
        {   10852,        0},
        {    1128,     7122},
        {   -2002,      650},
        {     502,      986},
        {   -1135,      824},
        {    -201,     -201},
        {    -230,      316},
        {    -176,      -89},
        {     -44,      138},
        {    -107,      -16},
        {       0,      104},
        {    -123,       19},
        {       6,       20},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 168 */
        {     -28,       88},
        {    -133,      -21},
        {       0,       52},
        {    -172,       27},
        {      28,       86},
        {    -361,      184},
        {      13,       18},
        {    -823,      823},
        {   -1157,     -841},
        {    -459,      900},
        {   -5606,    -1821},
        {    1605,   -10133},
        {   10843,        0},
        {    1123,     7096},
        {   -1980,      643},
        {     506,      993},
        {   -1131,      822},
        {    -197,     -197},
        {    -230,      317},
        {    -174,      -88},
        {     -45,      139},
        {    -106,      -16},
        {       0,      105},
        {    -122,       19},
        {       6,       20},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 169 */
        {     -29,       89},
        {    -133,      -21},
        {       0,       53},
        {    -172,       27},
        {      28,       88},
        {    -361,      184},
        {      16,       22},
        {    -827,      827},
        {   -1154,     -838},
        {    -468,      919},
        {   -5632,    -1830},
        {    1607,   -10148},
        {   10834,        0},
        {    1119,     7070},
        {   -1957,      635},
        {     510,     1001},
        {   -1128,      819},
        {    -193,     -193},
        {    -231,      318},
        {    -172,      -88},
        {     -45,      139},
        {    -105,      -16},
        {       0,      106},
        {    -122,       19},
        {       6,       21},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 170 */
        {     -29,       90},
        {    -132,      -21},
        {       0,       54},
        {    -172,       27},
        {      29,       90},
        {    -362,      184},
        {      19,       26},
        {    -831,      831},
        {   -1150,     -835},
        {    -477,      937},
        {   -5658,    -1838},
        {    1609,   -10163},
        {   10824,        0},
        {    1115,     7044},
        {   -1934,      628},
        {     514,     1009},
        {   -1125,      817},
        {    -189,     -189},
        {    -231,      318},
        {    -170,      -87},
        {     -45,      140},
        {    -104,      -16},
        {       0,      107},
        {    -121,       19},
        {       7,       22},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 171 */
        {     -29,       90},
        {    -132,      -20},
        {       0,       55},
        {    -171,       27},
        {      30,       92},
        {    -362,      184},
        {      22,       30},
        {    -835,      835},
        {   -1146,     -832},
        {    -487,      956},
        {   -5684,    -1847},
        {    1611,   -10177},
        {   10815,        0},
        {    1111,     7019},
        {   -1912,      621},
        {     517,     1016},
        {   -1121,      815},
        {    -185,     -185},
        {    -232,      319},
        {    -168,      -86},
        {     -46,      141},
        {    -102,      -16},
        {       0,      108},
        {    -121,       19},
        {       7,       22},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 172 */
        {     -29,       91},
        {    -132,      -20},
        {       0,       57},
        {    -171,       27},
        {      30,       94},
        {    -362,      184},
        {      25,       34},
        {    -838,      838},
        {   -1142,     -830},
        {    -496,      975},
        {   -5710,    -1855},
        {    1614,   -10192},
        {   10805,        0},
        {    1107,     6993},
        {   -1889,      614},
        {     521,     1023},
        {   -1118,      812},
        {    -181,     -181},
        {    -232,      320},
        {    -166,      -85},
        {     -46,      142},
        {    -101,      -16},
        {       0,      108},
        {    -120,       19},
        {       7,       23},
        {     -71,       36}
    },
    {
        {       0,        0},     /* Filter 173 */
        {     -30,       92},
        {    -131,      -20},
        {       0,       58},
        {    -171,       27},
        {      31,       96},
        {    -362,      184},
        {      27,       38},
        {    -842,      842},
        {   -1138,     -827},
        {    -506,      993},
        {   -5736,    -1864},
        {    1616,   -10206},
        {   10795,        0},
        {    1103,     6967},
        {   -1867,      606},
        {     525,     1031},
        {   -1114,      810},
        {    -177,     -177},
        {    -233,      320},
        {    -165,      -84},
        {     -46,      143},
        {    -100,      -15},
        {       0,      109},
        {    -120,       19},
        {       7,       24},
        {     -70,       36}
    },
    {
        {       0,        0},     /* Filter 174 */
        {     -30,       93},
        {    -131,      -20},
        {       0,       59},
        {    -170,       27},
        {      32,       99},
        {    -362,      184},
        {      30,       42},
        {    -846,      846},
        {   -1134,     -824},
        {    -515,     1012},
        {   -5762,    -1872},
        {    1618,   -10220},
        {   10785,        0},
        {    1099,     6941},
        {   -1845,      599},
        {     529,     1038},
        {   -1111,      807},
        {    -173,     -173},
        {    -233,      321},
        {    -163,      -83},
        {     -46,      143},
        {     -99,      -15},
        {       0,      110},
        {    -119,       18},
        {       8,       24},
        {     -70,       36}
    },
    {
        {       0,        0},     /* Filter 175 */
        {     -30,       93},
        {    -130,      -20},
        {       0,       60},
        {    -170,       26},
        {      32,      101},
        {    -362,      184},
        {      33,       46},
        {    -850,      850},
        {   -1130,     -821},
        {    -525,     1031},
        {   -5788,    -1880},
        {    1620,   -10234},
        {   10775,        0},
        {    1095,     6915},
        {   -1822,      592},
        {     532,     1045},
        {   -1107,      804},
        {    -169,     -169},
        {    -233,      321},
        {    -161,      -82},
        {     -47,      144},
        {     -98,      -15},
        {       0,      111},
        {    -119,       18},
        {       8,       25},
        {     -70,       36}
    },
    {
        {       0,        0},     /* Filter 176 */
        {     -30,       94},
        {    -130,      -20},
        {       0,       62},
        {    -170,       26},
        {      33,      103},
        {    -363,      184},
        {      36,       50},
        {    -854,      854},
        {   -1125,     -818},
        {    -535,     1050},
        {   -5814,    -1889},
        {    1623,   -10248},
        {   10765,        0},
        {    1091,     6889},
        {   -1800,      585},
        {     536,     1052},
        {   -1104,      802},
        {    -165,     -165},
        {    -234,      322},
        {    -159,      -81},
        {     -47,      145},
        {     -97,      -15},
        {       0,      111},
        {    -118,       18},
        {       8,       26},
        {     -70,       35}
    },
    {
        {       0,        0},     /* Filter 177 */
        {     -30,       95},
        {    -129,      -20},
        {       0,       63},
        {    -169,       26},
        {      34,      105},
        {    -363,      185},
        {      39,       54},
        {    -858,      858},
        {   -1121,     -814},
        {    -544,     1069},
        {   -5840,    -1897},
        {    1625,   -10262},
        {   10755,        0},
        {    1086,     6862},
        {   -1778,      577},
        {     539,     1059},
        {   -1100,      799},
        {    -161,     -161},
        {    -234,      323},
        {    -157,      -80},
        {     -47,      146},
        {     -96,      -15},
        {       0,      112},
        {    -117,       18},
        {       8,       26},
        {     -70,       35}
    },
    {
        {       0,        0},     /* Filter 178 */
        {     -31,       95},
        {    -129,      -20},
        {       0,       64},
        {    -169,       26},
        {      34,      107},
        {    -363,      185},
        {      42,       58},
        {    -861,      861},
        {   -1117,     -811},
        {    -554,     1088},
        {   -5866,    -1906},
        {    1627,   -10275},
        {   10744,        0},
        {    1082,     6836},
        {   -1756,      570},
        {     543,     1066},
        {   -1097,      797},
        {    -157,     -157},
        {    -235,      323},
        {    -155,      -79},
        {     -47,      147},
        {     -95,      -15},
        {       0,      113},
        {    -117,       18},
        {       8,       27},
        {     -70,       35}
    },
    {
        {       0,        0},     /* Filter 179 */
        {     -31,       96},
        {    -128,      -20},
        {       0,       65},
        {    -168,       26},
        {      35,      109},
        {    -363,      185},
        {      45,       62},
        {    -865,      865},
        {   -1112,     -808},
        {    -564,     1107},
        {   -5892,    -1914},
        {    1629,   -10289},
        {   10733,        0},
        {    1078,     6810},
        {   -1734,      563},
        {     546,     1073},
        {   -1093,      794},
        {    -153,     -153},
        {    -235,      324},
        {    -153,      -78},
        {     -48,      147},
        {     -94,      -14},
        {       0,      113},
        {    -116,       18},
        {       9,       28},
        {     -70,       35}
    },
    {
        {       0,        0},     /* Filter 180 */
        {     -31,       97},
        {    -128,      -20},
        {       0,       66},
        {    -168,       26},
        {      36,      111},
        {    -363,      185},
        {      48,       66},
        {    -869,      869},
        {   -1108,     -805},
        {    -573,     1126},
        {   -5918,    -1923},
        {    1631,   -10302},
        {   10723,        0},
        {    1074,     6784},
        {   -1712,      556},
        {     550,     1080},
        {   -1089,      791},
        {    -149,     -149},
        {    -235,      324},
        {    -151,      -77},
        {     -48,      148},
        {     -93,      -14},
        {       0,      114},
        {    -116,       18},
        {       9,       28},
        {     -69,       35}
    },
    {
        {       0,        0},     /* Filter 181 */
        {     -31,       97},
        {    -127,      -20},
        {       0,       67},
        {    -167,       26},
        {      36,      113},
        {    -363,      185},
        {      51,       71},
        {    -872,      872},
        {   -1103,     -801},
        {    -583,     1145},
        {   -5944,    -1931},
        {    1633,   -10316},
        {   10712,        0},
        {    1070,     6758},
        {   -1690,      549},
        {     553,     1086},
        {   -1086,      789},
        {    -145,     -145},
        {    -236,      324},
        {    -149,      -76},
        {     -48,      149},
        {     -92,      -14},
        {       0,      115},
        {    -115,       18},
        {       9,       29},
        {     -69,       35}
    },
    {
        {       0,        0},     /* Filter 182 */
        {     -31,       98},
        {    -126,      -20},
        {       0,       69},
        {    -167,       26},
        {      37,      115},
        {    -363,      185},
        {      54,       75},
        {    -876,      876},
        {   -1099,     -798},
        {    -593,     1164},
        {   -5970,    -1939},
        {    1636,   -10329},
        {   10701,        0},
        {    1066,     6731},
        {   -1668,      542},
        {     557,     1093},
        {   -1082,      786},
        {    -141,     -141},
        {    -236,      325},
        {    -147,      -75},
        {     -48,      149},
        {     -91,      -14},
        {       0,      116},
        {    -115,       18},
        {       9,       29},
        {     -69,       35}
    },
    {
        {       0,        0},     /* Filter 183 */
        {     -32,       99},
        {    -126,      -20},
        {       0,       70},
        {    -166,       26},
        {      38,      117},
        {    -363,      185},
        {      57,       79},
        {    -880,      880},
        {   -1094,     -795},
        {    -603,     1184},
        {   -5995,    -1948},
        {    1638,   -10342},
        {   10690,        0},
        {    1062,     6705},
        {   -1646,      534},
        {     560,     1100},
        {   -1078,      783},
        {    -137,     -137},
        {    -236,      325},
        {    -145,      -74},
        {     -48,      150},
        {     -89,      -14},
        {       0,      116},
        {    -114,       18},
        {       9,       30},
        {     -69,       35}
    },
    {
        {       0,        0},     /* Filter 184 */
        {     -32,       99},
        {    -125,      -19},
        {       0,       71},
        {    -166,       26},
        {      38,      119},
        {    -363,      185},
        {      60,       83},
        {    -884,      884},
        {   -1089,     -791},
        {    -613,     1203},
        {   -6021,    -1956},
        {    1640,   -10355},
        {   10679,        0},
        {    1057,     6679},
        {   -1624,      527},
        {     563,     1106},
        {   -1075,      781},
        {    -133,     -133},
        {    -237,      326},
        {    -143,      -73},
        {     -49,      151},
        {     -88,      -14},
        {       0,      117},
        {    -113,       18},
        {      10,       31},
        {     -69,       35}
    },
    {
        {       0,        0},     /* Filter 185 */
        {     -32,      100},
        {    -125,      -19},
        {       0,       72},
        {    -165,       26},
        {      39,      121},
        {    -363,      185},
        {      63,       87},
        {    -887,      887},
        {   -1084,     -788},
        {    -623,     1223},
        {   -6047,    -1964},
        {    1642,   -10368},
        {   10668,        0},
        {    1053,     6652},
        {   -1602,      520},
        {     567,     1113},
        {   -1071,      778},
        {    -129,     -129},
        {    -237,      326},
        {    -141,      -72},
        {     -49,      151},
        {     -87,      -13},
        {       0,      118},
        {    -113,       17},
        {      10,       31},
        {     -68,       35}
    },
    {
        {       0,        0},     /* Filter 186 */
        {     -32,      100},
        {    -124,      -19},
        {       0,       73},
        {    -165,       26},
        {      40,      124},
        {    -363,      184},
        {      66,       91},
        {    -891,      891},
        {   -1080,     -784},
        {    -633,     1242},
        {   -6073,    -1973},
        {    1644,   -10381},
        {   10656,        0},
        {    1049,     6626},
        {   -1581,      513},
        {     570,     1119},
        {   -1067,      775},
        {    -125,     -125},
        {    -237,      326},
        {    -139,      -71},
        {     -49,      152},
        {     -86,      -13},
        {       0,      118},
        {    -112,       17},
        {      10,       32},
        {     -68,       35}
    },
    {
        {       0,        0},     /* Filter 187 */
        {     -33,      101},
        {    -124,      -19},
        {       0,       75},
        {    -164,       26},
        {      40,      126},
        {    -362,      184},
        {      69,       96},
        {    -894,      894},
        {   -1075,     -781},
        {    -643,     1262},
        {   -6099,    -1981},
        {    1646,   -10393},
        {   10645,        0},
        {    1045,     6599},
        {   -1559,      506},
        {     573,     1125},
        {   -1063,      772},
        {    -121,     -121},
        {    -237,      327},
        {    -137,      -70},
        {     -49,      153},
        {     -85,      -13},
        {       0,      119},
        {    -111,       17},
        {      10,       33},
        {     -68,       34}
    },
    {
        {       0,        0},     /* Filter 188 */
        {     -33,      102},
        {    -123,      -19},
        {       0,       76},
        {    -164,       26},
        {      41,      128},
        {    -362,      184},
        {      72,      100},
        {    -898,      898},
        {   -1070,     -777},
        {    -653,     1281},
        {   -6124,    -1990},
        {    1648,   -10406},
        {   10633,        0},
        {    1041,     6573},
        {   -1538,      499},
        {     576,     1131},
        {   -1059,      769},
        {    -118,     -118},
        {    -238,      327},
        {    -135,      -69},
        {     -49,      153},
        {     -84,      -13},
        {       0,      120},
        {    -111,       17},
        {      10,       33},
        {     -68,       34}
    },
    {
        {       0,        0},     /* Filter 189 */
        {     -33,      102},
        {    -122,      -19},
        {       0,       77},
        {    -163,       25},
        {      42,      130},
        {    -362,      184},
        {      76,      104},
        {    -901,      901},
        {   -1065,     -773},
        {    -663,     1301},
        {   -6150,    -1998},
        {    1650,   -10418},
        {   10621,        0},
        {    1036,     6546},
        {   -1516,      492},
        {     579,     1137},
        {   -1055,      767},
        {    -114,     -114},
        {    -238,      327},
        {    -133,      -68},
        {     -50,      154},
        {     -83,      -13},
        {       0,      120},
        {    -110,       17},
        {      11,       34},
        {     -68,       34}
    },
    {
        {       0,        0},     /* Filter 190 */
        {     -33,      103},
        {    -122,      -19},
        {       0,       78},
        {    -163,       25},
        {      43,      132},
        {    -362,      184},
        {      79,      108},
        {    -905,      905},
        {   -1059,     -770},
        {    -673,     1321},
        {   -6176,    -2006},
        {    1652,   -10431},
        {   10609,        0},
        {    1032,     6520},
        {   -1495,      485},
        {     582,     1143},
        {   -1051,      764},
        {    -110,     -110},
        {    -238,      328},
        {    -131,      -67},
        {     -50,      154},
        {     -82,      -13},
        {       0,      121},
        {    -110,       17},
        {      11,       34},
        {     -67,       34}
    },
    {
        {       0,        0},     /* Filter 191 */
        {     -33,      104},
        {    -121,      -19},
        {       0,       79},
        {    -162,       25},
        {      43,      134},
        {    -362,      184},
        {      82,      113},
        {    -909,      909},
        {   -1054,     -766},
        {    -683,     1341},
        {   -6201,    -2015},
        {    1654,   -10443},
        {   10597,        0},
        {    1028,     6493},
        {   -1473,      478},
        {     585,     1149},
        {   -1048,      761},
        {    -106,     -106},
        {    -238,      328},
        {    -129,      -66},
        {     -50,      155},
        {     -80,      -12},
        {       0,      122},
        {    -109,       17},
        {      11,       35},
        {     -67,       34}
    }
};
