/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#ifndef _HYANTES_MODULE_H
#define _HYANTES_MODULE_H

#include "computing.h"

/** 
* @brief structure containing precomputed values
* of a given hs_potential_t
*/
typedef struct extra
{
    double cos[4]; /**< array containing { cos(mLat), cos(mLon), cos(MLat), cos(MLon) } */
    double sin[4]; /**< array containing { sin(mLat), sin(mLon), sin(MLat), sin(MLon) } */
} extra_t;

/** 
* @brief structure containing parameters for the
* make_all_pot function
*/
struct make_pot_param
{
                                          /*@temp@ */ const planartree *ptrees;
                                          /**< pointer to a valid planartree */
                                      /*@temp@ */ const extra_t *extra;
                                      /**< pointer to precomuted values of the potential in ptrees, in the same order*/
};


/* computes the potential from ITER to ITER+NB_ITER using data from PARAM and fills ITER accordingly */
#ifdef __cplusplus
extern "C"
#endif
int make_all_pot(hs_potential_t * iter, size_t nb_iter,
   const struct make_pot_param *param)
/*@modifies iter@*/ ;

extern
#ifdef __cplusplus
   "C"
#endif
unsigned long get_status();

#endif
