/*
 * nbtk-label.h: Plain label actor
 *
 * Copyright 2008, 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 * Boston, MA 02111-1307, USA.
 *
 * Written by: Thomas Wood <thomas@linux.intel.com>
 *
 */


#ifndef __NBTK_IM_LABEL_H__
#define __NBTK_IM_LABEL_H__

G_BEGIN_DECLS

#include <nbtk/nbtk.h>

#define NBTK_TYPE_IM_LABEL             (nbtk_im_label_get_type ())
#define NBTK_IM_LABEL(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), NBTK_TYPE_IM_LABEL, NbtkIMLabel))
#define NBTK_IS_IM_LABEL(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NBTK_TYPE_IM_LABEL))
#define NBTK_IM_IM_LABEL_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), NBTK_TYPE_IM_LABEL, NbtkIMLabelClass))
#define NBTK_IS_IM_LABEL_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), NBTK_TYPE_IM_LABEL))
#define NBTK_IM_IM_LABEL_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), NBTK_TYPE_IM_LABEL, NbtkIMLabelClass))

typedef struct _NbtkIMLabel              NbtkIMLabel;
typedef struct _NbtkIMLabelPrivate       NbtkIMLabelPrivate;
typedef struct _NbtkIMLabelClass         NbtkIMLabelClass;

/**
 * NbtkIMLabel:
 *
 * The contents of this structure is private and should only be accessed using
 * the provided API.
 */
struct _NbtkIMLabel
{
  /*< private >*/
  NbtkWidget parent_instance;

  NbtkIMLabelPrivate *priv;
};

struct _NbtkIMLabelClass
{
  NbtkWidgetClass parent_class;
};

GType nbtk_im_label_get_type (void) G_GNUC_CONST;

NbtkWidget *          nbtk_im_label_new              (const gchar *text);
G_CONST_RETURN gchar *nbtk_im_label_get_text         (NbtkIMLabel *label);
void                  nbtk_im_label_set_text         (NbtkIMLabel *label,
                                                      const gchar *text);
ClutterActor *        nbtk_im_label_get_clutter_text (NbtkIMLabel *label);

G_END_DECLS

#endif /* __NBTK_IM_LABEL_H__ */
