#include <nbtk/nbtk.h>

#include "hrn-sidebar.h"
#include "hrn-sidebar-item.h"
#include "hrn-sidebar-item-factory.h"

struct _HrnSidebarItemFactoryPrivate {
    HrnSidebar *sidebar;
    HrnPinManager *pin_manager;

    GList *sidebar_items;
};

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HRN_TYPE_SIDEBAR_ITEM_FACTORY, HrnSidebarItemFactoryPrivate))

static void item_factory_init (NbtkItemFactoryIface *iface);
G_DEFINE_TYPE_WITH_CODE (HrnSidebarItemFactory, hrn_sidebar_item_factory, G_TYPE_OBJECT,
                         G_IMPLEMENT_INTERFACE (NBTK_TYPE_ITEM_FACTORY,
                                                item_factory_init));

static void
hrn_sidebar_item_factory_finalize (GObject *object)
{
    G_OBJECT_CLASS (hrn_sidebar_item_factory_parent_class)->finalize (object);
}

static void
hrn_sidebar_item_factory_dispose (GObject *object)
{
    G_OBJECT_CLASS (hrn_sidebar_item_factory_parent_class)->dispose (object);
}

static void
hrn_sidebar_item_factory_set_property (GObject      *object,
                                       guint         prop_id,
                                       const GValue *value,
                                       GParamSpec   *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_sidebar_item_factory_get_property (GObject    *object,
                                       guint       prop_id,
                                       GValue     *value,
                                       GParamSpec *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_sidebar_item_factory_class_init (HrnSidebarItemFactoryClass *klass)
{
    GObjectClass *o_class = (GObjectClass *) klass;

    o_class->dispose = hrn_sidebar_item_factory_dispose;
    o_class->finalize = hrn_sidebar_item_factory_finalize;
    o_class->set_property = hrn_sidebar_item_factory_set_property;
    o_class->get_property = hrn_sidebar_item_factory_get_property;

    g_type_class_add_private (klass, sizeof (HrnSidebarItemFactoryPrivate));
}

static void
source_changed_cb (HrnSidebarItem        *item,
                   HrnSource             *source,
                   int                    filter,
                   const char            *query_name,
                   HrnSidebarItemFactory *factory)
{
    HrnSidebarItemFactoryPrivate *priv = factory->priv;
    GList *l;

    hrn_sidebar_change_source (priv->sidebar, source, filter, query_name);

    for (l = priv->sidebar_items; l; l = l->next) {
        HrnSidebarItem *i = (HrnSidebarItem *) l->data;
        hrn_sidebar_item_set_selected (i, i == item);
    }
}

static void
item_destroyed (gpointer data,
                GObject *dead_object)
{
    HrnSidebarItemFactory *factory = (HrnSidebarItemFactory *) data;
    HrnSidebarItemFactoryPrivate *priv = factory->priv;

    priv->sidebar_items = g_list_remove (priv->sidebar_items, dead_object);
}

static ClutterActor *
create_item (NbtkItemFactory *factory)
{
    HrnSidebarItemFactory *item_factory = (HrnSidebarItemFactory *) factory;
    HrnSidebarItemFactoryPrivate *priv = item_factory->priv;
    HrnSidebarItem *item;

    item = g_object_new (HRN_TYPE_SIDEBAR_ITEM,
                         "pin-manager", priv->pin_manager,
                         NULL);
    clutter_actor_set_width (CLUTTER_ACTOR (item), 40);
    g_signal_connect (item, "source-changed",
                      G_CALLBACK (source_changed_cb), factory);
    g_object_weak_ref ((GObject *) item, item_destroyed, factory);

    if (priv->sidebar_items == NULL) {
        /* Select the first item */
        hrn_sidebar_item_select_initial (item);
    }

    priv->sidebar_items = g_list_prepend (priv->sidebar_items, item);

    return (ClutterActor *) item;
}

static void
item_factory_init (NbtkItemFactoryIface *iface)
{
    iface->create = create_item;
}

static void
hrn_sidebar_item_factory_init (HrnSidebarItemFactory *self)
{
    self->priv = GET_PRIVATE (self);
}

HrnSidebarItemFactory *
hrn_sidebar_item_factory_new (HrnSidebar    *sidebar,
                              HrnPinManager *pin_manager)
{
    HrnSidebarItemFactory *factory;
    HrnSidebarItemFactoryPrivate *priv;

    factory = g_object_new (HRN_TYPE_SIDEBAR_ITEM_FACTORY, NULL);
    priv = factory->priv;

    priv->sidebar = sidebar;
    priv->pin_manager = pin_manager;

    return factory;
}
