{- This module was generated from data in the Kate syntax
   highlighting file noweb.xml, version 1.0, by Scott Collins (scc@scottcollins.net) -}

module Text.Highlighting.Kate.Syntax.Noweb
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Html
import qualified Text.Highlighting.Kate.Syntax.Cpp
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)

-- | Full name of language.
syntaxName :: String
syntaxName = "noweb"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.w;*.nw"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "noweb" }
  context <- currentContext <|> (pushContext "RawDocumentation" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("noweb",["RawDocumentation"])], synStLanguage = "noweb", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "RawDocumentation" -> return ()
    "CodeQuote" -> return ()
    "CodeSection" -> return ()
    "SectionNames" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))


regex_'3c'3c'2e'2a'3e'3e'3d'24 = compileRegex "<<.*>>=$"
regex_'5c'5d'5c'5d'28'3f'21'5c'5d'29 = compileRegex "\\]\\](?!\\])"
regex_'40'24 = compileRegex "@$"
regex_'40'28'3f'3d'5b'5cs'25'5d'29 = compileRegex "@(?=[\\s%])"
regex_'40'3c'3c = compileRegex "@<<"
regex_'3c'3c'2e'2a'5b'5e'40'5d'3e'3e'28'3f'21'3d'29 = compileRegex "<<.*[^@]>>(?!=)"

defaultAttributes = [("RawDocumentation",NormalTok),("CodeQuote",NormalTok),("CodeSection",NormalTok),("SectionNames",NormalTok)]

parseRules "RawDocumentation" =
  (((pColumn 0 >> pRegExpr regex_'3c'3c'2e'2a'3e'3e'3d'24 >>= withAttribute RegionMarkerTok) >>~ pushContext "CodeSection")
   <|>
   ((pDetect2Chars False '@' '[' >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '[' '[' >>= withAttribute RegionMarkerTok) >>~ pushContext "CodeQuote")
   <|>
   ((Text.Highlighting.Kate.Syntax.Html.parseExpression)))

parseRules "CodeQuote" =
  (((pDetect2Chars False '@' ']' >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'5d'5c'5d'28'3f'21'5c'5d'29 >>= withAttribute RegionMarkerTok) >>~ (popContext))
   <|>
   ((parseRules "SectionNames"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Cpp.parseExpression)))

parseRules "CodeSection" =
  (((pColumn 0 >> pRegExpr regex_'40'24 >>= withAttribute RegionMarkerTok) >>~ pushContext "RawDocumentation")
   <|>
   ((pColumn 0 >> pRegExpr regex_'40'28'3f'3d'5b'5cs'25'5d'29 >>= withAttribute RegionMarkerTok) >>~ pushContext "RawDocumentation")
   <|>
   ((pColumn 0 >> lookAhead (pRegExpr regex_'3c'3c'2e'2a'3e'3e'3d'24) >> pushContext "RawDocumentation" >> currentContext >>= parseRules))
   <|>
   ((parseRules "SectionNames"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Cpp.parseExpression)))

parseRules "SectionNames" =
  (((pRegExpr regex_'40'3c'3c >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'3c'3c'2e'2a'5b'5e'40'5d'3e'3e'28'3f'21'3d'29 >>= withAttribute RegionMarkerTok)))

parseRules "" = parseRules "RawDocumentation"

parseRules x = fail $ "Unknown context" ++ x
