module Language.Haskell.Hsx (
	  module Language.Haskell.Hsx.Syntax
	, module Language.Haskell.Hsx.Build
	, module Language.Haskell.Hsx.Parser
	, module Language.Haskell.Hsx.Pretty
	, module Language.Haskell.Hsx.Transform
	, parseFileContents
	, parseFileContentsWithMode
	, parseFile
	) where

import Language.Haskell.Hsx.Build
import Language.Haskell.Hsx.Syntax
import Language.Haskell.Hsx.Parser
import Language.Haskell.Hsx.Pretty
import Language.Haskell.Hsx.Transform

parseFile :: FilePath -> IO (ParseResult HsModule)
parseFile fp = readFile fp >>= (return . parseFileContentsWithMode (ParseMode fp))

parseFileContents :: String -> ParseResult HsModule
parseFileContents = parseFileContentsWithMode defaultParseMode

parseFileContentsWithMode :: ParseMode -> String -> ParseResult HsModule
parseFileContentsWithMode p rawStr =
	let cleanStr = unlines [ s | s@(c:_) <- lines rawStr, c /= '#' ]
	 in parseModuleWithMode p cleanStr
