# -- coding: utf-8
"""
macros.py - Defining macro variables for use by other
modules.

Created Anand B Pillai <abpillai at gmail dot com> Oct 5 2007

Copyright (C) 2007, Anand B Pillai.
"""

class HarvestManMacroVariable(type):
    """ A metaclass for HarvestMan macro variables """
    
    PIDX = 0
    NIDX = 0
    macrodict = {}
    
    def __new__(cls, name, bases=(), dct={}):

        val = dct.get('value')
        if val != None:
            dct['index'] = val
            
        elif dct.get('negate'):
            cls.NIDX -= 1
            dct['index'] = cls.NIDX
        else:
            cls.PIDX += 1
            dct['index'] = cls.PIDX
            
        item = type.__new__(cls, name, bases, dct)
        cls.macrodict[name] = item
        return item

    def __str__(self):
        return '%d' % (self.index)

    def __eq__(self, number):
        # Makes it easy to do things like
        # THREAD_IDLE == 0 in code.
        return self.index == number

    def __lt__(self, number):

        return self.index < number

    def __gt__(self, number):

        return self.index > number

    def __le__(self, number):

        return self.index <= number

    def __ge__(self, number):

        return self.index >= number
    
    
def DEFINE_MACRO(name, val=None):
    """ A factory function for defining macros """

    if val != None:
        globals()[name] = HarvestManMacroVariable(name, dct={'value': val})
    else:
        globals()[name] = HarvestManMacroVariable(name)

def DEFINE_NEGATIVE_MACRO(name, val=None):
    """ A factory function for defining macros with negative values """

    if val != None:
        globals()[name] = HarvestManMacroVariable(name, dct={'value': val,'negate': True})
    else:
        globals()[name] = HarvestManMacroVariable(name, dct={'negate': True})


def SUCCESS(status):
    return (status > 0)
    
DEFINE_ERROR_MACRO = DEFINE_NEGATIVE_MACRO

# Special (predefined) macros
DEFINE_MACRO("HARVESTMAN_OK", 1)
DEFINE_MACRO("HARVESTMAN_FAIL", -1)
DEFINE_MACRO("OPTION_TURN_OFF", 0)
DEFINE_MACRO("OPTION_TURN_ON", 1)
DEFINE_MACRO("CONNECTOR_DATA_MODE_FLUSH", 0)
DEFINE_MACRO("CONNECTOR_DATA_MODE_INMEM", 1)

# Success macros
DEFINE_MACRO("RESTORE_STATE_OK")
DEFINE_MACRO("SAVE_STATE_OK")
DEFINE_MACRO("CONFIG_FILE_EXISTS")
DEFINE_MACRO("CONFIG_FILE_PARSE_OK")
DEFINE_MACRO("CONFIG_OPTION_SET")
DEFINE_MACRO("CONFIG_ITEM_SKIPPED")
DEFINE_MACRO("CONFIG_OPTION_NOT_DEFINED")
DEFINE_MACRO("CONFIG_ARGUMENT_OK")
DEFINE_MACRO("CONFIG_ARGUMENTS_OK")
DEFINE_MACRO("PROJECT_FILE_EXISTS", 0)
DEFINE_MACRO("CONFIGURE_PROTOCOL_OK")
DEFINE_MACRO("CONNECT_MULTIPART_DOWNLOAD")
DEFINE_MACRO("CONNECT_NO_UPTODATE")
DEFINE_MACRO("CONNECT_YES_DOWNLOADED")
DEFINE_MACRO("DOWNLOAD_YES_WITH_MODIFICATION")
DEFINE_MACRO("DOWNLOAD_NO_UPTODATE")
DEFINE_MACRO("DOWNLOAD_NO_CACHE_SYNCED")
DEFINE_MACRO("DOWNLOAD_YES_OK")
DEFINE_MACRO("URL_PUSHED_TO_POOL")
DEFINE_MACRO("CREATE_DIRECTORY_OK")
DEFINE_MACRO("URL_DOWNLOAD_OK")
DEFINE_MACRO("DATA_ALREADY_PRESENT")
DEFINE_MACRO("FILE_WRITE_OK")
DEFINE_MACRO("WRITE_URL_OK")
DEFINE_MACRO("DUMP_URL_OK")
DEFINE_MACRO("PROJECT_FILE_READ_OK")
DEFINE_MACRO("PROJECT_FILE_WRITE_OK")
DEFINE_MACRO("WRITE_URL_HEADERS_OK")
DEFINE_MACRO("BROWSE_FILE_WRITE_OK")
DEFINE_MACRO("LINK_FILTERED")
DEFINE_MACRO("LINK_NOT_FILTERED")
DEFINE_MACRO("LINK_EMPTY")
DEFINE_MACRO("ANCHOR_LINK_FOUND")
DEFINE_MACRO("SET_STATE_OK")
DEFINE_MACRO("THREAD_MIGRATION_OK")
DEFINE_MACRO("MULTIPART_DOWNLOAD_QUEUED")
DEFINE_MACRO("MULTIPART_DOWNLOAD_COMPLETED")
DEFINE_MACRO("MULTIPART_DOWNLOAD_STATUS_UNKNOWN")
DEFINE_MACRO("HGET_DOWNLOAD_OK")

# Error macros
DEFINE_ERROR_MACRO("SAVE_STATE_NOT_OK")
DEFINE_ERROR_MACRO("RESTORE_STATE_NOT_OK")
DEFINE_ERROR_MACRO("CONFIG_FILE_DOES_NOT_EXIST")
DEFINE_ERROR_MACRO("CONFIG_FILE_PARSE_ERROR")
DEFINE_ERROR_MACRO("CONFIG_VALUE_EMPTY")
DEFINE_ERROR_MACRO("CONFIG_VALUE_MISMATCH")
DEFINE_ERROR_MACRO("CONFIG_OPTION_NOT_SET")
DEFINE_ERROR_MACRO("CONFIG_OPTION_ASSIGN_ERROR")
DEFINE_ERROR_MACRO("CONFIG_INVALID_ARGUMENT")
DEFINE_ERROR_MACRO("CONFIG_ARGUMENT_ERROR")
DEFINE_ERROR_MACRO("CONNECT_NO_RULE_VIOLATION")
DEFINE_ERROR_MACRO("CONNECT_NO_ERROR")
DEFINE_ERROR_MACRO("CONNECT_DOWNLOAD_ABORTED")
DEFINE_ERROR_MACRO("DOWNLOAD_NO_ERROR")
DEFINE_ERROR_MACRO("DOWNLOAD_NO_RULE_VIOLATION")
DEFINE_ERROR_MACRO("DOWNLOAD_NO_CACHE_SYNC")
DEFINE_ERROR_MACRO("CREATE_DIRECTORY_NOT_OK")
DEFINE_ERROR_MACRO("URL_DOWNLOAD_FAILED")
DEFINE_ERROR_MACRO("DATA_DOWNLOAD_ERROR")
DEFINE_ERROR_MACRO("DATA_EMPTY_ERROR")
DEFINE_ERROR_MACRO("FILE_WRITE_ERROR")
DEFINE_ERROR_MACRO("WRITE_URL_FAILED")
DEFINE_ERROR_MACRO("NULL_URLOBJECT_ERROR")
DEFINE_ERROR_MACRO("INVALID_ARCHIVE_FORMAT")
DEFINE_ERROR_MACRO("FILE_TRUNCATE_ERROR")
DEFINE_ERROR_MACRO("DUMP_URL_ERROR")
DEFINE_ERROR_MACRO("PROJECT_FILE_READ_ERROR")
DEFINE_ERROR_MACRO("PROJECT_FILE_WRITE_ERROR")
DEFINE_ERROR_MACRO("PROJECT_FILE_REMOVE_ERROR")
DEFINE_ERROR_MACRO("WRITE_URL_HEADERS_ERROR")
DEFINE_ERROR_MACRO("BROWSE_FILE_NOT_FOUND")
DEFINE_ERROR_MACRO("BROWSE_FILE_READ_ERROR")
DEFINE_ERROR_MACRO("BROWSE_FILE_EMPTY")
DEFINE_ERROR_MACRO("BROWSE_FILE_INVALID")
DEFINE_ERROR_MACRO("BROWSE_FILE_WRITE_ERROR")
DEFINE_ERROR_MACRO("ANCHOR_LINK_NOT_FOUND")
DEFINE_ERROR_MACRO("SET_STATE_ERROR")
DEFINE_ERROR_MACRO("THREAD_MIGRATION_ERROR")
DEFINE_ERROR_MACRO("MULTIPART_DOWNLOAD_ERROR")
DEFINE_ERROR_MACRO("HGET_FATAL_ERROR")
DEFINE_ERROR_MACRO("HGET_KEYBOARD_INTERRUPT")
DEFINE_ERROR_MACRO("HGET_DOWNLOAD_ERROR")
DEFINE_ERROR_MACRO("MIRRORS_NOT_FOUND")


if __name__ == "__main__":
    for key, val in HarvestManMacroVariable.macrodict.iteritems():
        print key,'=>',val.index
