/*
 * Copyright (C) 2011 Hermann Meyer, Andreas Degert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * ---------------------------------------------------------------------------
 *
 *        file: gxtuner.h   guitar tuner for jack
 *
 * ----------------------------------------------------------------------------
 */

#pragma once

#ifndef SRC_HEADERS_TUNER_H_
#define SRC_HEADERS_TUNER_H_

#include <jack/jack.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gtk/gtkprivate.h>
#include <math.h>
#include <fftw3.h>
#include <semaphore.h>
#include <assert.h> 
#include <pthread.h>

#include <cstring> 
#include <string> 
#include <cmath>
#include <cstdlib>

#include <zita-resampler.h>


G_BEGIN_DECLS

#define GX_TYPE_TUNER          (gx_tuner_get_type())
#define GX_TUNER(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), GX_TYPE_TUNER, GxTuner))
#define GX_IS_TUNER(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GX_TYPE_TUNER))
#define GX_TUNER_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass),  GX_TYPE_TUNER, GxTunerClass))
#define GX_IS_TUNER_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass),  GX_TYPE_TUNER))

typedef struct _GxTuner GxTuner;
typedef struct _GxTunerClass GxTunerClass;

struct _GxTuner
{
    GtkDrawingArea parent;
    double GSEAL (freq);
};

struct _GxTunerClass
{
    GtkDrawingAreaClass parent_class;
    /*< private >*/
    cairo_surface_t *surface_tuner;
};


GType gx_tuner_get_type();

void gx_tuner_set_freq(GxTuner *tuner, double freq);
GtkWidget *gx_tuner_new(void);

G_END_DECLS

namespace gx_jack {

    static bool gx_jack_init();
    static int gx_jack_process(jack_nframes_t nframes, void *arg);
    void jack_shutdown (void *arg);
    std::string         client_name;
    jack_client_t*      client;
    jack_status_t       jackstat;
    jack_port_t*        input_port;
    jack_nframes_t      jack_sr;   // jack sample rate
    jack_nframes_t      jack_bs;   // jack buffer size
}
namespace gx_gui {
    float               fConsta4;
    GtkWidget*          tuner;
    int                 g_threads;
}

namespace gx_engine {
/* ------------- Pitch Tracker ------------- */

const int MAX_FFT_SIZE = 512; // The size of the read buffer (max FFT window size).

class PitchTracker {
 public:
    PitchTracker();
    ~PitchTracker();
    bool                pt_initialized;
    bool                setParameters(int sampleRate, int fftSize );
    void                init()
                        {setParameters(static_cast<int>(gx_jack::jack_sr), MAX_FFT_SIZE);}
    void                add(int count, float *input);
    float               tuner_estimate();

 private:
    void                run();
    static void*        static_run(void* p);
    void                setEstimatedFrequency(float freq);
    int                 find_minimum();
    int                 find_maximum(int l);
    void                start_thread();
    void                copy();
    bool                error;
    volatile bool       busy;
    int                 tick;
    sem_t               m_trig;
    pthread_t           m_pthr;
    Resampler           resamp;
    int                 m_sampleRate;
    // Size of the FFT window.
    int                 m_fftSize;
    // The audio buffer that stores the input signal.
    float*              m_buffer;
    // Index of the first empty position in the buffer.
    int                 m_bufferIndex;
    // Whether or not the input level is high enough.
    bool                m_audioLevel;
    // Support buffer used to store signals in the time domain.
    float*              m_fftwBufferTime;
    // Support buffer used to store signals in the frequency domain.
    fftwf_complex*      m_fftwBufferFreq;
    // Plan to compute the FFT of a given signal.
    fftwf_plan          m_fftwPlanFFT;
    // Plan to compute the IFFT of a given signal (with additional zero-padding).
    fftwf_plan          m_fftwPlanIFFT;
};

extern PitchTracker pitch_tracker;
}

#endif // SRC_HEADERS_TUNER_H_
