// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Hash wrapper functions for uniform hash interface
// ****************************************************************************

// Copyright 2008, 2009, 2010 Guy Voncken
//
// This file is part of guymager.
//
// guymager is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// guymager is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with guymager. If not, see <http://www.gnu.org/licenses/>.

#ifndef __HASH_H__
#define __HASH_H__

#ifndef __COMMON_H__
   #include "common.h"
#endif

#ifdef USE_MD5_FROM_OPENSSL   // Only for test purposes; It is strongly recommended to use the local md5 functions in order to avoid an OpenSSL dependency
   #include <openssl/md5.h>
   typedef MD5_CTX t_HashContextMD5;
#else
   #include "md5.h"
   typedef md5_state_t t_HashContextMD5;
#endif
typedef t_HashContextMD5 *t_pHashContextMD5;

#include "sha256.h"
typedef sha256_context  t_HashContextSHA256;
typedef sha256_context *t_pHashContextSHA256;



class QString;

const int HASH_MD5_DIGEST_LENGTH    = 16;
const int HASH_SHA256_DIGEST_LENGTH = 32;

typedef struct
{
   unsigned char Buff[HASH_MD5_DIGEST_LENGTH];
} t_HashMD5Digest, *t_pHashMD5Digest;

typedef struct
{
   unsigned char Buff[HASH_SHA256_DIGEST_LENGTH];
} t_HashSHA256Digest, *t_pHashSHA256Digest;

APIRET HashMD5Init      (t_pHashContextMD5 pContext);
APIRET HashMD5Append    (t_pHashContextMD5 pContext, const void *pData, int DataLen);
APIRET HashMD5Digest    (t_pHashContextMD5 pContext, t_pHashMD5Digest pDigest);
APIRET HashMD5DigestStr (t_pHashMD5Digest pDigest, QString &Str);
bool   HashMD5Match     (t_pHashMD5Digest pDigest1, t_pHashMD5Digest pDigest2);

APIRET HashSHA256Init      (t_pHashContextSHA256 pContext);
APIRET HashSHA256Append    (t_pHashContextSHA256 pContext, void *pData, int DataLen);
APIRET HashSHA256Digest    (t_pHashContextSHA256 pContext, t_pHashSHA256Digest pDigest);
APIRET HashSHA256DigestStr (t_pHashSHA256Digest pDigest, QString &Str);
bool   HashSHA256Match     (t_pHashSHA256Digest pDigest1, t_pHashSHA256Digest pDigest2);


APIRET HashInit   (void);
APIRET HashDeInit (void);

// ------------------------------------
//             Error codes
// ------------------------------------

enum
{
   ERROR_HASH_ = ERROR_BASE_HASH + 1,
};

#endif


