// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************


#ifndef __MAINWINDOW_H__
#define __MAINWINDOW_H__

#include <QtGui>  //lint !e537 repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif
#ifndef __DEVICE_H__
   #include "device.h"
#endif

class t_MainWindowLocal;

class t_MainWindow: public QMainWindow
{
   Q_OBJECT

   public:
      t_MainWindow (void);
      t_MainWindow (t_pDeviceList pDeviceList, QWidget *pParent = 0, Qt::WFlags Flags = 0);
     ~t_MainWindow ();

   private:
      APIRET CreateMenu (void);

   protected:
      void closeEvent (QCloseEvent *pEvent);

   private slots:
      void SlotDebug         (void);
      void SlotAboutGuymager (void);
      void SlotAboutQt       (void);
      void SlotScanFinished  (t_pDeviceList);
      void SlotRefresh       ();

   private:
      t_MainWindowLocal *pOwn;
};

// ------------------------------------
//             Error codes
// ------------------------------------

enum
{
   ERROR_MAINWINDOW_CONSTRUCTOR_NOT_SUPPORTED = ERROR_BASE_MAINWINDOW + 1,
   ERROR_MAINWINDOW_INVALID_COLUMN,
   ERROR_MAINWINDOW_INVALID_DATATYPE
};


#endif

