// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Error handling utilities
// ****************************************************************************


#include <stdarg.h>
#include <stdlib.h>

#include <QtGui>

#include "common.h"
#include "qtutil.h"


// -----------------------
//     Constants
// -----------------------

static const int EXIT_SLEEP_BEFORE_EXIT = 3000; // ms

// -----------------------
//     Local variables
// -----------------------

static int ErrorPopupCounter = 0;


// -----------------------
//       Functions
// -----------------------

void ErrorExit (int ExitCode)
{
   LOG_ERROR ("Exiting GUYMAGER with code %d", ExitCode)
   printf ("\n\n");

   (void) QtUtilSleep (EXIT_SLEEP_BEFORE_EXIT); // Quite often, the last messages of the slave cannot be
   exit (ExitCode);
}


void ErrorPopupExit (const char *pFileName, const char *pFunctionName, int LineNr, APIRET ec, const char *pMsg)
{
   const char *pErr;
   QString      MsgTxt;

   if (ErrorPopupCounter < 3)   // If there are already several windows, then they are most probably generated by a timer and we risk
   {                    // to fill up the screen without being able to click them all away. So, we simply exit here.
      ErrorPopupCounter++;
      (void) ToolErrorCheck (pFileName, pFunctionName, LineNr, ec);
      pErr = ToolErrorMessage(ec);
      if (pMsg)
           MsgTxt = QString(pMsg) + QString("\n") + QString(pErr);
      else MsgTxt = pErr;
      (void) QMessageBox::critical (0, "Internal error", MsgTxt);
   }
   ErrorExit ();
}

APIRET ErrorInit (void)
{
   CHK (TOOL_ERROR_REGISTER_CODE (ERROR_QT_UNSUCCESSFUL))
   return NO_ERROR;
}

APIRET ErrorDeInit (void)
{
   return NO_ERROR;
}


