// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Directory selection dialog
// ****************************************************************************


#ifndef __DLGDIRSEL_H__
#define __DLGDIRSEL_H__

#include <QtGui> //lint !e537 Repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif


class t_DlgDirSelLocal;

class t_DlgDirSel: public QDialog
{
   Q_OBJECT

   public:
      t_DlgDirSel ();
      t_DlgDirSel (QString *pPath, QWidget *pParent=NULL, Qt::WFlags Flags=0);
     ~t_DlgDirSel ();

   private:
      t_DlgDirSelLocal *pOwn;

   private slots:
      void SlotAccept         (void);
      void SlotCurrentChanged (const QModelIndex &Current);
      void SlotContextMenu    (const QPoint &Position);
};

enum
{
   ERROR_DLGDIRSEL_CONSTRUCTOR_NOT_SUPPORTED = ERROR_BASE_DLGDIRSEL + 1,
};

#endif

