/*
 * Copyright (C) 1997, 1998  Free Software Foundation
 * Copyright (C) 1994, 1995 Eric M. Ludlam
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.org
 *
 * $Log: gtalkd.h,v $
 * Revision 1.15  1998/10/11 11:41:27  zappo
 * Changed GTALK_VERSION to VERSION for automake.
 *
 * Revision 1.14  1998/02/15 13:57:25  zappo
 * Added extended name buffers to the RequestObject to prevent buffer
 * overflows.
 *
 * Revision 1.13  1998/01/04 15:16:14  zappo
 * Update copyright year.
 *
 * Revision 1.12  1997/12/14 19:18:45  zappo
 * Renamed package to gtalk, renamed symbols and files apropriately
 * Fixed copyright and email address.
 *
 * Revision 1.11  1997/12/02 22:53:04  zappo
 * Added filter file data to struct, and prototypes for accessors.
 *
 * Revision 1.10  1997/07/27 20:40:08  zappo
 * Deamon's objects now use the generic list
 *
 * Revision 1.9  1997/01/26 15:34:13  zappo
 * Now uses GTALK_VERSION which is a string for the GTALKD_ macro
 *
 * Revision 1.8  1995/12/10  03:52:18  zappo
 * Added gtd_disp.c prototypes
 *
 * Revision 1.7  1995/09/22  13:50:53  zappo
 * Added _answer_ field to request object for filtering of duplicate
 * announcements
 *
 * Revision 1.6  1995/07/21  02:22:48  zappo
 * Changed version number
 *
 * Revision 1.5  1995/03/25  04:21:12  zappo
 * Updated copyright and non-ANSI prototypes
 *
 * Revision 1.4  1995/03/03  02:51:27  zappo
 * Modified some prototypes
 *
 * Revision 1.3  1995/02/12  14:13:39  zappo
 * Added sun forwarding flag to main context
 *
 * Revision 1.2  1995/02/11  17:17:42  zappo
 * formatting changes
 *
 * Revision 1.1  1995/02/01  03:47:09  zappo
 * Initial revision
 *
 */
#define DEBUG2

#ifndef GTALKD_
#define GTALKD_ "GTALK daemon version " VERSION \
" (c) 1994-98 Free Software Foundation"

/* There may be duplicates, but load this just in case. */
#include "otalk.h"
#include "talk.h"
#include "gtalk.h"
#include "gtl_union.h"

/*
 * lets define the context used thoughout
 * this talk program.
 */
struct DaemonContext {
  enum DaemonType     type;	/* current daemon type to emulate         */
  int                 sunf;	/* sun version forward flag               */
  struct HostObject  *me;	/* The current host.                      */
  struct InputDevice *talk;	/* udp port for talk (old) daemon service */
  struct InputDevice *udp_ring;	/* ringer socket for talking to ring srvc */
  long                checkrate; /* how often to clean out lists.         */
  pid_t               pid;	/* pid, (autoconf makes pid_t)            */
  unsigned char       tty;	/* flag set when not started from inetd   */
  unsigned char       forever;	/* run forever and ever flag              */
};

/*
 * Describe a request, meaning invites, phone addresses, and such
 */
struct RequestObject {
  struct GenericListNode  link;	  /* List part                         */
  CTL_MSG_GNU             request;/* request being stored              */
  char                   *extend; /* extension character string        */
  char                    l_name[GNAME_SIZE + 1]; /* NULL terminated   */
  char                    r_name[GNAME_SIZE + 1]; /* versions of what's*/
  char                    r_tty[GTTY_SIZE + 1]; /* in `request'        */
  u_char                  answer; /* how we responded to this last time*/
  struct InputDevice     *sender; /* io virtualism of sender           */
  struct InputDevice     *retto;  /* return address listed in the mesg */
  struct timeval          stamp;  /* timestamp when this was received  */
};

struct UserObject {
  struct GenericListNode  link;  /* List part                            */
  char                   *name;  /* name of the user this describes      */
  uid_t                   uid; 	 /* The user id of this person           */
  char                   *tty; 	 /* requested tty to pester              */
  char                   *ringf; /* The ringer file of this user         */
  struct InputDevice     *ringto;/* address of any opened ringer socket  */
  char                   *filterf; /* The filter file of this user       */
  struct GenericList      filters; /* User specified filters             */
};

#ifdef PROTOTYPES
/* gtd_fusr.c */
extern struct UserObject *FUSR_alloc(char *name, char *tty);
extern char *FUSR_lookup(struct UserObject *uo);

/* gtd_reqst.c */
extern void GTR_read_request(struct DaemonContext *Ctxt, struct InputDevice *dev);

/* gtd_rman.c */
extern struct RequestObject *GCM_alloc(struct DaemonContext *Ctxt, struct InputDevice *dev, union ctl_msg *source, char *extend);
extern void GCM_free_request(struct RequestObject *request);
extern struct RequestObject *GCM_lookfor(struct RequestObject *ro);
extern struct RequestObject *GCM_looksame(struct RequestObject *ro);
extern struct RequestObject *GCM_lookid(struct RequestObject *ro);
extern struct RequestObject *GCM_findannounce(struct RequestObject *ro);
extern void GCM_timeout_messages(struct DaemonContext *Ctxt, struct InputDevice *dev);
extern void GCM_print();

/* gtd_annc.c */
extern int ANN_sendto(struct UserObject *uo, struct RequestObject *ro);

/* gtd_ring.c */
extern int RINGER_sendto(struct UserObject *uo, struct RequestObject *ro, struct DaemonContext *Ctxt);

/* gtd_disp.c */
extern void DISP_init(struct DaemonContext *Ctxt, int sldb);
extern void DISP_message(struct DaemonContext *Ctxt, char *msg, int severity);

/* gtd_filter.c */
extern void FILT_ReadFile(struct UserObject *uo);
extern int FILT_CheckFilterSimple(struct UserObject *uo, struct HostObject *host, char *caller, struct DaemonContext *Ctxt);
extern int FILT_CheckFilters(struct UserObject *uo, struct RequestObject *ro, struct DaemonContext *Ctxt);

#else /* PROTOTYPES */
/* gtd_fusr.c */
extern struct UserObject *FUSR_alloc();
extern char *FUSR_lookup();

/* gtd_reqst.c */
extern void GTR_read_request();

/* gtd_rman.c */
extern struct RequestObject *GCM_alloc();
extern void GCM_free_request();
extern struct RequestObject *GCM_lookfor();
extern struct RequestObject *GCM_looksame();
extern struct RequestObject *GCM_lookid();
extern struct RequestObject *GCM_findannounce();
extern void GCM_timeout_messages();
extern void GCM_print();

/* gtd_annc.c */
extern int ANN_sendto();

/* gtd_ring.c */
extern int RINGER_sendto();

/* gtd_disp.c */
extern void DISP_init();
extern void DISP_message();

/* gtd_filter.c */
extern void FILT_ReadFile();
extern int FILT_CheckFilterSimple();
extern int FILT_CheckFilters();

#endif /* PROTOTYPES */


#endif /* GTALKD_ */
