//*****************************************************************************
//                               CmdGnuCapPR.hpp                              *
//                              -----------------                             *
// Description : This class contains values associated with the GNU-Cap       *
//               PRINT command. It inherits from the class CmdBase.           *
// Started     : 17/03/2008                                                   *
// Last Update : 16/04/2010                                                   *
// Copyright   : (C) 2008 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDGCPPR_HPP
#define CMDGCPPR_HPP

// System Includes

using  namespace  std;

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "ngspice/commands/CmdNgSpicePR.hpp"

struct CmdNgSpicePR;

// Local Macro and Constant Declarations


//*****************************************************************************

struct CmdGnuCapPR : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    eCmdType       m_eAnaType;
    wxArrayString  m_osaNodes;
    wxArrayString  m_osaCpnts;
    bool           m_bParmtrs[ ePAR_LST+1 ];
    bool           m_bCpxPrts[ eCPX_LST+1 ];

             CmdGnuCapPR( void );
    virtual ~CmdGnuCapPR( );

    virtual  bool  bClear( void );

             bool  bSetAnaType( eCmdType eAnaType );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    CmdGnuCapPR & operator = ( const CmdNgSpicePR & roCmdPR );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDGCPPR_HPP
