//*****************************************************************************
//                              CmdGnuCapOPT.hpp                              *
//                             ------------------                             *
// Description : This class contains values associated with the GNU-Cap       *
//               OPTIONS command. It inherits from the class CmdBase.         *
// Started     : 11/09/2006                                                   *
// Last Update : 16/04/2010                                                   *
// Copyright   : (C) 2006 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDGCPOPT_HPP
#define CMDGCPOPT_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "ngspice/commands/CmdNgSpiceOPT.hpp"
#include "utility/ConvertType.hpp"

struct CmdNgSpiceOPT;

// Local Macro and/or Constant Declarations

#define  GCP_ABSTOL    1.0E-12
#define  GCP_CHGTOL    1.0E-14
#define  GCP_DEFAD     0.0
#define  GCP_DEFAS     0.0
#define  GCP_DEFL      100.0E-06
#define  GCP_DEFW      100.0E-06
#define  GCP_GMIN      1.0E-12
#define  GCP_ITL1      100
#define  GCP_ITL2      50
#define  GCP_ITL4      10
#define  GCP_METHOD    wxT("Trap")
#define  GCP_RELTOL    0.001
#define  GCP_TNOM      27.0
#define  GCP_TRTOL     7.0
#define  GCP_VNTOL     1.0E-06

#define  GCP_BYPASS    TRUE
#define  GCP_CSTRAY    TRUE
#define  GCP_DAMPMAX   1.0
#define  GCP_DAMPMIN   0.5
#define  GCP_DAMPST    0
#define  GCP_DTMIN     1.0E-12
#define  GCP_DTRATIO   1.0E+09
#define  GCP_FLOOR     1.0E-21
#define  GCP_HARMS     9
#define  GCP_INCMODE   TRUE
#define  GCP_ITL7      1
#define  GCP_ITL8      100
#define  GCP_LIMIT     1.0E+10
#define  GCP_LUBYPASS  TRUE
#define  GCP_MODE      wxT("Mixed")
#define  GCP_NUMDGT    5
#define  GCP_ORDER     wxT("Auto")
#define  GCP_RSTRAY    FALSE
#define  GCP_SEED      1.0
#define  GCP_SHORT     1.0E-07
#define  GCP_TEMPAMB   27.0
#define  GCP_TRACEL    TRUE
#define  GCP_TRANSITS  2
#define  GCP_TRREJECT  0.5
#define  GCP_TRSTEPG   2.0
#define  GCP_TRSTEPS   8.0
#define  GCP_VBYPASS   FALSE
#define  GCP_VFLOOR    1.0E-15
#define  GCP_VMAX      30.0
#define  GCP_VMIN      -30.0
#define  GCP_WCZERO    1.0E-09

//*****************************************************************************

struct CmdGnuCapOPT : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    // Options used by both NG-Spice and GNU-Cap
    wxString  m_osABSTOL;   // Absolute current error tolerance
    wxString  m_osCHGTOL;   // Charge tolerance
    wxString  m_osDEFAD;    // MOS drain diffusion area
    wxString  m_osDEFAS;    // MOS source diffusion area
    wxString  m_osDEFL;     // MOS channel length
    wxString  m_osDEFW;     // MOS channel width
    wxString  m_osGMIN;     // Minimum allowable conductance
    wxString  m_osITL1;     // DC iteration limit
    wxString  m_osITL2;     // DC transfer curve iteration limit
    wxString  m_osITL4;     // TR analysis timepoint iteration limit
    wxString  m_osMETHOD;   // Numerical integration method
    wxString  m_osRELTOL;   // Relative error tolerance
    wxString  m_osTNOM;     // Nominal temp. at which device parameters measured
    wxString  m_osTRTOL;    // TR error tolerance
    wxString  m_osVNTOL;    // Absolute voltage error tolerance

    // Options specific to GNU-Cap
    bool      m_bBYPASS;    // Bypass model evaluation if appropriate
    bool      m_bCSTRAY;    // Include capacitance in device models
    wxString  m_osDAMPMAX;  // Normal Newton damping factor (when all is well)
    wxString  m_osDAMPMIN;  // Newton damping factor when there's a problem
    wxString  m_osDAMPST;   // Damping strategy
    wxString  m_osDTMIN;    // Minimum time step
    wxString  m_osDTRATIO;  // The ratio between minimum and maximum time step
    wxString  m_osFLOOR;    // Effective zero value
    wxString  m_osHARMS;    // Harmonics in Fourier analysis
    bool      m_bINCMODE;   // Incrementally update the matrix
    wxString  m_osITL7;     // Worst case analysis iteration limit
    wxString  m_osITL8;     // Convergence diagnostic iteration threshold
    wxString  m_osLIMIT;    // Internal differential branch voltage limit
    bool      m_bLUBYPASS;  // Bypass parts of LU decomposition if appropriate
    wxString  m_osMODE;     // Simulation mode selection
    wxString  m_osNUMDGT;   // No. of digits to print for analysis results
    wxString  m_osORDER;    // Equation ordering
    bool      m_bRSTRAY;    // Include series resistance in device models
    wxString  m_osSEED;     // Seed used by the random number generator
    wxString  m_osSHORT;    // Resistance of voltage source or short
    wxString  m_osTEMPAMB;  // Simulation temperature
    bool      m_bTRACEL;    // Use a queue to only load changed elements to the matrix
    wxString  m_osTRANSITS; // Mixed mode transition count
    wxString  m_osTRREJECT; // Transient error rejection threshold
    wxString  m_osTRSTEPG;  // Maximum internal step size growth in transient analysis
    wxString  m_osTRSTEPS;  // Amount to decrease the transient step size by when convergence fails
    bool      m_bVBYPASS;   // Check only voltage to bypass model evaluation
    wxString  m_osVFLOOR;   // Effective zero value for voltage probes
    wxString  m_osVMAX;     // Positive node voltage limit
    wxString  m_osVMIN;     // Negative node voltage limit
    wxString  m_osWCZERO;   // Worst case zero window

              CmdGnuCapOPT( void );
    virtual  ~CmdGnuCapOPT( );

    virtual  bool  bClear( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    CmdGnuCapOPT & operator = ( const CmdNgSpiceOPT & roCmdOPT );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDGCPOPT_HPP
