/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib/gi18n.h>

#include "util.h"
#include "gpass/root-entry.h"

static GPassEntryClass *parent_class = NULL;

static const gchar *
root_entry_class_nick(void)
{
    return _("Root");
}

static gboolean
root_entry_class_can_have_child(void)
{
    return TRUE;
}

static void
root_entry_instance_init(GTypeInstance *instance, gpointer g_class)
{
    GPassRootEntry *self = GPASS_ROOT_ENTRY(instance);
    
    GPASS_ENTRY(self)->type = "root";
}

static void
root_entry_class_init(gpointer g_class, gpointer g_class_data)
{
    GPassEntryClass *entry_class = GPASS_ENTRY_CLASS(g_class);

    parent_class = g_type_class_peek_parent(g_class);
    
    entry_class->nick = root_entry_class_nick;
    entry_class->can_have_child = root_entry_class_can_have_child;
}

GType
gpass_root_entry_get_type(void)
{
    static GType type = 0;
    
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof(GPassRootEntryClass),
            NULL,
            NULL,
            root_entry_class_init,
            NULL,
            NULL,
            sizeof(GPassRootEntry),
            0,
            root_entry_instance_init
        };
        
        type = g_type_register_static(GPASS_TYPE_ENTRY, "GPassRootEntry",
                                      &info, 0);
    }
    return type;
}
