/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_PASSWORD_H__
#define __GPASS_PASSWORD_H__

#include "gpass/entry.h"

G_BEGIN_DECLS

#define GPASS_TYPE_PASSWORD (gpass_password_get_type())
#define GPASS_PASSWORD(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_PASSWORD, GPassPassword))
#define GPASS_PASSWORD_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_PASSWORD, GPassPasswordClass))
#define GPASS_IS_PASSWORD(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_PASSWORD))
#define GPASS_IS_PASSWORD_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_PASSWORD))
#define GPASS_PASSWORD_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_PASSWORD, GPassPasswordClass))

typedef struct {
    GPassEntry parent;

    gchar *username;
    gchar *password;
} GPassPassword;

typedef struct {
    GPassEntryClass parent;
} GPassPasswordClass;

GType gpass_password_get_type(void);

/***********************************************************
 *
 * generate password
 *
 ***********************************************************/
typedef enum {
    GPASS_PASSWORD_GENERATE_TYPE_RANDOM,
} GPassPasswordGenerateType;

GType gpass_password_generate_type_get_type(void);

#define GPASS_PASSWORD_GENERATE_USE_LOWERCASE (1 << 1)
#define GPASS_PASSWORD_GENERATE_USE_UPPERCASE (1 << 2)
#define GPASS_PASSWORD_GENERATE_USE_NUMBER    (1 << 3)
#define GPASS_PASSWORD_GENERATE_USE_SPECIAL   (1 << 4)

#define GPASS_PASSWORD_GENERATE_USE_NORMAL \
    (GPASS_PASSWORD_GENERATE_USE_LOWERCASE | \
     GPASS_PASSWORD_GENERATE_USE_UPPERCASE | \
     GPASS_PASSWORD_GENERATE_USE_NUMBER)

GError *gpass_password_generate(GPassPasswordGenerateType type, gint use_flags,
                                gint length, GString **password);

G_END_DECLS

#endif /* #ifndef __GPASS_PASSWORD_H__ */
