/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_ATTRIBUTE_H__
#define __GPASS_ATTRIBUTE_H__

#include <stdarg.h>
#include <glib-object.h>

G_BEGIN_DECLS

/***********************************************************
 *
 * GPassAttributeType
 *
 ***********************************************************/
#define GPASS_TYPE_ATTRIBUTE_TYPE (gpass_attribute_type_get_type())

typedef enum {
    GPASS_ATTRIBUTE_TYPE_INVALID,
    GPASS_ATTRIBUTE_TYPE_INTEGER,
    GPASS_ATTRIBUTE_TYPE_BOOLEAN,
    GPASS_ATTRIBUTE_TYPE_TIME,
    GPASS_ATTRIBUTE_TYPE_STRING,
    GPASS_ATTRIBUTE_TYPE_TEXT,
    GPASS_ATTRIBUTE_TYPE_PASSWORD,
    GPASS_ATTRIBUTE_TYPE_URL,
    GPASS_ATTRIBUTE_TYPE_ENTRY_TYPE,
} GPassAttributeType;

GType gpass_attribute_type_get_type(void);

/***********************************************************
 *
 * GPassAttribute
 *
 ***********************************************************/
#define GPASS_TYPE_ATTRIBUTE (gpass_attribute_get_type())
#define GPASS_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_ATTRIBUTE, GPassAttribute))
#define GPASS_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_ATTRIBUTE, \
                             GPassAttributeClass))
#define GPASS_IS_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_ATTRIBUTE))
#define GPASS_IS_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_ATTRIBUTE))
#define GPASS_ATTRIBUTE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_ATTRIBUTE, \
                               GPassAttributeClass))

typedef struct {
    GObject parent;

    GPassAttributeType type;
    gchar *name;
    gchar *nick;
    gchar *blurb;
    GValue *value;
} GPassAttribute;

typedef struct {
    GObjectClass parent;
} GPassAttributeClass;

GType gpass_attribute_get_type(void);

GError *gpass_attribute_set_valist(GPassAttribute *self, va_list ap);
GError *gpass_attribute_set(GPassAttribute *self, ...);
GError *gpass_attribute_get_valist(GPassAttribute *self, va_list ap);
GError *gpass_attribute_get(GPassAttribute *self, ...);
GError *gpass_attribute_dump(GPassAttribute *self, GString **buffer);
GError *gpass_attribute_load(GPassAttribute *self, const guchar *buffer,
                             gsize buffer_len, gsize *read_len);

G_END_DECLS

#endif /* #ifndef __GPASS_ATTRIBUTE_H__ */
