/*
Copyright (C) 2000-2005  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/*Patch for list of gp functions. Must be include after header.h.*/
typedef enum {GPuser_private,
              GPgpmany,
              GPinstall,GPaddhelp,
              GPgrandO,
              GPbreak,GPnext,GPreturn,
              GPfor,GPforstep,GPforstepvec,GPforprime,GPforvec,GPfordiv,
              GPdoloop,
              GPlabel,
              GPglobal,GPlocal,
              GPif,
              GPprod,GPsum,GPsumdiv,GPprodeuler,
              GPuntil,GPwhile,
              GPmakevec,GPmakemat,
              GPvector,GPvectorsmall,GPvectorv,GPmatrix,
              GPinitfunc,GPcopyarg,
              GPclosure
} GPspec_private;

struct patchfunc_s
{
  const char *gpname;
  const char *code;
  int type;
  int mode;
  int spec;
} patchfunc[]={
/*Override previous definition in pari/src/init.c*/
{"O",NULL,Ggen,0,GPgrandO},
{"break",NULL,Gvoid,0,GPbreak},
{"next",NULL,Gvoid,0,GPnext},
{"for","GGIG",Gnotype,(1<<Msemicolon),GPfor},
{"fordiv",NULL,Gnotype,(1<<Msemicolon),GPfordiv},
{"forstep","GIGGGG",Gnotype,(1<<Msemicolon),GPforstep},
{"forvec",NULL,Gnotype,(1<<Msemicolon),GPforvec},
{"forprime",NULL,Gnotype,(1<<Msemicolon),GPforprime},
{"if","GII",Gnotype,(1<<Msemicolon),GPif},
{"prod","NULL",Gnotype,(1<<Msemicolon),GPprod},
{"prodeuler",NULL,Gnotype,(1<<Msemicolon),GPprodeuler},
{"return",NULL,Gnotype,(1<<Mterm),GPreturn},
{"sum",NULL,Gnotype,(1<<Msemicolon),GPsum},
{"sumdiv",NULL,Gnotype,(1<<Msemicolon),GPsumdiv},
{"until","EI",Gnotype,(1<<Msemicolon),GPuntil},
{"vector",NULL,Gnotype,(1<<Msemicolon),GPvector},
{"vectorsmall",NULL,Gnotype,(1<<Msemicolon),GPvectorsmall},
{"vectorv",NULL,Gnotype,(1<<Msemicolon),GPvectorv},
{"matrix",NULL,Gnotype,(1<<Msemicolon),GPmatrix},
{"while","EI",Gnotype,(1<<Msemicolon),GPwhile},
{"_doloop","I",Gnotype,(1<<Msemicolon),GPdoloop},
/* New definition*/
{"global",NULL,Gnotype,(1<<Msemicolon),GPglobal},
{"local",NULL,Gnotype,(1<<Msemicolon),GPlocal},
{"my",NULL,Gnotype,(1<<Msemicolon),GPlocal},
{"_makevec","*",Gnotype,(1<<Msemicolon),GPmakevec},
{"_gerepilemany",NULL,Gvoid,(1<<Msemicolon),GPgpmany},
{"_initfunc","",Gvoid,(1<<Msemicolon),GPinitfunc},
{"_copyarg","",Gvoid,(1<<Msemicolon),GPcopyarg},
{"_label",NULL,Gvoid,0,GPlabel},
{"forstepvec","GIGGGG",Gnotype,(1<<Msemicolon),GPforstepvec},
{"install",NULL,Gnotype,(1<<Msemicolon),GPinstall},
{"addhelp",NULL,Gnotype,(1<<Msemicolon),GPaddhelp},
{"_closure",NULL,Gnotype,0,GPclosure},
{NULL,NULL,0,0,0}};
