/*
 * Copyright (C) 2007  Miriam Ruiz <little_miry@yahoo.es>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "taghandler.h"

#include <iostream>

FilterTagHandler::FilterTagHandler() : current_position(0), current_flag(1)
{
}

FilterTagHandler::~FilterTagHandler()
{
}

const FilterTagHandler::Element *FilterTagHandler::GetTag(const std::string name)
{
	for (std::vector<Element>::const_iterator i = elements.begin();
			i != elements.end(); ++i)
	{ if (i->name == name) return &(*i); }
	return NULL;
}

void FilterTagHandler::AddTag(const std::string name)
{
	for (std::vector<Element>::const_iterator i = elements.begin();
			i != elements.end(); ++i)
	{ if (i->name == name) return; }

	Element tag(name, current_position, current_flag);
	current_flag = current_flag << 1;
	if (!current_flag)
	{ current_position++; current_flag=1; }
	elements.push_back(tag);
}

void FilterTagHandler::PrintAll()
{
	for (std::vector<Element>::const_iterator i = elements.begin();
			i != elements.end(); ++i)
	{
		std::cerr << i->name << " (" << i->position << ":" << i->flag << ")" << std::endl;
	}
}

void FilterTagHandler::Print(Result *result)
{
	for (std::vector<Element>::const_iterator i = elements.begin();
			i != elements.end(); ++i)
	{
		if (result->CheckAny(i->position, i->flag))
			std::cerr << i->name << " ";
	}
	std::cerr << std::endl;
}
