/* Interfaces.c generated by valac, the Vala compiler
 * generated from Interfaces.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>


#define TYPE_MEDIA_OBJECT1 (media_object1_get_type ())
#define MEDIA_OBJECT1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT1, MediaObject1))
#define IS_MEDIA_OBJECT1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT1))
#define MEDIA_OBJECT1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_OBJECT1, MediaObject1Iface))

typedef struct _MediaObject1 MediaObject1;
typedef struct _MediaObject1Iface MediaObject1Iface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MediaObject1DBusProxy MediaObject1DBusProxy;
typedef DBusGProxyClass MediaObject1DBusProxyClass;

#define TYPE_MEDIA_CONTAINER1 (media_container1_get_type ())
#define MEDIA_CONTAINER1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER1, MediaContainer1))
#define IS_MEDIA_CONTAINER1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER1))
#define MEDIA_CONTAINER1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_CONTAINER1, MediaContainer1Iface))

typedef struct _MediaContainer1 MediaContainer1;
typedef struct _MediaContainer1Iface MediaContainer1Iface;
typedef struct _MediaContainer1DBusProxy MediaContainer1DBusProxy;
typedef DBusGProxyClass MediaContainer1DBusProxyClass;

#define TYPE_MEDIA_ITEM1 (media_item1_get_type ())
#define MEDIA_ITEM1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_ITEM1, MediaItem1))
#define IS_MEDIA_ITEM1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_ITEM1))
#define MEDIA_ITEM1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_ITEM1, MediaItem1Iface))

typedef struct _MediaItem1 MediaItem1;
typedef struct _MediaItem1Iface MediaItem1Iface;
typedef struct _MediaItem1DBusProxy MediaItem1DBusProxy;
typedef DBusGProxyClass MediaItem1DBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _MediaObject1Iface {
	GTypeInterface parent_iface;
	char* (*get_Parent) (MediaObject1* self);
	char* (*get_DisplayName) (MediaObject1* self);
};

struct _MediaObject1DBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _MediaContainer1Iface {
	GTypeInterface parent_iface;
	char** (*get_Items) (MediaContainer1* self, int* result_length1);
	guint (*get_ItemCount) (MediaContainer1* self);
	char** (*get_Containers) (MediaContainer1* self, int* result_length1);
	guint (*get_ContainerCount) (MediaContainer1* self);
};

struct _MediaContainer1DBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _MediaItem1Iface {
	GTypeInterface parent_iface;
	char** (*get_URLs) (MediaItem1* self, int* result_length1);
	char* (*get_MIMEType) (MediaItem1* self);
	char* (*get_Type) (MediaItem1* self);
};

struct _MediaItem1DBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



GType media_object1_get_type (void);
char* media_object1_get_Parent (MediaObject1* self);
char* media_object1_get_DisplayName (MediaObject1* self);
void media_object1_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _media_object1_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult media_object1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_media_object1_introspect (MediaObject1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_object1_property_get (MediaObject1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_object1_property_get_all (MediaObject1* self, DBusConnection* connection, DBusMessage* message);
GType media_object1_dbus_proxy_get_type (void);
MediaObject1* media_object1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult media_object1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	MEDIA_OBJECT1_DBUS_PROXY_DUMMY_PROPERTY,
	MEDIA_OBJECT1_DBUS_PROXY_PARENT,
	MEDIA_OBJECT1_DBUS_PROXY_DISPLAY_NAME
};
static char* media_object1_dbus_proxy_get_Parent (MediaObject1* self);
static char* media_object1_dbus_proxy_get_DisplayName (MediaObject1* self);
static void media_object1_dbus_proxy_media_object1__interface_init (MediaObject1Iface* iface);
static void media_object1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void media_object1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType media_container1_get_type (void);
char** media_container1_get_Items (MediaContainer1* self, int* result_length1);
guint media_container1_get_ItemCount (MediaContainer1* self);
char** media_container1_get_Containers (MediaContainer1* self, int* result_length1);
guint media_container1_get_ContainerCount (MediaContainer1* self);
void media_container1_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _media_container1_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult media_container1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_media_container1_introspect (MediaContainer1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_container1_property_get (MediaContainer1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_container1_property_get_all (MediaContainer1* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_media_container1_updated (GObject* _sender, DBusConnection* _connection);
GType media_container1_dbus_proxy_get_type (void);
MediaContainer1* media_container1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_media_container1_updated (MediaContainer1* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult media_container1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	MEDIA_CONTAINER1_DBUS_PROXY_DUMMY_PROPERTY,
	MEDIA_CONTAINER1_DBUS_PROXY_ITEM_COUNT,
	MEDIA_CONTAINER1_DBUS_PROXY_CONTAINER_COUNT
};
static char** media_container1_dbus_proxy_get_Items (MediaContainer1* self, int* result_length1);
static guint media_container1_dbus_proxy_get_ItemCount (MediaContainer1* self);
static char** media_container1_dbus_proxy_get_Containers (MediaContainer1* self, int* result_length1);
static guint media_container1_dbus_proxy_get_ContainerCount (MediaContainer1* self);
static void media_container1_dbus_proxy_media_container1__interface_init (MediaContainer1Iface* iface);
static void media_container1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void media_container1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType media_item1_get_type (void);
char** media_item1_get_URLs (MediaItem1* self, int* result_length1);
char* media_item1_get_MIMEType (MediaItem1* self);
char* media_item1_get_Type (MediaItem1* self);
void media_item1_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _media_item1_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult media_item1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_media_item1_introspect (MediaItem1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_item1_property_get (MediaItem1* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_item1_property_get_all (MediaItem1* self, DBusConnection* connection, DBusMessage* message);
GType media_item1_dbus_proxy_get_type (void);
MediaItem1* media_item1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult media_item1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	MEDIA_ITEM1_DBUS_PROXY_DUMMY_PROPERTY,
	MEDIA_ITEM1_DBUS_PROXY_UR_LS,
	MEDIA_ITEM1_DBUS_PROXY_MIME_TYPE,
	MEDIA_ITEM1_DBUS_PROXY_TYPE
};
static char** media_item1_dbus_proxy_get_URLs (MediaItem1* self, int* result_length1);
static char* media_item1_dbus_proxy_get_MIMEType (MediaItem1* self);
static char* media_item1_dbus_proxy_get_Type (MediaItem1* self);
static void media_item1_dbus_proxy_media_item1__interface_init (MediaItem1Iface* iface);
static void media_item1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void media_item1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _media_object1_dbus_path_vtable = {_media_object1_dbus_unregister, media_object1_dbus_message};
static const _DBusObjectVTable _media_object1_dbus_vtable = {media_object1_dbus_register_object};
static const DBusObjectPathVTable _media_container1_dbus_path_vtable = {_media_container1_dbus_unregister, media_container1_dbus_message};
static const _DBusObjectVTable _media_container1_dbus_vtable = {media_container1_dbus_register_object};
static const DBusObjectPathVTable _media_item1_dbus_path_vtable = {_media_item1_dbus_unregister, media_item1_dbus_message};
static const _DBusObjectVTable _media_item1_dbus_vtable = {media_item1_dbus_register_object};


char* media_object1_get_Parent (MediaObject1* self) {
	return MEDIA_OBJECT1_GET_INTERFACE (self)->get_Parent (self);
}


char* media_object1_get_DisplayName (MediaObject1* self) {
	return MEDIA_OBJECT1_GET_INTERFACE (self)->get_DisplayName (self);
}


void _media_object1_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_media_object1_introspect (MediaObject1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject1\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_object1_property_get (MediaObject1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject1") == 0) && (strcmp (property_name, "Parent") == 0)) {
		char* result;
		const char* _tmp2_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "o", &subiter);
		result = media_object1_get_Parent (self);
		_tmp2_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_OBJECT_PATH, &_tmp2_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaObject1") == 0) && (strcmp (property_name, "DisplayName") == 0)) {
		char* result;
		const char* _tmp3_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = media_object1_get_DisplayName (self);
		_tmp3_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp3_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_object1_property_get_all (MediaObject1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp4_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp4_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp4_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaObject1") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char* result;
			const char* _tmp5_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Parent";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "o", &value_iter);
			result = media_object1_get_Parent (self);
			_tmp5_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_OBJECT_PATH, &_tmp5_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp6_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DisplayName";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = media_object1_get_DisplayName (self);
			_tmp6_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp6_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult media_object1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_media_object1_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_media_object1_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_media_object1_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void media_object1_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_media_object1_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void media_object1_base_init (MediaObject1Iface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("Parent", "Parent", "Parent", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("DisplayName", "DisplayName", "DisplayName", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_type_set_qdata (TYPE_MEDIA_OBJECT1, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_media_object1_dbus_vtable));
	}
}


GType media_object1_get_type (void) {
	static volatile gsize media_object1_type_id__volatile = 0;
	if (g_once_init_enter (&media_object1_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaObject1Iface), (GBaseInitFunc) media_object1_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType media_object1_type_id;
		media_object1_type_id = g_type_register_static (G_TYPE_INTERFACE, "MediaObject1", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (media_object1_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (media_object1_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &media_object1_dbus_proxy_get_type);
		g_once_init_leave (&media_object1_type_id__volatile, media_object1_type_id);
	}
	return media_object1_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MediaObject1DBusProxy, media_object1_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MEDIA_OBJECT1, media_object1_dbus_proxy_media_object1__interface_init) );
MediaObject1* media_object1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	MediaObject1* self;
	self = g_object_new (media_object1_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaObject1", NULL);
	return self;
}


static GObject* media_object1_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (media_object1_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), media_object1_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult media_object1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void media_object1_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((MediaObject1DBusProxy*) self)->disposed) {
		return;
	}
	((MediaObject1DBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), media_object1_dbus_proxy_filter, self);
	G_OBJECT_CLASS (media_object1_dbus_proxy_parent_class)->dispose (self);
}


static void media_object1_dbus_proxy_class_init (MediaObject1DBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = media_object1_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = media_object1_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = media_object1_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = media_object1_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_OBJECT1_DBUS_PROXY_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_OBJECT1_DBUS_PROXY_DISPLAY_NAME, "DisplayName");
}


static void media_object1_dbus_proxy_init (MediaObject1DBusProxy* self) {
}


static char* media_object1_dbus_proxy_get_Parent (MediaObject1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp7_;
	const char* _tmp8_;
	char* _result;
	const char* _tmp9_;
	if (((MediaObject1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp7_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp7_);
	_tmp8_ = "Parent";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp8_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "o")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "o", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp9_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp9_);
	dbus_message_unref (_reply);
	return _result;
}


static char* media_object1_dbus_proxy_get_DisplayName (MediaObject1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp10_;
	const char* _tmp11_;
	char* _result;
	const char* _tmp12_;
	if (((MediaObject1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp10_ = "org.gnome.UPnP.MediaObject1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp10_);
	_tmp11_ = "DisplayName";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp11_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp12_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp12_);
	dbus_message_unref (_reply);
	return _result;
}


static void media_object1_dbus_proxy_media_object1__interface_init (MediaObject1Iface* iface) {
	iface->get_Parent = media_object1_dbus_proxy_get_Parent;
	iface->get_DisplayName = media_object1_dbus_proxy_get_DisplayName;
}


static void media_object1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void media_object1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


char** media_container1_get_Items (MediaContainer1* self, int* result_length1) {
	return MEDIA_CONTAINER1_GET_INTERFACE (self)->get_Items (self, result_length1);
}


guint media_container1_get_ItemCount (MediaContainer1* self) {
	return MEDIA_CONTAINER1_GET_INTERFACE (self)->get_ItemCount (self);
}


char** media_container1_get_Containers (MediaContainer1* self, int* result_length1) {
	return MEDIA_CONTAINER1_GET_INTERFACE (self)->get_Containers (self, result_length1);
}


guint media_container1_get_ContainerCount (MediaContainer1* self) {
	return MEDIA_CONTAINER1_GET_INTERFACE (self)->get_ContainerCount (self);
}


void _media_container1_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_media_container1_introspect (MediaContainer1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaContainer1\">\n  <property name=\"Items\" type=\"ao\" access=\"read\"/>\n  <property name=\"ItemCount\" type=\"u\" access=\"read\"/>\n  <property name=\"Containers\" type=\"ao\" access=\"read\"/>\n  <property name=\"ContainerCount\" type=\"u\" access=\"read\"/>\n  <signal name=\"Updated\">\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_container1_property_get (MediaContainer1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp13_;
	char* property_name;
	const char* _tmp14_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp13_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp13_);
	dbus_message_iter_get_basic (&iter, &_tmp14_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp14_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "Items") == 0)) {
		char** result;
		int result_length1;
		char** _tmp15_;
		DBusMessageIter _tmp16_;
		int _tmp17_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "ao", &subiter);
		result = media_container1_get_Items (self, &result_length1);
		_tmp15_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "o", &_tmp16_);
		for (_tmp17_ = 0; _tmp17_ < result_length1; _tmp17_++) {
			const char* _tmp18_;
			_tmp18_ = *_tmp15_;
			dbus_message_iter_append_basic (&_tmp16_, DBUS_TYPE_OBJECT_PATH, &_tmp18_);
			_tmp15_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp16_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "ItemCount") == 0)) {
		guint result;
		dbus_uint32_t _tmp19_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "u", &subiter);
		result = media_container1_get_ItemCount (self);
		_tmp19_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT32, &_tmp19_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "Containers") == 0)) {
		char** result;
		int result_length1;
		char** _tmp20_;
		DBusMessageIter _tmp21_;
		int _tmp22_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "ao", &subiter);
		result = media_container1_get_Containers (self, &result_length1);
		_tmp20_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "o", &_tmp21_);
		for (_tmp22_ = 0; _tmp22_ < result_length1; _tmp22_++) {
			const char* _tmp23_;
			_tmp23_ = *_tmp20_;
			dbus_message_iter_append_basic (&_tmp21_, DBUS_TYPE_OBJECT_PATH, &_tmp23_);
			_tmp20_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp21_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) && (strcmp (property_name, "ContainerCount") == 0)) {
		guint result;
		dbus_uint32_t _tmp24_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "u", &subiter);
		result = media_container1_get_ContainerCount (self);
		_tmp24_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT32, &_tmp24_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_container1_property_get_all (MediaContainer1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp25_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp25_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp25_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaContainer1") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char** result;
			int result_length1;
			char** _tmp26_;
			DBusMessageIter _tmp27_;
			int _tmp28_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Items";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "ao", &value_iter);
			result = media_container1_get_Items (self, &result_length1);
			_tmp26_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "o", &_tmp27_);
			for (_tmp28_ = 0; _tmp28_ < result_length1; _tmp28_++) {
				const char* _tmp29_;
				_tmp29_ = *_tmp26_;
				dbus_message_iter_append_basic (&_tmp27_, DBUS_TYPE_OBJECT_PATH, &_tmp29_);
				_tmp26_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp27_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint result;
			dbus_uint32_t _tmp30_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ItemCount";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "u", &value_iter);
			result = media_container1_get_ItemCount (self);
			_tmp30_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT32, &_tmp30_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp31_;
			DBusMessageIter _tmp32_;
			int _tmp33_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Containers";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "ao", &value_iter);
			result = media_container1_get_Containers (self, &result_length1);
			_tmp31_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "o", &_tmp32_);
			for (_tmp33_ = 0; _tmp33_ < result_length1; _tmp33_++) {
				const char* _tmp34_;
				_tmp34_ = *_tmp31_;
				dbus_message_iter_append_basic (&_tmp32_, DBUS_TYPE_OBJECT_PATH, &_tmp34_);
				_tmp31_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp32_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint result;
			dbus_uint32_t _tmp35_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ContainerCount";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "u", &value_iter);
			result = media_container1_get_ContainerCount (self);
			_tmp35_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT32, &_tmp35_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult media_container1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_media_container1_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_media_container1_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_media_container1_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_media_container1_updated (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.UPnP.MediaContainer1", "Updated");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void media_container1_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_media_container1_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "updated", (GCallback) _dbus_media_container1_updated, connection);
}


static void media_container1_base_init (MediaContainer1Iface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_uint ("ItemCount", "ItemCount", "ItemCount", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_uint ("ContainerCount", "ContainerCount", "ContainerCount", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_signal_new ("updated", TYPE_MEDIA_CONTAINER1, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_type_set_qdata (TYPE_MEDIA_CONTAINER1, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_media_container1_dbus_vtable));
	}
}


GType media_container1_get_type (void) {
	static volatile gsize media_container1_type_id__volatile = 0;
	if (g_once_init_enter (&media_container1_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaContainer1Iface), (GBaseInitFunc) media_container1_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType media_container1_type_id;
		media_container1_type_id = g_type_register_static (G_TYPE_INTERFACE, "MediaContainer1", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (media_container1_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (media_container1_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &media_container1_dbus_proxy_get_type);
		g_once_init_leave (&media_container1_type_id__volatile, media_container1_type_id);
	}
	return media_container1_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MediaContainer1DBusProxy, media_container1_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MEDIA_CONTAINER1, media_container1_dbus_proxy_media_container1__interface_init) );
MediaContainer1* media_container1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	MediaContainer1* self;
	self = g_object_new (media_container1_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaContainer1", NULL);
	return self;
}


static GObject* media_container1_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (media_container1_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), media_container1_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_media_container1_updated (MediaContainer1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "updated");
}


DBusHandlerResult media_container1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.UPnP.MediaContainer1", "Updated")) {
			_dbus_handle_media_container1_updated (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void media_container1_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((MediaContainer1DBusProxy*) self)->disposed) {
		return;
	}
	((MediaContainer1DBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), media_container1_dbus_proxy_filter, self);
	G_OBJECT_CLASS (media_container1_dbus_proxy_parent_class)->dispose (self);
}


static void media_container1_dbus_proxy_class_init (MediaContainer1DBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = media_container1_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = media_container1_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = media_container1_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = media_container1_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_CONTAINER1_DBUS_PROXY_ITEM_COUNT, "ItemCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_CONTAINER1_DBUS_PROXY_CONTAINER_COUNT, "ContainerCount");
}


static void media_container1_dbus_proxy_init (MediaContainer1DBusProxy* self) {
}


static char** media_container1_dbus_proxy_get_Items (MediaContainer1* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp36_;
	const char* _tmp37_;
	char** _result;
	int _result_length1;
	char** _tmp38_;
	int _tmp38__length;
	int _tmp38__size;
	int _tmp38__length1;
	DBusMessageIter _tmp39_;
	if (((MediaContainer1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp36_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp36_);
	_tmp37_ = "Items";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp37_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "ao")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "ao", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp38_ = g_new (char*, 5);
	_tmp38__length = 0;
	_tmp38__size = 4;
	_tmp38__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp39_);
	for (; dbus_message_iter_get_arg_type (&_tmp39_); _tmp38__length1++) {
		const char* _tmp40_;
		if (_tmp38__size == _tmp38__length) {
			_tmp38__size = 2 * _tmp38__size;
			_tmp38_ = g_renew (char*, _tmp38_, _tmp38__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp39_, &_tmp40_);
		dbus_message_iter_next (&_tmp39_);
		_tmp38_[_tmp38__length++] = g_strdup (_tmp40_);
	}
	_result_length1 = _tmp38__length1;
	_tmp38_[_tmp38__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp38_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint media_container1_dbus_proxy_get_ItemCount (MediaContainer1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp41_;
	const char* _tmp42_;
	guint _result;
	dbus_uint32_t _tmp43_;
	if (((MediaContainer1DBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp41_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp41_);
	_tmp42_ = "ItemCount";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp42_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0U;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "u")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "u", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp43_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp43_;
	dbus_message_unref (_reply);
	return _result;
}


static char** media_container1_dbus_proxy_get_Containers (MediaContainer1* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp44_;
	const char* _tmp45_;
	char** _result;
	int _result_length1;
	char** _tmp46_;
	int _tmp46__length;
	int _tmp46__size;
	int _tmp46__length1;
	DBusMessageIter _tmp47_;
	if (((MediaContainer1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp44_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp44_);
	_tmp45_ = "Containers";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp45_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "ao")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "ao", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp46_ = g_new (char*, 5);
	_tmp46__length = 0;
	_tmp46__size = 4;
	_tmp46__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp47_);
	for (; dbus_message_iter_get_arg_type (&_tmp47_); _tmp46__length1++) {
		const char* _tmp48_;
		if (_tmp46__size == _tmp46__length) {
			_tmp46__size = 2 * _tmp46__size;
			_tmp46_ = g_renew (char*, _tmp46_, _tmp46__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp47_, &_tmp48_);
		dbus_message_iter_next (&_tmp47_);
		_tmp46_[_tmp46__length++] = g_strdup (_tmp48_);
	}
	_result_length1 = _tmp46__length1;
	_tmp46_[_tmp46__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp46_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint media_container1_dbus_proxy_get_ContainerCount (MediaContainer1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp49_;
	const char* _tmp50_;
	guint _result;
	dbus_uint32_t _tmp51_;
	if (((MediaContainer1DBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp49_ = "org.gnome.UPnP.MediaContainer1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp49_);
	_tmp50_ = "ContainerCount";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp50_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0U;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "u")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "u", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp51_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp51_;
	dbus_message_unref (_reply);
	return _result;
}


static void media_container1_dbus_proxy_media_container1__interface_init (MediaContainer1Iface* iface) {
	iface->get_Items = media_container1_dbus_proxy_get_Items;
	iface->get_ItemCount = media_container1_dbus_proxy_get_ItemCount;
	iface->get_Containers = media_container1_dbus_proxy_get_Containers;
	iface->get_ContainerCount = media_container1_dbus_proxy_get_ContainerCount;
}


static void media_container1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void media_container1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


char** media_item1_get_URLs (MediaItem1* self, int* result_length1) {
	return MEDIA_ITEM1_GET_INTERFACE (self)->get_URLs (self, result_length1);
}


char* media_item1_get_MIMEType (MediaItem1* self) {
	return MEDIA_ITEM1_GET_INTERFACE (self)->get_MIMEType (self);
}


char* media_item1_get_Type (MediaItem1* self) {
	return MEDIA_ITEM1_GET_INTERFACE (self)->get_Type (self);
}


void _media_item1_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_media_item1_introspect (MediaItem1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaItem1\">\n  <property name=\"URLs\" type=\"as\" access=\"read\"/>\n  <property name=\"MIMEType\" type=\"s\" access=\"read\"/>\n  <property name=\"Type\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_item1_property_get (MediaItem1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp52_;
	char* property_name;
	const char* _tmp53_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp52_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp52_);
	dbus_message_iter_get_basic (&iter, &_tmp53_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp53_);
	if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "URLs") == 0)) {
		char** result;
		int result_length1;
		char** _tmp54_;
		DBusMessageIter _tmp55_;
		int _tmp56_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = media_item1_get_URLs (self, &result_length1);
		_tmp54_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp55_);
		for (_tmp56_ = 0; _tmp56_ < result_length1; _tmp56_++) {
			const char* _tmp57_;
			_tmp57_ = *_tmp54_;
			dbus_message_iter_append_basic (&_tmp55_, DBUS_TYPE_STRING, &_tmp57_);
			_tmp54_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp55_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "MIMEType") == 0)) {
		char* result;
		const char* _tmp58_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = media_item1_get_MIMEType (self);
		_tmp58_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp58_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) && (strcmp (property_name, "Type") == 0)) {
		char* result;
		const char* _tmp59_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = media_item1_get_Type (self);
		_tmp59_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp59_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_item1_property_get_all (MediaItem1* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp60_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp60_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp60_);
	if (strcmp (interface_name, "org.gnome.UPnP.MediaItem1") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char** result;
			int result_length1;
			char** _tmp61_;
			DBusMessageIter _tmp62_;
			int _tmp63_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "URLs";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = media_item1_get_URLs (self, &result_length1);
			_tmp61_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp62_);
			for (_tmp63_ = 0; _tmp63_ < result_length1; _tmp63_++) {
				const char* _tmp64_;
				_tmp64_ = *_tmp61_;
				dbus_message_iter_append_basic (&_tmp62_, DBUS_TYPE_STRING, &_tmp64_);
				_tmp61_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp62_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp65_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "MIMEType";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = media_item1_get_MIMEType (self);
			_tmp65_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp65_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp66_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Type";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = media_item1_get_Type (self);
			_tmp66_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp66_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult media_item1_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_media_item1_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_media_item1_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_media_item1_property_get_all (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void media_item1_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_media_item1_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void media_item1_base_init (MediaItem1Iface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_boxed ("URLs", "URLs", "URLs", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("MIMEType", "MIMEType", "MIMEType", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("Type", "Type", "Type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_type_set_qdata (TYPE_MEDIA_ITEM1, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_media_item1_dbus_vtable));
	}
}


GType media_item1_get_type (void) {
	static volatile gsize media_item1_type_id__volatile = 0;
	if (g_once_init_enter (&media_item1_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaItem1Iface), (GBaseInitFunc) media_item1_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType media_item1_type_id;
		media_item1_type_id = g_type_register_static (G_TYPE_INTERFACE, "MediaItem1", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (media_item1_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (media_item1_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &media_item1_dbus_proxy_get_type);
		g_once_init_leave (&media_item1_type_id__volatile, media_item1_type_id);
	}
	return media_item1_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MediaItem1DBusProxy, media_item1_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MEDIA_ITEM1, media_item1_dbus_proxy_media_item1__interface_init) );
MediaItem1* media_item1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	MediaItem1* self;
	self = g_object_new (media_item1_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.UPnP.MediaItem1", NULL);
	return self;
}


static GObject* media_item1_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (media_item1_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), media_item1_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult media_item1_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void media_item1_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((MediaItem1DBusProxy*) self)->disposed) {
		return;
	}
	((MediaItem1DBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), media_item1_dbus_proxy_filter, self);
	G_OBJECT_CLASS (media_item1_dbus_proxy_parent_class)->dispose (self);
}


static void media_item1_dbus_proxy_class_init (MediaItem1DBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = media_item1_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = media_item1_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = media_item1_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = media_item1_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_ITEM1_DBUS_PROXY_UR_LS, "URLs");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_ITEM1_DBUS_PROXY_MIME_TYPE, "MIMEType");
	g_object_class_override_property (G_OBJECT_CLASS (klass), MEDIA_ITEM1_DBUS_PROXY_TYPE, "Type");
}


static void media_item1_dbus_proxy_init (MediaItem1DBusProxy* self) {
}


static char** media_item1_dbus_proxy_get_URLs (MediaItem1* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp67_;
	const char* _tmp68_;
	char** _result;
	int _result_length1;
	char** _tmp69_;
	int _tmp69__length;
	int _tmp69__size;
	int _tmp69__length1;
	DBusMessageIter _tmp70_;
	if (((MediaItem1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp67_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp67_);
	_tmp68_ = "URLs";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp68_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp69_ = g_new (char*, 5);
	_tmp69__length = 0;
	_tmp69__size = 4;
	_tmp69__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp70_);
	for (; dbus_message_iter_get_arg_type (&_tmp70_); _tmp69__length1++) {
		const char* _tmp71_;
		if (_tmp69__size == _tmp69__length) {
			_tmp69__size = 2 * _tmp69__size;
			_tmp69_ = g_renew (char*, _tmp69_, _tmp69__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp70_, &_tmp71_);
		dbus_message_iter_next (&_tmp70_);
		_tmp69_[_tmp69__length++] = g_strdup (_tmp71_);
	}
	_result_length1 = _tmp69__length1;
	_tmp69_[_tmp69__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp69_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* media_item1_dbus_proxy_get_MIMEType (MediaItem1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp72_;
	const char* _tmp73_;
	char* _result;
	const char* _tmp74_;
	if (((MediaItem1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp72_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp72_);
	_tmp73_ = "MIMEType";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp73_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp74_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp74_);
	dbus_message_unref (_reply);
	return _result;
}


static char* media_item1_dbus_proxy_get_Type (MediaItem1* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp75_;
	const char* _tmp76_;
	char* _result;
	const char* _tmp77_;
	if (((MediaItem1DBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp75_ = "org.gnome.UPnP.MediaItem1";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp75_);
	_tmp76_ = "Type";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp76_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp77_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp77_);
	dbus_message_unref (_reply);
	return _result;
}


static void media_item1_dbus_proxy_media_item1__interface_init (MediaItem1Iface* iface) {
	iface->get_URLs = media_item1_dbus_proxy_get_URLs;
	iface->get_MIMEType = media_item1_dbus_proxy_get_MIMEType;
	iface->get_Type = media_item1_dbus_proxy_get_Type;
}


static void media_item1_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void media_item1_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




