#!/bin/bash

. `dirname $0`/../../../scripts/CONFIG.sh

print_header "Project converter"
parse_opts "$@"

if [ "$clean" = 1 ]; then
   # ??? What should we do here ?
   echo ""
   exit 0
fi

files=${tests:-*}

PATH=$testpwd/..:$PATH
export PATH

run_and_exit 'make -C .. GNATMAKE="gnatmake -q"'

for dir in $files; do
   if [ -d "$dir" -a "$dir" != CVS ]; then
      ### A test to convert .adp into .gpr

      if [ -f $dir/test.cmd ]; then
         (cd $dir;
          pwd=`/bin/pwd`

          sh ./test.cmd | tr -d '\r' | \
            sed -e 's^\\^/^g' -e 's/[cde]://g' > /tmp/out.$$ 2>&1

          if [ -f test.out ]; then
             ./test.out | sed -e 's&@PATH@&'$pwd'&g' > /tmp/expected.$$
             $diff /tmp/expected.$$ /tmp/out.$$ > /tmp/diff.$$
             if [ -s /tmp/diff.$$ ]; then
                echo_with_status 0 "    ++++++$dir"
                if [ $showdiff = 1 ]; then
                   cat /tmp/diff.$$
                fi
             fi
             rm /tmp/expected.$$ /tmp/diff.$$
          else
             echo_with_status 0 "    ++++++$dir"
             if [ $showdiff = 1 ]; then
                echo "expecting no output, got:"
                cat /tmp/out.$$
             fi
          fi
          rm /tmp/out.$$

          ## Memorize where the object files are, for future reference

          find . -name '*.o' | sort > /tmp/expected.$$

          ## Now recompile the test, and see whether we really have the object
          ## files in the right place

          find . -name '*.o' -exec \rm {} \;
          find . -name '*.ali' -exec \rm {} \;

          for project in `ls *.gpr`; do
              gnatmake -q -c -u -P$project > /dev/null 2>&1
          done
          find . -name '*.o' | sort > /tmp/out.$$

          $diff /tmp/out.$$ /tmp/expected.$$

          rm /tmp/out.$$ /tmp/expected.$$ 
          find . -name '*.ali' -exec \rm {} \;
          find . -name '*.o' -exec \rm {} \;
          find . -name '*.gpr' -exec \rm {} \;
         )

      ### A test to convert .gpr into .adp

      elif [ -f $dir/test.cmd2 ]; then
         (cd $dir
          pwd=`/bin/pwd`

          sh ./test.cmd2 | tr -d '\r' | \
            sed -e 's^\\^/^g' -e 's/[cde]://g' > /tmp/out.$$ 2>&1

          if [ -f test.out ]; then
             ./test.out | sed -e 's&@PATH@&'$pwd'&g' > /tmp/expected.$$
             $diff /tmp/expected.$$ /tmp/out.$$ > /tmp/diff.$$
             if [ -s /tmp/diff.$$ ]; then
                echo_with_status 0 "    ++++++$dir"
                if [ $showdiff = 1 ]; then
                   cat /tmp/diff.$$
                fi
             fi
             rm /tmp/expected.$$ /tmp/diff.$$
          else
             echo_with_status 0 "    ++++++$dir"
             if [ $showdiff = 1 ]; then
                echo "expecting no output, got:"
                cat /tmp/out.$$
             fi
          fi
          rm /tmp/out.$$
         )
      fi
   fi
done

echo_with_status 1 ""
