#!/usr/bin/env perl

$param_entity=$ARGV[0];   ## Use "" for all entities

if ($#ARGV >= 1) {
  $dump_name=$ARGV[1];
} else {
  $dump_name = "db_dump";
}

open (FILE, $dump_name);
@lines=<FILE>;
close (FILE);

## Return the reference counting we should have for a specific entity
sub analyze_entity () {
  local ($entity)  = shift;
  local ($with_output) = shift;
  local ($section) = "";
  local ($count)   = 0;
  local ($matches) = 0;
  local ($file, $line)    = "";

  foreach (@lines) {
     if (/LI files/) {
        $section = "LI";
     } elsif (/Source files/) {
        $section = "SOURCES";
     } elsif (/Entities /) {
        $section = "ENTITIES";
     } else {
        if (/^\S/o) {
           if ($with_output && $matches) {
              print $file, $line;
           }
           $line = "";
           $file = ($section eq "SOURCES") ? $_ : "";
           $matches = 0;
        }
        if ($section eq "ENTITIES") {
           $line .= $_;
        }
        if ($section eq "ENTITIES" && /\b$entity\b/i) {
           $count ++ while (/\b$entity\b/g);
           $matches = 1;
        }
        if ($section eq "SOURCES" && /entities=.*\b$entity\b/i) {
           $count ++ while (/\b$entity\b/g);
           $matches = 1;
        }
     }
  }

  if ($with_output && $matches) {
     print $file, $line;
  }

  return $count;
}

## Find all the entities in the file, and set %entities to this, the value is
## their current ref_count
sub get_all_entities () {
   local ($section) = 0;
   $entity_regexp='\[?"?[\w\d<>=*&]+"?\]?:[^:]+:\d+:\d+';
   foreach (@lines) {
      if (/Entities /) {
         $section = 1;
      } elsif (/Source files/) {
         $section = 2;
      } elsif ($section == 1 && /^($entity_regexp) .*ref_count=(\d+)/o) {
         $entities {$1} = $2;
         # $count {$1}++;
      } elsif ($section == 1) {
         $count{$1}++ while (/($entity_regexp)/go);
      } elsif ($section == 2 && /entities=/) {
         $count{$1}++ while (/($entity_regexp)/go);
      }
   }
}


if ($param_entity ne "") {
  $count = &analyze_entity ($param_entity, 1);
  print "Ref_Count for $param_entity should be $count\n";

} else {
  &get_all_entities();
  foreach $entity (sort keys %entities) {
     $count2 = $count{$entity};
     if ($count2 != $entities{$entity}) {
        print "$entity actual=$entities{$entity}  should_be=$count2\n"; 
     }
  }
}
 

