with Test_Display_Items; use Test_Display_Items;
with Glib;          use Glib;
with Gtk.Enums;     use Gtk.Enums;
with Gtk.Main;      use Gtk.Main;
with Gtk.Window;    use Gtk.Window;
with Gtkada.Canvas; use Gtkada.Canvas;
with Gtk.Scrolled_Window;  use Gtk.Scrolled_Window;

procedure Test_Canvas is

   Win    : Gtk_Window;
   Canvas : Interactive_Canvas;
   Item1,
   Item2,
   Item3,
   Item4  : Display_Item;
   Scrolled : Gtk_Scrolled_Window;
   Link     : Canvas_Link;

begin
   Gtk.Main.Init;
   Gtk_New (Win, Window_Toplevel);

   Gtk_New (Scrolled);
   Add (Win, Scrolled);
   Set_Policy (Scrolled, Policy_Automatic, Policy_Automatic);

   Gtk_New (Canvas);
   Add (Scrolled, Canvas);
   Set_USize (Canvas, 500, 500);
   Align_On_Grid (Canvas, False);

   Realize (Canvas);

   Gtk_New (Item1, Canvas, Get_Window (Canvas));
   Put (Canvas, Item1);

   Gtk_New (Item2, Canvas, Get_Window (Canvas));
   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item1, Item2, Descr => "From1->2");
   Put (Canvas, Item2);

   Gtk_New (Item3, Canvas, Get_Window (Canvas));
   Put (Canvas, Item3);

   Gtk_New (Item4, Canvas, Get_Window (Canvas));
   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item3, Item4, Both_Arrow, Descr => "From3->4");
   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item2, Item4, No_Arrow, Descr => "From2->4");
   Put (Canvas, Item4);

   Gtk_New (Item1, Canvas, Get_Window (Canvas));
   Put (Canvas, Item1);

   Gtk_New (Item1, Canvas, Get_Window (Canvas));
   Put (Canvas, Item1);
   Gtk_New (Item1, Canvas, Get_Window (Canvas));
   Put (Canvas, Item1);
   Gtk_New (Item1, Canvas, Get_Window (Canvas));
   Put (Canvas, Item1);
   Gtk_New (Item1, Canvas, Get_Window (Canvas));
   Put (Canvas, Item1);

   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item3, Item1, Both_Arrow, Descr => "From3->1");
   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item1, Item4, Start_Arrow, Descr => "From1->4");
   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item2, Item3, End_Arrow, Descr => "From2->3");
   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item4, Item3, Both_Arrow, Descr => "From3->41");
   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item3, Item4, Both_Arrow, Descr => "From3->42");
   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item4, Item3, Both_Arrow, Descr => "From3->43");
   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item3, Item4, Both_Arrow, Descr => "From3->44");
   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item2, Item2, Both_Arrow, Descr => "Self");
   Link := new Canvas_Link_Record;
   Add_Link (Canvas, Link, Item2, Item2, Both_Arrow, Descr => "Self2");

   --  Remove (Canvas, Item3);

   Show_All (Win);
   Gtk.Main.Main;
end Test_Canvas;
